/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.ejb.gui.logic;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.gui.LocaleSettings;
import com.sap.engine.services.deploy.ear.common.RunAsIdentity;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.deploy.gui.common.BasicPanelView;
import com.sap.engine.services.deploy.gui.common.DescriptionPanel;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.common.RunAsIdentityPanel;
import com.sap.engine.services.ejb.deploy.descriptors.SecurityIdentity;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

public class SecurityIdentityPanel
extends BasicPanelView
implements ActionListener {
    public static final String RUN_AS = "RUN_AS";
    public static final String CALLER = "CALLER";
    public static final String NONE = "NONE";
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private JRadioButton runAsRadio = new JRadioButton();
    private JRadioButton useCallerRadio = new JRadioButton();
    private JRadioButton noneRadio = new JRadioButton();
    private ButtonGroup buttonGroup = new ButtonGroup();
    private JPanel buttonPanel = new JPanel();
    private DescriptionPanel securityIdentityDescr = new DescriptionPanel();
    private JPanel panel = new JPanel();
    private Border eatchedBorder = BorderFactory.createEtchedBorder();
    private RunAsIdentityPanel runAsPanel = null;
    private SecurityIdentity identity = null;
    private int madeFrom = -1;
    private boolean enabled = false;
    private boolean enabledUseCaller = true;
    private Vector warnings = new Vector();
    private ApplicationInformationProvider appProvider;

    public SecurityIdentityPanel(Frame mainFrame, int madeFrom) {
        this.runAsPanel = new RunAsIdentityPanel(mainFrame, madeFrom);
        this.madeFrom = madeFrom;
        try {
            this.init();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Visualization of panels cannot be initialized properly\nReason: " + ex.toString() + "\nRestart of the tool is recommended.\n We are sorry for the inconvenience.", "Error in visualization", 0);
        }
        this.init(madeFrom);
        this.runAsPanel.enableComponents(this.enabled);
        this.securityIdentityDescr.setEnabled(this.enabled);
        this.initListeners();
    }

    private void init() throws Exception {
        this.panel.setLayout(this.gridBagLayout1);
        this.setLayout(this.gridBagLayout2);
        this.securityIdentityDescr.setNewBorder(LocaleSettings.getInstance((String)"EJB").getResourceString("Security Identity Description", "Security Identity Description"));
        this.runAsRadio.setText(LocaleSettings.getInstance((String)"EJB").getResourceString("RunAsIdentity_Radio", "Run As Identity"));
        this.useCallerRadio.setText(LocaleSettings.getInstance((String)"EJB").getResourceString("UseCallerIdentity_Radio", "Use Caller Identity"));
        this.noneRadio.setText(LocaleSettings.getInstance((String)"EJB").getResourceString("None_Radio", "None"));
        this.buttonGroup.add(this.noneRadio);
        this.buttonGroup.add(this.useCallerRadio);
        this.buttonGroup.add(this.runAsRadio);
        this.noneRadio.setSelected(true);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.buttonPanel.add((Component)this.noneRadio, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.buttonPanel.add((Component)this.runAsRadio, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.buttonPanel.add((Component)this.useCallerRadio, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.panel.add((Component)this.buttonPanel, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.panel.add((Component)this.runAsPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.panel.setBorder(this.eatchedBorder);
        this.add((Component)this.panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.securityIdentityDescr, new GridBagConstraints(0, 1, 0, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void initListeners() {
        this.runAsRadio.setActionCommand(RUN_AS);
        this.runAsRadio.addActionListener(this);
        this.useCallerRadio.setActionCommand(CALLER);
        this.useCallerRadio.addActionListener(this);
        this.noneRadio.setActionCommand(NONE);
        this.noneRadio.addActionListener(this);
    }

    private void initRunAsPanel() {
        RunAsIdentity runAsIdentity = this.identity.getRunAsIdentity();
        if (runAsIdentity == null) {
            runAsIdentity = new RunAsIdentity("");
        }
        this.runAsPanel.setRunAsIdentity(runAsIdentity);
        this.runAsPanel.enableComponents(this.enabled);
        this.runAsRadio.setSelected(true);
        this.validate();
        this.repaint();
    }

    public void init(int madeFromConstant) {
        this.madeFrom = madeFromConstant;
        if (this.madeFrom == 2 || this.madeFrom == 1 || this.madeFrom == 4 || this.madeFrom == 0) {
            this.enabled = true;
        } else {
            this.enabled = false;
            if (this.enabledUseCaller) {
                this.enabledUseCaller = false;
            }
        }
    }

    public void clear() {
        this.identity = null;
        this.useCallerRadio.setEnabled(this.enabledUseCaller);
        this.runAsRadio.setEnabled(this.enabled);
        this.noneRadio.setEnabled(this.enabled);
        this.noneRadio.setSelected(true);
        this.securityIdentityDescr.setEnabled(false);
        this.runAsPanel.clear();
        this.runAsPanel.enableComponents(false);
        this.securityIdentityDescr.setText("");
        this.validate();
        this.repaint();
    }

    public int isCorrect() {
        return this.runAsPanel.isCorrect();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void commitChange() {
        this.runAsPanel.commitChange();
        RunAsIdentity runAsIdentity = this.runAsPanel.getRunAsIdentity();
        if (this.identity == null) {
            this.identity = new SecurityIdentity();
        }
        this.identity.setDescription(this.securityIdentityDescr.getText());
        if (this.noneRadio.isSelected()) {
            this.identity = null;
            return;
        }
        if (!this.runAsRadio.isSelected()) {
            if (!this.useCallerRadio.isSelected()) return;
            this.identity.setRunAsIdentity(null);
            this.identity.setCallerIdentity(true);
            return;
        }
        if (runAsIdentity.getSecurityRoleName() != null && !runAsIdentity.getSecurityRoleName().equals("")) {
            this.identity.setRunAsIdentity(runAsIdentity);
            this.identity.setCallerIdentity(false);
            return;
        }
        this.warnings.add("WARNING!!!!! Run as identity role name not set!!!!!!!No security identity......");
        this.identity = null;
    }

    public void setLoader(ClassLoader loader) {
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(NONE)) {
            this.clear();
        } else if (command.equals(CALLER)) {
            this.identity = new SecurityIdentity();
            this.identity.setCallerIdentity(true);
            this.securityIdentityDescr.setEnabled(true);
            this.runAsPanel.clear();
            this.runAsPanel.enableComponents(false);
        } else if (command.equals(RUN_AS)) {
            if (this.identity == null) {
                this.identity = new SecurityIdentity();
                this.identity.setCallerIdentity(false);
            }
            this.runAsPanel.clear();
            this.runAsPanel.enableComponents(true);
            this.securityIdentityDescr.setEnabled(true);
        }
        this.validate();
        this.repaint();
    }

    public void setSecurityIdentity(SecurityIdentity identity) {
        this.identity = identity;
        if (this.identity == null) {
            this.clear();
        } else {
            if (this.identity.isCallerIdentity()) {
                this.runAsPanel.clear();
                this.runAsPanel.enableComponents(false);
                this.useCallerRadio.setSelected(this.enabled);
            } else {
                this.initRunAsPanel();
            }
            this.securityIdentityDescr.setText(identity.getDescription());
            this.securityIdentityDescr.setEnabled(this.enabled);
        }
    }

    public SecurityIdentity getSecurityIdentity() {
        return this.identity;
    }

    public void setSecurityRoles(SecurityRoles[] roles) {
        this.runAsPanel.setSecurityRoles(roles);
    }

    public void setEJBName(String name) {
        if (this.identity == null) {
            return;
        }
        RunAsIdentity runAsIdentity = this.identity.getRunAsIdentity();
        if (runAsIdentity != null) {
            runAsIdentity.setComponentName(name);
            this.identity.setRunAsIdentity(runAsIdentity);
        }
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    public void setMessageDriveBeanType(boolean type) {
        if (type) {
            this.enabledUseCaller = false;
        } else if (this.enabled) {
            this.enabledUseCaller = true;
        }
    }
}

