/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.ejb.gui.logic;

import com.sap.engine.deploy.ejb.gui.visual.GeneralPanelView;
import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.deploy.tool.util.LoadedFilesListener;
import com.sap.engine.lib.lang.DynamicClassLoader;
import com.sap.engine.services.deploy.gui.common.ErrorObject;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.MessageDrivenDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.SessionDescriptor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;

public class GeneralPanelLogic
extends GeneralPanelView
implements LoadedFilesListener {
    private DeploymentDescriptor dDescr;
    private boolean documentChanged = false;
    private ClassLoader loader;
    private ApplicationInformationProvider appProvider;
    private Hashtable classes = new Hashtable();
    private String classPath;
    private ErrorReportObject errors;
    private Vector localErrorsVector;
    private int id;
    private boolean onSet = false;
    private Hashtable hashCMP;
    static /* synthetic */ Class class$javax$ejb$EJBHome;
    static /* synthetic */ Class class$javax$ejb$EJBObject;
    static /* synthetic */ Class class$javax$ejb$EJBLocalHome;
    static /* synthetic */ Class class$javax$ejb$EJBLocalObject;
    static /* synthetic */ Class class$java$io$Serializable;

    public GeneralPanelLogic(Frame frame, int beanType, int madeFrom, DeploymentDescriptor dD) {
        super(frame, beanType, madeFrom);
        this.frame = frame;
        this.beanType = beanType;
        this.madeFrom = madeFrom;
        this.dDescr = dD;
    }

    public GeneralPanelLogic(Frame frame, int madeFrom, DeploymentDescriptor dD) {
        super(frame, madeFrom);
        this.frame = frame;
        this.madeFrom = madeFrom;
        this.dDescr = dD;
        if (dD instanceof EntityDescriptor) {
            this.beanType = 0;
            this.init();
        } else if (dD instanceof SessionDescriptor) {
            this.beanType = 1;
            this.init();
        } else if (dD instanceof MessageDrivenDescriptor) {
            this.beanType = 2;
            this.init();
        }
    }

    public GeneralPanelLogic(Frame frame, int beanType, int madeFrom) {
        super(frame, beanType, madeFrom);
        this.frame = frame;
        this.beanType = beanType;
        this.madeFrom = madeFrom;
    }

    public GeneralPanelLogic(Frame frame, int madeFrom) {
        super(frame, madeFrom);
        this.frame = frame;
        this.madeFrom = madeFrom;
    }

    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equalsIgnoreCase("edit")) {
            this.setAllEditableFields(true);
        } else if (command.equalsIgnoreCase("check")) {
            this.setAllEditableFields(false);
        } else if (command.equalsIgnoreCase("destType")) {
            if (this.destinationTypeComboBox.getSelectedItem().equals("javax.jms.Topic")) {
                this.setSubscriberEnabled(true);
            } else {
                this.setSubscriberEnabled(false);
            }
        } else if (command.equals("persistenceMGM")) {
            if (this.persistenceManagment.getSelectedItem().equals(this.persistentManagmentArray[0]) && this.beanNameField.isEnabled()) {
                this.cmpVersionComboBox.setEnabled(true);
                if (((String)this.cmpVersionComboBox.getSelectedItem()).startsWith("2")) {
                    try {
                        if (this.dDescr instanceof CMPEntityDescriptor) {
                            this.schemaTextField.setText(((CMPEntityDescriptor)this.dDescr).getAbstractSchemaName());
                        } else {
                            this.schemaTextField.setText(((EntityDescriptor)this.dDescr).getEjbName());
                        }
                    }
                    catch (RuntimeException exd) {
                        this.schemaTextField.setText(((EntityDescriptor)this.dDescr).getEjbName());
                    }
                    this.schemaTextField.setEnabled(true);
                } else if (((String)this.cmpVersionComboBox.getSelectedItem()).startsWith("1")) {
                    this.schemaTextField.setText("");
                    this.schemaTextField.setEnabled(false);
                }
            } else {
                this.cmpVersionComboBox.setEnabled(false);
                this.schemaTextField.setText("");
                this.schemaTextField.setEnabled(false);
                this.fromInit = false;
            }
        } else if (command.equals("CMP_VER_CHANGED")) {
            if (((String)this.cmpVersionComboBox.getSelectedItem()).startsWith("2")) {
                try {
                    if (this.dDescr instanceof CMPEntityDescriptor) {
                        this.schemaTextField.setText(((CMPEntityDescriptor)this.dDescr).getAbstractSchemaName());
                    } else {
                        this.schemaTextField.setText(((EntityDescriptor)this.dDescr).getEjbName());
                    }
                }
                catch (RuntimeException exd) {
                    this.schemaTextField.setText(((EntityDescriptor)this.dDescr).getEjbName());
                }
                this.schemaTextField.setEnabled(true);
            } else if (((String)this.cmpVersionComboBox.getSelectedItem()).startsWith("1")) {
                this.schemaTextField.setText("");
                this.schemaTextField.setEnabled(false);
            }
        } else if (ae.getSource() == this.pkField) {
            this.onSet = true;
            this.trigerCMP20_PkEvent();
            this.onSet = false;
        }
    }

    public void init(int madeFrom) {
        this.madeFrom = madeFrom;
        this.init();
    }

    public void setDescriptor(DeploymentDescriptor dd) {
        this.fromInit = true;
        this.dDescr = dd;
        this.documentChanged = false;
        this.clear();
        this.classPath = this.appProvider.getClassPath();
        if (dd == null) {
            return;
        }
        this.onSet = true;
        if (dd instanceof EntityDescriptor) {
            this.beanType = 0;
            this.init();
            this.loadEntity(dd);
        } else if (dd instanceof SessionDescriptor) {
            this.beanType = 1;
            this.init();
            this.loadSession(dd);
        } else if (dd instanceof MessageDrivenDescriptor) {
            this.beanType = 2;
            this.init();
            this.loadMessageDriven(dd);
        }
        if (dd.getEjbName() != null && !dd.getEjbName().equals("") && dd.getClassName() != null && !dd.getClassName().trim().equals("")) {
            this.setAllEditableFields(false);
        } else {
            this.setAllEditableFields(true);
        }
        this.onSet = false;
    }

    private void loadDDescr(DeploymentDescriptor dd) {
        this.beanNameField.setText(dd.getEjbName() != null ? dd.getEjbName() : "");
        if (this.madeFrom == 3 || this.madeFrom == 4) {
            this.jndiNameField.setText(dd.getJndiName() != null ? dd.getJndiName() : "");
        }
        this.beanClassNameComboBox.setSelectedItem(dd.getClassName() != null ? dd.getClassName() : "");
        if (((JTextField)this.beanClassNameComboBox.getEditor().getEditorComponent()).getText().trim().equals("")) {
            ((JTextField)this.beanClassNameComboBox.getEditor().getEditorComponent()).setText(dd.getClassName());
        }
        this.remoteHomeInterfaceComboBox.setSelectedItem(dd.getRemoteHomeInterface() != null ? dd.getRemoteHomeInterface() : "");
        if (((JTextField)this.remoteHomeInterfaceComboBox.getEditor().getEditorComponent()).getText().trim().equals("")) {
            ((JTextField)this.remoteHomeInterfaceComboBox.getEditor().getEditorComponent()).setText(dd.getRemoteHomeInterface());
        }
        this.remoteInterfaceComboBox.setSelectedItem(dd.getRemoteInterface() != null ? dd.getRemoteInterface() : "");
        if (((JTextField)this.remoteInterfaceComboBox.getEditor().getEditorComponent()).getText().trim().equals("")) {
            ((JTextField)this.remoteInterfaceComboBox.getEditor().getEditorComponent()).setText(dd.getRemoteInterface());
        }
        this.localHomeInterfaceComboBox.setSelectedItem(dd.getLocalHomeInterface() != null ? dd.getLocalHomeInterface() : "");
        if (((JTextField)this.localHomeInterfaceComboBox.getEditor().getEditorComponent()).getText().trim().equals("")) {
            ((JTextField)this.localHomeInterfaceComboBox.getEditor().getEditorComponent()).setText(dd.getLocalHomeInterface());
        }
        this.localInterfaceComboBox.setSelectedItem(dd.getLocalInterface() != null ? dd.getLocalInterface() : "");
        if (((JTextField)this.localInterfaceComboBox.getEditor().getEditorComponent()).getText().trim().equals("")) {
            ((JTextField)this.localInterfaceComboBox.getEditor().getEditorComponent()).setText(dd.getLocalInterface());
        }
    }

    private void loadEntity(DeploymentDescriptor dd) {
        this.loadDDescr(dd);
        this.loadCMPFields();
        if (((EntityDescriptor)dd).getPersistenceType() == 1) {
            this.persistenceManagment.setSelectedItem("Container Managment");
        } else if (((EntityDescriptor)dd).getPersistenceType() == 0) {
            this.persistenceManagment.setSelectedItem("Bean Managment");
        }
        if (dd instanceof CMPEntityDescriptor) {
            if (((CMPEntityDescriptor)dd).getCmpVersion() == 1) {
                this.cmpVersionComboBox.setSelectedItem(this.cmpVerArray[0]);
            } else if (((CMPEntityDescriptor)dd).getCmpVersion() == 2) {
                this.cmpVersionComboBox.setSelectedItem(this.cmpVerArray[1]);
                try {
                    this.schemaTextField.setText(((CMPEntityDescriptor)this.dDescr).getAbstractSchemaName());
                }
                catch (RuntimeException exd) {
                    this.schemaTextField.setText(((CMPEntityDescriptor)this.dDescr).getEjbName());
                }
            }
            this.pkField.setSelectedItem(((CMPEntityDescriptor)dd).getPKFieldName() != null ? ((CMPEntityDescriptor)dd).getPKFieldName() : "");
            if (((JTextField)this.pkField.getEditor().getEditorComponent()).getText().trim().equals("")) {
                ((JTextField)this.pkField.getEditor().getEditorComponent()).setText(((CMPEntityDescriptor)dd).getPKFieldName());
            }
        }
        this.reentrantCheckBox.setSelected(((EntityDescriptor)dd).isReentrant());
        this.pkTypeField.setSelectedItem(((EntityDescriptor)dd).getPrimaryKeyClass() != null ? ((EntityDescriptor)dd).getPrimaryKeyClass() : "");
        if (((JTextField)this.pkTypeField.getEditor().getEditorComponent()).getText().trim().equals("")) {
            ((JTextField)this.pkTypeField.getEditor().getEditorComponent()).setText(((EntityDescriptor)dd).getPrimaryKeyClass());
        }
    }

    private void loadSession(DeploymentDescriptor dd) {
        this.loadDDescr(dd);
        if (((SessionDescriptor)dd).getTransactionType() == 0) {
            this.demarcationTypeComboBox.setSelectedItem("Bean");
        } else if (((SessionDescriptor)dd).getTransactionType() == 1) {
            this.demarcationTypeComboBox.setSelectedItem("Container");
        }
        if (((SessionDescriptor)dd).getSessionType() == 0) {
            this.managmentTypeComboBox.setSelectedItem("Stateless");
        } else if (((SessionDescriptor)dd).getSessionType() == 1) {
            this.managmentTypeComboBox.setSelectedItem("Stateful");
        }
    }

    private void loadMessageDriven(DeploymentDescriptor dd) {
        this.beanNameField.setText(dd.getEjbName());
        this.beanClassNameComboBox.setSelectedItem(dd.getClassName() != null ? dd.getClassName() : "");
        if (((JTextField)this.beanClassNameComboBox.getEditor().getEditorComponent()).getText().trim().equals("")) {
            ((JTextField)this.beanClassNameComboBox.getEditor().getEditorComponent()).setText(dd.getClassName());
        }
        if (((MessageDrivenDescriptor)dd).getTransactionType() == 0) {
            this.demarcationTypeComboBox.setSelectedItem("Bean");
        } else if (((MessageDrivenDescriptor)dd).getTransactionType() == 1) {
            this.demarcationTypeComboBox.setSelectedItem("Container");
        }
        this.aknoligementComboBox.setSelectedItem(((MessageDrivenDescriptor)dd).getAcknowledgeMode());
        if (((MessageDrivenDescriptor)dd).getDestinationType() == null) {
            this.destinationTypeComboBox.setSelectedItem("");
        } else if (((MessageDrivenDescriptor)dd).getDestinationType().equalsIgnoreCase("javax.jms.Queue")) {
            this.destinationTypeComboBox.setSelectedItem("javax.jms.Queue");
        } else if (((MessageDrivenDescriptor)dd).getDestinationType().equalsIgnoreCase("javax.jms.Topic")) {
            this.destinationTypeComboBox.setSelectedItem("javax.jms.Topic");
        }
        this.durableSubscrCheckBox.setSelected(((MessageDrivenDescriptor)dd).getSubscriptionDurability() != null);
    }

    private void commitDeployment() {
        if (!this.beanNameField.getText().trim().equals("")) {
            this.dDescr.setBeanName(this.beanNameField.getText().trim());
        }
        if (this.madeFrom == 3 || this.madeFrom == 4) {
            this.dDescr.setJndiName(this.jndiNameField.getText().trim().equals("") ? null : this.jndiNameField.getText().trim());
        }
        this.dDescr.setClassName(((JTextField)this.beanClassNameComboBox.getEditor().getEditorComponent()).getText().trim().equals("") ? null : ((JTextField)this.beanClassNameComboBox.getEditor().getEditorComponent()).getText().trim());
        this.dDescr.setRemoteHomeInterface(((JTextField)this.remoteHomeInterfaceComboBox.getEditor().getEditorComponent()).getText().trim().equals("") ? null : ((JTextField)this.remoteHomeInterfaceComboBox.getEditor().getEditorComponent()).getText().trim());
        this.dDescr.setRemoteInterface(((JTextField)this.remoteInterfaceComboBox.getEditor().getEditorComponent()).getText().trim().equals("") ? null : ((JTextField)this.remoteInterfaceComboBox.getEditor().getEditorComponent()).getText().trim());
        this.dDescr.setLocalHomeInterface(((JTextField)this.localHomeInterfaceComboBox.getEditor().getEditorComponent()).getText().trim().equals("") ? null : ((JTextField)this.localHomeInterfaceComboBox.getEditor().getEditorComponent()).getText().trim());
        this.dDescr.setLocalInterface(((JTextField)this.localInterfaceComboBox.getEditor().getEditorComponent()).getText().trim().equals("") ? null : ((JTextField)this.localInterfaceComboBox.getEditor().getEditorComponent()).getText().trim());
    }

    private void commitEntity() {
        this.commitDeployment();
        if (this.persistenceManagment.getSelectedItem().equals("Container Managment")) {
            ((EntityDescriptor)this.dDescr).setPersistenceType(1);
        } else if (this.persistenceManagment.getSelectedItem().equals("Bean Managment")) {
            ((EntityDescriptor)this.dDescr).setPersistenceType(0);
        }
        if (this.persistenceManagment.getSelectedItem().equals("Container Managment") && !(this.dDescr instanceof CMPEntityDescriptor)) {
            this.dDescr = new CMPEntityDescriptor((EntityDescriptor)this.dDescr);
        }
        if (this.persistenceManagment.getSelectedItem().equals("Bean Managment") && this.dDescr instanceof CMPEntityDescriptor) {
            this.dDescr = new EntityDescriptor((DeploymentDescriptor)this.dDescr.clone());
            ((EntityDescriptor)this.dDescr).setPersistenceType(0);
        }
        if (this.dDescr instanceof CMPEntityDescriptor) {
            if (this.cmpVersionComboBox.getSelectedItem().equals("1.x")) {
                ((CMPEntityDescriptor)this.dDescr).setCmpVersion(1);
                ((CMPEntityDescriptor)this.dDescr).setAbstractSchemaName(null);
            } else if (this.cmpVersionComboBox.getSelectedItem().equals("2.x")) {
                ((CMPEntityDescriptor)this.dDescr).setCmpVersion(2);
                if (!this.schemaTextField.getText().equals("")) {
                    ((CMPEntityDescriptor)this.dDescr).setAbstractSchemaName(this.schemaTextField.getText());
                } else {
                    ((CMPEntityDescriptor)this.dDescr).setAbstractSchemaName(this.dDescr.getEjbName());
                }
            }
            ((CMPEntityDescriptor)this.dDescr).setPKFieldName(((JTextField)this.pkField.getEditor().getEditorComponent()).getText());
        }
        ((EntityDescriptor)this.dDescr).setReentrant(this.reentrantCheckBox.isSelected());
        ((EntityDescriptor)this.dDescr).setPrimaryKeyClass(((JTextField)this.pkTypeField.getEditor().getEditorComponent()).getText().trim().equals("") ? null : ((JTextField)this.pkTypeField.getEditor().getEditorComponent()).getText().trim());
    }

    private void commitSession() {
        this.commitDeployment();
        if (this.demarcationTypeComboBox.getSelectedItem().equals("Bean")) {
            ((SessionDescriptor)this.dDescr).setTransactionType(0);
        } else if (this.demarcationTypeComboBox.getSelectedItem().equals("Container")) {
            ((SessionDescriptor)this.dDescr).setTransactionType(1);
        }
        if (this.managmentTypeComboBox.getSelectedItem().equals("Stateless")) {
            ((SessionDescriptor)this.dDescr).setSessionType(0);
        } else if (this.managmentTypeComboBox.getSelectedItem().equals("Stateful")) {
            ((SessionDescriptor)this.dDescr).setSessionType(1);
        }
    }

    private void commitMDB() {
        this.dDescr.setBeanName(this.beanNameField.getText());
        this.dDescr.setClassName(((JTextField)this.beanClassNameComboBox.getEditor().getEditorComponent()).getText());
        boolean isTopic = false;
        if (this.demarcationTypeComboBox.getSelectedItem().equals("Bean")) {
            ((MessageDrivenDescriptor)this.dDescr).setTransactionType(0);
        } else if (this.demarcationTypeComboBox.getSelectedItem().equals("Container")) {
            ((MessageDrivenDescriptor)this.dDescr).setTransactionType(1);
        }
        if (!"".equals((String)this.aknoligementComboBox.getSelectedItem())) {
            ((MessageDrivenDescriptor)this.dDescr).setAcknowledgeMode((String)this.aknoligementComboBox.getSelectedItem());
        } else {
            ((MessageDrivenDescriptor)this.dDescr).setAcknowledgeMode(null);
        }
        if (!"".equals((String)this.destinationTypeComboBox.getSelectedItem())) {
            ((MessageDrivenDescriptor)this.dDescr).setDestinationType((String)this.destinationTypeComboBox.getSelectedItem());
            if (((String)this.destinationTypeComboBox.getSelectedItem()).equals("javax.jms.Topic")) {
                isTopic = true;
            }
        } else {
            ((MessageDrivenDescriptor)this.dDescr).setDestinationType(null);
        }
        if (isTopic) {
            if (this.durableSubscrCheckBox.isSelected()) {
                ((MessageDrivenDescriptor)this.dDescr).setSubscriptionDurability("Durable");
            } else {
                ((MessageDrivenDescriptor)this.dDescr).setSubscriptionDurability("NonDurable");
            }
        }
    }

    public void commitChange() {
        if (this.documentChanged) {
            if (this.dDescr instanceof EntityDescriptor) {
                this.commitEntity();
            } else if (this.dDescr instanceof SessionDescriptor) {
                this.commitSession();
            } else if (this.dDescr instanceof MessageDrivenDescriptor) {
                this.commitMDB();
            }
        }
    }

    public void insertUpdate(DocumentEvent de) {
        this.documentChanged = true;
        if (!this.cmpVersionComboBox.getSelectedItem().equals("2.x")) {
            return;
        }
        if (this.pkField.isEnabled() && de.getDocument() == ((JTextField)this.pkField.getEditor().getEditorComponent()).getDocument()) {
            this.trigerCMP20_PkEvent();
        } else if (((JTextField)this.pkTypeField.getEditor().getEditorComponent()).getDocument() == de.getDocument() && ((JTextField)this.pkTypeField.getEditor().getEditorComponent()).getText().trim().equals("java.lang.Object")) {
            ((JTextField)this.pkField.getEditor().getEditorComponent()).setText("");
        }
    }

    public void removeUpdate(DocumentEvent de) {
        this.documentChanged = true;
        if (!this.cmpVersionComboBox.getSelectedItem().equals("2.x")) {
            return;
        }
        if (this.pkField.isEnabled() && de.getDocument() == ((JTextField)this.pkField.getEditor().getEditorComponent()).getDocument()) {
            if (this.onSet) {
                return;
            }
            if (((JTextField)this.pkField.getEditor().getEditorComponent()).getText().trim().equals("")) {
                this.pkTypeField.setSelectedItem("java.lang.Object");
            } else if (this.pkTypeField.getSelectedItem() != null && this.pkTypeField.getSelectedItem().equals("java.lang.Object")) {
                this.pkTypeField.setSelectedItem("java.lang.String");
            }
        }
    }

    public void changedUpdate(DocumentEvent de) {
        this.documentChanged = true;
    }

    protected int checkClasses() {
        this.errors = new ErrorReportObject();
        int result = 0;
        if (this.dDescr instanceof EntityDescriptor) {
            result = this.checkEntity();
        } else if (this.dDescr instanceof SessionDescriptor) {
            result = this.checkSession();
        } else if (this.dDescr instanceof MessageDrivenDescriptor) {
            result = this.checkMsgDriven();
        }
        return result;
    }

    private String findClassLocation(String str) {
        String[] classes = ApplicationInformationProvider.tokenizerToArray(this.classPath, File.pathSeparator);
        if (classes == null) {
            return null;
        }
        str = str.replace('.', File.separatorChar) + ".class";
        int i = 0;
        while (i < classes.length) {
            if (new File(classes[i]).isDirectory()) {
                if (new File(ApplicationInformationProvider.concatPath(classes[i], str)).exists()) {
                    return ApplicationInformationProvider.concatPath(classes[i], str);
                }
            } else if (this.isArchive(classes[i])) {
                String res = this.checkForFileInArchive(str, classes[i]);
                if (res.equals("")) {
                    return classes[i];
                }
                if (!res.equals("0")) {
                    return res;
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    private String checkForFileInArchive(String str, String fileName) {
        String correct = "";
        ZipFile zip = null;
        try {
            zip = new ZipFile(fileName);
            Enumeration<? extends ZipEntry> en = zip.entries();
            while (en.hasMoreElements()) {
                String comparable;
                ZipEntry entry = en.nextElement();
                if (entry == null || !(comparable = ApplicationInformationProvider.changeFileSeparatorsToOSDependant(entry.getName())).toLowerCase().equals(str.toLowerCase())) continue;
                return correct;
            }
            zip.close();
        }
        catch (Throwable e) {
            return "ERROR:" + e.getMessage();
        }
        return "0";
    }

    private boolean isArchive(String source) {
        if (source == null) {
            return false;
        }
        return source.toLowerCase().endsWith(".jar") || source.toLowerCase().endsWith(".war") || source.toLowerCase().endsWith(".rar") || source.toLowerCase().endsWith(".zip");
    }

    private Object[] checkSingleClass(ClassLoader loader, String testClass, boolean obligational, String type, int id) {
        Class<?> myClass = null;
        ErrorObject eo = null;
        if (!testClass.trim().equals("")) {
            String found = this.findClassLocation(testClass);
            if (found != null) {
                if (found.startsWith("ERROR:")) {
                    eo = new ErrorObject("GeneralPanelLogical", "956", 0, type + " could not be loaded.\n", found);
                    return new Object[]{myClass, eo};
                }
                try {
                    myClass = loader.loadClass(testClass);
                }
                catch (ClassNotFoundException classNotFound) {
                    eo = new ErrorObject("GeneralPanelLogical", "950", 0, type + " could not be loaded", "Possible reasons: 1. Missing class file(s) for loading the class.\n2. Incorect class path.\n", classNotFound);
                }
                catch (ClassCircularityError cce) {
                    eo = new ErrorObject("GeneralPanelLogical", "951", 0, type + " class could not be loaded", "Possible reasons: 1. Missing class file(s) for loading the class.\n2. Incorect class path.\n", cce);
                }
                catch (Exception exc) {
                    eo = new ErrorObject("GeneralPanelLogical", "952", 0, type + " class could not be loaded", "Possible reasons: 1. Missing class file(s) for loading the class.\n2. Incorect class path.\n", exc);
                }
                catch (NoClassDefFoundError ncdfe) {
                    eo = new ErrorObject("GeneralPanelLogical", "953", 0, type + " class could not be loaded", "Possible reasons: 1. Missing class file(s) for loading the class.\n2. Incorect class path.\n", ncdfe);
                }
            } else {
                eo = new ErrorObject("GeneralPanelLogical", "954", 0, "File not found in class path.\n" + type + " class could not be loaded", "Possible reasons: The class file is not in the class path.\n");
            }
        } else if (obligational) {
            eo = new ErrorObject("GeneralPanelLogical", "955", 0, type + " class could not be loaded", "Possible reasons: There is no information in " + type + " field.\n");
        }
        return new Object[]{myClass, eo};
    }

    private void checkInterfacesAvailability() {
        Object eo = null;
        Vector oeV = new Vector();
        if (((JTextField)this.remoteHomeInterfaceComboBox.getEditor().getEditorComponent()).getText().trim().equals("") && ((JTextField)this.remoteInterfaceComboBox.getEditor().getEditorComponent()).getText().trim().equals("") && ((JTextField)this.localHomeInterfaceComboBox.getEditor().getEditorComponent()).getText().trim().equals("") && ((JTextField)this.localInterfaceComboBox.getEditor().getEditorComponent()).getText().trim().equals("")) {
            this.localErrorsVector.add(new ErrorObject("GeneralPanelLogical", "930", 0, "Missing interfaces.", "There must be at least two interfaces of a king selected.\n You can have (Remote Home and Remote Interfaces)Local Home and Local Interfaces or both."));
        }
        if (((JTextField)this.remoteHomeInterfaceComboBox.getEditor().getEditorComponent()).getText().trim().equals("") ^ ((JTextField)this.remoteInterfaceComboBox.getEditor().getEditorComponent()).getText().trim().equals("")) {
            this.localErrorsVector.add(new ErrorObject("GeneralPanelLogical", "931", 0, "Missing remote interface.", "There must be at two remote interfaces selected.\n You must have pairs (Remote Home and Remote) interfaces or (Local Home and Local) interfaces or both."));
        }
        if (((JTextField)this.localHomeInterfaceComboBox.getEditor().getEditorComponent()).getText().trim().equals("") ^ ((JTextField)this.localInterfaceComboBox.getEditor().getEditorComponent()).getText().trim().equals("")) {
            this.localErrorsVector.add(new ErrorObject("GeneralPanelLogical", "932", 0, "Missing local interface.", "There must be at two remote interfaces selected.\n You must have pairs (Remote Home and Remote) interfaces or (Local Home and Local) interfaces or both."));
        }
    }

    private void checkDeploy(boolean isMDB) {
        this.localErrorsVector = new Vector();
        this.id = 900;
        if (!isMDB) {
            this.checkInterfacesAvailability();
        }
        DynamicClassLoader loader = new DynamicClassLoader(this.classPath);
        String testClass = ((JTextField)this.beanClassNameComboBox.getEditor().getEditorComponent()).getText();
        Object[] results = this.checkSingleClass(loader, testClass, true, "Bean", this.id++);
        Class test2 = (Class)results[0];
        ErrorObject erObj = (ErrorObject)results[1];
        if (erObj != null) {
            this.localErrorsVector.add(erObj);
        }
        testClass = ((JTextField)this.remoteHomeInterfaceComboBox.getEditor().getEditorComponent()).getText();
        results = this.checkSingleClass(loader, testClass, false, "Remote home interface", this.id++);
        test2 = (Class)results[0];
        ErrorObject erObj1 = (ErrorObject)results[1];
        if (erObj1 != null) {
            this.localErrorsVector.add(erObj1);
        }
        if (test2 != null && !(class$javax$ejb$EJBHome == null ? (class$javax$ejb$EJBHome = GeneralPanelLogic.class$("javax.ejb.EJBHome")) : class$javax$ejb$EJBHome).isAssignableFrom(test2)) {
            ErrorObject eo = new ErrorObject("GeneralPanelLogical", "911", 0, testClass + " does not inharit javax.ejb.EJBHome", "Possible reasons: Wrong class is put in Remote Home Interface field.\n");
            this.localErrorsVector.add(eo);
        }
        testClass = ((JTextField)this.remoteInterfaceComboBox.getEditor().getEditorComponent()).getText();
        results = this.checkSingleClass(loader, testClass, false, "Remote interface", this.id++);
        test2 = (Class)results[0];
        ErrorObject erObj2 = (ErrorObject)results[1];
        if (erObj2 != null) {
            this.localErrorsVector.add(erObj2);
        }
        if (test2 != null && !(class$javax$ejb$EJBObject == null ? (class$javax$ejb$EJBObject = GeneralPanelLogic.class$("javax.ejb.EJBObject")) : class$javax$ejb$EJBObject).isAssignableFrom(test2)) {
            ErrorObject eo = new ErrorObject("GeneralPanelLogical", "912", 0, testClass + " does not inharit javax.ejb.EJBObject", "Possible reasons: Wrong class is put in Remote Interface field.\n");
            this.localErrorsVector.add(eo);
        }
        testClass = ((JTextField)this.localHomeInterfaceComboBox.getEditor().getEditorComponent()).getText();
        results = this.checkSingleClass(loader, testClass, false, "Local home interface", this.id++);
        test2 = (Class)results[0];
        ErrorObject erObj3 = (ErrorObject)results[1];
        if (erObj3 != null) {
            this.localErrorsVector.add(erObj3);
        }
        if (test2 != null && !(class$javax$ejb$EJBLocalHome == null ? (class$javax$ejb$EJBLocalHome = GeneralPanelLogic.class$("javax.ejb.EJBLocalHome")) : class$javax$ejb$EJBLocalHome).isAssignableFrom(test2)) {
            ErrorObject eo = new ErrorObject("GeneralPanelLogical", "913", 0, testClass + " does not inharit javax.ejb.EJBLocalHome", "Possible reasons: Wrong class is put in Local Home Interface field.\n");
            this.localErrorsVector.add(eo);
        }
        testClass = ((JTextField)this.localInterfaceComboBox.getEditor().getEditorComponent()).getText();
        results = this.checkSingleClass(loader, testClass, false, "Local interface", this.id++);
        test2 = (Class)results[0];
        ErrorObject erObj4 = (ErrorObject)results[1];
        if (erObj4 != null) {
            this.localErrorsVector.add(erObj4);
        }
        if (test2 != null && !(class$javax$ejb$EJBLocalObject == null ? (class$javax$ejb$EJBLocalObject = GeneralPanelLogic.class$("javax.ejb.EJBLocalObject")) : class$javax$ejb$EJBLocalObject).isAssignableFrom(test2)) {
            ErrorObject eo = new ErrorObject("GeneralPanelLogical", "914", 0, testClass + " does not inharit javax.ejb.EJBLocalObject", "Possible reasons: Wrong class is put in Local Interface field.\n");
            this.localErrorsVector.add(eo);
        }
    }

    private int checkEntity() {
        int res = 0;
        this.checkDeploy(false);
        if (this.localErrorsVector.size() > 0) {
            res = 2;
        }
        DynamicClassLoader loader = new DynamicClassLoader(this.classPath);
        String testClass = null;
        Object[] results = null;
        Class test2 = null;
        if (this.persistenceManagment.getSelectedItem().equals("Container Managment") && !(testClass = ((JTextField)this.pkTypeField.getEditor().getEditorComponent()).getText()).toLowerCase().startsWith("java.") && !testClass.toLowerCase().startsWith("javax.")) {
            results = this.checkSingleClass(loader, testClass, false, "Primary key", this.id++);
            test2 = (Class)results[0];
            ErrorObject erObj5 = (ErrorObject)results[1];
            if (erObj5 != null) {
                this.localErrorsVector.add(erObj5);
            }
            if (test2 != null) {
                if (!(class$java$io$Serializable == null ? (class$java$io$Serializable = GeneralPanelLogic.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(test2)) {
                    ErrorObject eo = new ErrorObject("GeneralPanelLogical", "915", 0, testClass + " does not inharit Serializable", "Possible reasons: Wrong class is put in Primary key field.\n");
                    this.localErrorsVector.add(eo);
                    res = 2;
                }
            } else {
                res = 2;
            }
        }
        Object[] localErrors = new ErrorObject[this.localErrorsVector.size()];
        this.localErrorsVector.copyInto(localErrors);
        this.errors.setDescriptorName(this.dDescr.getEjbName());
        this.errors.setErrors((ErrorObject[])localErrors);
        return res;
    }

    private int checkSession() {
        int res = 0;
        this.checkDeploy(false);
        if (this.localErrorsVector.size() > 0) {
            res = 2;
        }
        Object[] localErrors = new ErrorObject[this.localErrorsVector.size()];
        this.localErrorsVector.copyInto(localErrors);
        this.errors.setDescriptorName(this.dDescr.getEjbName());
        this.errors.setErrors((ErrorObject[])localErrors);
        return res;
    }

    private int checkMsgDriven() {
        int res = 0;
        this.checkDeploy(true);
        if (this.localErrorsVector.size() > 0) {
            res = 2;
        }
        Object[] localErrors = new ErrorObject[this.localErrorsVector.size()];
        this.localErrorsVector.copyInto(localErrors);
        this.errors.setDescriptorName(this.dDescr.getEjbName());
        this.errors.setErrors((ErrorObject[])localErrors);
        return res;
    }

    public int isCorrect() {
        if (this.madeFrom == 1 || this.madeFrom == 0) {
            return this.checkClasses();
        }
        return 0;
    }

    public DeploymentDescriptor getDescriptor() {
        return this.dDescr;
    }

    public void setLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public ErrorReportObject getErrorObject() {
        return this.errors;
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
        if (this.madeFrom == 1 || this.madeFrom == 0) {
            appProvider.addLoadedFilesListener(this);
        }
    }

    public void addToHashTable(String key, String value) {
        if (key.equals("BeanClass")) {
            this.addValueToComboBox(value, this.beanClassNameComboBox);
        } else if (key.equals("javax.ejb.EJBHome")) {
            this.addValueToComboBox(value, this.remoteHomeInterfaceComboBox);
        } else if (key.equals("javax.ejb.EJBObject")) {
            this.addValueToComboBox(value, this.remoteInterfaceComboBox);
        } else if (key.equals("javax.ejb.EJBLocalHome")) {
            this.addValueToComboBox(value, this.localHomeInterfaceComboBox);
        } else if (key.equals("javax.ejb.EJBLocalObject")) {
            this.addValueToComboBox(value, this.localInterfaceComboBox);
        } else if (key.equals("PrimaryKey")) {
            this.addValueToComboBox(value, this.pkTypeField);
        }
    }

    public void removeFromHashTable(String key, Vector value) {
        if (key.equals("BeanClass")) {
            this.removeValueFromComboBox(value, this.beanClassNameComboBox);
        } else if (key.equals("javax.ejb.EJBHome")) {
            this.removeValueFromComboBox(value, this.remoteHomeInterfaceComboBox);
        } else if (key.equals("javax.ejb.EJBObject")) {
            this.removeValueFromComboBox(value, this.remoteInterfaceComboBox);
        } else if (key.equals("javax.ejb.EJBLocalHome")) {
            this.removeValueFromComboBox(value, this.localHomeInterfaceComboBox);
        } else if (key.equals("javax.ejb.EJBLocalObject")) {
            this.removeValueFromComboBox(value, this.localInterfaceComboBox);
        } else if (key.equals("PrimaryKey")) {
            this.removeValueFromComboBox(value, this.pkTypeField);
        }
    }

    private synchronized void addValueToComboBox(String value, JComboBox target) {
        if (target == null || value == null) {
            return;
        }
        if (this.hasElementInComboBox(value, target) == -1) {
            target.addItem(value);
        }
    }

    private synchronized void removeValueFromComboBox(Vector value, JComboBox target) {
        if (target == null || value == null) {
            return;
        }
        DefaultComboBoxModel model = new DefaultComboBoxModel(this.getVectorFromComboBox(target, value));
        target.setModel(model);
    }

    private synchronized Vector getVectorFromComboBox(JComboBox combo, Vector value) {
        Vector result = new Vector();
        int i = 0;
        while (i < combo.getModel().getSize()) {
            if (!value.contains(((DefaultComboBoxModel)combo.getModel()).getElementAt(i))) {
                result.addElement(((DefaultComboBoxModel)combo.getModel()).getElementAt(i));
            }
            ++i;
        }
        return result;
    }

    private int hasElementInComboBox(String elem, JComboBox target) {
        if (target == null || elem == null) {
            return -1;
        }
        JComboBox jComboBox = target;
        synchronized (jComboBox) {
            int i = 0;
            while (i < target.getItemCount()) {
                if (target.getItemAt(i).equals(elem)) {
                    int n = i;
                    return n;
                }
                ++i;
            }
        }
        return -1;
    }

    public void clearContent() {
    }

    private void loadCMPFields() {
        this.hashCMP = this.appProvider.getAllCMP2_0Fields(null, this.dDescr.getClassName(), this.dDescr.getEjbName());
        this.addFields();
    }

    private void trigerCMP20_PkEvent() {
        if (this.onSet) {
            return;
        }
        if (((JTextField)this.pkField.getEditor().getEditorComponent()).getText().trim().equals("")) {
            this.pkTypeField.setSelectedItem("java.lang.Object");
        } else if (this.hashCMP != null) {
            Enumeration hashEnum = this.hashCMP.keys();
            boolean found = false;
            while (hashEnum.hasMoreElements()) {
                String key = (String)hashEnum.nextElement();
                if (!key.equals(((JTextField)this.pkField.getEditor().getEditorComponent()).getText())) continue;
                StringBuffer value = (StringBuffer)this.hashCMP.get(key);
                this.pkTypeField.setSelectedItem(value.toString());
                found = true;
            }
            if (!found) {
                this.pkTypeField.setSelectedItem("java.lang.String");
            }
        } else if (this.pkTypeField.getSelectedItem() != null && this.pkTypeField.getSelectedItem().equals("java.lang.Object")) {
            this.pkTypeField.setSelectedItem("java.lang.String");
        }
    }

    private void addFields() {
        if (this.hashCMP == null) {
            return;
        }
        Enumeration hashEnum = this.hashCMP.keys();
        Vector<String> cmpFields = new Vector<String>();
        Vector<String> cmpTypes = new Vector<String>();
        while (hashEnum.hasMoreElements()) {
            String key = (String)hashEnum.nextElement();
            cmpFields.addElement(key);
            cmpTypes.addElement(this.hashCMP.get(key).toString());
        }
        if (cmpTypes.size() != 0) {
            this.pkField.removeAllItems();
            int i = 0;
            while (i < cmpTypes.size()) {
                if (this.hasElementInComboBox((String)cmpFields.elementAt(i), this.pkField) == -1) {
                    this.pkField.addItem(cmpFields.elementAt(i));
                }
                if (this.hasElementInComboBox((String)cmpTypes.elementAt(i), this.pkTypeField) == -1) {
                    this.pkTypeField.addItem(cmpTypes.elementAt(i));
                }
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

