/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.ejb.gui.logic;

import com.sap.engine.deploy.ejb.gui.visual.AccessControlPanel;
import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.gui.TreeUtils;
import com.sap.engine.services.deploy.ear.common.EqualUtils;
import com.sap.engine.services.deploy.ear.common.MethodEntry;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.common.additional.ListValues;
import com.sap.engine.services.deploy.gui.common.additional.SecurityTreeNode;
import com.sap.engine.services.deploy.gui.common.additional.SecurityTreeRenderer;
import com.sap.engine.services.deploy.gui.common.additional.SecurityUserObject;
import com.sap.engine.services.ejb.deploy.descriptors.AccessControls;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.MessageDrivenDescriptor;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class AccessControlPanelLogical
extends AccessControlPanel {
    protected SecurityTreeNode root = null;
    protected SecurityTreeNode beanNode = null;
    protected SecurityTreeNode globalNode = null;
    private Icon rootIcon = null;
    private String rootName = null;
    private Vector secValues = new Vector();
    private Vector availableValues = new Vector();
    private Vector addValue = new Vector();
    private Vector removeValue = new Vector();
    private Vector excludeValue = new Vector();
    private Hashtable access = new Hashtable();
    private Hashtable excludeList = new Hashtable();
    private EJBJarDescriptor jarDescriptor = null;
    private ClassLoader loader = null;
    private int madeFrom = 0;
    private boolean collapsed = false;
    private boolean uncheck = false;
    private boolean exclude = false;
    private boolean classNotFoundErr = false;
    private ApplicationInformationProvider appProvider;

    public AccessControlPanelLogical(Frame mainFrame, Icon rootIcon, ClassLoader loader) {
        this.loader = loader;
        this.rootIcon = rootIcon;
        this.mainFrame = mainFrame;
        this.methodTree.setCellRenderer(new SecurityTreeRenderer(rootIcon));
        this.root = new SecurityTreeNode(this.rootName == null ? "Entire Component" : this.rootName, 0);
        ((DefaultTreeModel)this.methodTree.getModel()).setRoot(this.root);
        this.initButtons();
        this.availableValues = new Vector();
    }

    public void setDescriptor(EJBJarDescriptor descr) {
        this.classNotFoundErr = false;
        this.jarDescriptor = descr;
        this.collapsed = false;
        this.uncheck = false;
        this.exclude = false;
        this.rootName = descr.getJarName();
        this.secValues.removeAllElements();
        this.availableValues.removeAllElements();
        this.addValue.removeAllElements();
        this.removeValue.removeAllElements();
        this.root.removeAllChildren();
        this.excludeValue = new Vector();
        this.excludeList = new Hashtable();
        this.access = new Hashtable();
        this.root = new SecurityTreeNode(this.jarDescriptor.getJarName() == null ? "Entire Component" : this.jarDescriptor.getJarName(), 0);
        ((DefaultTreeModel)this.methodTree.getModel()).setRoot(this.root);
        this.initButtons();
        this.initTree(this.jarDescriptor);
        ((DefaultTreeModel)this.methodTree.getModel()).reload();
        TreeUtils.expandTree((JTree)this.methodTree, (int)1);
    }

    private void initButtons() {
        SecurityTreeNode selectedNode = (SecurityTreeNode)this.methodTree.getLastSelectedPathComponent();
        SecurityUserObject selObject = null;
        if (this.methodTree.isSelectionEmpty() || this.availableList.isSelectionEmpty()) {
            this.addButton.setEnabled(false);
        } else {
            this.addButton.setEnabled(true);
        }
        if (this.methodTree.isSelectionEmpty() || this.selectedList.isSelectionEmpty()) {
            this.removeButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
        }
        if (selectedNode != null) {
            selObject = (SecurityUserObject)selectedNode.getUserObject();
            if (selObject.getType() == 3 || selObject.getType() == 4 || selObject.getType() == 12) {
                this.checked.setSelected(true);
                this.checked.setEnabled(false);
                this.unchecked.setEnabled(false);
                this.excluded.setEnabled(false);
            } else {
                this.checked.setEnabled(true);
                this.unchecked.setEnabled(true);
                this.excluded.setEnabled(true);
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        this.initButtons();
    }

    public void valueChanged(TreeSelectionEvent e) {
        this.treeValueChanged();
    }

    public void treeWillCollapse(TreeExpansionEvent e) {
        this.treeValueChanged();
    }

    public void treeWillExpand(TreeExpansionEvent e) {
    }

    public void treeValueChanged() {
        this.initButtons();
        SecurityTreeNode selectedNode = null;
        if (!this.methodTree.isSelectionEmpty()) {
            this.descrPanel.setEnabled(true);
            selectedNode = (SecurityTreeNode)this.methodTree.getLastSelectedPathComponent();
            if (((SecurityUserObject)selectedNode.getUserObject()).getType() == 0) {
                if (!this.collapsed) {
                    this.collapsed = true;
                    TreeUtils.collapseTree((JTree)this.methodTree, (int)2);
                }
                this.mainSplitPane.add((Component)this.emptyPanel, "right");
                this.mainSplitPane.setDividerLocation(200);
                return;
            }
            this.collapsed = false;
            this.mainSplitPane.add((Component)this.rolesPanel, "right");
            this.mainSplitPane.setDividerLocation(200);
            if (this.globalNode != null) {
                this.setValues(this.globalNode);
                if (this.globalNode.getAccessControls() != null) {
                    this.globalNode.getAccessControls().setDescription(this.descrPanel.getText());
                }
                if (!this.globalNode.isExcludedNode() && this.globalNode.getAccessControls() != null && !this.globalNode.getAccessControls().getUnchecked()) {
                    this.setEqualRolesDescr(this.secValues, this.descrPanel.getText());
                }
            }
            this.globalNode = selectedNode;
            if (selectedNode.isExcludedNode()) {
                this.exclude = true;
                this.availableList.clearSelection();
            } else {
                this.exclude = false;
            }
            if (selectedNode.getAccessControls() != null && selectedNode.getAccessControls().getUnchecked()) {
                this.uncheck = true;
                this.availableList.clearSelection();
            } else {
                this.uncheck = false;
            }
            if (this.uncheck) {
                this.unchecked.setSelected(true);
            } else if (this.exclude) {
                this.excluded.setSelected(true);
            } else {
                this.checked.setSelected(true);
            }
            if (!this.secValues.isEmpty()) {
                this.secValues.removeAllElements();
            }
            this.showValues(selectedNode);
            this.selectedList.setListData(this.secValues);
            if (!this.addValue.isEmpty()) {
                this.addValue.removeAllElements();
            }
            if (!this.removeValue.isEmpty()) {
                this.removeValue.removeAllElements();
            }
        } else {
            this.none.setSelected(true);
            this.checked.setEnabled(false);
            this.unchecked.setEnabled(false);
            this.excluded.setEnabled(false);
            this.descrPanel.setText("");
            this.descrPanel.setEnabled(false);
            this.globalNode = null;
            if (!this.secValues.isEmpty()) {
                this.secValues.removeAllElements();
            }
            this.selectedList.setListData(this.secValues);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("REMOVE_CMD")) {
            this.removeBtnAction();
        } else if (cmd.equals("ADD_CMD")) {
            this.addBtnAction();
        } else if (cmd.equals("CHECK")) {
            this.checkBtnAction();
        } else if (cmd.equals("UNCHECK")) {
            this.uncheckBtnAction();
        } else if (cmd.equals("EXCLUDE")) {
            this.excludeBtnAction();
        }
    }

    public void initAvailableList(Vector roles) {
        if (roles != null) {
            Object[] secRoles = new String[roles.size()];
            Vector diff = this.difference(this.availableValues, roles);
            roles.copyInto(secRoles);
            if (!this.availableValues.isEmpty()) {
                this.availableValues.removeAllElements();
            }
            int i = 0;
            while (i < secRoles.length) {
                this.availableValues.addElement(new ListValues((String)secRoles[i], 0));
                ++i;
            }
            this.availableList.setListData(this.availableValues);
            this.refreshTree(diff);
        }
    }

    private Vector difference(Vector oldVector, Vector newVector) {
        Vector<String> res = new Vector<String>();
        if (oldVector != null && newVector != null && oldVector.size() > 0) {
            int i = 0;
            while (i < oldVector.size()) {
                if (!newVector.contains(((ListValues)oldVector.elementAt(i)).getName())) {
                    res.addElement(((ListValues)oldVector.elementAt(i)).getName());
                }
                ++i;
            }
        }
        return res;
    }

    private void refreshTree(Vector diff) {
        Enumeration<TreeNode> beans = this.root.children();
        Enumeration<TreeNode> enumeration = null;
        SecurityTreeNode beanNode = null;
        SecurityTreeNode node = null;
        AccessControls ac = null;
        Object[] acc = null;
        Object[] roleNames = null;
        Vector<String> res = new Vector<String>();
        Vector<AccessControls> ace = new Vector<AccessControls>();
        String key = null;
        while (beans.hasMoreElements()) {
            beanNode = (SecurityTreeNode)beans.nextElement();
            key = beanNode.getName();
            enumeration = beanNode.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                node = (SecurityTreeNode)enumeration.nextElement();
                ac = node.getAccessControls();
                if (ac == null || ac.getSecurityRoleNames() == null) continue;
                roleNames = ac.getSecurityRoleNames();
                res = new Vector();
                int i = 0;
                while (i < roleNames.length) {
                    if (!diff.contains(roleNames[i])) {
                        res.add(roleNames[i]);
                    }
                    ++i;
                }
                if (res != null && res.size() != 0) {
                    roleNames = new String[res.size()];
                    res.copyInto(roleNames);
                    ac.setSecurityRoleNames((String[])roleNames);
                    node.setAccessControls(ac);
                    ace.add(ac);
                }
                if (ace == null || ace.size() <= 0) continue;
                acc = new AccessControls[ace.size()];
                ace.copyInto(acc);
                this.access.put(key, acc);
            }
        }
        this.selectedList.setListData(new Vector());
    }

    private void initTree(EJBJarDescriptor descr) {
        if (descr == null) {
            return;
        }
        DeploymentDescriptor[] dds = descr.getDDescriptors();
        if (dds == null) {
            return;
        }
        String beanName = null;
        AccessControls[] ace = null;
        Class[] classes = new Class[4];
        int i = 0;
        while (i < dds.length) {
            if (!(dds[i] instanceof MessageDrivenDescriptor)) {
                String mainMessage = "These classes can't be loaded. Please verify \nwhether they exist and/or set correct class path.\n";
                String warnings = "";
                Vector info = null;
                if (this.loader != null) {
                    warnings = "";
                    info = null;
                    info = this.loadClass(dds[i].getLocalHomeInterface(), this.loader);
                    warnings = warnings + (String)info.elementAt(0);
                    classes[0] = (Class)info.elementAt(1);
                    info = this.loadClass(dds[i].getLocalInterface(), this.loader);
                    warnings = warnings + (String)info.elementAt(0);
                    classes[1] = (Class)info.elementAt(1);
                    info = this.loadClass(dds[i].getRemoteHomeInterface(), this.loader);
                    warnings = warnings + (String)info.elementAt(0);
                    classes[2] = (Class)info.elementAt(1);
                    info = this.loadClass(dds[i].getRemoteInterface(), this.loader);
                    warnings = warnings + (String)info.elementAt(0);
                    classes[3] = (Class)info.elementAt(1);
                    if (!warnings.trim().equals("")) {
                        JOptionPane.showMessageDialog(this.mainFrame, mainMessage + warnings, "WARNING", 2);
                    }
                } else {
                    warnings = "";
                    if (dds[i].getLocalHomeInterface() != null) {
                        info = this.classForName(dds[i].getLocalHomeInterface());
                        warnings = warnings + (String)info.elementAt(0);
                        classes[0] = (Class)info.elementAt(1);
                    }
                    if (dds[i].getLocalInterface() != null) {
                        info = this.classForName(dds[i].getLocalInterface());
                        warnings = warnings + (String)info.elementAt(0);
                        classes[1] = (Class)info.elementAt(1);
                    }
                    if (dds[i].getRemoteHomeInterface() != null) {
                        info = this.classForName(dds[i].getRemoteHomeInterface());
                        warnings = warnings + (String)info.elementAt(0);
                        classes[2] = (Class)info.elementAt(1);
                    }
                    if (dds[i].getRemoteInterface() != null) {
                        info = this.classForName(dds[i].getRemoteInterface());
                        warnings = warnings + (String)info.elementAt(0);
                        classes[3] = (Class)info.elementAt(1);
                    }
                    if (!warnings.trim().equals("")) {
                        JOptionPane.showMessageDialog(this.mainFrame, mainMessage + warnings, "WARNING", 2);
                    }
                }
                if ((beanName = dds[i].getEjbName()) == null) {
                    beanName = dds[i].getDisplayName();
                }
                if (beanName == null) {
                    beanName = "NoName " + i;
                }
                if ((ace = dds[i].getAccessControlEntries()) == null) {
                    ace = new AccessControls[]{};
                }
                this.excludeValue = this.getExcludeList(dds[i]);
                if (ace.length > 0) {
                    this.access.put(beanName, ace);
                }
                this.initBeanNode(beanName, classes);
            }
            ++i;
        }
    }

    private Vector loadClass(String theClass, ClassLoader innerLoader) {
        Vector<Object> info = new Vector<Object>();
        String message = "";
        Class<?> loadedClass = null;
        try {
            if (theClass != null) {
                loadedClass = innerLoader.loadClass(theClass);
            }
        }
        catch (ClassNotFoundException cnfe) {
            message = message + "     " + cnfe.getMessage() + "\n";
        }
        catch (NoClassDefFoundError err) {
            message = message + "     " + err.getMessage() + "\n";
        }
        info.add(message);
        info.add(loadedClass);
        return info;
    }

    private Vector classForName(String theClass) {
        Vector<Object> info = new Vector<Object>();
        String message = "";
        Class<?> loadedClass = null;
        try {
            if (theClass != null) {
                loadedClass = Class.forName(theClass);
            }
        }
        catch (ClassNotFoundException cnfe) {
            message = message + "     " + cnfe.getMessage() + "\n";
        }
        catch (NoClassDefFoundError err) {
            message = message + "     " + err.getMessage() + "\n";
        }
        info.add(message);
        info.add(loadedClass);
        return info;
    }

    private void initBeanNode(String beanName, Class[] classes) {
        this.beanNode = new SecurityTreeNode(beanName, 12);
        AccessControls ac = this.findMethodAccess(beanName, null, null);
        if (ac == null) {
            MethodEntry ent = new MethodEntry(beanName);
            ent.setMethodInterface(null);
            ac = new AccessControls();
            ac.setMethod(ent);
        }
        this.beanNode.setAccessControls(ac);
        this.root.add(this.beanNode);
        if (classes != null && classes.length != 0) {
            int i = 0;
            while (i < classes.length) {
                if (classes[i] != null) {
                    if (i == 0 && classes[i] != null) {
                        this.loadNodes(beanName, classes[i], true, "LocalHome");
                    } else if (i == 1 && classes[i] != null) {
                        this.loadNodes(beanName, classes[i], false, "Local");
                    } else if (i == 2 && classes[i] != null) {
                        this.loadNodes(beanName, classes[i], true, "Home");
                    } else if (i == 3 && classes[i] != null) {
                        this.loadNodes(beanName, classes[i], false, "Remote");
                    }
                }
                ++i;
            }
        }
    }

    private void loadNodes(String beanName, Class mainClass, boolean color, String interF) {
        int type;
        SecurityTreeNode parentNode = null;
        SecurityTreeNode childNode = null;
        Method[] mainMethods = null;
        if (mainClass == null) {
            return;
        }
        AccessControls ac = null;
        MethodEntry meth = null;
        if (color) {
            type = 1;
            parentNode = new SecurityTreeNode(mainClass.getName(), 3);
        } else {
            type = 2;
            parentNode = new SecurityTreeNode(mainClass.getName(), 4);
        }
        ac = this.findMethodAccess(beanName, null, interF);
        if (ac == null) {
            meth = new MethodEntry();
            meth.setMethodInterface(interF);
            meth.setMethodName(null);
            ac = new AccessControls();
            ac.setMethod(meth);
        }
        parentNode.setAccessControls(ac);
        this.beanNode.add(parentNode);
        if (mainClass != null && (mainMethods = this.getClassMethods(mainClass)) != null) {
            MethodEntry entry = null;
            int i = 0;
            while (i < mainMethods.length) {
                if (Modifier.isPublic(mainMethods[i].getModifiers())) {
                    entry = new MethodEntry(mainMethods[i]);
                    entry.setMethodInterface(interF);
                    ac = this.findMethodAccess(beanName, entry, null);
                    if (ac == null) {
                        ac = new AccessControls();
                        ac.setMethod(entry);
                    }
                    childNode = new SecurityTreeNode(ac, type);
                    if (this.containsEntry(this.excludeValue, entry)) {
                        childNode.setExcludedNode(true);
                    }
                    parentNode.add(childNode);
                }
                ++i;
            }
        }
    }

    public void removeBtnAction() {
        if (!this.selectedList.isSelectionEmpty()) {
            Object selValue = this.selectedList.getSelectedValue();
            this.removeValue.addElement(selValue);
            if (this.removeValue != null && this.removeValue.size() > 0) {
                int i = 0;
                while (i < this.removeValue.size()) {
                    if (this.secValues.contains(this.removeValue.elementAt(i))) {
                        this.secValues.removeElement(this.removeValue.elementAt(i));
                    }
                    if (this.addValue.contains(this.removeValue.elementAt(i))) {
                        this.addValue.removeElement(this.removeValue.elementAt(i));
                    }
                    ++i;
                }
            }
            this.selectedList.setListData(this.secValues);
        }
        SecurityUserObject lastSelectedObj = null;
        if (this.methodTree.getSelectionPath() == null) {
            return;
        }
        String descr = this.findEqualRolesDescr(this.secValues);
        if (descr != null) {
            this.descrPanel.setText(descr);
        } else {
            this.descrPanel.setText("");
        }
        lastSelectedObj = (SecurityUserObject)this.globalNode.getUserObject();
        this.availableList.clearSelection();
        this.selectedList.clearSelection();
    }

    public void addBtnAction() {
        if (!this.availableList.isSelectionEmpty()) {
            boolean exists = false;
            int i = 0;
            while (i < this.secValues.size()) {
                if (((ListValues)this.secValues.elementAt(i)).getName().equals(((ListValues)this.availableList.getSelectedValue()).getName())) {
                    exists = true;
                    break;
                }
                ++i;
            }
            if (!exists) {
                this.addValue.addElement(this.availableList.getSelectedValue());
                if (this.addValue != null && this.addValue.size() != 0) {
                    int i2 = 0;
                    while (i2 < this.addValue.size()) {
                        if (!this.secValues.contains(this.addValue.elementAt(i2))) {
                            this.secValues.addElement(this.addValue.elementAt(i2));
                        }
                        if (this.removeValue.contains(this.addValue.elementAt(i2))) {
                            this.removeValue.removeElement(this.addValue.elementAt(i2));
                        }
                        ++i2;
                    }
                }
            }
            this.selectedList.setListData(this.secValues);
            String descr = this.findEqualRolesDescr(this.secValues);
            if (descr != null) {
                this.descrPanel.setText(descr);
            } else {
                this.descrPanel.setText("");
            }
            this.availableList.clearSelection();
            this.selectedList.clearSelection();
        }
    }

    public void checkBtnAction() {
        this.availableList.setEnabled(true);
        this.selectedList.setEnabled(true);
        this.uncheck = false;
        this.exclude = false;
        this.nodeChanged();
    }

    public void uncheckBtnAction() {
        this.availableList.clearSelection();
        this.availableList.setEnabled(false);
        this.secValues.removeAllElements();
        this.uncheck = true;
        this.exclude = false;
        this.selectedList.setListData(this.secValues);
        this.selectedList.setEnabled(false);
        this.nodeChanged();
    }

    public void excludeBtnAction() {
        this.availableList.clearSelection();
        this.availableList.setEnabled(false);
        this.secValues.removeAllElements();
        this.exclude = true;
        this.uncheck = false;
        this.selectedList.setListData(this.secValues);
        this.selectedList.setEnabled(false);
        this.nodeChanged();
    }

    public void nodeChanged() {
        SecurityTreeNode selectedNode = (SecurityTreeNode)this.methodTree.getLastSelectedPathComponent();
        AccessControls ac = selectedNode.getAccessControls();
        if (ac != null) {
            if (this.uncheck) {
                ac.setUnchecked(true);
                ac.setDescription("");
                selectedNode.setAccessControls(ac);
                selectedNode.setExcludedNode(false);
            } else if (this.exclude) {
                ac.setDescription("");
                selectedNode.setExcludedNode(true);
            } else {
                ac.setUnchecked(false);
                selectedNode.setAccessControls(ac);
                selectedNode.setExcludedNode(false);
            }
        }
        ((DefaultTreeModel)this.methodTree.getModel()).reload(selectedNode);
        this.showValues(selectedNode);
    }

    public void setValues(SecurityTreeNode node) {
        int i;
        DefaultMutableTreeNode[] children;
        int childrenCount;
        SecurityUserObject lastSelectedObj = (SecurityUserObject)node.getUserObject();
        SecurityTreeNode currentNode = null;
        String[] roles = null;
        String descr = null;
        if (this.secValues.size() > 0) {
            roles = new String[this.secValues.size()];
            int i2 = 0;
            while (i2 < this.secValues.size()) {
                roles[i2] = ((ListValues)this.secValues.elementAt(i2)).getName();
                ++i2;
            }
        } else if (node != null && node.getAccessControls() != null && node.getAccessControls().getUnchecked()) {
            roles = node.getAccessControls().getSecurityRoleNames();
        }
        if (lastSelectedObj.getType() == 12) {
            childrenCount = ((DefaultTreeModel)this.methodTree.getModel()).getChildCount(node);
            children = new DefaultMutableTreeNode[childrenCount];
            i = 0;
            while (i < childrenCount) {
                children[i] = (DefaultMutableTreeNode)((DefaultTreeModel)this.methodTree.getModel()).getChild(node, i);
                currentNode = (SecurityTreeNode)children[i];
                this.setValues(currentNode);
                ++i;
            }
        }
        if (lastSelectedObj.getType() == 3 || lastSelectedObj.getType() == 4) {
            childrenCount = ((DefaultTreeModel)this.methodTree.getModel()).getChildCount(node);
            if (childrenCount != 0) {
                children = new DefaultMutableTreeNode[childrenCount];
                i = 0;
                while (i < childrenCount) {
                    children[i] = (DefaultMutableTreeNode)((DefaultTreeModel)this.methodTree.getModel()).getChild(node, i);
                    ++i;
                }
                int i3 = 0;
                while (i3 < childrenCount) {
                    currentNode = (SecurityTreeNode)children[i3];
                    if (currentNode.getAccessControls().getSecurityRoleNames() != null) {
                        currentNode.getAccessControls().setSecurityRoleNames(this.merge(currentNode.getAccessControls().getSecurityRoleNames(), this.addValue, this.removeValue));
                    } else {
                        currentNode.getAccessControls().setSecurityRoleNames(roles);
                    }
                    if (!currentNode.isExcludedNode() && !currentNode.getAccessControls().getUnchecked() && (descr = this.findEqualRolesDescr(currentNode.getAccessControls().getSecurityRoleNames(), currentNode)) != null) {
                        currentNode.getAccessControls().setDescription(descr);
                    }
                    ++i3;
                }
            }
        } else if (this.exclude) {
            node.setExcludedNode(true);
            if (node.getAccessControls() != null) {
                node.getAccessControls().setDescription(this.descrPanel.getText());
            } else {
                AccessControls ac = new AccessControls();
                MethodEntry entry = node.getMethodEntry();
                ac.setMethod(entry);
                ac.setDescription(this.descrPanel.getText());
                node.setAccessControls(ac);
            }
        } else if (node.getAccessControls() != null) {
            node.getAccessControls().setSecurityRoleNames(roles);
            if (this.uncheck) {
                node.getAccessControls().setUnchecked(true);
                node.getAccessControls().setDescription(this.descrPanel.getText());
            }
        }
    }

    public AccessControls findMethodAccess(String beanName, MethodEntry method, String name) {
        AccessControls[] ace = (AccessControls[])this.access.get(beanName);
        if (ace != null) {
            int i = 0;
            while (i < ace.length) {
                if (ace[i] != null) {
                    if (method == null) {
                        if (ace[i].getMethod() != null && !ace[i].getMethod().isMethodSpecified()) {
                            if (ace[i].getMethod().getMethodName() != null && ace[i].getMethod().getMethodName().equals(name)) {
                                return ace[i];
                            }
                            if (ace[i].getMethod().getMethodInterface() != null && ace[i].getMethod().getMethodInterface().equals(name)) {
                                return ace[i];
                            }
                        }
                    } else if (ace[i].getMethod() != null && ace[i].getMethod().simpleEquals(method)) {
                        return ace[i];
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private Vector getExcludeList(DeploymentDescriptor descr) {
        MethodEntry[] methods = descr.getUncalableMethods();
        this.excludeValue = new Vector();
        if (methods == null || methods.length == 0) {
            return this.excludeValue;
        }
        int i = 0;
        while (i < methods.length) {
            this.excludeValue.add(methods[i]);
            ++i;
        }
        return this.excludeValue;
    }

    private String findEqualRolesDescr(String[] selectedRoles, SecurityTreeNode selNode) {
        Vector<AccessControls> acc = new Vector<AccessControls>();
        Enumeration<TreeNode> enumeration = this.root.depthFirstEnumeration();
        SecurityTreeNode node = null;
        AccessControls ac = null;
        String descr = null;
        while (enumeration.hasMoreElements()) {
            node = (SecurityTreeNode)enumeration.nextElement();
            if (node.equals(selNode) || (ac = node.getAccessControls()) == null) continue;
            acc.add(ac);
        }
        if (acc != null) {
            int i = 0;
            while (i < acc.size()) {
                if (EqualUtils.equalUnOrderedArrays(selectedRoles, ((AccessControls)acc.elementAt(i)).getSecurityRoleNames()) && (descr = ((AccessControls)acc.elementAt(i)).getDescription()) != null && !descr.trim().equals("")) {
                    return descr.trim();
                }
                ++i;
            }
        }
        return null;
    }

    private void setEqualRolesDescr(Vector listValues, String description) {
        Vector<AccessControls> acc = new Vector<AccessControls>();
        Enumeration<TreeNode> enumeration = this.root.depthFirstEnumeration();
        SecurityTreeNode node = null;
        AccessControls ac = null;
        Object[] selectedRoles = new String[listValues.size()];
        String descr = null;
        while (enumeration.hasMoreElements()) {
            node = (SecurityTreeNode)enumeration.nextElement();
            if (node.isExcludedNode() || (ac = node.getAccessControls()) == null || ac.getUnchecked()) continue;
            acc.add(ac);
        }
        int i = 0;
        while (i < selectedRoles.length) {
            selectedRoles[i] = ((ListValues)listValues.elementAt(i)).getName();
            ++i;
        }
        if (acc != null) {
            int i2 = 0;
            while (i2 < acc.size()) {
                descr = ((AccessControls)acc.elementAt(i2)).getDescription();
                if (EqualUtils.equalUnOrderedArrays(selectedRoles, ((AccessControls)acc.elementAt(i2)).getSecurityRoleNames()) && !description.equals(descr)) {
                    ((AccessControls)acc.elementAt(i2)).setDescription(description);
                }
                ++i2;
            }
        }
    }

    public void commitChange() {
        SecurityTreeNode selNode;
        if (this.classNotFoundErr) {
            return;
        }
        DeploymentDescriptor[] descriptors = this.jarDescriptor.getDDescriptors();
        AccessControls[] acc = null;
        MethodEntry[] entries = null;
        String beanName = null;
        if (this.methodTree.getSelectionPath() != null && (selNode = (SecurityTreeNode)this.methodTree.getLastSelectedPathComponent()).getAccessControls() != null) {
            this.setValues(this.globalNode);
            selNode.getAccessControls().setDescription(this.descrPanel.getText());
            this.setEqualRolesDescr(this.secValues, this.descrPanel.getText());
        }
        Hashtable ace = this.collectAll();
        if (descriptors != null && descriptors.length != 0) {
            int i = 0;
            while (i < descriptors.length) {
                beanName = descriptors[i].getEjbName();
                acc = (AccessControls[])ace.get(beanName);
                entries = (MethodEntry[])this.excludeList.get(beanName);
                if (acc != null && acc.length != 0) {
                    descriptors[i].setAccessControlEntries(acc);
                }
                descriptors[i].setUncalableMethods(entries);
                ++i;
            }
            this.jarDescriptor.setDescriptors(descriptors);
        }
        this.methodTree.getSelectionModel().clearSelection();
    }

    private Hashtable collectAll() {
        Hashtable<String, Object[]> res = new Hashtable<String, Object[]>();
        Vector<AccessControls> acc = new Vector<AccessControls>();
        Vector<MethodEntry> temp = new Vector<MethodEntry>();
        Enumeration<TreeNode> enumeration = null;
        Enumeration<TreeNode> beans = this.root.children();
        SecurityTreeNode beanNode = null;
        SecurityTreeNode node = null;
        AccessControls ace = null;
        Object[] aceArray = null;
        Object[] entries = null;
        String key = null;
        while (beans.hasMoreElements()) {
            beanNode = (SecurityTreeNode)beans.nextElement();
            key = beanNode.getName();
            temp = new Vector();
            enumeration = beanNode.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                node = (SecurityTreeNode)enumeration.nextElement();
                if (node.isExcludedNode()) {
                    temp.add(node.getMethodEntry());
                }
                if ((ace = node.getAccessControls()) == null) continue;
                acc.add(ace);
            }
            if (temp.size() != 0) {
                entries = new MethodEntry[temp.size()];
                temp.copyInto(entries);
                this.excludeList.put(key, entries);
            }
            if (acc.size() == 0) continue;
            aceArray = new AccessControls[acc.size()];
            acc.copyInto(aceArray);
            acc = new Vector();
            res.put(key, aceArray);
        }
        return res;
    }

    public void showValues(SecurityTreeNode node) {
        SecurityUserObject lastSelectedObj = null;
        SecurityTreeNode currentNode = null;
        String[] roles = null;
        String descr = null;
        lastSelectedObj = (SecurityUserObject)node.getUserObject();
        Vector res = new Vector();
        boolean flag = false;
        this.availableList.setEnabled(true);
        this.selectedList.setEnabled(true);
        this.secValues.removeAllElements();
        if (lastSelectedObj.getType() == 3 || lastSelectedObj.getType() == 4 || lastSelectedObj.getType() == 12) {
            if (lastSelectedObj.getType() == 12) {
                int childrenCount = ((DefaultTreeModel)this.methodTree.getModel()).getChildCount(node);
                DefaultMutableTreeNode[] children = new DefaultMutableTreeNode[childrenCount];
                Vector temp = new Vector();
                int i = 0;
                while (i < childrenCount) {
                    children[i] = (DefaultMutableTreeNode)((DefaultTreeModel)this.methodTree.getModel()).getChild(node, i);
                    currentNode = (SecurityTreeNode)children[i];
                    temp = this.getCommonRoles(currentNode);
                    if (temp == null || temp.size() == 0) {
                        res = new Vector();
                        break;
                    }
                    int j = 0;
                    while (j < temp.size()) {
                        if (!flag) {
                            res.add(temp.elementAt(j));
                        } else {
                            int index = 0;
                            int size = res.size();
                            while (index < size) {
                                if (!temp.contains(res.elementAt(index))) {
                                    res.removeElementAt(index);
                                    size = res.size();
                                    continue;
                                }
                                ++index;
                            }
                        }
                        ++j;
                    }
                    flag = true;
                    ++i;
                }
            } else {
                res = this.getCommonRoles(node);
            }
            if (res != null) {
                int i = 0;
                while (i < res.size()) {
                    this.secValues.add(new ListValues((String)res.elementAt(i), 0));
                    ++i;
                }
            }
            descr = this.findEqualRolesDescr(this.secValues);
        } else if (node != null && node.getAccessControls() != null) {
            roles = node.getAccessControls().getSecurityRoleNames();
            if (roles != null) {
                int i = 0;
                while (i < roles.length) {
                    if (this.findElement(roles[i], this.availableValues)) {
                        this.secValues.add(new ListValues(roles[i], 0));
                    }
                    ++i;
                }
            }
            if (node.isExcludedNode()) {
                this.excluded.setSelected(true);
                this.availableList.setEnabled(false);
                this.selectedList.setEnabled(false);
                this.secValues.removeAllElements();
                descr = node.getAccessControls().getDescription();
            } else if (node.getAccessControls().getUnchecked()) {
                this.unchecked.setSelected(true);
                this.availableList.setEnabled(false);
                this.selectedList.setEnabled(false);
                this.secValues.removeAllElements();
                descr = node.getAccessControls().getDescription();
            } else {
                descr = this.findEqualRolesDescr(this.secValues);
                this.checked.setSelected(true);
                this.selectedList.setListData(this.secValues);
            }
        }
        this.descrPanel.setText(descr);
    }

    private String findEqualRolesDescr(Vector listValues) {
        Vector<AccessControls> acc = new Vector<AccessControls>();
        Object[] selectedRoles = new String[listValues.size()];
        Enumeration<TreeNode> enumeration = this.root.depthFirstEnumeration();
        SecurityTreeNode node = null;
        AccessControls ac = null;
        String descr = null;
        while (enumeration.hasMoreElements()) {
            node = (SecurityTreeNode)enumeration.nextElement();
            ac = node.getAccessControls();
            acc.add(ac);
        }
        int i = 0;
        while (i < selectedRoles.length) {
            selectedRoles[i] = ((ListValues)listValues.elementAt(i)).getName();
            ++i;
        }
        if (acc != null) {
            int i2 = 0;
            while (i2 < this.access.size()) {
                if (EqualUtils.equalUnOrderedArrays(selectedRoles, ((AccessControls)acc.elementAt(i2)).getSecurityRoleNames())) {
                    descr = ((AccessControls)acc.elementAt(i2)).getDescription();
                    if (descr != null && !descr.trim().equals("")) {
                        return descr.trim();
                    }
                    return null;
                }
                ++i2;
            }
        }
        return null;
    }

    public String[] merge(String[] roles, Vector addVec, Vector removeVec) {
        int j;
        int i;
        Vector<String> rolesVec = new Vector<String>();
        String role = null;
        if (roles != null) {
            int i2 = 0;
            while (i2 < roles.length) {
                rolesVec.add(roles[i2]);
                ++i2;
            }
        }
        int index = -1;
        if (addVec != null) {
            i = 0;
            while (i < addVec.size()) {
                role = ((ListValues)addVec.elementAt(i)).getName();
                j = 0;
                while (j < rolesVec.size()) {
                    if (((String)rolesVec.elementAt(j)).equals(role)) {
                        index = i;
                        break;
                    }
                    ++j;
                }
                if (index == -1) {
                    rolesVec.add(role);
                }
                index = -1;
                ++i;
            }
        }
        index = -1;
        if (removeVec != null) {
            i = 0;
            while (i < removeVec.size()) {
                role = ((ListValues)removeVec.elementAt(i)).getName();
                j = 0;
                while (j < rolesVec.size()) {
                    if (((String)rolesVec.elementAt(j)).equals(role)) {
                        rolesVec.remove(j);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (rolesVec.size() != 0) {
            Object[] secRoles = new String[rolesVec.size()];
            rolesVec.copyInto(secRoles);
            return secRoles;
        }
        return null;
    }

    public Vector getCommonRoles(SecurityTreeNode node) {
        Vector<String> res = new Vector<String>();
        Object child = null;
        String[] secRoles = null;
        int childrenCount = ((DefaultTreeModel)this.methodTree.getModel()).getChildCount(node);
        if (childrenCount != 0) {
            SecurityTreeNode[] children = new SecurityTreeNode[childrenCount];
            children[0] = (SecurityTreeNode)((DefaultTreeModel)this.methodTree.getModel()).getChild(node, 0);
            secRoles = children[0].getAccessControls().getSecurityRoleNames();
            if (secRoles == null || secRoles.length == 0) {
                return res;
            }
            int i = 0;
            while (i < secRoles.length) {
                res.add(secRoles[i]);
                ++i;
            }
            i = 1;
            while (i < childrenCount) {
                children[i] = (SecurityTreeNode)((DefaultTreeModel)this.methodTree.getModel()).getChild(node, i);
                secRoles = children[i].getAccessControls().getSecurityRoleNames();
                int j = res.size() - 1;
                while (j >= 0) {
                    if (!this.findElement((String)res.elementAt(j), secRoles)) {
                        res.removeElementAt(j);
                    }
                    --j;
                }
                if (res.size() == 0) {
                    return null;
                }
                ++i;
            }
        }
        return res;
    }

    private Method[] getClassMethods(Class mainClass) {
        Method[] methods = null;
        try {
            methods = mainClass.getMethods();
        }
        catch (Throwable t) {
            this.classNotFoundErr = true;
            return null;
        }
        Vector<Method> methodsToReturn = new Vector<Method>();
        Method meth = null;
        Method tempMeth = null;
        int index = -1;
        int i = 0;
        while (i < methods.length) {
            meth = methods[i];
            if (methodsToReturn == null || methodsToReturn.size() == 0) {
                methodsToReturn.add(meth);
            } else {
                int j = 0;
                while (j < methodsToReturn.size()) {
                    tempMeth = (Method)methodsToReturn.elementAt(j);
                    if (this.identicalMethods(meth, tempMeth)) {
                        index = j;
                        break;
                    }
                    ++j;
                }
                if (index == -1) {
                    methodsToReturn.add(meth);
                }
                index = -1;
            }
            ++i;
        }
        Object[] res = new Method[methodsToReturn.size()];
        methodsToReturn.copyInto(res);
        return res;
    }

    public boolean findElement(String role, String[] secRoles) {
        if (secRoles == null || secRoles.length == 0) {
            return false;
        }
        int i = 0;
        while (i < secRoles.length) {
            if (role.equals(secRoles[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean findElement(String role, Vector roles) {
        if (roles == null || roles.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < roles.size()) {
            if (role.equals(((ListValues)roles.elementAt(i)).getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean identicalMethods(Method m1, Method m2) {
        if (m1 != null) {
            Class<?>[] params2;
            if (m2 == null) return true;
            if (!m1.getName().equals(m2.getName())) {
                return false;
            }
            Class<?>[] params1 = m1.getParameterTypes();
            if (params1.length != (params2 = m2.getParameterTypes()).length) return false;
            int i = 0;
            while (i < params1.length) {
                if (!params1[i].equals(params2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        } else {
            if (m2 == null) return true;
            return false;
        }
    }

    private boolean containsEntry(Vector excludeVector, MethodEntry methEntry) {
        int i = 0;
        while (i < excludeVector.size()) {
            if (methEntry.simpleEquals((MethodEntry)excludeVector.elementAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setLoader(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    public void init(int madeFromConstant) {
        this.madeFrom = madeFromConstant;
    }

    public void clear() {
    }

    public int isCorrect() {
        return 0;
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }
}

