/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.ejb.gui;

import com.sap.engine.deploy.ejb.gui.logic.RelationshipPanelLogical;
import com.sap.engine.deploy.ejb.gui.logic.SecurityPanel;
import com.sap.engine.deploy.ejb.gui.logic.TransactionPanelLogical;
import com.sap.engine.deploy.ejb.gui.persistent.JarPersistentPanel;
import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.deploy.tool.tree.ImageHolder;
import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.gui.UserNode;
import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.services.deploy.ear.common.ArchiveDescriptor;
import com.sap.engine.services.deploy.ear.common.Descriptor;
import com.sap.engine.services.deploy.gui.MappingPanel;
import com.sap.engine.services.deploy.gui.common.AdditionalPanelLogical;
import com.sap.engine.services.deploy.gui.common.ArchiveDescriptorPanel;
import com.sap.engine.services.deploy.gui.common.ErrorObject;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.SessionDescriptor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EJBJarPanel
extends ArchiveDescriptorPanel
implements ChangeListener {
    protected BorderLayout borderLayout1 = new BorderLayout();
    protected JTabbedPane theTabbedPane = new JTabbedPane();
    protected AdditionalPanelLogical first;
    protected MappingPanel second;
    protected SecurityPanel third;
    protected TransactionPanelLogical fourth;
    protected JarPersistentPanel six = null;
    protected RelationshipPanelLogical fifth = null;
    protected ArchiveDescriptor descriptor;
    private int previousIndex = 0;
    private int madeFrom = 0;
    private String archiveName;
    private ClassLoader loader;
    private ErrorReportObject errors;
    private UserNode node = null;
    private String prjDir = null;
    private ApplicationInformationProvider appProvider;

    public EJBJarPanel(Frame mainFrame, ClassLoader loader, Vector additionalFiles, String archName, int madeFrom) {
        this.mainFrame = mainFrame;
        this.madeFrom = madeFrom;
        try {
            SerializableFile[] defaultIcons = new SerializableFile[2];
            new ImageHolder();
            defaultIcons[0] = ImageHolder.eJarIcon;
            new ImageHolder();
            defaultIcons[1] = ImageHolder.eJarBigIcon;
            this.second = new MappingPanel(additionalFiles, mainFrame, this.archiveName, MappingPanel.EJB);
            this.first = new AdditionalPanelLogical(mainFrame, defaultIcons, "EJB Archive", false, false, madeFrom);
            this.first.enableAddingAdditionalFiles(this.second);
            this.archiveName = archName;
            this.third = new SecurityPanel(loader, mainFrame);
            this.third.setFrame(mainFrame);
            this.fourth = new TransactionPanelLogical(loader, mainFrame, madeFrom);
            this.fourth.setFrame(mainFrame);
            this.fifth = new RelationshipPanelLogical(mainFrame, madeFrom, loader);
            this.init();
            LookAndFeelHandler.add((Component)this);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(mainFrame, "Error could not initialize GUI for EJB group \n" + ex, "Error", 0);
        }
    }

    public EJBJarPanel(Frame mainFrame, ClassLoader loader, int madeFrom) {
        this.mainFrame = mainFrame;
        this.madeFrom = madeFrom;
        try {
            SerializableFile[] defaultIcons = new SerializableFile[2];
            new ImageHolder();
            defaultIcons[0] = ImageHolder.eJarIcon;
            new ImageHolder();
            defaultIcons[1] = ImageHolder.eJarBigIcon;
            this.first = new AdditionalPanelLogical(mainFrame, defaultIcons, "EJB Archive", false, false, madeFrom);
            this.first.enableAddingAdditionalFiles(this.second);
            if (madeFrom == 1) {
                this.second = new MappingPanel(mainFrame, MappingPanel.EJB);
            }
            this.third = new SecurityPanel(loader, mainFrame);
            this.third.setFrame(mainFrame);
            this.fourth = new TransactionPanelLogical(loader, mainFrame, madeFrom);
            if (madeFrom == 3) {
                this.six = new JarPersistentPanel(mainFrame);
            }
            this.fifth = new RelationshipPanelLogical(mainFrame, madeFrom, loader);
            this.init();
            LookAndFeelHandler.add((Component)this);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(mainFrame, "Error could not initialize GUI for EJB group \n" + ex, "Error", 0);
        }
    }

    protected void init() throws Exception {
        this.setLayout(this.borderLayout1);
        if (this.second != null) {
            this.theTabbedPane.addChangeListener(this);
            this.add((Component)this.theTabbedPane, "Center");
            this.theTabbedPane.addTab("Files", this.second);
            this.theTabbedPane.addTab("Security", this.third);
            this.theTabbedPane.addTab("Transaction", this.fourth);
            if (this.fifth != null) {
                this.theTabbedPane.addTab("Relation", this.fifth);
            }
            this.theTabbedPane.addTab("Additional", this.first);
        } else {
            this.theTabbedPane.addChangeListener(this);
            this.add((Component)this.theTabbedPane, "Center");
            this.theTabbedPane.addTab("Security", this.third);
            this.theTabbedPane.addTab("Transaction", this.fourth);
            if (this.fifth != null) {
                this.theTabbedPane.addTab("Relation", this.fifth);
            }
            if (this.six != null) {
                this.theTabbedPane.addTab("Persistent Mapping", this.six);
            }
            this.theTabbedPane.addTab("Additional", this.first);
        }
    }

    public void init(int madeFromConstant) {
        this.madeFrom = madeFromConstant;
        this.first.init(this.madeFrom);
        if (this.second != null) {
            this.second.init(this.madeFrom);
        }
        this.third.init(this.madeFrom);
        this.fourth.init(this.madeFrom);
        if (this.fifth != null) {
            this.fifth.init(this.madeFrom);
        }
        if (this.madeFrom == 3) {
            this.six = new JarPersistentPanel(this.mainFrame);
            this.six.init(this.madeFrom);
        }
    }

    public String getPrjDir() {
        return this.prjDir;
    }

    public void setPrjDir(String prjDir) {
        this.prjDir = prjDir;
    }

    public void clear() {
    }

    public int isCorrect() {
        int isCorrectIndex = 0;
        int secondIndex = 0;
        Vector<ErrorReportObject> errorsCollected = new Vector<ErrorReportObject>();
        if (this.first != null) {
            secondIndex = this.first.isCorrect();
            if (secondIndex > 0) {
                errorsCollected.add(this.first.getErrorObject());
            }
            int n = isCorrectIndex = isCorrectIndex < secondIndex ? secondIndex : isCorrectIndex;
        }
        if (this.second != null) {
            secondIndex = this.second.isCorrect();
            if (secondIndex > 0) {
                errorsCollected.add(this.second.getErrorObject());
            }
            int n = isCorrectIndex = isCorrectIndex < secondIndex ? secondIndex : isCorrectIndex;
        }
        if (this.third != null) {
            secondIndex = this.third.isCorrect();
            if (secondIndex > 0) {
                errorsCollected.add(this.third.getErrorObject());
            }
            int n = isCorrectIndex = isCorrectIndex < secondIndex ? secondIndex : isCorrectIndex;
        }
        if (this.fourth != null) {
            secondIndex = this.fourth.isCorrect();
            if (secondIndex > 0) {
                errorsCollected.add(this.fourth.getErrorObject());
            }
            int n = isCorrectIndex = isCorrectIndex < secondIndex ? secondIndex : isCorrectIndex;
        }
        if (this.six != null) {
            secondIndex = this.six.isCorrect();
            if (secondIndex > 0) {
                errorsCollected.add(this.six.getErrorObject());
            }
            int n = isCorrectIndex = isCorrectIndex < secondIndex ? secondIndex : isCorrectIndex;
        }
        if (this.fifth != null) {
            secondIndex = this.fifth.isCorrect();
            if (secondIndex > 0) {
                errorsCollected.add(this.fifth.getErrorObject());
            }
            int n = isCorrectIndex = isCorrectIndex < secondIndex ? secondIndex : isCorrectIndex;
        }
        if (isCorrectIndex > 0 && errorsCollected.size() > 0) {
            Vector<ErrorObject> tempErrorVector = new Vector<ErrorObject>();
            int i = 0;
            while (i < errorsCollected.size()) {
                if (errorsCollected.elementAt(i) != null) {
                    ErrorObject erObjTemp = null;
                    int j = 0;
                    while (j < ((ErrorReportObject)errorsCollected.elementAt(i)).getErrors().length) {
                        erObjTemp = ((ErrorReportObject)errorsCollected.elementAt(i)).getErrors()[j];
                        tempErrorVector.add(erObjTemp);
                        ++j;
                    }
                }
                ++i;
            }
            Object[] tempErrors = new ErrorObject[tempErrorVector.size()];
            tempErrorVector.copyInto(tempErrors);
            if (this.errors == null) {
                this.errors = new ErrorReportObject();
            }
            this.errors.setArchiveDescriptorName(this.descriptor.getDisplayName());
            this.errors.setPanel("EJBJarPAnel");
            this.errors.setArchiveDescriptorName(((EJBJarDescriptor)this.descriptor).getJarName());
            this.errors.setDescriptorName(null);
            this.errors.setTabPane(this.madeFrom);
            this.errors.setErrors((ErrorObject[])tempErrors);
        } else {
            if (this.errors == null) {
                this.errors = new ErrorReportObject();
            }
            this.errors.setErrors(null);
        }
        return isCorrectIndex;
    }

    public void setDescriptor(ArchiveDescriptor descr) {
        this.descriptor = (EJBJarDescriptor)((EJBJarDescriptor)descr).clone();
        SerializableFile[] icons = new SerializableFile[]{this.descriptor.getSmallIcon(), this.descriptor.getLargeIcon()};
        this.first.setDescriptor(icons, this.descriptor.getDescription(), this.descriptor.getDisplayName(), this.descriptor.getDisplayName() + " jar", this.getArchiveFile());
        this.third.setDescriptor((EJBJarDescriptor)this.descriptor);
        this.fourth.setDescriptor((EJBJarDescriptor)this.descriptor);
        if (this.checkForCMPEntity((EJBJarDescriptor)this.descriptor)) {
            if (this.fifth != null) {
                this.fifth.setDescriptor((EJBJarDescriptor)this.descriptor);
            } else {
                this.fifth = new RelationshipPanelLogical(this.mainFrame, this.madeFrom, this.loader);
                this.fifth.setDescriptor((EJBJarDescriptor)this.descriptor);
            }
            this.theTabbedPane.remove(this.fifth);
            if (this.fifth != null) {
                this.theTabbedPane.add("Relation", this.fifth);
            }
        } else {
            this.theTabbedPane.remove(this.fifth);
            this.fifth = null;
        }
        if (this.madeFrom == 3) {
            if (!((EJBJarDescriptor)this.descriptor).getAbstractSchema().isEmpty()) {
                if (this.six != null) {
                    this.six.setAbstractSchema(((EJBJarDescriptor)this.descriptor).getAbstractSchema());
                } else {
                    this.six = new JarPersistentPanel(this.mainFrame);
                    this.six.setAbstractSchema(((EJBJarDescriptor)this.descriptor).getAbstractSchema());
                }
                this.theTabbedPane.remove(this.six);
                if (this.six != null) {
                    this.theTabbedPane.add("Persistent Mapping", this.six);
                }
            } else {
                this.theTabbedPane.remove(this.six);
                this.six = null;
            }
        }
        this.theTabbedPane.remove(this.first);
        this.theTabbedPane.add("Additional", this.first);
        this.theTabbedPane.updateUI();
    }

    public ArchiveDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(String elementName, Descriptor descr) {
    }

    public Descriptor getDescriptor(String elementName) {
        return null;
    }

    public void setLoader(ClassLoader loader) {
        this.loader = loader;
        if (this.first != null) {
            this.first.setLoader(loader);
        }
        if (this.second != null) {
            this.second.setLoader(loader);
        }
        if (this.third != null) {
            this.third.setLoader(loader);
        }
        if (this.fourth != null) {
            this.fourth.setLoader(loader);
        }
        if (this.fifth != null) {
            this.fifth.setLoader(loader);
        }
        if (this.six != null) {
            this.six.setLoader(loader);
        }
    }

    public void stateChanged(ChangeEvent e) {
        int filesIndex = this.theTabbedPane.indexOfComponent(this.second);
        if (this.theTabbedPane.getSelectedIndex() == filesIndex && this.previousIndex != filesIndex && this.first != null) {
            this.first.addAdditionalFile();
            this.repaint();
            this.validate();
        }
        this.previousIndex = this.theTabbedPane.getSelectedIndex();
    }

    public void commitChange() {
        SerializableFile[] icons = this.first.commitChanges();
        this.first.addAdditionalFile();
        if (icons != null) {
            this.descriptor.setSmallIcon(icons[0]);
            this.descriptor.setLargeIcon(icons[1]);
        } else {
            this.descriptor.setSmallIcon(null);
            this.descriptor.setLargeIcon(null);
        }
        this.descriptor.setDisplayName(this.first.getDisplayName());
        this.descriptor.setDescription(this.first.getDescription());
        this.third.commitChange();
        this.fourth.commitChange();
        if (this.six != null) {
            this.six.commitChange();
        }
        if (this.fifth != null) {
            this.fifth.commitChange();
        }
    }

    private void tabsChanged() {
        this.repaint();
        this.validate();
    }

    public Vector getAdditionalFiles() {
        if (this.second == null) {
            return null;
        }
        return this.second.getDependenciesList();
    }

    public void setAdditionalFiles(Vector v) {
        if (this.second == null) {
            return;
        }
        this.second.setDependenciesList(v);
    }

    public void setClassFilesPaths(Vector v, String[] classPath) {
        if (this.second != null) {
            this.second.setClassFilesPaths(v, classPath);
        }
    }

    public void setClassPath(String[] classPath) {
        if (this.second != null) {
            this.second.setClassPath(classPath);
        }
    }

    public void setArchiveName(String archName) {
        this.archiveName = archName;
        if (this.second != null) {
            this.second.setArchiveName(archName);
        }
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
        if (this.first != null) {
            this.first.setApplicationInformationProvider(appProvider);
            this.first.setArchiveName(this.getArchiveFile());
        }
        if (this.second != null) {
            this.second.setApplicationInformationProvider(appProvider);
        }
        if (this.third != null) {
            this.third.setApplicationInformationProvider(appProvider);
        }
        if (this.fourth != null) {
            this.fourth.setApplicationInformationProvider(appProvider);
        }
        if (this.fifth != null) {
            this.fifth.setApplicationInformationProvider(appProvider);
        }
        if (this.six != null) {
            this.six.setApplicationInformationProvider(appProvider);
        }
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ErrorReportObject getErrorObject() {
        return this.errors;
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    public void enableWebService() {
    }

    private boolean checkIsWebServiceAllowed() {
        boolean flag = false;
        if (this.descriptor != null) {
            DeploymentDescriptor[] descr = (DeploymentDescriptor[])this.descriptor.getDescriptors();
            int i = 0;
            while (i < descr.length) {
                if (descr[i] instanceof SessionDescriptor) {
                    flag = true;
                }
                ++i;
            }
        }
        return flag;
    }

    private boolean checkForCMPEntity(EJBJarDescriptor ejbD) {
        CMPEntityDescriptor[] cmpD;
        return ejbD != null && ejbD.getAbstractSchema() != null && (cmpD = ejbD.getAbstractSchema().getDescriptors()) != null && cmpD.length != 0;
    }

    public void setDisplayName(String dName) {
        SerializableFile[] icons = new SerializableFile[]{this.descriptor.getSmallIcon(), this.descriptor.getLargeIcon()};
        this.first.setDescriptor(icons, this.descriptor.getDescription(), dName, this.descriptor.getDisplayName() + " jar", this.getArchiveFile());
    }

    public MappingPanel getAdditionalFilesPanel() {
        return this.second;
    }

    private String getArchiveFile() {
        if (this.appProvider != null) {
            return this.appProvider.getArchiveFile(this.descriptor);
        }
        return null;
    }
}

