/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.ejb.descriptors.xml;

import com.sap.engine.deploy.exceptions.BaseClassNotFoundException;
import com.sap.engine.deploy.exceptions.BaseIllegalArgumentException;
import com.sap.engine.deploy.exceptions.ExceptionWrapperException;
import com.sap.engine.deploy.exceptions.ToolDeploymentException;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.Symbols;
import com.sap.engine.lib.xml.dom.TextImpl;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.ejb.deploy.descriptors.AbstractSchema;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DataBaseProperties;
import com.sap.engine.services.ejb.deploy.descriptors.DependentValueDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.FinderDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.OneSideRelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.ejb.deploy.descriptors.RelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.M2MRelationFieldMap;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.RDependentValueMap;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.RPersistentFieldMap;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.RRelationFieldMap;
import com.sap.engine.services.ejb.deploy.tools.sql.Mappings;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class PersistentParser {
    private static final String DBPROPERTIES = "db-properties";
    private static final String DSNAME = "data-source-name";
    private static final String ENTITYBEANS = "entity-beans";
    private static final String ENTITYBEAN = "entity-bean";
    private static final String EJBNAME = "ejb-name";
    private static final String READONLY = "read-only";
    private static final String SELECTFORUPDATE = "select-for-update";
    private static final String TABLENAME = "table-name";
    private static final String FIELDMAP = "field-map";
    private static final String FIELDNAME = "field-name";
    private static final String SUBFIELDNAME = "subfield-name";
    private static final String FINDERDESCRIPTOR = "finder-descriptor";
    private static final String CRITERIA = "criteria";
    private static final String METHODNAME = "method-name";
    private static final String METHODPARAMS = "method-params";
    private static final String METHODPARAM = "method-param";
    private static final String SWITCHOFF = "switch-off-storing";
    private static final String COLUMNNAME = "column-name";
    private static final String KEYTYPE = "key-type";
    private static final String RELATIONSHIPS = "relationships";
    private static final String TABLERELATION = "table-relation";
    private static final String HELPTABLE = "help-table";
    private static final String TABLERELATIONSHIPROLE = "table-relationship-role";
    private static final String COLUMN = "column";
    private static final String DVCOLUMN = "dv-column";
    private static final String PRIMARYKEY = "PrimaryKey";
    private static final String FOREIGNKEY = "ForeignKey";
    private static final String UNIQUEKEY = "UniqueKey";
    private static final String CMRFIELD = "cmr-field";
    private static final String MAXTABNAMELTH = "MaxTableNameLength";
    private static final String DBVENDOR = "database-vendor";
    private static final String SWITCHOFFVERIFICATION = "switch-off-verification";
    private boolean validateXml = true;
    private Vector errors = new Vector();
    private boolean compliance = false;

    public void parseXML(EJBJarDescriptor ejbJarDscr, BufferedInputStream xmlStream, Vector warnings, ClassLoader loader, String xmlName) throws DeploymentException {
        Document doc = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        StandardDOMParser parser = new StandardDOMParser();
        Thread.currentThread().setContextClassLoader(cl);
        try {
            if (this.validateXml) {
                parser.setValidation(true);
            }
            doc = parser.parse((InputStream)xmlStream);
        }
        catch (Exception e) {
            Object[] args = new String[]{"persistent", e.toString()};
            ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4004\n\r", args, e);
            toThrow.log();
            throw toThrow;
        }
        this.scanDocument(ejbJarDscr, doc, warnings, loader);
    }

    private void scanDocument(EJBJarDescriptor ejbJarDscr, Document doc, Vector warnings, ClassLoader loader) throws DeploymentException {
        DataBaseProperties dbProps = null;
        AbstractSchema schema = null;
        NodeList nl = null;
        Element tempEl = null;
        Element dbPool = null;
        Object propsEl = null;
        Object locateFunctionList = null;
        Object lockStrategy = null;
        String dsName = null;
        Object propName = null;
        Object propValue = null;
        Object stringMappedtypes = null;
        Element root = doc.getDocumentElement();
        try {
            dbPool = this.getFirstElementByName(root, DBPROPERTIES);
            dsName = this.getElementText(this.getFirstElementByName(dbPool, DSNAME));
        }
        catch (DeploymentException de) {
            if (this.compliance) {
                throw de;
            }
            this.errors.add(((Throwable)((Object)de)).toString());
            return;
        }
        dbProps = new DataBaseProperties();
        dbProps.setDataSourceName(dsName);
        try {
            Element dbVendorEl = this.getFirstElementByName(dbPool, DBVENDOR);
            String dbVendorName = dbVendorEl.getAttribute("name");
            dbProps.setDBVendorName(dbVendorName);
        }
        catch (DeploymentException dex) {
            ExceptionWrapperException toLog = new ExceptionWrapperException(400, (Throwable)((Object)dex), "xml_ejb_4043");
            toLog.log();
        }
        schema = ejbJarDscr.getAbstractSchema();
        schema.setDBProperties(dbProps);
        try {
            Element switchOffVerifyEl = this.getFirstElementByName(root, SWITCHOFFVERIFICATION);
            schema.setSwitchOffVerification(true);
        }
        catch (DeploymentException dex) {
            schema.setSwitchOffVerification(false);
        }
        try {
            Element createTablesEl = this.getFirstElementByName(root, "create-tables-at-deploy");
            schema.setCreateTablesAtDeploy(true);
        }
        catch (DeploymentException dex) {
            schema.setCreateTablesAtDeploy(false);
        }
        this.initLocking(schema, root);
        try {
            tempEl = this.getFirstElementByName(root, ENTITYBEANS);
        }
        catch (DeploymentException de) {
            if (this.compliance) {
                throw de;
            }
            this.errors.add(((Throwable)((Object)de)).toString());
            return;
        }
        if (tempEl == null) {
            if (this.compliance) {
                throw new ToolDeploymentException("xml_ejb_4039", new String[]{"persistent", ENTITYBEANS});
            }
            this.errors.add("Incorrect persistemt.xml: missing tag <entity-beans>");
            return;
        }
        nl = tempEl.getElementsByTagName(ENTITYBEAN);
        if (nl.getLength() == 0) {
            if (this.compliance) {
                throw new ToolDeploymentException("xml_ejb_4039", new String[]{"persistent", ENTITYBEANS});
            }
            this.errors.add("Incorrect persistemt.xml: missing tag <entity-beans>");
            return;
        }
        int i = 0;
        while (i < nl.getLength()) {
            this.scanEntityEJB(schema, (Element)nl.item(i), warnings, loader);
            ++i;
        }
        this.relationships(schema, root, warnings);
    }

    private void initLocking(AbstractSchema schema, Element root) throws DeploymentException {
        NodeList nl = root.getElementsByTagName("locking");
        Element locking = (Element)nl.item(0);
        if (locking == null) {
            schema.setLockingType(0);
        } else {
            String lockingType = locking.getAttribute("type");
            if (lockingType.equals("Administrative")) {
                schema.setLockingType(0);
            } else if (lockingType.equals("Table")) {
                schema.setLockingType(1);
            } else if (lockingType.equals("Local")) {
                schema.setLockingType(2);
            } else {
                throw new BaseIllegalArgumentException("xml_ejb_4044");
            }
        }
    }

    private void relationships(AbstractSchema schema, Element schemaEl, Vector warnings) throws DeploymentException {
        Object dbProps = null;
        CMPEntityDescriptor dscr1 = null;
        CMPEntityDescriptor dscr2 = null;
        RelationDescriptor relDescr = null;
        OneSideRelationDescriptor side1 = null;
        OneSideRelationDescriptor side2 = null;
        M2MRelationFieldMap m2mRelMap = null;
        NodeList nl = null;
        NodeList relation = null;
        Object dbPool = null;
        Element el = null;
        Element el1 = null;
        Element el2 = null;
        Element tableRel = null;
        Element relEl = null;
        Object dsName = null;
        String ejbName1 = null;
        String ejbName2 = null;
        String cmrFieldName1 = null;
        String cmrFieldName2 = null;
        String helpTable = null;
        Object keyTypeStr = null;
        boolean cmr1ToCmr2 = true;
        int m2mRelId = 0;
        try {
            relEl = this.getFirstElementByName(schemaEl, RELATIONSHIPS);
            nl = relEl.getElementsByTagName(TABLERELATION);
        }
        catch (DeploymentException de) {
            return;
        }
        int i = 0;
        while (i < nl.getLength()) {
            ToolDeploymentException toThrow;
            Object[] args;
            tableRel = (Element)nl.item(i);
            relation = tableRel.getElementsByTagName(TABLERELATIONSHIPROLE);
            if (relation.getLength() < 2) {
                if (this.compliance) {
                    throw new ToolDeploymentException("xml_ejb_4040");
                }
                this.errors.add("Wrong persistent.xml: tag <table-relation> have only one <table-relationship-role> subtag, two reguired. ");
                return;
            }
            if (relation.getLength() > 2) {
                warnings.addElement("Wrong persistent.xml: tag <table-relation>: there is more then two subtags <table-relationship-role>, two subtags are expected.\n The first two are used during the deployment process. ");
            }
            el1 = (Element)relation.item(0);
            el2 = (Element)relation.item(1);
            try {
                ejbName1 = this.getElementText(this.getFirstElementByName(el1, EJBNAME));
                ejbName2 = this.getElementText(this.getFirstElementByName(el2, EJBNAME));
            }
            catch (DeploymentException de) {
                if (this.compliance) {
                    throw de;
                }
                this.errors.add(((Throwable)((Object)de)).toString());
                return;
            }
            dscr1 = schema.getDescriptor(ejbName1);
            if (dscr1 == null) {
                if (this.compliance) {
                    args = new String[]{ejbName1};
                    toThrow = new ToolDeploymentException("xml_ejb_4005", args);
                    toThrow.log();
                    throw toThrow;
                }
                this.errors.add("Cannot find bean with name " + ejbName1 + ", defined in ejb-jar.xml");
                return;
            }
            dscr2 = schema.getDescriptor(ejbName2);
            if (dscr2 == null) {
                if (this.compliance) {
                    args = new String[]{ejbName2};
                    toThrow = new ToolDeploymentException("xml_ejb_4005", args);
                    toThrow.log();
                    throw toThrow;
                }
                this.errors.add("Cannot find bean with name " + ejbName2 + ", defined in ejb-jar.xml");
                return;
            }
            try {
                cmrFieldName1 = this.getElementText(this.getFirstElementByName(el1, CMRFIELD));
                if (cmrFieldName1.equals("")) {
                    cmrFieldName1 = null;
                }
            }
            catch (DeploymentException de) {
                cmrFieldName1 = null;
            }
            try {
                cmrFieldName2 = this.getElementText(this.getFirstElementByName(el2, CMRFIELD));
                if (cmrFieldName2.equals("")) {
                    cmrFieldName2 = null;
                }
            }
            catch (DeploymentException de) {
                cmrFieldName2 = null;
            }
            relDescr = schema.getRelationDescriptor(dscr1.getId(), dscr2.getId(), cmrFieldName1, cmrFieldName2);
            if (relDescr == null) {
                if (this.compliance) {
                    args = new String[]{ejbName1, cmrFieldName1, ejbName2, cmrFieldName2};
                    toThrow = new ToolDeploymentException("xml_ejb_4006", args);
                    toThrow.log();
                    throw toThrow;
                }
                this.errors.add("persistent.xml describes unexisting relationship between <ejb1>: " + ejbName1 + ", <cmr-field1>:" + cmrFieldName1 + "  and  <ejb2>:" + ejbName2 + ", <cmr-field2>:" + cmrFieldName2);
                return;
            }
            PersistentField[] pk1 = dscr1.getPKCmpFields();
            PersistentField[] pk2 = dscr2.getPKCmpFields();
            side1 = relDescr.getSide1();
            side2 = relDescr.getSide2();
            cmr1ToCmr2 = side1.getEjbId() == dscr1.getId();
            try {
                el = this.getFirstElementByName(tableRel, HELPTABLE);
                helpTable = this.getElementText(el);
                m2mRelMap = new M2MRelationFieldMap(m2mRelId++);
                m2mRelMap.setHelpTable(helpTable);
                if (cmr1ToCmr2) {
                    m2mRelMap.setColumns1(this.getFkColumnsInOrder(el1, pk1, ejbName1, ejbName2));
                    m2mRelMap.setColumns2(this.getFkColumnsInOrder(el2, pk2, ejbName1, ejbName2));
                } else {
                    m2mRelMap.setColumns2(this.getFkColumnsInOrder(el1, pk1, ejbName1, ejbName2));
                    m2mRelMap.setColumns1(this.getFkColumnsInOrder(el2, pk2, ejbName1, ejbName2));
                }
                relDescr.setM2MMap(m2mRelMap);
            }
            catch (DeploymentException de) {
                ExceptionWrapperException toLog = new ExceptionWrapperException(400, (Throwable)((Object)de), "xml_ejb_4043");
                toLog.log();
            }
            if (cmr1ToCmr2) {
                this.fillOneSideRelation(el1, side1, pk2, ejbName1, ejbName2);
                this.fillOneSideRelation(el2, side2, pk1, ejbName1, ejbName2);
            } else {
                this.fillOneSideRelation(el2, side1, pk1, ejbName1, ejbName2);
                this.fillOneSideRelation(el1, side2, pk2, ejbName1, ejbName2);
            }
            ++i;
        }
    }

    private void fillOneSideRelation(Element tableRelRoleEl, OneSideRelationDescriptor side, PersistentField[] pkFields, String ejbName1, String ejbName2) throws DeploymentException {
        RRelationFieldMap dbMap = new RRelationFieldMap();
        String sKeyType = tableRelRoleEl.getAttribute(KEYTYPE);
        dbMap.setKey(this.convertKeyType(sKeyType));
        String[] fkColumns = this.getFkColumnsInOrder(tableRelRoleEl, pkFields, ejbName1, ejbName2);
        dbMap.setColumn(fkColumns);
        side.setFieldDBMap(dbMap);
    }

    private void scanEntityEJB(AbstractSchema schema, Element ejb, Vector warnings, ClassLoader loader) throws DeploymentException {
        ToolDeploymentException toThrow;
        Object[] args;
        FinderDescriptor[] finders = null;
        PersistentField[] cmp = null;
        CMPEntityDescriptor dscr = null;
        DependentValueDescriptor dvCmp = null;
        RPersistentFieldMap fieldDBMap = null;
        Class<?> homeClass = null;
        Object tempList = null;
        NodeList columnNamesNL = null;
        NodeList nl = null;
        NodeList readOnlyList = null;
        NodeList selectForupdateList = null;
        Object paramsEl = null;
        Element tempEl = null;
        Element columnEl = null;
        Object paramsTypes = null;
        String[] columnName = null;
        int[] columnType = null;
        String fieldName = null;
        Object resTypeMap = null;
        String ejbName = null;
        String subfield = null;
        String homeClassName = null;
        boolean dv = false;
        boolean cmp11 = true;
        int pos = -1;
        int columnPos = 0;
        try {
            ejbName = this.getElementText(this.getFirstElementByName(ejb, EJBNAME));
        }
        catch (DeploymentException de) {
            if (this.compliance) {
                throw de;
            }
            this.errors.add(((Throwable)((Object)de)).toString());
            return;
        }
        dscr = schema.getDescriptor(ejbName);
        if (dscr == null) {
            warnings.add("persistent.xml contains information about CMP Entity Bean with name : <" + ejbName + "> which is not described in the ejb-jar.xml");
            return;
        }
        try {
            dscr.setTableName(this.getElementText(this.getFirstElementByName(ejb, TABLENAME)));
        }
        catch (DeploymentException de) {
            if (this.compliance) {
                throw de;
            }
            this.errors.add(((Throwable)((Object)de)).toString());
            return;
        }
        nl = ejb.getElementsByTagName(FIELDMAP);
        cmp = dscr.getCmpFields();
        PersistentField[] pkCmp = dscr.getPKCmpFields();
        PersistentField persistentField = null;
        int pkPos = -1;
        int i = 0;
        while (i < nl.getLength()) {
            block48: {
                block55: {
                    Object[] args2;
                    block53: {
                        block54: {
                            block52: {
                                block50: {
                                    block51: {
                                        tempEl = (Element)nl.item(i);
                                        try {
                                            fieldName = this.getElementText(this.getFirstElementByName(tempEl, FIELDNAME));
                                        }
                                        catch (DeploymentException de) {
                                            if (this.compliance) {
                                                throw de;
                                            }
                                            this.errors.add(((Throwable)((Object)de)).toString());
                                            break block48;
                                        }
                                        pos = this.getPosInArray(cmp, fieldName);
                                        if (pos != -1) break block50;
                                        pkPos = this.getPosInArray(pkCmp, fieldName);
                                        if (pkPos != -1) break block51;
                                        if (this.compliance) {
                                            args2 = new String[]{"cmp-field", fieldName, ejbName};
                                            ToolDeploymentException toThrow2 = new ToolDeploymentException("xml_ejb_4007", args2);
                                            toThrow2.log();
                                            throw toThrow2;
                                        }
                                        this.errors.add("Cannot find element cmp-field with value " + fieldName + " for bean " + ejbName + " described in ejb-jar.xml.");
                                        break block48;
                                    }
                                    persistentField = pkCmp[pkPos];
                                    break block52;
                                }
                                persistentField = cmp[pos];
                            }
                            columnNamesNL = tempEl.getElementsByTagName(DVCOLUMN);
                            if (columnNamesNL.getLength() <= 0) break block53;
                            dv = true;
                            if (persistentField instanceof DependentValueDescriptor) break block54;
                            if (this.compliance) {
                                ToolDeploymentException toThrow3 = new ToolDeploymentException("xml_ejb_4008");
                                toThrow3.log();
                                throw toThrow3;
                            }
                            this.errors.add("Dependent value class has private fields or has no empty constructor. The only allowed db-mapping is to byte[].");
                            break block48;
                        }
                        dvCmp = (DependentValueDescriptor)persistentField;
                        break block55;
                    }
                    dv = false;
                    columnNamesNL = tempEl.getElementsByTagName(COLUMN);
                    if (columnNamesNL.getLength() == 0) {
                        if (this.compliance) {
                            args2 = new String[]{fieldName, ejbName};
                            ToolDeploymentException toThrow4 = new ToolDeploymentException("xml_ejb_4009", args2);
                            toThrow4.log();
                            throw toThrow4;
                        }
                        this.errors.add("Missing OR-mapping for field " + fieldName + " of bean " + ejbName + ".");
                        return;
                    }
                }
                columnName = new String[columnNamesNL.getLength()];
                columnType = new int[columnName.length];
                columnPos = -1;
                Class fieldClass = null;
                int j = 0;
                while (j < columnName.length) {
                    block49: {
                        block58: {
                            block56: {
                                block57: {
                                    columnEl = (Element)columnNamesNL.item(j);
                                    if (!dv) break block56;
                                    try {
                                        subfield = this.getElementText(this.getFirstElementByName(columnEl, SUBFIELDNAME));
                                    }
                                    catch (DeploymentException de) {
                                        if (this.compliance) {
                                            throw de;
                                        }
                                        this.errors.add(((Throwable)((Object)de)).toString());
                                        break block49;
                                    }
                                    columnPos = this.getColumnPos(dvCmp, subfield);
                                    if (columnPos != -1) break block57;
                                    if (this.compliance) {
                                        args = new String[]{subfield, fieldName};
                                        toThrow = new ToolDeploymentException("xml_ejb_4010", args);
                                        toThrow.log();
                                        throw toThrow;
                                    }
                                    this.errors.add("Described subfield " + subfield + " of dependent value field " + fieldName + " does not exist in the dependent value class.");
                                    break block49;
                                }
                                fieldClass = dvCmp.getValueFieldClasses()[columnPos];
                                break block58;
                            }
                            if (persistentField instanceof DependentValueDescriptor) {
                                persistentField = new PersistentField();
                                persistentField.setFieldName(dvCmp.getFieldName());
                                persistentField.setFieldType(dvCmp.getFieldType());
                                persistentField.setFieldClass(dvCmp.getFieldClass());
                                if (pos != -1) {
                                    cmp[pos] = persistentField;
                                } else {
                                    pkCmp[pkPos] = persistentField;
                                }
                            }
                            columnPos = j;
                            fieldClass = persistentField.getFieldClass();
                        }
                        try {
                            columnName[columnPos] = this.getElementText(this.getFirstElementByName(columnEl, COLUMNNAME));
                        }
                        catch (DeploymentException de) {
                            if (this.compliance) {
                                throw de;
                            }
                            this.errors.add(((Throwable)((Object)de)).toString());
                            break block49;
                        }
                        if (fieldClass != null) {
                            try {
                                columnType[columnPos] = Mappings.getDefaultSqlTypeForJavaType(fieldClass);
                            }
                            catch (DeploymentException ex) {
                                toThrow = new ToolDeploymentException("xml_ejb_4200", new String[]{persistentField.getFieldName(), fieldClass.getName()});
                                toThrow.log();
                                throw toThrow;
                            }
                        }
                    }
                    ++j;
                }
                String sKeyType = tempEl.getAttribute(KEYTYPE);
                if (dv) {
                    fieldDBMap = new RDependentValueMap();
                    ((RDependentValueMap)fieldDBMap).setDvColumnName(columnName);
                    ((RDependentValueMap)fieldDBMap).setDvColumnType(columnType);
                } else {
                    fieldDBMap = new RPersistentFieldMap();
                    fieldDBMap.setColumnName(columnName[0]);
                    fieldDBMap.setColumnType(columnType[0]);
                    if (persistentField instanceof DependentValueDescriptor) {
                        persistentField = new PersistentField();
                        persistentField.setFieldName(dvCmp.getFieldName());
                        persistentField.setFieldType(dvCmp.getFieldType());
                        persistentField.setFieldClass(dvCmp.getFieldClass());
                        if (pkPos == -1) {
                            cmp[pos] = persistentField;
                        } else {
                            if (pkCmp[pkPos].isCompoundPK()) {
                                persistentField.setCompoundPK();
                            }
                            pkCmp[pkPos] = persistentField;
                        }
                    }
                }
                NodeList mutableList = tempEl.getElementsByTagName("mutable");
                if (mutableList != null && mutableList.getLength() > 0) {
                    persistentField.setMutable(true);
                }
                fieldDBMap.setKey(this.convertKeyType(sKeyType));
                persistentField.setFieldDBMap(fieldDBMap);
            }
            ++i;
        }
        nl = ejb.getElementsByTagName(FINDERDESCRIPTOR);
        cmp11 = dscr.getCmpVersion() == 1;
        finders = dscr.getFinderDescriptors();
        if (cmp11 && (finders == null || finders.length == 0)) {
            homeClassName = dscr.getRemoteHomeInterface();
            try {
                homeClass = loader.loadClass(homeClassName);
            }
            catch (ClassNotFoundException cnfe) {
                if (this.compliance) {
                    Object[] args3 = new String[]{"home", homeClassName};
                    ToolDeploymentException toThrow5 = new ToolDeploymentException("xml_ejb_4011", args3, cnfe);
                    toThrow5.log();
                    throw toThrow5;
                }
                this.errors.add("Cannot find home interface \"" + homeClassName + "\".");
                return;
            }
            catch (NoClassDefFoundError err) {
                if (this.compliance) {
                    args = new String[]{"home", homeClassName};
                    toThrow = new ToolDeploymentException("xml_ejb_4011", args, err);
                    toThrow.log();
                    throw toThrow;
                }
                this.errors.add("Cannot find home interface \"" + homeClassName + "\".");
                return;
            }
            finders = new FinderDescriptor[nl.getLength()];
            int k = 0;
            while (k < nl.getLength()) {
                tempEl = (Element)nl.item(k);
                finders[k] = this.fillFinderDescriptor11(tempEl, homeClass, loader);
                ++k;
            }
            dscr.setFinderDescriptors(finders);
        } else {
            int i2 = 0;
            while (i2 < nl.getLength()) {
                tempEl = (Element)nl.item(i2);
                this.fillFinderDescriptor20(finders, tempEl);
                ++i2;
            }
        }
        readOnlyList = ejb.getElementsByTagName(READONLY);
        selectForupdateList = ejb.getElementsByTagName(SELECTFORUPDATE);
        if (readOnlyList != null && readOnlyList.getLength() > 0) {
            dscr.setReadOnly(true);
        } else if (selectForupdateList != null && selectForupdateList.getLength() > 0) {
            dscr.setSelectForUpdate(true);
        }
    }

    private int getPosInArray(PersistentField[] cmp, String field) {
        int i = 0;
        while (i < cmp.length) {
            if (field.equals(cmp[i].getFieldName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getColumnPos(DependentValueDescriptor dvCmp, String subfield) {
        String[] dvFields = dvCmp.getValueFieldNames();
        int i = 0;
        while (i < dvFields.length) {
            if (subfield.equals(dvFields[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private Element getFirstElementByName(Element el, String name) throws DeploymentException {
        NodeList nl = el.getElementsByTagName(name);
        if (nl.getLength() < 1) {
            throw new ToolDeploymentException("xml_ejb_4038", new String[]{name, el.getNodeName()});
        }
        return (Element)nl.item(0);
    }

    private String getElementText(Element el) {
        if (el == null) {
            return "";
        }
        NodeList nodeList = null;
        Node node = null;
        nodeList = el.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                ((TextImpl)node).trimWhiteSpace();
                if (!Symbols.isWhitespace((String)((Text)node).getData())) {
                    return ((Text)node).getData();
                }
            }
            ++i;
        }
        return "";
    }

    private String[] getFkColumnsInOrder(Element tableRelRoleEl, PersistentField[] pkFields, String ejbName1, String ejbName2) throws DeploymentException {
        NodeList fkColumns = tableRelRoleEl.getElementsByTagName("fk-column");
        if (fkColumns.getLength() == 0) {
            return new String[0];
        }
        if (fkColumns.getLength() != pkFields.length) {
            throw new ToolDeploymentException("xml_ejb_4045", new String[]{ejbName1, ejbName2});
        }
        String[] result = new String[fkColumns.getLength()];
        int i = 0;
        while (i < fkColumns.getLength()) {
            Element fkColumn = (Element)fkColumns.item(i);
            Element pkFieldNameEl = this.getFirstElementByName(fkColumn, "pk-field-name");
            Element columnNameEl = this.getFirstElementByName(fkColumn, COLUMNNAME);
            String refPkFieldName = this.getElementText(pkFieldNameEl);
            String columnName = this.getElementText(columnNameEl);
            int j = 0;
            while (j < pkFields.length) {
                String pkFieldName = pkFields[j].getFieldName();
                if (pkFieldName.equals(refPkFieldName)) {
                    if (result[i] != null) {
                        throw new ToolDeploymentException("xml_ejb_4046", new String[]{columnName, refPkFieldName, ejbName1, ejbName2});
                    }
                    result[i] = columnName;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    private Class getClassFromString(String className, ClassLoader loader) throws ClassNotFoundException {
        try {
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            ExceptionWrapperException toLog = new ExceptionWrapperException(400, cnfe, "xml_ejb_4043");
            toLog.log();
            Class cl = Mappings.getPrimitiveClass(className);
            if (cl == null) {
                throw new BaseClassNotFoundException("xml_ejb_4041", new Object[]{className});
            }
            return cl;
        }
    }

    private int convertKeyType(String keyStr) {
        if (keyStr.equals(PRIMARYKEY)) {
            return 1;
        }
        if (keyStr.equals(FOREIGNKEY)) {
            return 2;
        }
        if (keyStr.equals(UNIQUEKEY)) {
            return 3;
        }
        return 0;
    }

    private void fillFinderDescriptor20(FinderDescriptor[] fDscrs, Element el) throws DeploymentException {
        NodeList list;
        NodeList paramsList = null;
        Element paramsEl = null;
        String[] paramsTypesFromXml = null;
        String[] paramsTypes = null;
        String exceptionMessage = null;
        String methodName = null;
        boolean dscrFound = false;
        boolean paramFound = false;
        boolean storingMode = true;
        boolean loadSelected = true;
        String lockMode = "";
        boolean lazyLoading = false;
        boolean fetchSize = true;
        String fetchSizeValue = "";
        boolean ql21 = true;
        try {
            methodName = this.getElementText(this.getFirstElementByName(el, METHODNAME));
        }
        catch (DeploymentException de) {
            if (this.compliance) {
                throw de;
            }
            this.errors.add(((Throwable)((Object)de)).toString());
            return;
        }
        try {
            paramsEl = this.getFirstElementByName(el, METHODPARAMS);
        }
        catch (DeploymentException de) {
            if (this.compliance) {
                throw de;
            }
            this.errors.add(((Throwable)((Object)de)).toString());
            return;
        }
        paramsList = paramsEl.getElementsByTagName(METHODPARAM);
        if (el.getElementsByTagName(SWITCHOFF).getLength() != 0) {
            storingMode = false;
        }
        if ((list = el.getElementsByTagName("load-selected-objects")).getLength() == 0) {
            loadSelected = false;
        } else {
            lockMode = ((Element)list.item(0)).getAttribute("lock");
        }
        if (el.getElementsByTagName("lazy-loading").getLength() != 0) {
            lazyLoading = true;
        }
        if ((list = el.getElementsByTagName("fetch-size")).getLength() == 0) {
            fetchSize = false;
        } else {
            fetchSizeValue = this.getElementText((Element)list.item(0));
        }
        if (el.getElementsByTagName("ql-2.1-compatible").getLength() == 0) {
            ql21 = false;
        }
        paramsTypesFromXml = new String[paramsList.getLength()];
        int j = 0;
        while (j < paramsList.getLength()) {
            paramsTypesFromXml[j] = this.getElementText((Element)paramsList.item(j));
            ++j;
        }
        int i = 0;
        while (i < fDscrs.length) {
            if (fDscrs[i].getMethodName().equals(methodName) && (paramsTypes = fDscrs[i].getParamsTypes()).length == paramsTypesFromXml.length) {
                if (paramsTypes.length == 0) {
                    paramFound = true;
                } else {
                    int j2 = 0;
                    while (j2 < paramsTypes.length) {
                        paramFound = false;
                        int k = 0;
                        while (k < paramsTypesFromXml.length) {
                            if (paramsTypes[j2].equals(paramsTypesFromXml[k])) {
                                paramFound = true;
                                break;
                            }
                            ++k;
                        }
                        if (!paramFound) break;
                        ++j2;
                    }
                }
                if (paramFound) {
                    if (!fDscrs[i].isSelect()) {
                        fDscrs[i].setParamsTypes(paramsTypesFromXml);
                        fDscrs[i].setStoringMode(storingMode);
                        fDscrs[i].setToLoadSelectedObjects(loadSelected);
                        fDscrs[i].setLazyLoading(lazyLoading);
                        if (fetchSize) {
                            try {
                                int fetchSizeInt = Integer.parseInt(fetchSizeValue);
                                if (fetchSizeInt < 1) {
                                    this.errors.add("The <fetch-size> must be positive integer. The <fetch-size> is ignored.");
                                } else {
                                    fDscrs[i].setFetchSize(fetchSizeInt);
                                }
                            }
                            catch (NumberFormatException nfe) {
                                this.errors.add("The <fetch-size> does not contain a parsable integer. The <fetch-size> is ignored.");
                            }
                        }
                        if (loadSelected && !lockMode.equals("")) {
                            fDscrs[i].setLockMode(lockMode);
                        }
                        fDscrs[i].setQLVersionTo2_1(ql21);
                        try {
                            fDscrs[i].setSQLStatement(this.getElementText(this.getFirstElementByName(el, CRITERIA)));
                        }
                        catch (DeploymentException de) {
                            if (this.compliance) {
                                throw de;
                            }
                            this.errors.add(((Throwable)((Object)de)).toString());
                            return;
                        }
                    }
                    return;
                }
            }
            ++i;
        }
        exceptionMessage = "(";
        int i2 = 0;
        while (i2 < paramsTypesFromXml.length) {
            exceptionMessage = i2 != paramsTypesFromXml.length - 1 ? exceptionMessage + paramsTypesFromXml[i2] + "," : exceptionMessage + paramsTypesFromXml[i2] + ")";
            ++i2;
        }
        if (this.compliance) {
            Object[] args = new String[]{methodName, exceptionMessage};
            ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4015", args);
            toThrow.log();
            throw toThrow;
        }
        this.errors.add("Find or select method " + methodName + " with parameters " + exceptionMessage + ",\n which is described in persistent.xml is missing in the bean classes or is not described in the ejb-jar.xml.");
    }

    private FinderDescriptor fillFinderDescriptor11(Element el, Class homeClass, ClassLoader loader) throws DeploymentException {
        FinderDescriptor finder = null;
        Method reflIntfMethod = null;
        NodeList paramsList = null;
        Element paramsEl = null;
        Class[] paramsClass = null;
        Class<?>[] exceptionsClass = null;
        String[] exceptions = null;
        String[] paramsTypesFromXml = null;
        String methodName = null;
        try {
            methodName = this.getElementText(this.getFirstElementByName(el, METHODNAME));
        }
        catch (DeploymentException de) {
            if (this.compliance) {
                throw de;
            }
            this.errors.add(((Throwable)((Object)de)).toString());
            return null;
        }
        try {
            paramsEl = this.getFirstElementByName(el, METHODPARAMS);
        }
        catch (DeploymentException de) {
            if (this.compliance) {
                throw de;
            }
            this.errors.add(((Throwable)((Object)de)).toString());
            return null;
        }
        paramsList = paramsEl.getElementsByTagName(METHODPARAM);
        paramsTypesFromXml = new String[paramsList.getLength()];
        int j = 0;
        while (j < paramsList.getLength()) {
            paramsTypesFromXml[j] = this.getElementText((Element)paramsList.item(j));
            ++j;
        }
        if (paramsTypesFromXml != null) {
            paramsClass = new Class[paramsTypesFromXml.length];
            int l = 0;
            while (l < paramsTypesFromXml.length) {
                try {
                    paramsClass[l] = this.getClassFromString(paramsTypesFromXml[l], loader);
                }
                catch (ClassNotFoundException cnfe) {
                    if (this.compliance) {
                        Object[] args = new String[]{paramsTypesFromXml[l]};
                        ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4014", args, cnfe);
                        toThrow.log();
                        throw toThrow;
                    }
                    this.errors.add("Cannot find method parameter class " + paramsTypesFromXml[l] + ".");
                    return finder;
                }
                catch (NoClassDefFoundError err) {
                    if (this.compliance) {
                        Object[] args = new String[]{paramsTypesFromXml[l]};
                        ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4014", args, err);
                        toThrow.log();
                        throw toThrow;
                    }
                    this.errors.add("Cannot find method parameter class " + paramsTypesFromXml[l] + ".");
                    return finder;
                }
                ++l;
            }
        } else {
            paramsClass = new Class[]{};
        }
        try {
            reflIntfMethod = homeClass.getMethod(methodName, paramsClass);
        }
        catch (NoSuchMethodException nsme1) {
            Object[] args = new String[]{methodName, "home", homeClass.getName()};
            if (this.compliance) {
                ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4027", args, nsme1);
                toThrow.log();
                throw toThrow;
            }
            this.errors.add("Cannot find method \"" + methodName + "\" in home interface \"" + (String)args[2] + "\".");
            return finder;
        }
        finder = new FinderDescriptor();
        finder.setMethodName(methodName);
        finder.setParamsTypes(paramsTypesFromXml);
        finder.setFinder();
        finder.setReturnType(reflIntfMethod.getReturnType().getName());
        exceptionsClass = reflIntfMethod.getExceptionTypes();
        exceptions = new String[exceptionsClass.length];
        int n = 0;
        while (n < exceptionsClass.length) {
            exceptions[n] = exceptionsClass[n].getName();
            ++n;
        }
        finder.setExceptions(exceptions);
        finder.setRemote();
        try {
            finder.setSQLStatement(this.getElementText(this.getFirstElementByName(el, CRITERIA)));
        }
        catch (DeploymentException de) {
            if (this.compliance) {
                throw de;
            }
            this.errors.add(((Throwable)((Object)de)).toString());
        }
        finder.setStoringMode(el.getElementsByTagName(SWITCHOFF).getLength() == 0);
        NodeList loadModeNL = el.getElementsByTagName("load-selected-objects");
        if (loadModeNL.getLength() > 0) {
            finder.setToLoadSelectedObjects(true);
            String lockMode = ((Element)loadModeNL.item(0)).getAttribute("lock");
            if (!lockMode.equals("")) {
                finder.setLockMode(lockMode);
            }
        } else {
            finder.setToLoadSelectedObjects(false);
        }
        NodeList list = el.getElementsByTagName("fetch-size");
        if (list.getLength() > 0) {
            try {
                int fetchSizeInt = Integer.parseInt(this.getElementText((Element)list.item(0)));
                if (fetchSizeInt < 1) {
                    this.errors.add("The <fetch-size> must be positive integer. The <fetch-size> is ignored.");
                } else {
                    finder.setFetchSize(fetchSizeInt);
                }
            }
            catch (NumberFormatException nfe) {
                this.errors.add("The <fetch-size> does not contain a parsable integer. The <fetch-size> is ignored.");
            }
        }
        finder.setLazyLoading(el.getElementsByTagName("lazy-loading").getLength() > 0);
        return finder;
    }
}

