/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.ejb.descriptors.xml;

import com.sap.engine.deploy.exceptions.ToolDeploymentException;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.ear.common.ComponentReference;
import com.sap.engine.services.deploy.ear.common.Descriptor;
import com.sap.engine.services.deploy.ear.common.EJBeanLocalReference;
import com.sap.engine.services.deploy.ear.common.EJBeanReference;
import com.sap.engine.services.deploy.ear.common.MethodEntry;
import com.sap.engine.services.deploy.ear.common.ResourceEnvReference;
import com.sap.engine.services.deploy.ear.common.ResourceReference;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.ejb.deploy.descriptors.AbstractSchema;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.ControlDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.IORDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.MessageDrivenDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.SecurityIdentity;
import com.sap.engine.services.ejb.deploy.descriptors.SessionDescriptor;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class InqmyEjbParser {
    public static final String TRANSACTION_READ_COMMITTED = "Committed";
    public static final String TRANSACTION_READ_UNCOMMITTED = "Uncommitted";
    public static final String TRANSACTION_REPEATABLE_READ = "Repeatable";
    public static final String TRANSACTION_SERIALIZABLE = "Serializable";
    private Vector errors = new Vector();
    private EJBJarDescriptor ejbJar = null;
    private Vector iors = new Vector();

    public void parseXml(EJBJarDescriptor ejbJar, BufferedInputStream xmlStream, Vector warnings, String xmlName) throws DeploymentException {
        this.errors = warnings;
        this.ejbJar = ejbJar;
        Document document = null;
        AbstractSchema abstractSchema = ejbJar.getAbstractSchema();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        StandardDOMParser parser = new StandardDOMParser();
        Thread.currentThread().setContextClassLoader(cl);
        try {
            parser.setSystemId(xmlName);
            document = parser.parse((InputStream)xmlStream);
            xmlStream.close();
        }
        catch (IOException ioe) {
            Object[] args = new String[]{"ejb-j2ee-engine", ioe.toString()};
            ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4004", args, ioe);
            toThrow.log();
            throw toThrow;
        }
        catch (SAXException sax) {
            Object[] args = new String[]{"ejb-j2ee-engine", sax.toString()};
            ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4004", args, sax);
            toThrow.log();
            throw toThrow;
        }
        NodeList nl = document.getElementsByTagName("ejb-j2ee-engine");
        if (nl.getLength() < 1) {
            throw new DeploymentException("xml_ejb_4037");
        }
        Node inqmyJar = nl.item(0);
        NodeList inqmyJarList = inqmyJar.getChildNodes();
        Element el = null;
        String tag = null;
        int i = 0;
        while (i < inqmyJarList.getLength()) {
            if (inqmyJarList.item(i).getNodeType() == 1) {
                el = (Element)inqmyJarList.item(i);
                tag = el.getNodeName();
                if (tag.equals("description")) {
                    ejbJar.setInqmyDescription(this.getTextValue(el));
                } else if (tag.equals("enterprise-beans")) {
                    this.processBeans(el);
                } else if (tag.equals("transaction-descriptor")) {
                    this.processTransactions(el);
                } else if (tag.equals("security-permission")) {
                    this.processSecurityPermition(el);
                }
            }
            ++i;
        }
    }

    protected String getTextValue(Element element) {
        if (element == null) {
            return new String("");
        }
        Node node = element.getFirstChild();
        if (node != null && node.getNodeType() == 3) {
            String value = node.getNodeValue();
            return value.trim();
        }
        return new String("");
    }

    private void processBeans(Element beans) {
        NodeList beansList = beans.getChildNodes();
        Element el = null;
        String tag = null;
        int i = 0;
        while (i < beansList.getLength()) {
            if (beansList.item(i).getNodeType() == 1 && (tag = (el = (Element)beansList.item(i)).getNodeName()).equals("enterprise-bean")) {
                this.processBean(el);
            }
            ++i;
        }
    }

    private void processBean(Element bean) {
        NodeList entList = bean.getChildNodes();
        DeploymentDescriptor dDescr = null;
        Element el = null;
        this.iors = new Vector();
        int i = 0;
        while (i < entList.getLength()) {
            if (entList.item(i).getNodeType() == 1) {
                el = (Element)entList.item(i);
                if (el.getNodeName().equals("ejb-name")) {
                    dDescr = this.findDescriptor(this.getTextValue(el));
                    if (dDescr == null) {
                        break;
                    }
                } else if (el.getNodeName().equals("jndi-name")) {
                    if (dDescr == null) {
                        this.errors.add(" Incorrect enterprise-bean tag. Missing ejb name.");
                        return;
                    }
                    dDescr.setJndiName(this.getTextValue(el));
                } else if (el.getNodeName().equals("container-size")) {
                    if (dDescr == null) {
                        this.errors.add(" Incorrect enterprise-bean tag. Missing ejb name.");
                        return;
                    }
                    try {
                        dDescr.setContainerSize(Integer.parseInt(this.getTextValue(el)));
                    }
                    catch (NumberFormatException nfe) {
                        this.errors.add(" Not integer value of tag <container-size> to bean \"" + dDescr.getName() + "\".");
                    }
                } else if (el.getNodeName().equals("ejb-ref")) {
                    if (dDescr == null) {
                        this.errors.add(" Incorrect enterprise-bean tag. Missing ejb name.");
                        return;
                    }
                    this.processEjbRef(el, dDescr);
                } else if (el.getNodeName().equals("ejb-local-ref")) {
                    if (dDescr == null) {
                        this.errors.add(" Incorrect enterprise-bean tag. Missing ejb name.");
                        return;
                    }
                    this.processEjbLocalRef(el, dDescr);
                } else if (el.getNodeName().equals("resource-ref")) {
                    if (dDescr == null) {
                        this.errors.add(" Incorrect enterprise-bean tag. Missing ejb name.");
                        return;
                    }
                    this.processResRef(el, dDescr);
                } else if (el.getNodeName().equals("resource-env-ref")) {
                    if (dDescr == null) {
                        this.errors.add(" Incorrect enterprise-bean tag. Missing ejb name.");
                        return;
                    }
                    this.processResEnvRef(el, dDescr);
                } else if (el.getNodeName().equals("server-component-ref")) {
                    if (dDescr == null) {
                        this.errors.add(" Incorrect enterprise-bean tag. Missing ejb name.");
                        return;
                    }
                    this.processServerCompRef(el, dDescr);
                } else if (el.getNodeName().equals("run-as-identity-map")) {
                    if (dDescr == null) {
                        this.errors.add(" Incorrect enterprise-bean tag. Missing ejb name.");
                        return;
                    }
                    this.processRunAsIdentityMap(el, dDescr);
                } else if (el.getNodeName().equals("ior-security-config")) {
                    if (dDescr == null) {
                        this.errors.add(" Incorrect enterprise-bean tag. Missing ejb name.");
                        return;
                    }
                    this.processIORSecurity(el, dDescr);
                } else if (el.getNodeName().equals("session-props")) {
                    if (dDescr == null) {
                        this.errors.add(" Incorrect enterprise-bean tag. Missing ejb name.");
                        return;
                    }
                    if (dDescr instanceof SessionDescriptor) {
                        this.processSessionProps(el, (SessionDescriptor)dDescr);
                    } else {
                        this.errors.add(" Incorrect tag <session-props> defined for non session bean \"" + dDescr.getName() + ".");
                    }
                } else if (el.getNodeName().equals("entity-props")) {
                    if (dDescr == null) {
                        this.errors.add(" Incorrect enterprise-bean tag. Missing ejb name.");
                        return;
                    }
                    if (dDescr instanceof EntityDescriptor) {
                        this.processEntityProps(el, (EntityDescriptor)dDescr);
                    } else {
                        this.errors.add(" Incorrect tag <entity-props> defined for non entity bean \"" + dDescr.getName() + ".");
                    }
                } else if (el.getNodeName().equals("message-props")) {
                    if (dDescr == null) {
                        this.errors.add(" Incorrect enterprise-bean tag. Missing ejb name.");
                        return;
                    }
                    if (dDescr instanceof MessageDrivenDescriptor) {
                        this.processMessageDrivenProps(el, (MessageDrivenDescriptor)dDescr);
                    } else {
                        this.errors.add(" Incorrect tag <session-props> defined for non session bean \"" + dDescr.getName() + ".");
                    }
                }
            }
            ++i;
        }
        if (!this.iors.isEmpty()) {
            IORDescriptor[] iorsArray = new IORDescriptor[this.iors.size()];
            iorsArray = this.iors.toArray(iorsArray);
            dDescr.setIORDescriptors(iorsArray);
        }
    }

    private void processEjbRef(Element ref, DeploymentDescriptor descr) {
        NodeList list = ref.getChildNodes();
        Element el = null;
        String tempString = null;
        EJBeanReference[] allRefs = descr.getEJBeanReferences();
        int index = -1;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                el = (Element)list.item(i);
                if (el.getNodeName().equals("ejb-ref-name")) {
                    tempString = this.getTextValue(el);
                    if (tempString.equals("")) {
                        this.errors.add(" Incorrect ejb reference defined for bean \"" + descr.getName() + "\". Missing reference name.");
                        return;
                    }
                    if (allRefs != null && allRefs.length != 0) {
                        int j = 0;
                        while (j < allRefs.length) {
                            if (allRefs[j] != null && tempString.equals(allRefs[j].getReferenceName())) {
                                index = j;
                                break;
                            }
                            ++j;
                        }
                    }
                    if (index == -1) {
                        this.errors.add(" There is no such ejb reference \"" + tempString + "\" defined for bean \"" + descr.getName() + "\" in ejb-jar.xml for " + this.ejbJar.getJarName());
                        return;
                    }
                } else if (el.getNodeName().equals("jndi-name")) {
                    if (index == -1) {
                        this.errors.add(" Incorrect ejb reference defined for bean \"" + descr.getName() + "\". Missing reference name.");
                        return;
                    }
                    tempString = this.getTextValue(el);
                    if (tempString.equals("")) {
                        this.errors.add(" Incorrect ejb reference \"" + allRefs[index].getReferenceName() + "\" defined for bean \"" + descr.getName() + "\". Missing jndi name.");
                        return;
                    }
                    allRefs[index].setReferenceJndiLink(tempString);
                    descr.setEJBeanReferences(allRefs);
                }
            }
            ++i;
        }
    }

    private void processEjbLocalRef(Element localRef, DeploymentDescriptor descr) {
        NodeList list = localRef.getChildNodes();
        Element el = null;
        String tempString = null;
        EJBeanLocalReference[] allLocalRefs = descr.getEJBeanLocalReferences();
        int index = -1;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                el = (Element)list.item(i);
                if (el.getNodeName().equals("ejb-ref-name")) {
                    tempString = this.getTextValue(el);
                    if (tempString.equals("")) {
                        this.errors.add(" Incorrect ejb local reference defined for bean \"" + descr.getName() + "\". Missing reference name.");
                        return;
                    }
                    if (allLocalRefs != null && allLocalRefs.length != 0) {
                        int j = 0;
                        while (j < allLocalRefs.length) {
                            if (allLocalRefs[j] != null && tempString.equals(allLocalRefs[j].getReferenceName())) {
                                index = j;
                                break;
                            }
                            ++j;
                        }
                    }
                    if (index == -1) {
                        this.errors.add(" There is no such ejb local reference \"" + tempString + "\" defined for bean \"" + descr.getName() + "\" in ejb-jar.xml for " + this.ejbJar.getJarName());
                        return;
                    }
                } else if (el.getNodeName().equals("jndi-name")) {
                    if (index == -1) {
                        this.errors.add(" Incorrect ejb local reference defined for bean \"" + descr.getName() + "\". Missing reference name.");
                        return;
                    }
                    tempString = this.getTextValue(el);
                    if (tempString.equals("")) {
                        this.errors.add(" Incorrect ejb local reference \"" + allLocalRefs[index].getReferenceName() + "\" defined for bean \"" + descr.getName() + "\". Missing jndi name.");
                        return;
                    }
                    allLocalRefs[index].setReferenceJndiLink(tempString);
                    descr.setEJBeanLocalReferences(allLocalRefs);
                }
            }
            ++i;
        }
    }

    private void processResRef(Element resRefEl, DeploymentDescriptor dd) {
        NodeList list = resRefEl.getChildNodes();
        Element el = null;
        ResourceReference[] allRefs = dd.getResourceReferences();
        String tempString = null;
        int index = -1;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                el = (Element)list.item(i);
                if (el.getNodeName().equals("res-ref-name") || el.getNodeName().equals("res-name")) {
                    tempString = this.getTextValue(el);
                    if (tempString.equals("")) {
                        this.errors.add(" Incorrect resource reference defined for bean \"" + dd.getName() + "\". Missing reference name.");
                        return;
                    }
                    if (allRefs != null && allRefs.length != 0) {
                        int j = 0;
                        while (j < allRefs.length) {
                            if (allRefs[j] != null && tempString.equals(allRefs[j].getResourceName())) {
                                index = j;
                                break;
                            }
                            ++j;
                        }
                    }
                    if (index == -1) {
                        this.errors.add(" There is no such resource reference \"" + tempString + "\" defined for bean \"" + dd.getName() + "\" in ejb-jar.xml for " + this.ejbJar.getJarName());
                        return;
                    }
                } else if (el.getNodeName().equals("res-link")) {
                    if (index == -1) {
                        this.errors.add(" Incorrect resource reference defined for bean \"" + dd.getName() + "\". Missing resource name.");
                        return;
                    }
                    tempString = this.getTextValue(el);
                    if (tempString.equals("")) {
                        this.errors.add(" Incorrect resource reference \"" + allRefs[index].getResourceName() + "\" defined for bean \"" + dd.getName() + "\". Missing resource link.");
                        return;
                    }
                    allRefs[index].setResourceLink(tempString);
                } else if (el.getNodeName().equals("non-transactional")) {
                    if (index == -1) {
                        this.errors.add(" Incorrect resource reference defined for bean \"" + dd.getName() + "\". Missing resource name.");
                        return;
                    }
                    allRefs[index].setTransactional(false);
                }
            }
            ++i;
        }
        dd.setResourceReferences(allRefs);
    }

    private void processResEnvRef(Element resEnvRef, DeploymentDescriptor descr) {
        NodeList list = resEnvRef.getChildNodes();
        Element el = null;
        String tempString = null;
        ResourceEnvReference[] allRefs = descr.getResourceEnvReferences();
        int index = -1;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                el = (Element)list.item(i);
                if (el.getNodeName().equals("res-env-ref-name")) {
                    tempString = this.getTextValue(el);
                    if (tempString.equals("")) {
                        this.errors.add(" Incorrect resource environment reference defined for bean \"" + descr.getName() + "\" . Missing reference name.");
                        return;
                    }
                    if (allRefs != null && allRefs.length != 0) {
                        int j = 0;
                        while (j < allRefs.length) {
                            if (allRefs[j] != null && tempString.equals(allRefs[j].getName())) {
                                index = j;
                                break;
                            }
                            ++j;
                        }
                    }
                    if (index == -1) {
                        this.errors.add(" There is no such resource environment reference \"" + tempString + "\" defined for bean \"" + descr.getName() + "\" in ejb-jar.xml for " + this.ejbJar.getJarName());
                        return;
                    }
                } else if (el.getNodeName().equals("jndi-name")) {
                    if (index == -1) {
                        this.errors.add(" Incorrect ejb resource environment reference defined for bean \"" + descr.getName() + "\". Missing reference name.");
                        return;
                    }
                    tempString = this.getTextValue(el);
                    if (tempString.equals("")) {
                        this.errors.add(" Incorrect resource environment reference \"" + allRefs[index].getName() + "\" defined for bean \"" + descr.getName() + "\". Missing jndi name.");
                        return;
                    }
                    allRefs[index].setJndiName(tempString);
                    descr.setResourceEnvReferences(allRefs);
                }
            }
            ++i;
        }
    }

    private void processServerCompRef(Element compRefEl, DeploymentDescriptor dd) {
        NodeList list = compRefEl.getChildNodes();
        Element el = null;
        String tempString = null;
        String description = "";
        ComponentReference[] allRefs = dd.getServerComponentReferences();
        int index = -1;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                el = (Element)list.item(i);
                if (el.getNodeName().equals("description")) {
                    description = this.getTextValue(el);
                } else if (el.getNodeName().equals("name")) {
                    tempString = this.getTextValue(el);
                    if (tempString.equals("")) {
                        this.errors.add(" Incorrect server compoment reference defined for bean \"" + dd.getName() + "\". Missing reference name.");
                        return;
                    }
                    if (allRefs != null && allRefs.length != 0) {
                        int j = 0;
                        while (j < allRefs.length) {
                            if (allRefs[j] != null && tempString.equals(allRefs[j].getName())) {
                                index = j;
                                break;
                            }
                            ++j;
                        }
                    }
                    if (index != -1) {
                        this.errors.add(" There allready is such server component reference \"" + tempString + "\" defined for bean \"" + dd.getName() + "\" in ejb-jar.xml for " + this.ejbJar.getJarName());
                        return;
                    }
                    if (allRefs == null) {
                        allRefs = new ComponentReference[]{new ComponentReference()};
                        allRefs[0].setName(tempString);
                        index = 0;
                    } else {
                        ComponentReference[] newRefs = new ComponentReference[allRefs.length];
                        System.arraycopy(allRefs, 0, newRefs, 0, allRefs.length);
                        newRefs[allRefs.length] = new ComponentReference();
                        newRefs[allRefs.length].setName(tempString);
                        allRefs = newRefs;
                        index = allRefs.length;
                    }
                } else if (el.getNodeName().equals("type")) {
                    tempString = this.getTextValue(el);
                    if (tempString.equals("")) {
                        this.errors.add(" Incorrect server component reference \"" + allRefs[index].getName() + "\" defined for bean \"" + dd.getName() + "\". Missing type.");
                    } else {
                        try {
                            allRefs[index].setType(tempString);
                        }
                        catch (IllegalArgumentException biae) {
                            this.errors.add("Incorrect server component reference :" + allRefs[index].getName() + "\" for bean \"" + dd.getName() + "\":\n" + biae.toString());
                            return;
                        }
                    }
                } else if (el.getNodeName().equals("jndi-name")) {
                    tempString = this.getTextValue(el);
                    if (tempString.equals("")) {
                        this.errors.add(" Incorrect resource environment reference \"" + allRefs[index].getName() + "\" defined for bean \"" + dd.getName() + "\". Missing jndi name.");
                        return;
                    }
                    allRefs[index].setJndiName(tempString);
                }
            }
            ++i;
        }
        if (!description.equals("")) {
            allRefs[index].setDescription(description);
        }
        dd.setServerComponentReferences(allRefs);
    }

    private void processRunAsIdentityMap(Element runAsEl, DeploymentDescriptor dd) {
        SecurityIdentity identity = dd.getSecurityIdentity();
        if (identity.isCallerIdentity()) {
            this.errors.add(" Incorrect <run-as-identity-map> to bean \"" + dd.getName() + "\". Use caller identity selected.");
            return;
        }
        NodeList list = runAsEl.getChildNodes();
        Element el = null;
        String userName = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1 && (el = (Element)list.item(i)).getNodeName().equals("user-name")) {
                userName = this.getTextValue(el);
                if (userName.equals("")) {
                    this.errors.add(" Incorrect <run-as-identity-map> to bean \"" + dd.getName() + "\". Missing user name.");
                    return;
                }
                identity.getRunAsIdentity().setUserName(userName);
                dd.setSecurityIdentity(identity);
            }
            ++i;
        }
    }

    private void processIORSecurity(Element iorEl, DeploymentDescriptor dd) {
        NodeList list = iorEl.getChildNodes();
        Element el = null;
        Object userName = null;
        boolean add = false;
        IORDescriptor ior = new IORDescriptor();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                el = (Element)list.item(i);
                if (el.getNodeName().equals("transport-config")) {
                    if (this.processTransConfig(el, dd, ior)) {
                        add = true;
                    }
                } else if (el.getNodeName().equals("as-context")) {
                    if (this.processAsContext(el, dd, ior)) {
                        add = true;
                    }
                } else if (el.getNodeName().equals("sas-context") && this.processSasContext(el, dd, ior)) {
                    add = true;
                }
            }
            ++i;
        }
        if (add) {
            this.iors.add(ior);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean processTransConfig(Element iorEl, DeploymentDescriptor dd, IORDescriptor ior) {
        NodeList list = iorEl.getChildNodes();
        Element el = null;
        String tagValue = null;
        int i = 0;
        while (i < list.getLength()) {
            el = (Element)list.item(i);
            if (el.getNodeName().equals("integrity")) {
                tagValue = this.getTextValue(el);
                if (tagValue.equals("")) {
                    this.errors.add(" Incorrect tag <transport-config> to bean \"" + dd.getName() + "\". Missing <integrity> tag.");
                    return false;
                }
                ior.setIntegrity(tagValue);
            } else if (el.getNodeName().equals("confidentiality")) {
                tagValue = this.getTextValue(el);
                if (tagValue.equals("")) {
                    this.errors.add(" Incorrect tag <transport-config> to bean \"" + dd.getName() + "\". Missing <confidentiality> tag.");
                    return false;
                }
                ior.setConfidentiality(tagValue);
            } else if (el.getNodeName().equals("establish-trust-in-target")) {
                tagValue = this.getTextValue(el);
                if (tagValue.equals("")) {
                    this.errors.add(" Incorrect tag <transport-config> to bean \"" + dd.getName() + "\". Missing <establish-trust-in-target> tag.");
                    return false;
                }
                ior.setEstablishTrustInTarget(tagValue);
            } else if (el.getNodeName().equals("establish-trust-in-client")) {
                tagValue = this.getTextValue(el);
                if (tagValue.equals("")) {
                    this.errors.add(" Incorrect tag <transport-config> to bean \"" + dd.getName() + "\". Missing <establish-trust-in-client> tag.");
                    return false;
                }
                ior.setEstablishTrustInClient(tagValue);
            }
            ++i;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean processAsContext(Element iorEl, DeploymentDescriptor dd, IORDescriptor ior) {
        NodeList list = iorEl.getChildNodes();
        Element el = null;
        String tagValue = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                el = (Element)list.item(i);
                if (el.getNodeName().equals("auth-method")) {
                    tagValue = this.getTextValue(el);
                    if (tagValue.equals("")) {
                        this.errors.add(" Incorrect tag <as-context> to bean \"" + dd.getName() + "\". Missing <auth-method> tag.");
                        return false;
                    }
                    ior.setAuthenticationMethod(tagValue);
                } else if (el.getNodeName().equals("realm")) {
                    tagValue = this.getTextValue(el);
                    if (tagValue.equals("")) {
                        this.errors.add(" Incorrect tag <as-context> to bean \"" + dd.getName() + "\". Missing <realm> tag.");
                        return false;
                    }
                    ior.setAuthenticationMethod(tagValue);
                } else if (el.getNodeName().equals("required")) {
                    tagValue = this.getTextValue(el);
                    if (tagValue.equals("")) {
                        this.errors.add(" Incorrect tag <as-context> to bean \"" + dd.getName() + "\". Missing <required> tag.");
                        return false;
                    }
                    ior.setAuthenticationMethod(tagValue);
                }
            }
            ++i;
        }
        return true;
    }

    private boolean processSasContext(Element iorEl, DeploymentDescriptor dd, IORDescriptor ior) {
        NodeList list = iorEl.getChildNodes();
        if (!((Element)list.item(0)).getNodeName().equals("caller-propagation")) {
            this.errors.add(" Incorrect tag <sas-context> to bean \"" + dd.getName() + "\". Missing <caller-propagation> tag.");
            return false;
        }
        ior.setAuthenticationMethod(this.getTextValue((Element)list.item(0)));
        return true;
    }

    private void processSessionProps(Element element, SessionDescriptor des) {
        NodeList list = element.getChildNodes();
        Properties props = new Properties();
        boolean usePassivation = false;
        Element child = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                child = (Element)list.item(i);
                if (child.getNodeName().equals("session-timeout")) {
                    try {
                        des.setSessionTimeout(Integer.parseInt(this.getTextValue(child)));
                    }
                    catch (NumberFormatException nfe) {
                        this.errors.add(" Non integer value of tag <session-timeout> of session properties  for bean \"" + des.getName() + "\".");
                        return;
                    }
                } else if (child.getNodeName().equals("passivation")) {
                    usePassivation = true;
                    this.processPassivation(child, des);
                } else if (child.getNodeName().equals("keeps-open-resources")) {
                    usePassivation = false;
                    des.setKeepsOpenResources(true);
                } else if (child.getNodeName().equals("property")) {
                    props.setProperty(this.getTextValue(this.getFirstElementByName(child, "property-name")), this.getTextValue(this.getFirstElementByName(child, "property-value")));
                }
            }
            ++i;
        }
        des.setUsePassivation(usePassivation);
        des.setBeanProperties(props);
    }

    private void processPassivation(Element passEl, SessionDescriptor des) {
        NodeList list = passEl.getChildNodes();
        Element el = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                el = (Element)list.item(i);
                if (el.getNodeName().equals("passive-timeout")) {
                    try {
                        des.setSessionTimeout(Integer.parseInt(this.getTextValue(el)));
                    }
                    catch (NumberFormatException nfe) {
                        this.errors.add(" Non integer value of tag <passive-timeout> for bean \"" + des.getName() + "\". ");
                        return;
                    }
                }
                if (el.getNodeName().equals("lrulimit")) {
                    try {
                        des.setLruLimit(Integer.parseInt(this.getTextValue(el)));
                    }
                    catch (NumberFormatException nfe) {
                        this.errors.add(" Non integer value of tag <lrulimit> for bean \"" + des.getName() + "\".");
                        return;
                    }
                }
            }
            ++i;
        }
    }

    private void processEntityProps(Element element, EntityDescriptor des) {
        NodeList list = element.getChildNodes();
        Properties props = new Properties();
        Element el = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                el = (Element)list.item(i);
                if (el.getNodeName().equals("unknown-pk-interval")) {
                    if (des instanceof CMPEntityDescriptor) {
                        try {
                            ((CMPEntityDescriptor)des).setUnknownPKInterval(Integer.parseInt(this.getTextValue(el)));
                        }
                        catch (NumberFormatException nfe) {
                            this.errors.add(" Not integer value of tag <unknown-pk-interval> for bean \"" + des.getName() + "\".");
                        }
                    } else {
                        this.errors.add(" Incorrect tag <unknown-pk-interval> defined for non CMP entity bean \"" + des.getName() + ".");
                    }
                } else if (el.getNodeName().equals("initial-cache-size")) {
                    if (des instanceof CMPEntityDescriptor) {
                        try {
                            ((CMPEntityDescriptor)des).setCacheSize(Integer.parseInt(this.getTextValue(el)));
                        }
                        catch (NumberFormatException nfe) {
                            this.errors.add(" Not integer value of tag <initial-cache-size> for bean \"" + des.getName() + "\".");
                        }
                    } else {
                        this.errors.add(" Incorrect tag <initial-cache-size> defined for non CMP entity bean \"" + des.getName() + ".");
                    }
                } else if (el.getNodeName().equals("property")) {
                    props.setProperty(this.getTextValue(this.getFirstElementByName(el, "property-name")), this.getTextValue(this.getFirstElementByName(el, "property-value")));
                }
            }
            ++i;
        }
        des.setBeanProperties(props);
    }

    private void processMessageDrivenProps(Element element, MessageDrivenDescriptor des) {
        NodeList list = element.getChildNodes();
        Properties props = new Properties();
        Element el = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                el = (Element)list.item(i);
                if (el.getNodeName().equals("destination-name")) {
                    props.setProperty("DestinationName", this.getTextValue(el));
                } else if (el.getNodeName().equals("connection-factory-name")) {
                    props.setProperty("ConnectionFactoryName", this.getTextValue(el));
                } else if (el.getNodeName().equals("property")) {
                    props.setProperty(this.getTextValue(this.getFirstElementByName(el, "property-name")), this.getTextValue(this.getFirstElementByName(el, "property-value")));
                }
            }
            ++i;
        }
        des.setBeanProperties(props);
    }

    private void processTransactions(Element transactions) {
        NodeList list = transactions.getChildNodes();
        Element el = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1 && (el = (Element)list.item(i)).getNodeName().equals("isolation-level")) {
                this.processIsoLevel(el);
            }
            ++i;
        }
    }

    private void processIsoLevel(Element isoEl) {
        NodeList list = isoEl.getChildNodes();
        Element el = null;
        ControlDescriptor[] controlDescriptors = null;
        ControlDescriptor beanControlDescriptor = null;
        Vector<ControlDescriptor> allControls = new Vector<ControlDescriptor>();
        String tempString = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                int j;
                el = (Element)list.item(i);
                if (el.getNodeName().equals("ejb-name")) {
                    tempString = this.getTextValue(el);
                    beanControlDescriptor = this.findControlDescriptor(tempString);
                    if (beanControlDescriptor == null) {
                        this.errors.add(" Incorrect tag. <isolation-level> defined for non CMP entity bean \"" + tempString + "\".");
                    } else {
                        allControls.add(beanControlDescriptor);
                    }
                } else if (el.getNodeName().equals("method")) {
                    controlDescriptors = this.findCtrlDescriptors(el);
                    if (controlDescriptors != null && controlDescriptors.length != 0) {
                        j = 0;
                        while (j < controlDescriptors.length) {
                            allControls.add(controlDescriptors[j]);
                            ++j;
                        }
                    }
                } else if (el.getNodeName().equals("isolation-attribute")) {
                    tempString = this.getTextValue(el);
                    j = 0;
                    while (j < allControls.size()) {
                        ((ControlDescriptor)allControls.get(j)).setIsolationLevel(tempString);
                        ++j;
                    }
                    this.setControls(allControls);
                    allControls = new Vector();
                }
            }
            ++i;
        }
    }

    private void processSecurityPermition(Element securityPerm) {
        NodeList list = securityPerm.getChildNodes();
        Element el = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1 && (el = (Element)list.item(i)).getNodeName().equals("security-role-map")) {
                this.processSecurityRoleMap(el);
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processSecurityRoleMap(Element roleMap) {
        NodeList list = roleMap.getChildNodes();
        Element el = null;
        SecurityRoles role = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                el = (Element)list.item(i);
                if (el.getNodeName().equals("role-name") || el.getNodeName().equals("security-role")) {
                    role = this.ejbJar.getSecurityRole(this.getTextValue(el));
                    role.setUserGroups(null);
                    role.setUserNames(null);
                } else if (el.getNodeName().equals("user-name") || el.getNodeName().equals("user")) {
                    if (role == null) {
                        this.errors.add("Incorrect security-role-map: existing user-name \"" + this.getTextValue(el) + "\", but role-name mising.");
                        return;
                    }
                    role.setUserName(this.getTextValue(el));
                } else if (el.getNodeName().equals("group-name") || el.getNodeName().equals("group")) {
                    if (role == null) {
                        this.errors.add("Incorrect security-role-name: existing group-name \"" + this.getTextValue(el) + "\", but role-name mising.");
                        return;
                    }
                    role.setUserGroup(this.getTextValue(el));
                } else if (el.getNodeName().equals("server-role-name") || el.getNodeName().equals("server-security-role")) {
                    if (role == null) {
                        this.errors.add("Incorrect security-role-name: existing server-role \"" + this.getTextValue(el) + "\", but role-name mising.");
                        return;
                    }
                    role.setServerRoleName(this.getTextValue(el));
                    role.setUserGroups(null);
                    role.setUserNames(null);
                }
            }
            ++i;
        }
    }

    private ControlDescriptor findControlDescriptor(String ejbName) {
        Descriptor descr = this.ejbJar.getDescriptor(ejbName);
        if (!(descr instanceof CMPEntityDescriptor)) {
            return null;
        }
        ControlDescriptor[] allControls = ((DeploymentDescriptor)descr).getTransactionDescriptors();
        MethodEntry entry = new MethodEntry((Method)null);
        entry.setEjbName(ejbName);
        ControlDescriptor result = new ControlDescriptor(entry);
        if (allControls != null && allControls.length != 0) {
            int i = 0;
            while (i < allControls.length) {
                if (allControls[i].getMethodEntry().getMethodName().equals("Entire EJB")) {
                    result = allControls[i];
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    private ControlDescriptor[] findCtrlDescriptors(Element mEl) {
        int i;
        Vector<ControlDescriptor> filtered;
        NodeList methodList = mEl.getChildNodes();
        String ejbName = null;
        String methodIntf = null;
        String methodName = null;
        Vector<String> methodParams = new Vector<String>();
        boolean hasMethodParams = false;
        int i2 = 0;
        while (i2 < methodList.getLength()) {
            if (methodList.item(i2).getNodeType() == 1) {
                Element el = (Element)methodList.item(i2);
                String tag = el.getNodeName();
                if (tag.equals("ejb-name")) {
                    ejbName = this.getTextValue(el);
                } else if (tag.equals("method-intf")) {
                    methodIntf = this.getTextValue(el);
                } else if (tag.equals("method-name")) {
                    methodName = this.getTextValue(el).trim();
                } else if (tag.equals("method-params")) {
                    hasMethodParams = true;
                    NodeList paramList = el.getChildNodes();
                    int j = 0;
                    while (j < paramList.getLength()) {
                        Element pel;
                        if (paramList.item(j).getNodeType() == 1 && (pel = (Element)paramList.item(j)).getNodeName().equals("method-param")) {
                            methodParams.add(this.getTextValue(pel));
                        }
                        ++j;
                    }
                }
            }
            ++i2;
        }
        ControlDescriptor[] controls = this.findDescriptor(ejbName).getTransactionDescriptors();
        if (controls == null) {
            MethodEntry entry = new MethodEntry(methodName);
            entry.setEjbName(ejbName);
            entry.setMethodInterface(methodIntf);
            entry.setMethodSpecified(true);
            String[] params = new String[methodParams.size()];
            params = methodParams.toArray(params);
            entry.setParameters(params);
            return new ControlDescriptor[]{new ControlDescriptor(entry)};
        }
        if (methodName.equals("*")) {
            if (methodIntf != null) {
                filtered = new Vector<ControlDescriptor>();
                int i3 = 0;
                while (i3 < controls.length) {
                    if (controls[i3].getMethodEntry().getMethodInterface().equals(methodIntf)) {
                        filtered.add(controls[i3]);
                    }
                    ++i3;
                }
                return filtered.toArray(new ControlDescriptor[filtered.size()]);
            }
            return controls;
        }
        if (!hasMethodParams) {
            filtered = new Vector();
            if (methodIntf != null) {
                int i4 = 0;
                while (i4 < controls.length) {
                    MethodEntry mEntry = controls[i4].getMethodEntry();
                    if (mEntry.getMethodInterface().equals(methodIntf) && mEntry.getMethodName().equals(methodName)) {
                        filtered.add(controls[i4]);
                    }
                    ++i4;
                }
                if (filtered.size() == 0) {
                    this.errors.add("ID016393: Can not find method " + methodName + " in " + methodIntf + " interface of bean " + ejbName);
                }
            } else {
                int i5 = 0;
                while (i5 < controls.length) {
                    MethodEntry mEntry = controls[i5].getMethodEntry();
                    if (mEntry.getMethodName().equals(methodName)) {
                        filtered.add(controls[i5]);
                    }
                    ++i5;
                }
                if (filtered.size() == 0) {
                    this.errors.add("ID016394: Can not find method " + methodName + " in bean " + ejbName);
                }
            }
            return filtered.toArray(new ControlDescriptor[filtered.size()]);
        }
        filtered = new Vector();
        if (methodIntf != null) {
            i = 0;
            while (i < controls.length) {
                MethodEntry mEntry = controls[i].getMethodEntry();
                if (mEntry.getMethodInterface().equals(methodIntf) && mEntry.getMethodName().equals(methodName)) {
                    filtered.add(controls[i]);
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < controls.length) {
                MethodEntry mEntry = controls[i].getMethodEntry();
                if (mEntry.getMethodName().equals(methodName)) {
                    filtered.add(controls[i]);
                }
                ++i;
            }
        }
        Vector<ControlDescriptor> secondFiltered = new Vector<ControlDescriptor>();
        String[] params = methodParams.toArray(new String[methodParams.size()]);
        Enumeration e = filtered.elements();
        while (e.hasMoreElements()) {
            ControlDescriptor accCtrl = (ControlDescriptor)e.nextElement();
            String[] mParams = accCtrl.getMethodEntry().getParameters();
            if (params.length != mParams.length) continue;
            boolean equals = true;
            int j = 0;
            while (j < params.length) {
                if (!params[j].equals(this.convertClassName(mParams[j]))) {
                    equals = false;
                }
                ++j;
            }
            if (!equals) continue;
            secondFiltered.add(accCtrl);
        }
        if (secondFiltered.size() == 0) {
            MethodEntry entry = new MethodEntry(methodName);
            entry.setEjbName(ejbName);
            entry.setMethodInterface(methodIntf);
            entry.setParameters(params);
            entry.setMethodSpecified(true);
            return new ControlDescriptor[]{new ControlDescriptor(entry)};
        }
        return secondFiltered.toArray(new ControlDescriptor[secondFiltered.size()]);
    }

    private DeploymentDescriptor findDescriptor(String name) {
        DeploymentDescriptor[] descriptors = this.ejbJar.getDDescriptors();
        if (descriptors == null) {
            this.errors.add("ID016396: Internal Ejb deploy error!");
            return null;
        }
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i].getEjbName().equals(name)) {
                return descriptors[i];
            }
            ++i;
        }
        this.errors.add("Warning  can not find Bean with name : " + name + "  Fix this name is ejb-j2ee-engine.xml!");
        return null;
    }

    private Element getFirstElementByName(Element el, String name) {
        NodeList nl = el.getElementsByTagName(name);
        if (nl.getLength() < 1) {
            return null;
        }
        return (Element)nl.item(0);
    }

    private String convertClassName(String className) {
        if (className.charAt(0) != '[') {
            return className;
        }
        int first = className.indexOf(91);
        int last = className.lastIndexOf(91);
        char ch = className.charAt(last + 1);
        String st = "";
        int i = 0;
        while (i <= last - first) {
            st = st + "[]";
            ++i;
        }
        switch (ch) {
            case 'B': {
                return "byte" + st;
            }
            case 'C': {
                return "char" + st;
            }
            case 'D': {
                return "double" + st;
            }
            case 'F': {
                return "float" + st;
            }
            case 'I': {
                return "int" + st;
            }
            case 'J': {
                return "long" + st;
            }
            case 'S': {
                return "short" + st;
            }
            case 'Z': {
                return "boolean" + st;
            }
            case 'L': {
                return className.substring(last + 2, className.length() - 1) + st;
            }
        }
        return "";
    }

    public Vector getErrors() {
        return this.errors;
    }

    private void setControls(Vector controls) {
        if (controls.isEmpty()) {
            return;
        }
        Object beanControls = null;
        ControlDescriptor current = null;
        DeploymentDescriptor descr = null;
        int i = 0;
        while (i < controls.size()) {
            current = (ControlDescriptor)controls.get(i);
            descr = this.findDescriptor(current.getMethodEntry().getEjbName());
            descr.setTransactionDescriptor(current);
            ++i;
        }
    }
}

