/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.ejb.descriptors.xml;

import com.sap.engine.deploy.exceptions.BaseIllegalArgumentException;
import com.sap.engine.services.deploy.ear.common.EJBeanLocalReference;
import com.sap.engine.services.deploy.ear.common.EJBeanReference;
import com.sap.engine.services.deploy.ear.common.EnvironmentEntry;
import com.sap.engine.services.deploy.ear.common.MethodEntry;
import com.sap.engine.services.deploy.ear.common.ResourceEnvReference;
import com.sap.engine.services.deploy.ear.common.ResourceReference;
import com.sap.engine.services.deploy.ear.common.SecurityRoleReference;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.ejb.deploy.descriptors.AbstractSchema;
import com.sap.engine.services.ejb.deploy.descriptors.AccessControls;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.ControlDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.FinderDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.MessageDrivenDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.OneSideRelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.ejb.deploy.descriptors.RelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.RelationField;
import com.sap.engine.services.ejb.deploy.descriptors.SecurityIdentity;
import com.sap.engine.services.ejb.deploy.descriptors.SessionDescriptor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EJB20DescriptorDocument {
    public static final String dtd = "<!DOCTYPE ejb-jar PUBLIC '-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN' 'http://java.sun.com/dtd/ejb-jar_2_0.dtd'>";
    public Document mainDocument = null;
    private DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    public DocumentBuilder builder = null;
    private static Object obj = new Object();
    private boolean compliance = true;
    private Vector errors = null;
    private String illegalArgumentException = "";

    public EJB20DescriptorDocument() {
        try {
            this.builder = this.factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pcfe) {
            throw new BaseIllegalArgumentException("xml_ejb_4000", pcfe);
        }
    }

    public EJB20DescriptorDocument(boolean compliance) {
        this();
        this.compliance = compliance;
    }

    public void setCompliance(boolean compliance) {
        this.compliance = compliance;
    }

    public Document loadEJBJarDescriptor(EJBJarDescriptor ejbJar) throws IllegalArgumentException {
        this.errors = new Vector();
        this.factory = DocumentBuilderFactory.newInstance();
        try {
            this.builder = this.factory.newDocumentBuilder();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        this.mainDocument = null;
        this.mainDocument = this.builder.newDocument();
        Element ejbJarEl = this.mainDocument.createElement("ejb-jar");
        this.mainDocument.appendChild(ejbJarEl);
        if (ejbJar.getDescription() != null && !ejbJar.getDescription().trim().equals("")) {
            this.load(ejbJarEl, ejbJar.getDescription(), "description");
        }
        if (ejbJar.getDisplayName() != null && !ejbJar.getDisplayName().trim().equals("")) {
            this.load(ejbJarEl, ejbJar.getDisplayName(), "display-name");
        }
        if (ejbJar.getSmallIcon() != null && ejbJar.getSmallIcon().getFileName() != null && !ejbJar.getSmallIcon().getFileName().trim().equals("")) {
            this.load(ejbJarEl, ejbJar.getSmallIcon().getFileName(), "small-icon");
        }
        if (ejbJar.getLargeIcon() != null && ejbJar.getLargeIcon().getFileName() != null && !ejbJar.getLargeIcon().getFileName().trim().equals("")) {
            this.load(ejbJarEl, ejbJar.getLargeIcon().getFileName(), "large-icon");
        }
        DeploymentDescriptor[] dd = ejbJar.getDDescriptors();
        AbstractSchema schema = ejbJar.getAbstractSchema();
        Object relDescriptors = null;
        if (dd != null && dd.length > 0) {
            Element enterpriseBeansEl = this.mainDocument.createElement("enterprise-beans");
            int i = 0;
            while (i < dd.length) {
                if (dd[i] instanceof EntityDescriptor) {
                    this.loadEntityDescriptor(this.mainDocument, enterpriseBeansEl, (EntityDescriptor)dd[i]);
                    if (dd[i] instanceof CMPEntityDescriptor) {
                        // empty if block
                    }
                } else if (dd[i] instanceof SessionDescriptor) {
                    this.loadSessionDescriptor(this.mainDocument, enterpriseBeansEl, (SessionDescriptor)dd[i]);
                } else if (dd[i] instanceof MessageDrivenDescriptor) {
                    this.loadMessageDrivenDescr(this.mainDocument, enterpriseBeansEl, (MessageDrivenDescriptor)dd[i]);
                }
                ++i;
            }
            ejbJarEl.appendChild(enterpriseBeansEl);
        } else {
            if (this.compliance) {
                throw new BaseIllegalArgumentException("xml_ejb_4047", new String[]{ejbJar.getJarName()});
            }
            this.errors.add("Ejb-jar \"" + ejbJar.getJarName() + "\" contains no beans.");
        }
        if (schema != null && schema.getDescriptors() != null && schema.getDescriptors().length > 0) {
            this.loadRelationsShips1(this.mainDocument, ejbJarEl, schema);
        }
        Element assemblyDescriptorEl = this.mainDocument.createElement("assembly-descriptor");
        this.loadSecurityRoles(this.mainDocument, assemblyDescriptorEl, ejbJar.getSecurityRoles());
        this.loadPermissions(this.mainDocument, assemblyDescriptorEl, ejbJar);
        this.loadContainerTransaction(this.mainDocument, assemblyDescriptorEl, ejbJar);
        this.loadExcludeList(this.mainDocument, assemblyDescriptorEl, ejbJar);
        ejbJarEl.appendChild(assemblyDescriptorEl);
        return this.mainDocument;
    }

    public void loadRelationsShips1(Document mainDocument, Element ejbJarEl, AbstractSchema schema) throws BaseIllegalArgumentException {
        RelationDescriptor[] relations = schema.getRelDescriptors();
        if (relations == null || relations.length == 0) {
            return;
        }
        Object cmpd = null;
        Element relationEl = null;
        String relationDescr = null;
        OneSideRelationDescriptor side1 = null;
        OneSideRelationDescriptor side2 = null;
        Object role1El = null;
        Object role1E2 = null;
        Object name = null;
        Object description = null;
        Object multiplicity = null;
        Object roleSourceEl = null;
        Object destEjbName = null;
        Object cmr1 = null;
        Element relationsEl = mainDocument.createElement("relationships");
        int i = 0;
        while (i < relations.length) {
            if (relations[i] != null) {
                relationEl = mainDocument.createElement("ejb-relation");
                relationDescr = relations[i].getRelationDescription();
                if (relationDescr != null && !relationDescr.equals("")) {
                    this.load(relationEl, relationDescr, "description");
                }
                if ((relationDescr = relations[i].getRelationName()) != null && !relationDescr.equals("")) {
                    this.load(relationEl, relationDescr, "ejb-relation-name");
                }
                side1 = relations[i].getSide1();
                side2 = relations[i].getSide2();
                if (side1 != null || side2 != null) {
                    // empty if block
                }
                this.loadRelationRole(mainDocument, relationEl, schema, side1);
                this.loadRelationRole(mainDocument, relationEl, schema, side2);
                relationsEl.appendChild(relationEl);
            }
            ++i;
        }
        ejbJarEl.appendChild(relationsEl);
    }

    private void loadRelationRole(Document mainDocument, Element relationEl, AbstractSchema schema, OneSideRelationDescriptor side) {
        String name;
        Element role1El = mainDocument.createElement("ejb-relationship-role");
        String description = side.getRoleDescription();
        if (description != null && !description.equals("")) {
            this.load(role1El, description, "description");
        }
        if ((name = side.getRoleName()) != null && !name.equals("")) {
            this.load(role1El, name, "ejb-relationship-role-name");
        }
        String multiplicity = null;
        if (side.getMultiplicityType() == 4 || side.getMultiplicityType() == 3) {
            multiplicity = "Many";
        } else if (side.getMultiplicityType() == 1 || side.getMultiplicityType() == 2) {
            multiplicity = "One";
        }
        this.load(role1El, multiplicity, "multiplicity");
        if (side.isCascade()) {
            role1El.appendChild(mainDocument.createElement("cascade-delete"));
        }
        Element roleSourceEl = mainDocument.createElement("relationship-role-source");
        int id = side.getEjbId();
        CMPEntityDescriptor cmpd = schema.getDescriptor(id);
        if (cmpd == null || cmpd.getEjbName() == null || cmpd.getEjbName().equals("")) {
            // empty if block
        }
        String destEjbName = cmpd.getEjbName();
        this.load(roleSourceEl, destEjbName, "ejb-name");
        role1El.appendChild(roleSourceEl);
        id = side.getCmrId();
        RelationField cmr = cmpd.getRelationField(id);
        if (cmr != null && cmr.getFieldName() != null && !cmr.getFieldName().equals("")) {
            Element fieldEl = mainDocument.createElement("cmr-field");
            description = cmr.getDescription();
            if (description != null && !description.equals("")) {
                this.load(fieldEl, description, "description");
            }
            name = cmr.getFieldName();
            this.load(fieldEl, name, "cmr-field-name");
            String type = cmr.getFieldType();
            if (type != null && !type.equals("")) {
                this.load(fieldEl, type, "cmr-field-type");
            }
            role1El.appendChild(fieldEl);
        }
        relationEl.appendChild(role1El);
    }

    private void loadExcludeList(Document mainDocument, Element assemblyDescriptorEl, EJBJarDescriptor ejbJar) {
        DeploymentDescriptor[] dd = ejbJar.getDDescriptors();
        Element excludeListEl = mainDocument.createElement("exclude-list");
        if (ejbJar.getExcludeListDescription() != null && !ejbJar.getExcludeListDescription().equals("")) {
            this.load(excludeListEl, ejbJar.getExcludeListDescription(), "description");
        }
        MethodEntry[] entries = null;
        Element methodEl = null;
        int i = 0;
        while (i < dd.length) {
            entries = dd[i].getUncalableMethods();
            if (entries != null && entries.length > 0) {
                int j = 0;
                while (j < entries.length) {
                    methodEl = mainDocument.createElement("method");
                    if (entries[j].getMethodDescription() != null && !entries[j].getMethodDescription().trim().equals("")) {
                        this.load(methodEl, entries[j].getMethodDescription(), "description");
                    }
                    this.load(methodEl, dd[i].getEjbName(), "ejb-name");
                    if (entries[j].getMethodInterface() != null) {
                        this.load(methodEl, entries[j].getMethodInterface(), "method-intf");
                    }
                    this.load(methodEl, entries[j].getMethodName(), "method-name");
                    if (entries[j].getParameters() != null) {
                        this.loadMethodParams(methodEl, entries[j].getParameters());
                    }
                    excludeListEl.appendChild(methodEl);
                    ++j;
                }
            }
            ++i;
        }
        if (excludeListEl.getChildNodes() != null && excludeListEl.getChildNodes().getLength() > 0) {
            assemblyDescriptorEl.appendChild(excludeListEl);
        }
    }

    private void loadContainerTransaction(Document mainDocument, Element assemblyDescriptorEl, EJBJarDescriptor ejbJar) {
        DeploymentDescriptor[] dd = ejbJar.getDDescriptors();
        ControlDescriptor[] cd = null;
        ControlDescriptor oneCd = null;
        String[] trNames = null;
        Element containerTrEl = null;
        Hashtable<ControlDescriptor, String> methods = null;
        Enumeration keys = null;
        Element methodEl = null;
        int i = 0;
        while (i < dd.length) {
            trNames = null;
            cd = dd[i].getTransactionDescriptors();
            if (cd != null) {
                int j = 0;
                while (j < cd.length) {
                    if (cd[j].getTxName() != null) {
                        trNames = this.concatArrays(new String[]{cd[j].getTxName()}, trNames);
                    }
                    ++j;
                }
            }
            if (!(trNames == null || trNames.length == 0 || dd[i] instanceof SessionDescriptor && ((SessionDescriptor)dd[i]).getTransactionType() == 0 || dd[i] instanceof MessageDrivenDescriptor && ((MessageDrivenDescriptor)dd[i]).getTransactionType() == 0 || cd == null || cd.length == 0)) {
                boolean flag = false;
                int j = 0;
                while (j < cd.length) {
                    flag = false;
                    methods = new Hashtable<ControlDescriptor, String>();
                    containerTrEl = mainDocument.createElement("container-transaction");
                    if (cd[j].getDescription() != null && !cd[j].getDescription().trim().equals("")) {
                        this.load(containerTrEl, cd[j].getDescription(), "description");
                        flag = true;
                    }
                    int k = 0;
                    while (k < trNames.length) {
                        if (trNames[k].equals(cd[j].getTxName())) {
                            methods.put(cd[j], dd[i].getEjbName());
                        }
                        ++k;
                    }
                    keys = methods.keys();
                    methodEl = null;
                    while (keys.hasMoreElements()) {
                        methodEl = mainDocument.createElement("method");
                        oneCd = (ControlDescriptor)keys.nextElement();
                        this.loadMethodElement(methodEl, (String)methods.get(oneCd), oneCd);
                        containerTrEl.appendChild(methodEl);
                        flag = true;
                    }
                    if (cd[j].getTxName() != null && !cd[j].getTxName().trim().equals("")) {
                        this.load(containerTrEl, cd[j].getTxName(), "trans-attribute");
                        flag = true;
                    }
                    if (flag) {
                        assemblyDescriptorEl.appendChild(containerTrEl);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private boolean containTrans(String[] trNames, String name) {
        int i = 0;
        while (i < trNames.length) {
            if (trNames[i].equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void loadPermissions(Document mainDocument, Element assemblyDescriptorEl, EJBJarDescriptor ejbJar) {
        DeploymentDescriptor[] dd = ejbJar.getDDescriptors();
        AccessControls[] ac = null;
        AccessControls access = null;
        String[] roles = null;
        String uncheckedRole = "unchecked" + System.currentTimeMillis();
        Element roleNameEl = null;
        int i = 0;
        while (i < dd.length) {
            ac = dd[i].getAccessControlEntries();
            if (ac != null) {
                int j = 0;
                while (j < ac.length) {
                    if (ac[j].getUnchecked()) {
                        roles = this.concatArrays(new String[]{new String(uncheckedRole)}, roles);
                    } else if (ac[j].getSecurityRoleNames() != null) {
                        roles = this.concatArrays(ac[j].getSecurityRoleNames(), roles);
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (roles == null || roles.length == 0) {
            return;
        }
        Hashtable<AccessControls, String> methods = null;
        String roleName = null;
        Element methodPermissionEl = null;
        Element methodEl = null;
        Enumeration keys = null;
        int i2 = 0;
        while (i2 < roles.length) {
            roleName = roles[i2];
            methods = new Hashtable<AccessControls, String>();
            methodPermissionEl = mainDocument.createElement("method-permission");
            if (!roleName.equals(uncheckedRole)) {
                this.load(methodPermissionEl, roleName, "role-name");
            } else {
                roleNameEl = mainDocument.createElement("unchecked");
                methodPermissionEl.appendChild(roleNameEl);
            }
            int j = 0;
            while (j < dd.length) {
                ac = dd[j].getAccessControlEntries();
                int k = 0;
                while (k < ac.length) {
                    if (this.containsRole(roleName, ac[k]) || ac[k].getUnchecked() && roleName.equals(uncheckedRole)) {
                        methods.put(ac[k], dd[j].getEjbName());
                    }
                    ++k;
                }
                ++j;
            }
            if (methods.size() == 0) {
                assemblyDescriptorEl.appendChild(methodPermissionEl);
            } else {
                keys = methods.keys();
                while (keys.hasMoreElements()) {
                    methodEl = mainDocument.createElement("method");
                    access = (AccessControls)keys.nextElement();
                    this.loadMethodElement(methodEl, (String)methods.get(access), access);
                    methodPermissionEl.appendChild(methodEl);
                }
                assemblyDescriptorEl.appendChild(methodPermissionEl);
            }
            ++i2;
        }
    }

    private void loadMethodElement(Element methodsEl, String ejbName, AccessControls access) {
        if (access.getDescription() != null && !access.getDescription().trim().equals("")) {
            this.load(methodsEl, access.getDescription(), "description");
        }
        this.load(methodsEl, ejbName, "ejb-name");
        if (access.getMethod().getMethodInterface() != null && !access.getMethod().getMethodInterface().trim().equals("")) {
            this.load(methodsEl, access.getMethod().getMethodInterface(), "method-intf");
        }
        if (!access.getMethod().isMethodSpecified()) {
            this.load(methodsEl, "*", "method-name");
            return;
        }
        this.load(methodsEl, access.getMethod().getMethodName(), "method-name");
        if (access.getMethod().getParameters() != null) {
            this.loadMethodParams(methodsEl, access.getMethod().getParameters());
        }
    }

    private void loadMethodElement(Element methodsEl, String ejbName, ControlDescriptor cd) {
        if (cd.getMethodEntry().getMethodDescription() != null && !cd.getMethodEntry().getMethodDescription().trim().equals("")) {
            this.load(methodsEl, cd.getMethodEntry().getMethodDescription(), "description");
        }
        this.load(methodsEl, ejbName, "ejb-name");
        if (cd.getMethodEntry().getMethodInterface() != null && !cd.getMethodEntry().getMethodInterface().trim().equals("")) {
            this.load(methodsEl, cd.getMethodEntry().getMethodInterface(), "method-intf");
        }
        if (!cd.getMethodEntry().isMethodSpecified()) {
            this.load(methodsEl, "*", "method-name");
            return;
        }
        this.load(methodsEl, cd.getMethodEntry().getMethodName(), "method-name");
        if (cd.getMethodEntry().getParameters() != null) {
            this.loadMethodParams(methodsEl, cd.getMethodEntry().getParameters());
        }
    }

    private void loadMethodParams(Element parent, String[] params) {
        if (params != null) {
            Element newEl = this.mainDocument.createElement("method-params");
            int j = 0;
            while (j < params.length) {
                this.load(newEl, this.convertClassName(params[j]), "method-param");
                ++j;
            }
            parent.appendChild(newEl);
        }
    }

    private boolean containsRole(String name, AccessControls ac) {
        String[] sr = ac.getSecurityRoleNames();
        if (sr == null) {
            return false;
        }
        int i = 0;
        while (i < sr.length) {
            if (name.equals(sr[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void loadRelationsShips(Document mainDocument, Element ejbJarEl, CMPEntityDescriptor[] cmpd, RelationDescriptor[] relDescriptors) {
        if (cmpd == null) {
            return;
        }
        CMPEntityDescriptor descr = null;
        RelationField[] fields = null;
        RelationField field1 = null;
        RelationField field2 = null;
        RelationField[] fieldsDescr = null;
        Element relationshipsEl = mainDocument.createElement("relationships");
        Element relationEl = null;
        String relationDescr = null;
        Element role1El = null;
        Element role2El = null;
        Element roleSourceEl = null;
        String multiplicity = null;
        Hashtable<RelationField, Object> usedRelations = new Hashtable<RelationField, Object>();
        Object shemaName = null;
        String destEjbName = null;
        String ejbName = null;
        int i = 0;
        while (i < cmpd.length) {
            fields = cmpd[i].getCmrFields();
            if (fields != null && fields.length != 0) {
                destEjbName = null;
                int j = 0;
                while (j < fields.length) {
                    field1 = fields[j];
                    int id = field1.getRelationId();
                    if (id < relDescriptors.length) {
                        RelationDescriptor relation = relDescriptors[id];
                        destEjbName = relation.getSide1().getEjbId() != i ? cmpd[relation.getSide1().getEjbId()].getEjbName() : cmpd[relation.getSide2().getEjbId()].getEjbName();
                        if (destEjbName == null) {
                            if (this.compliance) {
                                throw new BaseIllegalArgumentException("xml_ejb_4048");
                            }
                            this.errors.add("Field 'relationship-role-source' from deployment descriptor is missing.");
                        }
                        if ((descr = this.findDescriptorByName(cmpd, destEjbName)) == null) {
                            if (this.compliance) {
                                throw new BaseIllegalArgumentException("xml_ejb_4049", new String[]{destEjbName});
                            }
                            this.errors.add("Bean \"" + destEjbName + "\" coresponding to 'relationship-role-source' is missing!");
                        }
                        fieldsDescr = descr.getCmrFields();
                        field2 = null;
                        if (fieldsDescr != null) {
                            int k = 0;
                            while (k < fieldsDescr.length) {
                                if (destEjbName.equals(cmpd[i].getEjbName())) {
                                    field2 = fieldsDescr[k];
                                }
                                ++k;
                            }
                        }
                        if (field1 == null && field2 == null) {
                            if (this.compliance) {
                                throw new BaseIllegalArgumentException("xml_ejb_4017", new String[]{"multiplicity", "element", "ejb-relationship-role", "One or Many"});
                            }
                            this.errors.add("Incerrect value of element \"multiplicity\" for element \"ejb-relationship-role\". Must be one of the following: One or Many");
                        }
                        if (field1 == null) {
                            destEjbName = cmpd[i].getEjbName();
                            ejbName = descr.getEjbName();
                            field1 = field2;
                            field2 = null;
                        } else {
                            destEjbName = descr.getEjbName();
                            ejbName = cmpd[i].getEjbName();
                        }
                        if (!this.isUsedRelation(usedRelations, field1, field2) && !field1.equals(field2)) {
                            if (field2 == null) {
                                usedRelations.put(field1, obj);
                            } else {
                                usedRelations.put(field1, field2);
                            }
                            relationEl = mainDocument.createElement("ejb-relation");
                            relationDescr = relation.getRelationDescription();
                            if (relationDescr != null && !relationDescr.equals("")) {
                                this.load(relationEl, relationDescr, "description");
                            }
                            if (relation.getRelationName() != null && !relation.getRelationName().equals("")) {
                                this.load(relationEl, relation.getRelationName(), "ejb-relation-name");
                            }
                            role1El = mainDocument.createElement("ejb-relationship-role");
                            this.loadRelationField(mainDocument, role1El, relation.getSide1(), field1, ejbName);
                            relationEl.appendChild(role1El);
                            role2El = mainDocument.createElement("ejb-relationship-role");
                            if (field2 != null) {
                                this.loadRelationField(mainDocument, role2El, relation.getSide2(), field2, destEjbName);
                            } else {
                                if (relation.getSide2().getRoleDescription() != null && !relation.getSide2().getRoleDescription().trim().equals("")) {
                                    this.load(role2El, relation.getSide2().getRoleDescription(), "description");
                                }
                                if (relation.getSide2().getRoleName() != null && !relation.getSide2().getRoleName().trim().equals("")) {
                                    this.load(role2El, relation.getSide2().getRoleName(), "ejb-relationship-role-name");
                                }
                                if (relation.getSide1().getMultiplicityType() == 4 || relation.getSide1().getMultiplicityType() == 2) {
                                    multiplicity = "Many";
                                } else if (relation.getSide1().getMultiplicityType() == 3 || relation.getSide1().getMultiplicityType() == 1) {
                                    multiplicity = "One";
                                }
                                this.load(role2El, multiplicity, "multiplicity");
                                roleSourceEl = mainDocument.createElement("relationship-role-source");
                                this.load(roleSourceEl, destEjbName, "ejb-name");
                                role2El.appendChild(roleSourceEl);
                            }
                            relationEl.appendChild(role2El);
                            relationshipsEl.appendChild(relationEl);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (relationshipsEl.getChildNodes().getLength() > 0) {
            ejbJarEl.appendChild(relationshipsEl);
        }
    }

    private CMPEntityDescriptor findDescriptorByName(CMPEntityDescriptor[] cmpd, String name) {
        int i = 0;
        while (i < cmpd.length) {
            if (name.equals(cmpd[i].getEjbName())) {
                return cmpd[i];
            }
            ++i;
        }
        return null;
    }

    private boolean isUsedRelation(Hashtable h, RelationField f1, RelationField f2) {
        Object f22 = null;
        boolean isObj = false;
        if (f2 == null) {
            isObj = true;
            f22 = obj;
        } else {
            f22 = f2;
        }
        Object key = null;
        Object value = null;
        Enumeration enumeration = h.keys();
        while (enumeration.hasMoreElements()) {
            key = enumeration.nextElement();
            value = h.get(key);
            if (!(isObj ? f1.equals(key) && f22.equals(value) || f1.equals(value) && f22.equals(key) : f1.equals(key) && ((RelationField)f22).equals(value) || f1.equals(value) && ((RelationField)f22).equals(key))) continue;
            return true;
        }
        return false;
    }

    private void loadRelationField(Document mainDocument, Element role1El, OneSideRelationDescriptor side, RelationField field, String ejbName) {
        if (side.getRoleDescription() != null && !side.getRoleDescription().trim().equals("")) {
            this.load(role1El, side.getRoleDescription(), "description");
        }
        if (side.getRoleName() != null && !side.getRoleName().trim().equals("")) {
            this.load(role1El, side.getRoleName(), "ejb-relationship-role-name");
        }
        String multiplicity = null;
        if (side.getMultiplicityType() == 4 || side.getMultiplicityType() == 3) {
            multiplicity = "Many";
        } else if (side.getMultiplicityType() == 2 || side.getMultiplicityType() == 1) {
            multiplicity = "One";
        } else {
            if (this.compliance) {
                throw new BaseIllegalArgumentException("xml_ejb_4017", new String[]{"multiplicity", "element", "ejb-relationship-role", "One or Many"});
            }
            this.errors.add("Incerrect value of element \"multiplicity\" for element \"ejb-relationship-role\". Must be one of the following: One or Many");
        }
        this.load(role1El, multiplicity, "multiplicity");
        if (side.isCascade()) {
            role1El.appendChild(mainDocument.createElement("cascade-delete"));
        }
        if (ejbName != null) {
            Element roleSourceEl = mainDocument.createElement("relationship-role-source");
            this.load(roleSourceEl, ejbName, "ejb-name");
            role1El.appendChild(roleSourceEl);
        } else {
            if (this.compliance) {
                throw new BaseIllegalArgumentException("xml_ejb_4049", new String[]{ejbName});
            }
            this.errors.add("Bean \"" + ejbName + "\" coresponding to 'relationship-role-source' is missing!");
        }
        if (field.getFieldName() != null) {
            Element cmrFieldEl = mainDocument.createElement("cmr-field");
            this.load(cmrFieldEl, field.getFieldName(), "cmr-field-name");
            if (field.getFieldType() != null && !field.getFieldType().trim().equals("")) {
                this.load(cmrFieldEl, field.getFieldType(), "cmr-field-type");
            }
            role1El.appendChild(cmrFieldEl);
        }
    }

    public void loadMessageDrivenDescr(Document mainDocument, Element ejbJarEl, MessageDrivenDescriptor mdd) {
        ResourceEnvReference[] resEnvRefs;
        ResourceReference[] resRefs;
        SecurityIdentity secIdentity;
        Hashtable secRoleRefs;
        EJBeanLocalReference[] localRefs;
        EJBeanReference[] ejbRefs;
        EnvironmentEntry[] envEntr;
        Element messageBean = mainDocument.createElement("message-driven");
        ejbJarEl.appendChild(messageBean);
        if (mdd.getDescription() != null && !mdd.getDescription().trim().equals("")) {
            this.load(messageBean, mdd.getDescription(), "description");
        }
        if (mdd.getDisplayName() != null && !mdd.getDisplayName().trim().equals("")) {
            this.load(messageBean, mdd.getDisplayName(), "display-name");
        }
        if (mdd.getSmallIcon() != null && mdd.getSmallIcon().getFileName() != null && !mdd.getSmallIcon().getFileName().trim().equals("")) {
            this.load(messageBean, mdd.getSmallIcon().getFileName(), "small-icon");
        }
        if (mdd.getLargeIcon() != null && mdd.getLargeIcon().getFileName() != null && !mdd.getLargeIcon().getFileName().trim().equals("")) {
            this.load(messageBean, mdd.getLargeIcon().getFileName(), "large-icon");
        }
        if (mdd.getEjbName() != null && !mdd.getEjbName().trim().equals("")) {
            this.load(messageBean, mdd.getEjbName(), "ejb-name");
        } else {
            if (this.compliance) {
                throw new BaseIllegalArgumentException("xml_ejb_4048");
            }
            this.errors.add("Field 'relationship-role-source' from deployment descriptor is missing.");
        }
        if (mdd.getClassName() != null && !mdd.getClassName().trim().equals("")) {
            this.load(messageBean, mdd.getClassName(), "ejb-class");
        } else {
            if (this.compliance) {
                throw new BaseIllegalArgumentException("xml_ejb_4050", new String[]{mdd.getEjbName()});
            }
            this.errors.add("Bean Class for bean \"" + mdd.getEjbName() + "\" is missing in deployment descriptor.");
        }
        String type = mdd.getTransactionType() == 1 ? "Container" : "Bean";
        this.load(messageBean, type, "transaction-type");
        if (mdd.getMessageSelector() != null && !mdd.getMessageSelector().trim().equals("")) {
            this.load(messageBean, mdd.getMessageSelector(), "message-selector");
        }
        if (mdd.getAcknowledgeMode() != null && !mdd.getAcknowledgeMode().trim().equals("")) {
            this.load(messageBean, mdd.getAcknowledgeMode(), "acknowledge-mode");
        }
        Element messageDrivenDestination = null;
        if (mdd.getDestinationType() != null && !mdd.getDestinationType().trim().equals("")) {
            messageDrivenDestination = mainDocument.createElement("message-driven-destination");
            this.load(messageDrivenDestination, mdd.getDestinationType(), "destination-type");
        }
        if (mdd.getSubscriptionDurability() != null && !mdd.getSubscriptionDurability().trim().equals("")) {
            if (messageDrivenDestination == null) {
                messageDrivenDestination = mainDocument.createElement("message-driven-destination");
            }
            this.load(messageDrivenDestination, mdd.getSubscriptionDurability(), "subscription-durability");
        }
        if (messageDrivenDestination != null) {
            messageBean.appendChild(messageDrivenDestination);
        }
        if ((envEntr = mdd.getEnvironmentEntries()) != null && envEntr.length > 0) {
            this.loadEnvEntr(mainDocument, messageBean, envEntr);
        }
        if ((ejbRefs = mdd.getEJBeanReferences()) != null && ejbRefs.length > 0) {
            this.loadEjbRefs(mainDocument, messageBean, ejbRefs);
        }
        if ((localRefs = mdd.getEJBeanLocalReferences()) != null) {
            this.loadEjbLocalRefs(mainDocument, messageBean, localRefs);
        }
        if ((secRoleRefs = mdd.getRoleReferences()) != null) {
            SecurityRoleReference[] refs = secRoleRefs.values().toArray(new SecurityRoleReference[0]);
            this.loadSecurityRoleRefs(mainDocument, messageBean, refs);
        }
        if ((secIdentity = mdd.getSecurityIdentity()) != null) {
            messageBean.appendChild(this.loadSecIdentity(messageBean, secIdentity));
        }
        if ((resRefs = mdd.getResourceReferences()) != null) {
            this.loadResourceRefs(mainDocument, messageBean, resRefs);
        }
        if ((resEnvRefs = mdd.getResourceEnvReferences()) != null) {
            this.loadResourceEnvRefs(mainDocument, messageBean, resEnvRefs);
        }
        ejbJarEl.appendChild(messageBean);
    }

    public void loadEntityDescriptor(Document mainDocument, Element ejbJarEl, EntityDescriptor ed) {
        FinderDescriptor[] ejbFindSelectDescr;
        ResourceEnvReference[] resEnvRefs;
        ResourceReference[] resRefs;
        SecurityIdentity secIdentity;
        Hashtable secRoleRefs;
        EJBeanLocalReference[] localRefs;
        EJBeanReference[] ejbRefs;
        EnvironmentEntry[] envEntr;
        int cmpVersion;
        boolean isCMP;
        Element entityBean;
        block50: {
            String pk;
            block55: {
                int i;
                Object description;
                Object fieldName;
                PersistentField[] pField;
                Element cmpFieldEl;
                Vector<String> checkCMPField;
                block51: {
                    entityBean = mainDocument.createElement("entity");
                    ejbJarEl.appendChild(entityBean);
                    if (ed.getDescription() != null && !ed.getDescription().trim().equals("")) {
                        this.load(entityBean, ed.getDescription(), "description");
                    }
                    if (ed.getDisplayName() != null && !ed.getDisplayName().trim().equals("")) {
                        this.load(entityBean, ed.getDisplayName(), "display-name");
                    }
                    if (ed.getSmallIcon() != null && ed.getSmallIcon().getFileName() != null && !ed.getSmallIcon().getFileName().trim().equals("")) {
                        this.load(entityBean, ed.getSmallIcon().getFileName(), "small-icon");
                    }
                    if (ed.getLargeIcon() != null && ed.getLargeIcon().getFileName() != null && !ed.getLargeIcon().getFileName().trim().equals("")) {
                        this.load(entityBean, ed.getLargeIcon().getFileName(), "large-icon");
                    }
                    if (ed.getEjbName() != null && !ed.getEjbName().trim().equals("")) {
                        this.load(entityBean, ed.getEjbName(), "ejb-name");
                    } else {
                        if (this.compliance) {
                            throw new BaseIllegalArgumentException("xml_ejb_4048");
                        }
                        this.errors.add("Field 'relationship-role-source' from deployment descriptor is missing.");
                    }
                    boolean hasAnyHome = false;
                    boolean hasAnyComponentInt = false;
                    if (ed.getRemoteHomeInterface() != null && !ed.getRemoteHomeInterface().trim().equals("")) {
                        hasAnyHome = true;
                        this.load(entityBean, ed.getRemoteHomeInterface(), "home");
                    }
                    if (ed.getRemoteInterface() != null && !ed.getRemoteInterface().trim().equals("")) {
                        hasAnyComponentInt = true;
                        this.load(entityBean, ed.getRemoteInterface(), "remote");
                    }
                    if (ed.getLocalHomeInterface() != null && !ed.getLocalHomeInterface().trim().equals("")) {
                        hasAnyHome = true;
                        this.load(entityBean, ed.getLocalHomeInterface(), "local-home");
                    }
                    if (ed.getLocalInterface() != null && !ed.getLocalInterface().trim().equals("")) {
                        hasAnyComponentInt = true;
                        this.load(entityBean, ed.getLocalInterface(), "local");
                    }
                    if (!hasAnyComponentInt || !hasAnyHome) {
                        if (this.compliance) {
                            throw new BaseIllegalArgumentException("xml_ejb_4051", new String[]{ed.getEjbName()});
                        }
                        this.errors.add(" Component or Home interface for bean \"" + ed.getEjbName() + "\"are missing.");
                    }
                    if (ed.getClassName() != null && !ed.getClassName().trim().equals("")) {
                        this.load(entityBean, ed.getClassName(), "ejb-class");
                    } else {
                        if (this.compliance) {
                            throw new BaseIllegalArgumentException("xml_ejb_4050", new String[]{ed.getEjbName()});
                        }
                        this.errors.add("Bean Class for bean \"" + ed.getEjbName() + "\" is missing in deployment descriptor.");
                    }
                    String persistence = ed.getPersistenceType() == 1 ? "Container" : "Bean";
                    this.load(entityBean, persistence, "persistence-type");
                    if (ed.getPrimaryKeyClass() != null && !ed.getPrimaryKeyClass().trim().equals("")) {
                        this.load(entityBean, ed.getPrimaryKeyClass(), "prim-key-class");
                    } else {
                        if (this.compliance) {
                            throw new BaseIllegalArgumentException("xml_ejb_4052", new String[]{ed.getEjbName()});
                        }
                        this.errors.add("Primary key class for bean \"" + ed.getEjbName() + "\" is missing.");
                    }
                    String reentrant = ed.isReentrant() ? "True" : "False";
                    this.load(entityBean, reentrant, "reentrant");
                    isCMP = false;
                    cmpVersion = 0;
                    if (!(ed instanceof CMPEntityDescriptor)) break block50;
                    checkCMPField = new Vector<String>();
                    isCMP = true;
                    cmpVersion = ((CMPEntityDescriptor)ed).getCmpVersion();
                    if (cmpVersion == 1) {
                        this.load(entityBean, "1.x", "cmp-version");
                    } else {
                        this.load(entityBean, "2.x", "cmp-version");
                        String abstractSchemaName = ((CMPEntityDescriptor)ed).getAbstractSchemaName();
                        if (abstractSchemaName != null && !abstractSchemaName.trim().equals("")) {
                            this.load(entityBean, abstractSchemaName, "abstract-schema-name");
                        }
                    }
                    cmpFieldEl = null;
                    cmpFieldEl = mainDocument.createElement("cmp-field");
                    pk = ((CMPEntityDescriptor)ed).getPKFieldName();
                    if (pk != null && !pk.trim().equals("")) {
                        checkCMPField.add(pk.trim());
                        this.load(cmpFieldEl, pk, "field-name");
                        entityBean.appendChild(cmpFieldEl);
                    }
                    if ((pField = ((CMPEntityDescriptor)ed).getCmpFields()) == null || pField.length <= 0) break block51;
                    fieldName = null;
                    description = null;
                    i = 0;
                    while (i < pField.length) {
                        block53: {
                            block54: {
                                block52: {
                                    cmpFieldEl = mainDocument.createElement("cmp-field");
                                    if (pField[i].getDescription() != null && !pField[i].getDescription().trim().equals("")) {
                                        this.load(cmpFieldEl, pField[i].getDescription(), "description");
                                    }
                                    if (pField[i].getFieldName() == null || pField[i].getFieldName().trim().equals("")) break block52;
                                    if (checkCMPField.contains(pField[i].getFieldName())) break block53;
                                    checkCMPField.add(pField[i].getFieldName().trim());
                                    this.load(cmpFieldEl, pField[i].getFieldName(), "field-name");
                                    break block54;
                                }
                                if (this.compliance) {
                                    throw new BaseIllegalArgumentException("xml_ejb_4053", new String[]{ed.getEjbName()});
                                }
                                this.errors.add("Bean \"" + ed.getEjbName() + "\" : Missing name for cmp field.");
                            }
                            entityBean.appendChild(cmpFieldEl);
                        }
                        ++i;
                    }
                }
                pField = ((CMPEntityDescriptor)ed).getPKCmpFields();
                if (((CMPEntityDescriptor)ed).isUnknownPK() || pField == null || pField.length <= 0) break block55;
                fieldName = null;
                description = null;
                i = 0;
                while (i < pField.length) {
                    block57: {
                        block58: {
                            block56: {
                                cmpFieldEl = mainDocument.createElement("cmp-field");
                                if (pField[i].getDescription() != null && !pField[i].getDescription().trim().equals("")) {
                                    this.load(cmpFieldEl, pField[i].getDescription(), "description");
                                }
                                if (pField[i].getFieldName() == null || pField[i].getFieldName().trim().equals("")) break block56;
                                if (checkCMPField.contains(pField[i].getFieldName())) break block57;
                                checkCMPField.add(pField[i].getFieldName().trim());
                                this.load(cmpFieldEl, pField[i].getFieldName(), "field-name");
                                break block58;
                            }
                            if (this.compliance) {
                                throw new BaseIllegalArgumentException("xml_ejb_4053", new String[]{ed.getEjbName()});
                            }
                            this.errors.add("Bean \"" + ed.getEjbName() + "\" : Missing name for cmp field.");
                        }
                        entityBean.appendChild(cmpFieldEl);
                    }
                    ++i;
                }
            }
            if (pk != null && !pk.trim().equals("")) {
                this.load(entityBean, pk, "primkey-field");
            }
        }
        if ((envEntr = ed.getEnvironmentEntries()) != null && envEntr.length > 0) {
            this.loadEnvEntr(mainDocument, entityBean, envEntr);
        }
        if ((ejbRefs = ed.getEJBeanReferences()) != null && ejbRefs.length > 0) {
            this.loadEjbRefs(mainDocument, entityBean, ejbRefs);
        }
        if ((localRefs = ed.getEJBeanLocalReferences()) != null) {
            this.loadEjbLocalRefs(mainDocument, entityBean, localRefs);
        }
        if ((secRoleRefs = ed.getRoleReferences()) != null) {
            SecurityRoleReference[] refs = secRoleRefs.values().toArray(new SecurityRoleReference[0]);
            this.loadSecurityRoleRefs(mainDocument, entityBean, refs);
        }
        if ((secIdentity = ed.getSecurityIdentity()) != null) {
            entityBean.appendChild(this.loadSecIdentity(entityBean, secIdentity));
        }
        if ((resRefs = ed.getResourceReferences()) != null) {
            this.loadResourceRefs(mainDocument, entityBean, resRefs);
        }
        if ((resEnvRefs = ed.getResourceEnvReferences()) != null) {
            this.loadResourceEnvRefs(mainDocument, entityBean, resEnvRefs);
        }
        if (isCMP && (ejbFindSelectDescr = ((CMPEntityDescriptor)ed).getFinderDescriptors()) != null && ejbFindSelectDescr.length > 0 && cmpVersion == 2) {
            Element ejbFindEl = null;
            Element queryMethodEl = null;
            Element paramsEl = null;
            int i = 0;
            while (i < ejbFindSelectDescr.length) {
                ejbFindEl = mainDocument.createElement("query");
                if (ejbFindSelectDescr[i].getDescription() != null && !ejbFindSelectDescr[i].getDescription().trim().equals("")) {
                    this.load(ejbFindEl, ejbFindSelectDescr[i].getDescription(), "description");
                }
                if (ejbFindSelectDescr[i].getMethodName() != null && !ejbFindSelectDescr[i].getMethodName().trim().equals("")) {
                    queryMethodEl = mainDocument.createElement("query-method");
                    this.load(queryMethodEl, ejbFindSelectDescr[i].getMethodName(), "method-name");
                    String[] params = ejbFindSelectDescr[i].getParamsTypes();
                    paramsEl = mainDocument.createElement("method-params");
                    if (params != null) {
                        int j = 0;
                        while (j < params.length) {
                            this.load(paramsEl, this.convertClassName(params[j]), "method-param");
                            ++j;
                        }
                    }
                    queryMethodEl.appendChild(paramsEl);
                    ejbFindEl.appendChild(queryMethodEl);
                } else {
                    if (this.compliance) {
                        throw new BaseIllegalArgumentException("xml_ejb_4054", new String[]{ed.getEjbName()});
                    }
                    this.errors.add("Bean \"" + ed.getEjbName() + "\" : Query element contains no methods.");
                }
                if (ejbFindSelectDescr[i].isLocal()) {
                    this.load(ejbFindEl, "Local", "result-type-mapping");
                } else {
                    this.load(ejbFindEl, "Remote", "result-type-mapping");
                }
                if (ejbFindSelectDescr[i].getQuery() != null && !ejbFindSelectDescr[i].getQuery().trim().equals("")) {
                    this.load(ejbFindEl, ejbFindSelectDescr[i].getQuery(), "ejb-ql");
                } else {
                    if (this.compliance) {
                        throw new BaseIllegalArgumentException("xml_ejb_4055", new String[]{ed.getEjbName()});
                    }
                    this.errors.add("Bean \"" + ed.getEjbName() + "\" : Query element contains no ejb-ql statement.");
                }
                entityBean.appendChild(ejbFindEl);
                ++i;
            }
        }
        ejbJarEl.appendChild(entityBean);
    }

    public void loadSessionDescriptor(Document mainDocument, Element ejbJarEl, SessionDescriptor sd) {
        ResourceEnvReference[] resEnvRefs;
        ResourceReference[] resRefs;
        SecurityIdentity secIdentity;
        Hashtable secRoleRefs;
        EJBeanLocalReference[] localRefs;
        EJBeanReference[] ejbRefs;
        Element sessionBean = mainDocument.createElement("session");
        ejbJarEl.appendChild(sessionBean);
        if (sd.getDescription() != null && !sd.getDescription().trim().equals("")) {
            this.load(sessionBean, sd.getDescription(), "description");
        }
        if (sd.getDisplayName() != null && !sd.getDisplayName().trim().equals("")) {
            this.load(sessionBean, sd.getDisplayName(), "display-name");
        }
        if (sd.getSmallIcon() != null && sd.getSmallIcon().getFileName() != null && !sd.getSmallIcon().getFileName().trim().equals("")) {
            this.load(sessionBean, sd.getSmallIcon().getFileName(), "small-icon");
        }
        if (sd.getLargeIcon() != null && sd.getLargeIcon().getFileName() != null && !sd.getLargeIcon().getFileName().trim().equals("")) {
            this.load(sessionBean, sd.getLargeIcon().getFileName(), "large-icon");
        }
        if (sd.getEjbName() != null && !sd.getEjbName().trim().equals("")) {
            this.load(sessionBean, sd.getEjbName(), "ejb-name");
        } else {
            if (this.compliance) {
                throw new BaseIllegalArgumentException("xml_ejb_4056");
            }
            this.errors.add(" Field ejb-name is missing in ejb descriptor.");
        }
        boolean hasAnyHome = false;
        boolean hasAnyComponentInt = false;
        if (sd.getRemoteHomeInterface() != null && !sd.getRemoteHomeInterface().trim().equals("")) {
            hasAnyHome = true;
            this.load(sessionBean, sd.getRemoteHomeInterface(), "home");
        }
        if (sd.getRemoteInterface() != null && !sd.getRemoteInterface().trim().equals("")) {
            hasAnyComponentInt = true;
            this.load(sessionBean, sd.getRemoteInterface(), "remote");
        }
        if (sd.getLocalHomeInterface() != null && !sd.getLocalHomeInterface().trim().equals("")) {
            hasAnyHome = true;
            this.load(sessionBean, sd.getLocalHomeInterface(), "local-home");
        }
        if (sd.getLocalInterface() != null && !sd.getLocalInterface().trim().equals("")) {
            hasAnyComponentInt = true;
            this.load(sessionBean, sd.getLocalInterface(), "local");
        }
        if (!hasAnyComponentInt || !hasAnyHome) {
            if (this.compliance) {
                throw new BaseIllegalArgumentException("xml_ejb_4051", new String[]{sd.getEjbName()});
            }
            this.errors.add(" Component or Home interface for bean \"" + sd.getEjbName() + "\"are missing.");
        }
        if (sd.getClassName() != null && !sd.getClassName().trim().equals("")) {
            this.load(sessionBean, sd.getClassName(), "ejb-class");
        } else {
            if (this.compliance) {
                throw new BaseIllegalArgumentException("xml_ejb_4051", new String[]{sd.getEjbName()});
            }
            this.errors.add(" Component or Home interface for bean \"" + sd.getEjbName() + "\"are missing.");
        }
        String type = null;
        type = sd.getSessionType() == 1 ? "Stateful" : "Stateless";
        this.load(sessionBean, type, "session-type");
        type = sd.getTransactionType() == 1 ? "Container" : "Bean";
        this.load(sessionBean, type, "transaction-type");
        EnvironmentEntry[] envEntr = sd.getEnvironmentEntries();
        if (envEntr != null && envEntr.length > 0) {
            this.loadEnvEntr(mainDocument, sessionBean, envEntr);
        }
        if ((ejbRefs = sd.getEJBeanReferences()) != null && ejbRefs.length > 0) {
            this.loadEjbRefs(mainDocument, sessionBean, ejbRefs);
        }
        if ((localRefs = sd.getEJBeanLocalReferences()) != null) {
            this.loadEjbLocalRefs(mainDocument, sessionBean, localRefs);
        }
        if ((secRoleRefs = sd.getRoleReferences()) != null) {
            SecurityRoleReference[] refs = secRoleRefs.values().toArray(new SecurityRoleReference[0]);
            this.loadSecurityRoleRefs(mainDocument, sessionBean, refs);
        }
        if ((secIdentity = sd.getSecurityIdentity()) != null) {
            sessionBean.appendChild(this.loadSecIdentity(sessionBean, secIdentity));
        }
        if ((resRefs = sd.getResourceReferences()) != null) {
            this.loadResourceRefs(mainDocument, sessionBean, resRefs);
        }
        if ((resEnvRefs = sd.getResourceEnvReferences()) != null) {
            this.loadResourceEnvRefs(mainDocument, sessionBean, resEnvRefs);
        }
        ejbJarEl.appendChild(sessionBean);
    }

    private Element loadSecIdentity(Element parent, SecurityIdentity secIdentity) throws IllegalArgumentException {
        Element secIdentityEl = this.mainDocument.createElement("security-identity");
        if (secIdentity.getDescription() != null) {
            this.load(secIdentityEl, secIdentity.getDescription(), "description");
        }
        if (secIdentity.isCallerIdentity()) {
            secIdentityEl.appendChild(this.mainDocument.createElement("use-caller-identity"));
        } else {
            Element runAsEl = this.mainDocument.createElement("run-as");
            if (secIdentity.getRunAsIdentity().getDescription() != null && !secIdentity.getRunAsIdentity().getDescription().trim().equals("")) {
                this.load(runAsEl, secIdentity.getRunAsIdentity().getDescription(), "description");
            }
            if (secIdentity.getRunAsIdentity().getSecurityRoleName() != null && !secIdentity.getRunAsIdentity().getSecurityRoleName().trim().equals("")) {
                this.load(runAsEl, secIdentity.getRunAsIdentity().getSecurityRoleName(), "role-name");
            } else {
                if (this.compliance) {
                    throw new BaseIllegalArgumentException("xml_ejb_4057");
                }
                this.errors.add("Run as identity role name is missing.");
            }
            secIdentityEl.appendChild(runAsEl);
        }
        return secIdentityEl;
    }

    private Element load(Element el, String value, String tagName) {
        if (value == null) {
            value = new String("");
        }
        Element nextElement = this.mainDocument.createElement(tagName);
        Text textNode = this.mainDocument.createTextNode(value);
        nextElement.appendChild(textNode);
        el.appendChild(nextElement);
        return nextElement;
    }

    private String[] concatArrays(String[] arr1, String[] arr2) {
        if (arr1 == null) {
            return arr2;
        }
        if (arr2 == null) {
            return arr1;
        }
        Vector<String> resultV = new Vector<String>();
        int i = 0;
        while (i < arr1.length) {
            resultV.add(arr1[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < arr2.length) {
            if (!resultV.contains(arr2[i2])) {
                resultV.add(arr2[i2]);
            }
            ++i2;
        }
        if (resultV.size() > 0) {
            Object[] res = new String[resultV.size()];
            resultV.copyInto(res);
            return res;
        }
        return null;
    }

    private String convertClassName(String className) {
        if (className.charAt(0) != '[') {
            return className;
        }
        int first = className.indexOf(91);
        int last = className.lastIndexOf(91);
        char ch = className.charAt(last + 1);
        String st = "";
        int i = 0;
        while (i <= last - first) {
            st = st + "[]";
            ++i;
        }
        switch (ch) {
            case 'B': {
                return "byte" + st;
            }
            case 'C': {
                return "char" + st;
            }
            case 'D': {
                return "double" + st;
            }
            case 'F': {
                return "float" + st;
            }
            case 'I': {
                return "int" + st;
            }
            case 'J': {
                return "long" + st;
            }
            case 'S': {
                return "short" + st;
            }
            case 'Z': {
                return "boolean" + st;
            }
            case 'L': {
                return className.substring(last + 2, className.length() - 1) + st;
            }
        }
        return "";
    }

    public Vector getErrors() {
        return this.errors;
    }

    public String getIllegalArgumentException() {
        this.clear();
        return this.illegalArgumentException == null ? null : this.illegalArgumentException + ".";
    }

    public void loadEnvEntr(Document mainDocument, Element parent, EnvironmentEntry[] envEntr) {
        if (envEntr == null || envEntr.length == 0) {
            return;
        }
        Element envEntryEl = null;
        int i = 0;
        while (i < envEntr.length) {
            if (envEntr[i] != null) {
                if (envEntr[i].getEntryName() == null || envEntr[i].getEntryName().trim().equals("")) {
                    this.illegalArgumentException = this.updateIllegalArgumentException("ID_016 Obligatory field  env-entry-name is missing.", envEntr[i].getEntryName());
                } else if (envEntr[i].getEntryType() == null || !this.checkEntryType(envEntr[i].getEntryType())) {
                    this.illegalArgumentException = this.updateIllegalArgumentException("ID_017 Wrong falue for env-entry-type. Type: \"{0}\"", envEntr[i].getEntryType());
                } else {
                    envEntryEl = mainDocument.createElement("env-entry");
                    if (envEntr[i].getEntryDescription() != null && !envEntr[i].getEntryDescription().trim().equals("")) {
                        this.load(mainDocument, envEntryEl, envEntr[i].getEntryDescription(), "description");
                    }
                    this.load(mainDocument, envEntryEl, envEntr[i].getEntryName(), "env-entry-name");
                    this.load(mainDocument, envEntryEl, envEntr[i].getEntryType(), "env-entry-type");
                    if (envEntr[i].getEntryValue() != null && !envEntr[i].getEntryValue().toString().trim().equals("")) {
                        this.load(mainDocument, envEntryEl, envEntr[i].getEntryValue().toString(), "env-entry-value");
                    }
                    parent.appendChild(envEntryEl);
                }
            }
            ++i;
        }
    }

    private boolean checkEntryType(String type) {
        if (type.equals("java.lang.Double")) {
            return true;
        }
        if (type.equals("java.lang.Integer")) {
            return true;
        }
        if (type.equals("java.lang.Boolean")) {
            return true;
        }
        if (type.equals("java.lang.Float")) {
            return true;
        }
        if (type.equals("java.lang.String")) {
            return true;
        }
        if (type.equals("java.lang.Character")) {
            return true;
        }
        if (type.equals("java.lang.Byte")) {
            return true;
        }
        if (type.equals("java.lang.Short")) {
            return true;
        }
        return type.equals("java.lang.Long");
    }

    public void loadEjbRefs(Document mainDocument, Element parent, EJBeanReference[] ejbRefs) {
        if (ejbRefs == null || ejbRefs.length == 0) {
            return;
        }
        int i = 0;
        while (i < ejbRefs.length) {
            if (ejbRefs[i] != null) {
                if (ejbRefs[i].getReferenceName() == null || ejbRefs[i].getReferenceName().trim().equals("")) {
                    this.illegalArgumentException = this.updateIllegalArgumentException("ID_018 Ejb-ref-name for ejb-ref is missing.", ejbRefs[i].getReferenceName());
                } else if (ejbRefs[i].getHomeInterfaceName() == null || ejbRefs[i].getHomeInterfaceName().trim().equals("")) {
                    this.illegalArgumentException = this.updateIllegalArgumentException("ID_019 Home iterface for ejb references is missing.", ejbRefs[i].getHomeInterfaceName());
                } else if (ejbRefs[i].getRemoteInterfaceName() == null || ejbRefs[i].getRemoteInterfaceName().trim().equals("")) {
                    this.illegalArgumentException = this.updateIllegalArgumentException("ID_020 Remote iterface for ejb references is missing.", ejbRefs[i].getRemoteInterfaceName());
                } else {
                    Element ejbRefsEl = mainDocument.createElement("ejb-ref");
                    if (ejbRefs[i].getReferenceDescription() != null && !ejbRefs[i].getReferenceDescription().trim().equals("")) {
                        this.load(mainDocument, ejbRefsEl, ejbRefs[i].getReferenceDescription(), "description");
                    }
                    this.load(mainDocument, ejbRefsEl, ejbRefs[i].getReferenceName(), "ejb-ref-name");
                    String type = ejbRefs[i].getType() == 1 ? "Entity" : "Session";
                    this.load(mainDocument, ejbRefsEl, type, "ejb-ref-type");
                    this.load(mainDocument, ejbRefsEl, ejbRefs[i].getHomeInterfaceName(), "home");
                    this.load(mainDocument, ejbRefsEl, ejbRefs[i].getRemoteInterfaceName(), "remote");
                    if (ejbRefs[i].getReferenceEjbLink() != null && !ejbRefs[i].getReferenceEjbLink().trim().equals("")) {
                        this.load(mainDocument, ejbRefsEl, ejbRefs[i].getReferenceEjbLink(), "ejb-link");
                    }
                    parent.appendChild(ejbRefsEl);
                }
            }
            ++i;
        }
    }

    public void loadEjbLocalRefs(Document mainDocument, Element parent, EJBeanLocalReference[] ejbLocalRefs) {
        if (ejbLocalRefs == null) {
            return;
        }
        int i = 0;
        while (i < ejbLocalRefs.length) {
            if (ejbLocalRefs[i] != null) {
                if (ejbLocalRefs[i].getReferenceName() == null || ejbLocalRefs[i].getReferenceName().trim().equals("")) {
                    this.illegalArgumentException = this.updateIllegalArgumentException("ID_021 Ejb-ref-name for ejb local references is missing.", ejbLocalRefs[i].getReferenceName());
                } else if (ejbLocalRefs[i].getLocalHomeInterfaceName() == null || ejbLocalRefs[i].getLocalHomeInterfaceName().trim().equals("")) {
                    this.illegalArgumentException = this.updateIllegalArgumentException("ID_022 Home iterface for ejb local references is missing.", ejbLocalRefs[i].getLocalHomeInterfaceName());
                } else if (ejbLocalRefs[i].getLocalInterfaceName() == null || ejbLocalRefs[i].getLocalInterfaceName().trim().equals("")) {
                    this.illegalArgumentException = this.updateIllegalArgumentException("ID_023 Local iterface for ejb local references is missing.", ejbLocalRefs[i].getLocalInterfaceName());
                } else {
                    Element localRefsEl = mainDocument.createElement("ejb-local-ref");
                    if (ejbLocalRefs[i].getReferenceDescription() != null && !ejbLocalRefs[i].getReferenceDescription().trim().equals("")) {
                        this.load(mainDocument, localRefsEl, ejbLocalRefs[i].getReferenceDescription(), "description");
                    }
                    this.load(mainDocument, localRefsEl, ejbLocalRefs[i].getReferenceName(), "ejb-ref-name");
                    String type = ejbLocalRefs[i].getType() == 1 ? "Entity" : "Session";
                    this.load(mainDocument, localRefsEl, type, "ejb-ref-type");
                    this.load(mainDocument, localRefsEl, ejbLocalRefs[i].getLocalHomeInterfaceName(), "local-home");
                    this.load(mainDocument, localRefsEl, ejbLocalRefs[i].getLocalInterfaceName(), "local");
                    if (ejbLocalRefs[i].getReferenceEjbLink() != null && !ejbLocalRefs[i].getReferenceEjbLink().trim().equals("")) {
                        this.load(mainDocument, localRefsEl, ejbLocalRefs[i].getReferenceEjbLink(), "ejb-link");
                    }
                    parent.appendChild(localRefsEl);
                }
            }
            ++i;
        }
    }

    public void loadSecurityRoleRefs(Document mainDocument, Element parent, SecurityRoleReference[] secRoleRefs) {
        Element secRoleRefsEl = null;
        if (secRoleRefs == null || secRoleRefs.length == 0) {
            return;
        }
        int i = 0;
        while (i < secRoleRefs.length) {
            if (secRoleRefs[i] != null) {
                if (secRoleRefs[i].getRoleName() == null || secRoleRefs[i].getRoleName().trim().equals("")) {
                    this.illegalArgumentException = this.updateIllegalArgumentException("ID_024 Role name for security role references is missing.", secRoleRefs[i].getRoleName());
                } else {
                    secRoleRefsEl = mainDocument.createElement("security-role-ref");
                    if (secRoleRefs[i].getDescription() != null && !secRoleRefs[i].getDescription().trim().equals("")) {
                        this.load(mainDocument, secRoleRefsEl, secRoleRefs[i].getDescription(), "description");
                    }
                    this.load(mainDocument, secRoleRefsEl, secRoleRefs[i].getRoleName(), "role-name");
                    if (secRoleRefs[i].getRoleLink() != null && secRoleRefs[i].getRoleLink().getRoleName() != null && !secRoleRefs[i].getRoleLink().getRoleName().trim().equals("")) {
                        this.load(mainDocument, secRoleRefsEl, secRoleRefs[i].getRoleLink().getRoleName(), "role-link");
                    }
                    parent.appendChild(secRoleRefsEl);
                }
            }
            ++i;
        }
    }

    public void loadResourceEnvRefs(Document mainDocument, Element parent, ResourceEnvReference[] resEnvRefs) {
        if (resEnvRefs == null) {
            return;
        }
        int i = 0;
        while (i < resEnvRefs.length) {
            if (resEnvRefs[i] != null) {
                if (resEnvRefs[i].getName() == null || resEnvRefs[i].getName().trim().equals("")) {
                    this.illegalArgumentException = this.updateIllegalArgumentException("ID_025 Missing resource environment reference name.", resEnvRefs[i].getName());
                } else if (resEnvRefs[i].getType() == null || resEnvRefs[i].getType().trim().equals("")) {
                    this.illegalArgumentException = this.updateIllegalArgumentException("ID_026 Missing resource environment reference type.", resEnvRefs[i].getType());
                } else {
                    Element resEnvRefsEl = mainDocument.createElement("resource-env-ref");
                    if (resEnvRefs[i].getDescription() != null && !resEnvRefs[i].getDescription().trim().equals("")) {
                        this.load(mainDocument, resEnvRefsEl, resEnvRefs[i].getDescription(), "description");
                    }
                    this.load(mainDocument, resEnvRefsEl, resEnvRefs[i].getName(), "resource-env-ref-name");
                    this.load(mainDocument, resEnvRefsEl, resEnvRefs[i].getType(), "resource-env-ref-type");
                    parent.appendChild(resEnvRefsEl);
                }
            }
            ++i;
        }
    }

    public void loadResourceRefs(Document mainDocument, Element parent, ResourceReference[] resRefs) {
        if (resRefs == null) {
            return;
        }
        int i = 0;
        while (i < resRefs.length) {
            block13: {
                block15: {
                    block14: {
                        if (resRefs[i] == null) break block13;
                        if (resRefs[i].getResourceName() != null && !resRefs[i].getResourceName().trim().equals("")) break block14;
                        this.illegalArgumentException = this.updateIllegalArgumentException("ID_027 Missing resource reference name.", resRefs[i].getResourceName());
                        break block13;
                    }
                    if (resRefs[i].getResourceType() != null && !resRefs[i].getResourceType().trim().equals("")) break block15;
                    this.illegalArgumentException = this.updateIllegalArgumentException("ID_028 Missing resource reference type.", resRefs[i].getResourceType());
                    break block13;
                }
                switch (resRefs[i].getResourceAuthorization()) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        this.illegalArgumentException = this.updateIllegalArgumentException("ID_029 Wrong value for resource authorization in resource reference.\n Must be one of the falowign: ResourceReference.BEAN_AUTHORIZATION, ResourceReference.SERVLET_AUTHORIZATION,\nResourceReference.CONTAINER_AUTHORIZATION, ResourceReference.APPLICATION_AUTHORIZATION ", null);
                        break block13;
                    }
                }
                Element resRefsEl = mainDocument.createElement("resource-ref");
                if (resRefs[i].getResourceDescription() != null && !resRefs[i].getResourceDescription().trim().equals("")) {
                    this.load(mainDocument, resRefsEl, resRefs[i].getResourceDescription(), "description");
                }
                this.load(mainDocument, resRefsEl, resRefs[i].getResourceName(), "res-ref-name");
                this.load(mainDocument, resRefsEl, resRefs[i].getResourceType(), "res-type");
                boolean resourceAuthorization = false;
                String authStr = null;
                switch (resRefs[i].getResourceAuthorization()) {
                    case 1: {
                        authStr = "Application";
                        break;
                    }
                    case 2: {
                        authStr = "Container";
                        break;
                    }
                    case 3: {
                        authStr = "Application";
                    }
                }
                this.load(mainDocument, resRefsEl, authStr, "res-auth");
                String shareable = resRefs[i].getResourceSharingScope() == 0 ? "Shareable" : "Unshareable";
                this.load(mainDocument, resRefsEl, shareable, "res-sharing-scope");
                parent.appendChild(resRefsEl);
            }
            ++i;
        }
    }

    public void loadSecurityRoles(Document mainDocument, Element parent, SecurityRoles[] secRoles) {
        Element secRolesEl = null;
        if (secRoles == null || secRoles.length == 0) {
            return;
        }
        int i = 0;
        while (i < secRoles.length) {
            if (secRoles[i] != null) {
                if (secRoles[i].getRoleName() == null || secRoles[i].getRoleName().trim().equals("")) {
                    this.illegalArgumentException = this.updateIllegalArgumentException("ID_029 Wrong value for resource authorization in resource reference.\n Must be one of the falowign: ResourceReference.BEAN_AUTHORIZATION, ResourceReference.SERVLET_AUTHORIZATION,\nResourceReference.CONTAINER_AUTHORIZATION, ResourceReference.APPLICATION_AUTHORIZATION ", secRoles[i].getRoleName());
                } else {
                    secRolesEl = mainDocument.createElement("security-role");
                    if (secRoles[i].getDescription() != null && !secRoles[i].getDescription().trim().equals("")) {
                        this.load(mainDocument, secRolesEl, secRoles[i].getDescription(), "description");
                    }
                    this.load(mainDocument, secRolesEl, secRoles[i].getRoleName(), "role-name");
                    parent.appendChild(secRolesEl);
                }
            }
            ++i;
        }
    }

    private Element load(Document mainDocument, Element el, String value, String tagName) {
        if (value == null) {
            value = new String("");
        }
        Element nextElement = mainDocument.createElement(tagName);
        Text textNode = mainDocument.createTextNode(value);
        nextElement.appendChild(textNode);
        el.appendChild(nextElement);
        return nextElement;
    }

    private String updateIllegalArgumentException(String message, String error) {
        if (error == null) {
            error = "null";
        } else if (error.trim().equals("")) {
            error = "empty string";
        }
        if (message != null && message.length() != 0) {
            return this.illegalArgumentException + ";\n   " + message + ": " + error;
        }
        return this.illegalArgumentException;
    }

    public void resetErrors() {
        this.illegalArgumentException = "";
    }

    public void addError(String newError) {
        if (newError != null && newError.length() != 0) {
            this.illegalArgumentException = this.illegalArgumentException + newError;
        }
    }

    private void clear() {
        if (this.illegalArgumentException != null && this.illegalArgumentException.length() != 0) {
            if (this.illegalArgumentException.startsWith(";")) {
                this.illegalArgumentException = this.illegalArgumentException.substring(1, this.illegalArgumentException.length());
            }
        } else {
            this.illegalArgumentException = null;
        }
    }
}

