/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.dbtool;

import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.WrongStructureException;
import com.sap.engine.services.dbpool.deploy.DataSourceManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DBTool {
    private static final SimpleDateFormat logfileDateFormat = new SimpleDateFormat("yy/MM/dd HH:mm:ss");
    public String ctxFactory;
    public String serverHost;
    public String serverPort;
    public String serverUser;
    public String serverPassword;

    private void parseLoginXML(String xml) throws IOException, SAXException, WrongStructureException {
        StandardDOMParser parser = new StandardDOMParser();
        Document document = parser.parse(xml);
        Element rootElement = document.getDocumentElement();
        this.ctxFactory = this.getTextValue(rootElement, "initial-context-factory");
        this.serverHost = this.getTextValue(rootElement, "server-host");
        this.serverPort = this.getTextValue(rootElement, "server-port");
        this.serverUser = this.getTextValue(rootElement, "server-user");
        this.serverPassword = this.getTextValue(rootElement, "server-password");
        this.log("Parsed XML file '" + xml + "'.");
    }

    private String getTextValue(Element element, String tagname) throws WrongStructureException {
        NodeList list = element.getElementsByTagName(tagname);
        int j = 0;
        while (j < list.getLength()) {
            if (list.item(j).getNodeType() == 1) {
                Node node = ((Element)list.item(j)).getFirstChild();
                if (node != null) {
                    if (node.getNodeType() == 3) {
                        return node.getNodeValue();
                    }
                } else {
                    return "";
                }
            }
            ++j;
        }
        throw new WrongStructureException("Mandatory tag <" + tagname + "> not found");
    }

    private void log(String message) {
        String dateString = logfileDateFormat.format(new Date()) + " -  ";
        StringBuffer emptyStringBuffer = new StringBuffer(dateString.length());
        int i = 0;
        while (i < dateString.length()) {
            emptyStringBuffer.append(' ');
            ++i;
        }
        String emptyString = emptyStringBuffer.toString();
        StringTokenizer st = new StringTokenizer(message, "\n\r");
        if (st.hasMoreTokens()) {
            System.out.println(dateString + st.nextToken());
        }
        while (st.hasMoreTokens()) {
            System.out.println(emptyString + st.nextToken());
        }
    }

    private void log(Throwable t) {
        this.log("ERROR:\n" + t.getMessage());
        StringWriter writer = new StringWriter(2048);
        t.printStackTrace(new PrintWriter(writer));
        this.log("STACKTRACE:\n" + writer.toString());
    }

    public static void main(String[] params) throws Exception {
        DBTool dbtool = new DBTool();
        if (params.length < 2 || params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
            String msg = "\nDeploys a standalone application with DataSource(s) on J2EE Engine.\n\nUsage: com.sap.engine.deploy.dbtool.DBTool <login_xml> <datasources_xml> [db_init_xml]\nParameters:\n\t<login_xml>        - XML file with properties for login\n\t<datasources_xml>  - XML file with DataSource(s) properties\n\t[db_init_xml]      - XML file with SQL statements for DB initialization (optional)\n";
            dbtool.log(msg);
            return;
        }
        try {
            dbtool.parseLoginXML(params[0]);
            Properties props = new Properties();
            ((Hashtable)props).put("java.naming.factory.initial", dbtool.ctxFactory);
            ((Hashtable)props).put("java.naming.provider.url", dbtool.serverHost.concat(":").concat(dbtool.serverPort));
            ((Hashtable)props).put("java.naming.security.principal", dbtool.serverUser);
            ((Hashtable)props).put("java.naming.security.credentials", dbtool.serverPassword);
            InitialContext initCtx = new InitialContext(props);
            DataSourceManager dsManager = (DataSourceManager)initCtx.lookup("dbpool");
            dsManager.deploy(new SerializableFile(params[1]));
            dbtool.log("Deployed DataSource(s) from XML file '" + params[1] + "'.");
            if (params.length > 2) {
                dsManager.dbInit(new SerializableFile(params[2]));
                dbtool.log("DB initialized from XML file '" + params[2] + "'.");
            }
            dbtool.log("DBTool finished successfully.");
            dbtool.log("************************************************************\n \n ");
        }
        catch (Throwable th) {
            dbtool.log(th);
            dbtool.log("************************************************************\n \n ");
            System.exit(1);
        }
    }
}

