/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.components;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.deploy.components.J2EEArchive;
import com.sap.engine.deploy.components.J2EEComponentsGenerator;
import com.sap.engine.deploy.components.J2EEGeneratorDoc;
import com.sap.engine.deploy.components.J2EEGeneratorException;
import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.lib.lang.DynamicClassLoader;
import com.sap.engine.services.deploy.ear.common.ArchiveDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class XMLComponentsGenerator {
    private String xmlFileName;
    private J2EEArchive[] j2eeArchive = null;
    private J2EEGeneratorDoc document = null;
    private String logFileName = null;
    private Hashtable archTable = null;
    private Vector archivesMade = null;

    public XMLComponentsGenerator() {
    }

    public XMLComponentsGenerator(String xmlFile, String logFile) {
        this.xmlFileName = xmlFile;
        this.logFileName = logFile;
    }

    public void setLogFileName(String fileName) {
        this.logFileName = fileName;
    }

    public void setXMLFileName(String fileName) {
        this.xmlFileName = fileName;
    }

    public void makeArchive() throws IOException {
        this.makeArchive(true);
    }

    private void makeArchive(boolean fromWhereIsInvoked) throws IOException {
        if (this.xmlFileName == null) {
            return;
        }
        J2EEComponentsGenerator compGenerator = new J2EEComponentsGenerator();
        compGenerator.setHasLogFile(fromWhereIsInvoked);
        compGenerator.startLog(this.logFileName);
        this.document = new J2EEGeneratorDoc();
        try {
            this.document.readFromXMLFile(this.xmlFileName);
            this.j2eeArchive = this.document.getJ2EEComponentArchive();
        }
        catch (J2EEGeneratorException j2ex1) {
            compGenerator.toLog("ERROR : " + j2ex1.getMessage());
            compGenerator.toLog("STACK TRACE : \n " + compGenerator.loadStackTrace(j2ex1));
            compGenerator.stopLog();
            throw new IOException(j2ex1.getMessage());
        }
        catch (Exception ex1) {
            compGenerator.toLog("ERROR : " + ex1.getMessage());
            compGenerator.toLog("STACK TRACE : \n " + compGenerator.loadStackTrace(ex1));
            compGenerator.stopLog();
            throw new IOException(ex1.getMessage());
        }
        String archName = null;
        InfoObject[] infoArray = null;
        StringTokenizer addClasspaths = null;
        String[] paths = null;
        String descrLocation = null;
        ArrayList errors = new ArrayList();
        String[] tempErr = new String[]{};
        ArrayList<String> wrongArhives = new ArrayList<String>();
        this.archivesMade = new Vector();
        int i = 0;
        while (i < this.j2eeArchive.length) {
            ArchiveDescriptor ad;
            archName = this.j2eeArchive[i].getFileName();
            int archType = this.j2eeArchive[i].getDescriptorIntType();
            infoArray = this.j2eeArchive[i].getFileInfo();
            descrLocation = this.j2eeArchive[i].getDescriptorLocation();
            addClasspaths = new StringTokenizer(this.j2eeArchive[i].getAddClasspath(), File.pathSeparator);
            paths = new String[addClasspaths.countTokens()];
            int j = 0;
            while (j < paths.length) {
                paths[j] = addClasspaths.nextToken();
                ++j;
            }
            compGenerator.addNewArchive(archName, archType);
            compGenerator.addAdditionalFiles(archName, infoArray);
            compGenerator.addAdditionalClassPath(archName, paths);
            tempErr = null;
            if (this.archTable != null && (ad = (ArchiveDescriptor)this.archTable.get(archName)) instanceof EJBJarDescriptor && (tempErr = compGenerator.checkDescriptor(new DynamicClassLoader(this.j2eeArchive[i].getAddClasspath()), (EJBJarDescriptor)ad, this.xmlFileName)) != null && tempErr.length > 0) {
                compGenerator.toLog("ERROR: Cannot make archive " + archName + " because : \n");
                wrongArhives.add(archName);
                int i1 = 0;
                while (i1 < tempErr.length) {
                    compGenerator.toLog("           " + tempErr[i1] + ".\n");
                    ++i1;
                }
            } else {
                try {
                    compGenerator.setArchiveDescriptor(archName, descrLocation);
                    compGenerator.makeArchive(archName);
                    this.archivesMade.add(archName);
                }
                catch (J2EEGeneratorException j2ex2) {
                    compGenerator.toLog("ERROR: " + j2ex2.getMessage());
                    compGenerator.toLog("STACK TRACE : \n " + compGenerator.loadStackTrace(j2ex2));
                    wrongArhives.add(archName);
                }
                catch (IOException ioex2) {
                    compGenerator.toLog("ERROR: " + ioex2.getMessage());
                    compGenerator.toLog("STACK TRACE : \n " + compGenerator.loadStackTrace(ioex2));
                    wrongArhives.add(archName);
                }
            }
            ++i;
        }
        if (wrongArhives.size() > 0) {
            String message = "The following archives cannot be made: \n";
            int i2 = 0;
            while (i2 < wrongArhives.size()) {
                message = message + (String)wrongArhives.get(i2) + "  \n";
                ++i2;
            }
            compGenerator.stopLog();
            throw new IOException("ERROR: " + message + "See log file for details!");
        }
        compGenerator.stopLog();
    }

    private static void ebcdicConvert(String[] args) {
        String platform = SystemProperties.getProperty("platform.notASCII");
        if (platform != null && platform.equalsIgnoreCase("false")) {
            System.setErr(System.out);
            String ASCII = "ISO8859_1";
            String EBCDIC = "Cp1047";
            try {
                int i = 0;
                while (i < args.length) {
                    args[i] = new String(args[i].getBytes(ASCII), EBCDIC);
                    ++i;
                }
            }
            catch (Exception ex) {
                return;
            }
        }
    }

    public String[] getMadeArchives() {
        if (this.archivesMade == null) {
            return new String[0];
        }
        Object[] temp = new String[this.archivesMade.size()];
        this.archivesMade.copyInto(temp);
        return temp;
    }

    public void addArchiveDescr(String archName, ArchiveDescriptor descr) {
        if (this.archTable == null) {
            this.archTable = new Hashtable();
        }
        this.archTable.put(archName, descr);
    }

    public static void main(String[] args) {
        XMLComponentsGenerator.ebcdicConvert(args);
        if (args.length < 1) {
            System.out.println("Usage: java com.sap.engine.deploy.components.XMLComponentsGenerator <xmlFile> <[logFile]>!");
            return;
        }
        String xmlFile = args[0];
        String logFile = null;
        if (args.length > 1) {
            logFile = args[1];
        }
        XMLComponentsGenerator xmlGenerator = new XMLComponentsGenerator(xmlFile, logFile);
        try {
            if (logFile == null) {
                xmlGenerator.makeArchive(false);
            } else {
                xmlGenerator.makeArchive(true);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

