/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.components;

import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.services.deploy.gui.mapping.MappingObject;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class J2EEArchive {
    private InfoObject[] fileInfoObject = null;
    private MappingObject[] dirMapping;
    private String fileName = null;
    private int archDescrType;
    private String archDescrFileLocation = null;
    private String addClasspath = null;

    public void setFileInfo(String[] entryNames, String[] filePaths) {
        if (entryNames == null || filePaths == null || entryNames.length != filePaths.length) {
            this.fileInfoObject = new InfoObject[1];
            this.fileInfoObject[0] = new InfoObject("", "");
            return;
        }
        int length = entryNames.length;
        this.fileInfoObject = new InfoObject[length];
        int i = 0;
        while (i < length) {
            this.fileInfoObject[i] = new InfoObject(entryNames[i], filePaths[i]);
            ++i;
        }
    }

    public void setFilesFileInfo(Vector fileInfoVector) {
        if (fileInfoVector == null) {
            this.fileInfoObject = null;
            return;
        }
        int length = fileInfoVector.size();
        this.fileInfoObject = new InfoObject[length];
        int i = 0;
        while (i < length) {
            InfoObject fileInfo;
            this.fileInfoObject[i] = fileInfo = (InfoObject)fileInfoVector.elementAt(i);
            ++i;
        }
    }

    public void setFileInfo(Vector fileDirInfoV) {
        if (fileDirInfoV == null) {
            return;
        }
        Vector<InfoObject> fileInfoVector = new Vector<InfoObject>();
        Vector<MappingObject> dirMapVector = new Vector<MappingObject>();
        int i = 0;
        while (i < fileDirInfoV.size()) {
            if (fileDirInfoV.elementAt(i) instanceof InfoObject) {
                fileInfoVector.add((InfoObject)fileDirInfoV.elementAt(i));
            } else {
                dirMapVector.add((MappingObject)fileDirInfoV.elementAt(i));
            }
            ++i;
        }
        if (fileInfoVector.size() > 0) {
            this.setFilesFileInfo(fileInfoVector);
        }
        if (dirMapVector.size() > 0) {
            Object[] tempObj = new MappingObject[dirMapVector.size()];
            dirMapVector.copyInto(tempObj);
            this.setMappingObjects((MappingObject[])tempObj);
        }
    }

    public InfoObject[] getFilesFileInfo() {
        return this.fileInfoObject;
    }

    public InfoObject[] getDirsFileInfo() {
        return this.parseDirMapping();
    }

    public Vector getFileInfoVector() {
        int i;
        Vector<Object> infVector = new Vector<Object>();
        if (this.fileInfoObject != null) {
            i = 0;
            while (i < this.fileInfoObject.length) {
                infVector.add(this.fileInfoObject[i]);
                ++i;
            }
        }
        if (this.dirMapping != null) {
            i = 0;
            while (i < this.dirMapping.length) {
                infVector.add(this.dirMapping[i]);
                ++i;
            }
        }
        return infVector;
    }

    public InfoObject[] getFileInfo() {
        int i;
        Object[] dirAndFileInfo = null;
        InfoObject[] dirInfoObject = null;
        Vector<InfoObject> dirAndFilesVector = null;
        int fileInfoLength = 0;
        int dirInfoLength = 0;
        if (this.fileInfoObject != null) {
            fileInfoLength = this.fileInfoObject.length;
        }
        if ((dirInfoObject = this.parseDirMapping()) != null) {
            dirInfoLength = dirInfoObject.length;
        }
        if (fileInfoLength > 0) {
            dirAndFilesVector = new Vector<InfoObject>();
            i = 0;
            while (i < fileInfoLength) {
                dirAndFilesVector.add(this.fileInfoObject[i]);
                ++i;
            }
        }
        if (dirInfoLength > 0) {
            if (dirAndFilesVector == null) {
                dirAndFilesVector = new Vector();
            }
            i = 0;
            while (i < dirInfoLength) {
                dirAndFilesVector.add(dirInfoObject[i]);
                ++i;
            }
        }
        if (dirAndFilesVector != null) {
            dirAndFileInfo = new InfoObject[dirAndFilesVector.size()];
            dirAndFilesVector.copyInto(dirAndFileInfo);
        }
        if (dirAndFileInfo != null) {
            int i2 = 0;
            while (i2 < dirAndFileInfo.length) {
                if (((InfoObject)dirAndFileInfo[i2]).getEntryName() == null || ((InfoObject)dirAndFileInfo[i2]).getEntryName().trim().equals("")) {
                    String p = ((InfoObject)dirAndFileInfo[i2]).getFilePath();
                    String defaultEntry = p.substring(p.lastIndexOf(File.separator) + 1);
                    dirAndFileInfo[i2] = new InfoObject(defaultEntry, p);
                }
                ++i2;
            }
        }
        return dirAndFileInfo;
    }

    protected InfoObject[] parseDirMapping() {
        if (this.dirMapping == null) {
            return null;
        }
        Vector info = new Vector();
        String defaultEntry = "";
        String mainDir = null;
        this.sortDirMapping();
        int i = 0;
        while (i < this.dirMapping.length) {
            if (this.dirMapping[i].isIncluded()) {
                if (mainDir == null || this.dirMapping[i].getFilePath().indexOf(mainDir) == -1) {
                    mainDir = this.dirMapping[i].getFilePath();
                }
                try {
                    defaultEntry = this.dirMapping[i].getFilePath().substring(mainDir.length() + 1);
                }
                catch (IndexOutOfBoundsException ioobexc) {
                    defaultEntry = this.dirMapping[i].getFilePath().substring(mainDir.length());
                }
                defaultEntry = this.allExtEntryMapping(this.dirMapping[i], defaultEntry);
                if (defaultEntry.length() > 0 && !defaultEntry.endsWith(File.separator)) {
                    defaultEntry = defaultEntry + File.separator;
                }
                this.addDirFiles(info, this.dirMapping[i], defaultEntry);
            }
            ++i;
        }
        Object[] infoArray = new InfoObject[info.size()];
        info.copyInto(infoArray);
        return infoArray;
    }

    private String allExtEntryMapping(MappingObject mapObj, String defaultEntry) {
        Properties propMap = mapObj.getMappings();
        if (propMap == null) {
            return "";
        }
        Enumeration keyEnum = ((Hashtable)propMap).keys();
        StringTokenizer tokenizer = null;
        while (keyEnum.hasMoreElements()) {
            String el = (String)keyEnum.nextElement();
            tokenizer = new StringTokenizer(el, ";");
            while (tokenizer.hasMoreTokens()) {
                String ext = tokenizer.nextToken();
                if (!ext.trim().equals(".*")) continue;
                return propMap.getProperty(el);
            }
        }
        return defaultEntry;
    }

    protected void addDirFiles(Vector info, MappingObject mapObj, String defaultEntry) {
        Properties propMap = mapObj.getMappings();
        Enumeration keyEnum = null;
        String path = null;
        Vector excludedExt = mapObj.getExcludedFilters();
        Vector<String> extV = new Vector<String>();
        Vector<String> entrV = new Vector<String>();
        Object[] ext = null;
        Object[] entries = null;
        StringTokenizer tokenizer = null;
        if (propMap != null) {
            boolean index = false;
            keyEnum = ((Hashtable)propMap).keys();
            while (keyEnum.hasMoreElements()) {
                String el = (String)keyEnum.nextElement();
                tokenizer = new StringTokenizer(el, ";");
                while (tokenizer.hasMoreTokens()) {
                    entrV.add(propMap.getProperty(el));
                    extV.add(tokenizer.nextToken());
                }
            }
        }
        if (extV.size() > 0) {
            ext = new String[extV.size()];
            entries = new String[entrV.size()];
            extV.copyInto(ext);
            entrV.copyInto(entries);
        } else {
            ext = new String[]{};
        }
        path = mapObj.getFilePath();
        File dir = new File(path);
        if (!dir.exists()) {
            return;
        }
        String[] dirList = dir.list();
        int i = 0;
        while (i < dirList.length) {
            File file = new File(dir.getAbsolutePath(), dirList[i]);
            String absPath = file.getAbsolutePath();
            if (!new File(absPath).isDirectory()) {
                boolean isAdded = false;
                Object key = null;
                String fileExt = dirList[i].indexOf(".") != -1 ? dirList[i].substring(dirList[i].lastIndexOf(".")) : "";
                int j = 0;
                while (j < ext.length) {
                    if (fileExt.equals(ext[j])) {
                        Object entry = entries[j];
                        if (!((String)entry).endsWith(File.separator)) {
                            entry = (String)entry + File.separator;
                        }
                        info.add(new InfoObject((String)entry + dirList[i], absPath));
                        isAdded = true;
                    }
                    ++j;
                }
                if (excludedExt != null) {
                    int k = 0;
                    while (k < excludedExt.size()) {
                        if (fileExt.equals((String)excludedExt.elementAt(k))) {
                            isAdded = true;
                            break;
                        }
                        ++k;
                    }
                }
                if (!isAdded) {
                    info.add(new InfoObject(defaultEntry + dirList[i], absPath));
                }
            }
            ++i;
        }
    }

    protected void sortDirMapping() {
        if (this.dirMapping == null && this.dirMapping.length == 0) {
            return;
        }
        MappingObject swapObject = null;
        String compareI = "";
        String compareJ = "";
        boolean index = false;
        boolean length = false;
        int i = 0;
        while (i < this.dirMapping.length) {
            int j = i + 1;
            while (j < this.dirMapping.length) {
                compareI = this.dirMapping[i].getFilePath();
                if (compareI.compareTo(compareJ = this.dirMapping[j].getFilePath()) > 0) {
                    swapObject = this.dirMapping[i];
                    this.dirMapping[i] = this.dirMapping[j];
                    this.dirMapping[j] = swapObject;
                }
                ++j;
            }
            ++i;
        }
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public void setMappingObjects(MappingObject[] mapping) {
        this.dirMapping = mapping;
    }

    public MappingObject[] getMappingObjects() {
        return this.dirMapping;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setDescriptorType(String descrType) {
        if (descrType == null) {
            return;
        }
        if (descrType.trim().equals("EJB")) {
            this.archDescrType = 1;
            return;
        }
        if (descrType.trim().equals("WEB")) {
            this.archDescrType = 4;
            return;
        }
        if (descrType.trim().equals("JAVA")) {
            this.archDescrType = 3;
            return;
        }
        if (descrType.trim().equals("SERVICE")) {
            this.archDescrType = 2;
            return;
        }
        if (descrType.trim().equals("CONNECTOR")) {
            this.archDescrType = 5;
            return;
        }
        if (descrType.trim().equals("OTHER")) {
            this.archDescrType = 0;
            return;
        }
        if (this.fileName.trim().endsWith(".jar")) {
            this.archDescrType = 1;
            return;
        }
        if (this.fileName.trim().endsWith(".war")) {
            this.archDescrType = 4;
            return;
        }
        throw new IllegalArgumentException("descriptor type: " + descrType);
    }

    public void setDescriptorIntType(int dType) {
        this.archDescrType = dType;
    }

    public String getDescriptorType() {
        if (this.archDescrType == 1) {
            return "EJB";
        }
        if (this.archDescrType == 4) {
            return "WEB";
        }
        if (this.archDescrType == 3) {
            return "JAVA";
        }
        if (this.archDescrType == 2) {
            return "SERVICE";
        }
        if (this.archDescrType == 5) {
            return "CONNECTOR";
        }
        if (this.archDescrType == 0) {
            return "OTHER";
        }
        return null;
    }

    public int getDescriptorIntType() {
        return this.archDescrType;
    }

    public void setDescriptorLocation(String descrFileLocation) {
        this.archDescrFileLocation = descrFileLocation;
    }

    public String getDescriptorLocation() {
        return this.archDescrFileLocation;
    }

    public void setAddClasspath(String addPath) {
        this.addClasspath = addPath;
    }

    public String getAddClasspath() {
        return this.addClasspath;
    }
}

