/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy;

import com.sap.engine.lib.jar.JarExtractor;
import com.sap.engine.lib.lang.DynamicClassLoader;
import java.io.File;
import java.util.Vector;

public class SimpleEARClassLoader
extends DynamicClassLoader {
    private String classpath;
    private File outputDir;
    private ClassLoader parent;

    public SimpleEARClassLoader(String filePath) {
        this(null, filePath);
    }

    public SimpleEARClassLoader(String applicationName, String filePath) {
        this(applicationName, filePath, ".", Long.toString(System.currentTimeMillis()));
    }

    public SimpleEARClassLoader(String applicationName, String filePath, ClassLoader parent) {
        this(applicationName, filePath, ".", Long.toString(System.currentTimeMillis()), parent);
    }

    public SimpleEARClassLoader(String applicationName, String filePath, String parentDir) {
        this(applicationName, filePath, parentDir, Long.toString(System.currentTimeMillis()));
    }

    public SimpleEARClassLoader(String applicationName, String filePath, String parentDir, ClassLoader loader) {
        this(applicationName, filePath, parentDir, Long.toString(System.currentTimeMillis()), loader);
    }

    public SimpleEARClassLoader(String applicationName, String filePath, String parentDir, String tempDirName) {
        this(applicationName, filePath, parentDir, tempDirName, null);
    }

    public SimpleEARClassLoader(String applicationName, String filePath, String parentDir, String tempDirName, ClassLoader loader) {
        super(parentDir, loader);
        this.parent = loader;
        this.outputDir = new File(parentDir + File.separator + tempDirName);
        JarExtractor util = new JarExtractor();
        try {
            util.extractJar(filePath, this.outputDir.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[] classes = this.listRecursivelyArchives(this.outputDir);
        this.classpath = this.outputDir.getAbsolutePath();
        this.classpath = this.classpath + File.pathSeparator;
        int i = 0;
        while (i < classes.length) {
            this.classpath = this.classpath + classes[i] + File.pathSeparator;
            ++i;
        }
        this.addClasspath(this.classpath);
    }

    public String getClassPath() {
        return this.classpath;
    }

    public void setAdditionalPath(String additional) {
        this.classpath = this.classpath + additional;
        this.addClasspath(additional);
    }

    public String getOutputDir() {
        return this.outputDir.getAbsolutePath();
    }

    public void clear() {
        this.deleteDir(this.outputDir);
    }

    private void deleteDir(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (!files[i].isDirectory()) {
                    files[i].delete();
                } else {
                    this.deleteDir(files[i]);
                }
                ++i;
            }
        }
        dir.delete();
    }

    private String[] listRecursivelyArchives(File outputDir) {
        Vector files = new Vector();
        if (outputDir.isDirectory()) {
            this.list(outputDir, files);
        }
        Object[] res = new String[files.size()];
        files.copyInto(res);
        return res;
    }

    private void list(File file, Vector all) {
        File[] files = file.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.list(files[i], all);
            } else if (files[i].getName().toLowerCase().endsWith(".jar") || files[i].getName().toLowerCase().endsWith(".zip") || files[i].getName().toLowerCase().endsWith(".war")) {
                all.add(files[i].getAbsolutePath());
            } else if (files[i].getName().toLowerCase().endsWith(".rar")) {
                JarExtractor util = new JarExtractor();
                try {
                    File connectorDir = new File(files[i].getParentFile(), String.valueOf(System.currentTimeMillis()));
                    util.extractJar(files[i].getAbsolutePath(), connectorDir.getAbsolutePath());
                    String[] connectorJars = this.listRecursivelyArchives(connectorDir);
                    if (connectorJars != null) {
                        int j = 0;
                        while (j < connectorJars.length) {
                            all.add(connectorJars[j]);
                            ++j;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }
}

