/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.boot;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;

public class BootScriptProcessor {
    public static final String autoScriptName = "nextboot.scr";
    public static final String autoScriptPath = "." + File.separator + "temp";
    public static final String COMMENT_COMMAND = "#";
    public static final String REPLACE_COMMAND = "!REPLACE";
    public static final String DELETE_COMMAND = "!DELETE";
    String pathLimiter = null;

    public BootScriptProcessor() {
        try {
            this.pathLimiter = new File(".").getCanonicalPath();
        }
        catch (IOException e) {
            System.out.println("Unable to get Cannonical Path of local folder.");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean processScript(File script, String serverPath) {
        try {
            String command;
            RandomAccessFile bootScript = new RandomAccessFile(script, "r");
            int count = 0;
            while ((command = bootScript.readLine()) != null) {
                void var4_6;
                ++count;
                if (var4_6.startsWith(COMMENT_COMMAND)) continue;
                if (var4_6.startsWith(REPLACE_COMMAND)) {
                    StringTokenizer parsed = new StringTokenizer(var4_6.substring(REPLACE_COMMAND.length()).trim());
                    if (parsed.countTokens() == 2) {
                        File dst;
                        File src = new File(serverPath + File.separator + parsed.nextToken());
                        if (this.doReplace(src, dst = new File(serverPath + File.separator + parsed.nextToken()))) continue;
                        System.err.println("[BOOT SCRIPT] Command failed on line " + count + "...");
                        continue;
                    }
                    System.err.println("[BOOT SCRIPT] Invalid number of arguments on line " + count + "...");
                    continue;
                }
                if (var4_6.startsWith(DELETE_COMMAND)) {
                    if (this.doDelete(serverPath + File.separator + var4_6.substring(DELETE_COMMAND.length()).trim())) continue;
                    System.err.println("[BOOT SCRIPT] Command failed on line " + count + "...");
                    continue;
                }
                System.err.println("[BOOT SCRIPT] Unknown command on line " + count + "...");
            }
            bootScript.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean doReplace(File src, File dst) {
        if (!(src.exists() && this.validateFile(src) && this.validateFile(dst))) {
            return false;
        }
        if (dst.exists()) {
            dst.delete();
        }
        src.renameTo(dst);
        return true;
    }

    private boolean doDelete(String file) {
        File victim = new File(file);
        if (!victim.exists() || !this.validateFile(victim)) {
            return false;
        }
        victim.delete();
        return true;
    }

    private boolean validateFile(File f) {
        try {
            return f.getCanonicalPath().startsWith(this.pathLimiter);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean processIfAny() {
        boolean rezult = false;
        File workerScript = new File(autoScriptPath + File.separator + autoScriptName);
        if (workerScript.exists()) {
            rezult = this.processScript(workerScript, this.pathLimiter);
            workerScript.delete();
        }
        return rezult;
    }
}

