/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.help.internal.HelpSystem;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.search.SearchQuery;
import org.eclipse.help.internal.search.SearchResults;
import org.eclipse.help.internal.webapp.HelpWebappPlugin;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.XMLGenerator;

public class SearchServlet
extends HttpServlet {
    private String locale;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.locale = UrlUtil.getLocale(req);
        req.setCharacterEncoding("UTF-8");
        resp.setContentType("application/xml; charset=UTF-8");
        resp.setHeader("Cache-Control", "max-age=0");
        SearchHit[] hits = this.loadSearchResults(req);
        ResultsWriter resultsWriter = new ResultsWriter(resp.getWriter());
        resultsWriter.generate(hits, resp);
        resultsWriter.close();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private SearchHit[] loadSearchResults(HttpServletRequest request) {
        SearchHit[] hits = null;
        try {
            try {
                NullProgressMonitor pm = new NullProgressMonitor();
                SearchResults results = this.createHitCollector(request);
                HelpSystem.getSearchManager().search(this.createSearchQuery(request), (ISearchHitCollector)results, (IProgressMonitor)pm);
                hits = results.getSearchHits();
            }
            catch (Exception e) {
                HelpWebappPlugin.logError((String)"", (Throwable)e);
            }
        }
        catch (Throwable throwable) {}
        if (hits == null) {
            hits = new SearchHit[]{};
        }
        return hits;
    }

    private ISearchQuery createSearchQuery(HttpServletRequest request) {
        String searchWord = "";
        searchWord = UrlUtil.isIE(request) && request.getParameter("encoding") != null ? UrlUtil.unescape(UrlUtil.getRawRequestParameter(request, "searchWord")) : request.getParameter("searchWord");
        String fieldSearchStr = request.getParameter("fieldSearch");
        boolean fieldSearch = fieldSearchStr != null ? new Boolean(fieldSearchStr) : false;
        return new SearchQuery(searchWord, fieldSearch, new ArrayList(), this.locale);
    }

    private SearchResults createHitCollector(HttpServletRequest request) {
        String[] scopes = request.getParameterValues("scope");
        ArrayList<String> scopeCol = null;
        if (scopes != null && scopes.length != HelpSystem.getTocManager().getTocs(this.locale).length) {
            scopeCol = new ArrayList<String>(scopes.length);
            int i = 0;
            while (i < scopes.length) {
                scopeCol.add(scopes[i]);
                ++i;
            }
        }
        int maxHits = 500;
        String maxHitsStr = request.getParameter("maxHits");
        if (maxHitsStr != null) {
            try {
                int clientmaxHits = Integer.parseInt(maxHitsStr);
                if (clientmaxHits > 0 && clientmaxHits < 500) {
                    maxHits = clientmaxHits;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return new SearchResults(scopeCol, maxHits, this.locale);
    }

    private static class ResultsWriter
    extends XMLGenerator {
        public ResultsWriter(Writer writer) {
            super(writer);
        }

        public void generate(SearchHit[] hits, HttpServletResponse resp) {
            this.println("<hits>");
            ++this.pad;
            int i = 0;
            while (i < hits.length) {
                this.printPad();
                this.print("<topic label=\"" + XMLGenerator.xmlEscape(hits[i].getLabel()) + "\"" + " href=\"" + hits[i].getHref() + "\"" + " score=\"" + Float.toString(hits[i].getScore()) + "\"");
                if (hits[i].getToc() != null) {
                    this.print(" toc=\"" + hits[i].getToc().getHref() + "\"" + " toclabel=\"" + hits[i].getToc().getLabel() + "\"");
                }
                this.print(" />");
                ++i;
            }
            --this.pad;
            this.println("</hits>");
        }
    }
}

