/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.IHelp;
import org.eclipse.help.internal.HelpApplication;
import org.eclipse.help.internal.HelpSystem;
import org.eclipse.help.internal.webapp.data.UrlUtil;

public class ControlServlet
extends HttpServlet {
    private IHelp helpSupport = null;
    private boolean shuttingDown = false;

    public void init() throws ServletException {
        super.init();
        if (HelpSystem.getMode() == 2) {
            this.helpSupport = HelpSystem.getHelpSupport();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    private void processRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setCharacterEncoding("UTF-8");
        resp.setHeader("Cache-Control", "no-cache");
        resp.setHeader("Pragma", "no-cache");
        resp.setDateHeader("Expires", 0L);
        if (!UrlUtil.isLocalRequest(req)) {
            return;
        }
        if (!"/helpControl".equals(req.getContextPath()) || !"/control.html".equals(req.getServletPath())) {
            resp.sendError(403, "");
            return;
        }
        if (this.shuttingDown) {
            return;
        }
        String command = req.getParameter("command");
        if (command == null) {
            resp.getWriter().print("No command.");
            return;
        }
        if ("shutdown".equalsIgnoreCase(command)) {
            this.shutdown();
        } else if ("displayHelp".equalsIgnoreCase(command)) {
            if (HelpSystem.getMode() == 2) {
                this.displayHelp(req);
            }
        } else {
            resp.getWriter().print("Unrecognized command.");
        }
    }

    private void shutdown() {
        this.shuttingDown = true;
        HelpApplication.stop();
    }

    private void displayHelp(HttpServletRequest req) {
        String href = req.getParameter("href");
        if (href != null) {
            this.helpSupport.displayHelpResource(href);
        } else {
            this.helpSupport.displayHelp();
        }
    }
}

