/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.IContext;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.HelpSystem;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.XMLGenerator;

public class ContextServlet
extends HttpServlet {
    private String locale;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.locale = UrlUtil.getLocale(req);
        req.setCharacterEncoding("UTF-8");
        resp.setContentType("application/xml; charset=UTF-8");
        resp.setHeader("Cache-Control", "max-age=0");
        String contextId = req.getPathInfo();
        if (contextId == null || contextId.length() < 2) {
            throw new ServletException();
        }
        contextId = contextId.substring(1);
        IContext context = HelpSystem.getContextManager().getContext(contextId);
        if (context == null) {
            throw new ServletException();
        }
        ContextWriter resultsWriter = new ContextWriter(resp.getWriter(), this.locale);
        resultsWriter.generate(contextId, context, resp);
        resultsWriter.close();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private static class ContextWriter
    extends XMLGenerator {
        private String locale;

        public ContextWriter(Writer writer, String locale) {
            super(writer);
            this.locale = locale;
        }

        public void generate(String contextId, IContext context, HttpServletResponse resp) {
            this.println("<context id=\"" + contextId + "\">");
            ++this.pad;
            this.printPad();
            this.print("<description>");
            this.print(context.getText());
            this.println("</description>");
            IHelpResource[] links = context.getRelatedTopics();
            if (links == null) {
                links = new IHelpResource[]{};
            }
            int i = 0;
            while (i < links.length) {
                this.printPad();
                this.print("<topic label=\"" + XMLGenerator.xmlEscape(links[i].getLabel()) + "\"" + " href=\"" + links[i].getHref() + "\"");
                IToc toc = this.findTocForTopic(links[i].getHref());
                if (toc != null) {
                    this.print(" toc=\"" + toc.getHref() + "\"" + " toclabel=\"" + toc.getLabel() + "\"");
                }
                this.print(" />");
                ++i;
            }
            --this.pad;
            this.println("</context>");
        }

        IToc findTocForTopic(String href) {
            IToc[] tocs = HelpSystem.getTocManager().getTocs(this.locale);
            int i = 0;
            while (i < tocs.length) {
                ITopic topic = tocs[i].getTopic(href);
                if (topic != null) {
                    return tocs[i];
                }
                ++i;
            }
            return null;
        }
    }
}

