/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.text.NumberFormat;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.HelpSystem;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.search.SearchProgressMonitor;
import org.eclipse.help.internal.search.SearchQuery;
import org.eclipse.help.internal.search.SearchResults;
import org.eclipse.help.internal.util.Resources;
import org.eclipse.help.internal.webapp.HelpWebappPlugin;
import org.eclipse.help.internal.webapp.data.RequestData;
import org.eclipse.help.internal.webapp.data.ServletResources;
import org.eclipse.help.internal.webapp.data.TocData;
import org.eclipse.help.internal.webapp.data.UrlUtil;

public class SearchData
extends RequestData {
    private String topicHref;
    private String selectedTopicId = "";
    private String searchWord;
    private String workingSetName;
    SearchHit[] hits;
    private int indexCompletion = 100;

    public SearchData(ServletContext context, HttpServletRequest request) {
        super(context, request);
        this.topicHref = request.getParameter("topic");
        if (this.topicHref != null && this.topicHref.length() == 0) {
            this.topicHref = null;
        }
        this.searchWord = this.getDBCSParameter("searchWord");
        if (this.isSearchRequest() && !this.isScopeRequest()) {
            this.loadSearchResults();
            if (!this.isProgressRequest()) {
                int i = 0;
                while (i < this.hits.length) {
                    if (this.hits[i].getHref().equals(this.topicHref)) {
                        this.selectedTopicId = "a" + i;
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    public boolean isSearchRequest() {
        return this.request.getParameter("searchWord") != null;
    }

    public boolean isProgressRequest() {
        return this.hits == null && this.indexCompletion != 100;
    }

    public boolean isScopeRequest() {
        return this.request.getParameter("workingSet") != null;
    }

    public int getResultsCount() {
        return this.hits.length;
    }

    public String getSelectedTopicId() {
        return this.selectedTopicId;
    }

    public String getTopicHref(int i) {
        return UrlUtil.getHelpURL(this.hits[i].getHref());
    }

    public String getTopicLabel(int i) {
        return UrlUtil.htmlEncode(this.hits[i].getLabel());
    }

    public String getTopicScore(int i) {
        try {
            float score = this.hits[i].getScore();
            NumberFormat percentFormat = NumberFormat.getPercentInstance(UrlUtil.getLocaleObj(this.request));
            return percentFormat.format(score);
        }
        catch (NumberFormatException numberFormatException) {
            return String.valueOf(this.hits[i].getScore());
        }
    }

    public String getTopicTocLabel(int i) {
        if (this.hits[i].getToc() != null) {
            return UrlUtil.htmlEncode(this.hits[i].getToc().getLabel());
        }
        return "";
    }

    public String getIndexedPercentage() {
        return String.valueOf(this.indexCompletion);
    }

    public String getSearchWord() {
        if (this.searchWord == null) {
            return "";
        }
        return this.searchWord;
    }

    public String[] getSelectedTocs() {
        String[] books = this.request.getParameterValues("scope");
        if (books == null) {
            TocData tocData = new TocData(this.context, this.request);
            books = new String[tocData.getTocCount()];
            int i = 0;
            while (i < books.length) {
                books[i] = tocData.getTocHref(i);
                ++i;
            }
        }
        return books;
    }

    public boolean isTocSelected(int toc) {
        TocData tocData = new TocData(this.context, this.request);
        String href = tocData.getTocHref(toc);
        String[] books = this.request.getParameterValues("scope");
        if (books == null) {
            return false;
        }
        int i = 0;
        while (i < books.length) {
            if (books[i].equals(href)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getScope() {
        if (this.workingSetName != null) {
            return this.workingSetName;
        }
        if (this.isScopeRequest()) {
            this.workingSetName = this.getDBCSParameter("workingSet");
        } else if (this.isSearchRequest()) {
            this.workingSetName = this.getDBCSParameter("scope");
            if (this.workingSetName == null) {
                this.workingSetName = this.getDBCSParameter("workingSet");
            }
        } else {
            this.workingSetName = HelpPlugin.getDefault().getPluginPreferences().getString("workingSet");
        }
        if (this.workingSetName == null || this.workingSetName.length() == 0 || HelpSystem.getWorkingSetManager((String)this.getLocale()).getWorkingSet(this.workingSetName) == null) {
            this.workingSetName = ServletResources.getString("All", this.request);
        }
        return this.workingSetName;
    }

    public void saveScope() {
        if (this.getMode() == 1) {
            return;
        }
        String workingSet = this.getDBCSParameter("scope");
        String lastWS = HelpPlugin.getDefault().getPluginPreferences().getString("workingSet");
        if (workingSet != null && !workingSet.equals(lastWS)) {
            HelpPlugin.getDefault().getPluginPreferences().setValue("workingSet", workingSet);
            HelpPlugin.getDefault().savePluginPreferences();
        } else if (workingSet == null && lastWS != null && lastWS.length() > 0) {
            HelpPlugin.getDefault().getPluginPreferences().setValue("workingSet", "");
            HelpPlugin.getDefault().savePluginPreferences();
        }
    }

    private void loadSearchResults() {
        try {
            SearchProgressMonitor pm = SearchProgressMonitor.getProgressMonitor((String)this.getLocale());
            if (pm.isDone()) {
                this.indexCompletion = 100;
                SearchResults results = this.createHitCollector();
                HelpSystem.getSearchManager().search(this.createSearchQuery(), (ISearchHitCollector)results, (IProgressMonitor)pm);
                this.hits = results.getSearchHits();
                if (this.hits == null) {
                    HelpWebappPlugin.logError((String)Resources.getString((String)"index_is_busy"), null);
                }
                return;
            }
            this.indexCompletion = pm.getPercentage();
            return;
        }
        catch (Exception exception) {
            this.indexCompletion = 0;
            return;
        }
    }

    private ISearchQuery createSearchQuery() {
        String fieldSearchStr = this.request.getParameter("fieldSearch");
        boolean fieldSearch = fieldSearchStr != null ? new Boolean(fieldSearchStr) : false;
        return new SearchQuery(this.searchWord, fieldSearch, new ArrayList(), this.getLocale());
    }

    private SearchResults createHitCollector() {
        String[] scopes = this.getDBCSParameters("scope");
        ArrayList<String> scopeCol = null;
        if (scopes != null) {
            if (this.request.getParameterValues("scopedSearch") == null || scopes.length != HelpSystem.getTocManager().getTocs(this.getLocale()).length) {
                scopeCol = new ArrayList(scopes.length);
                int i = 0;
                while (i < scopes.length) {
                    scopeCol.add(scopes[i]);
                    ++i;
                }
            }
        } else if (this.request.getParameterValues("scopedSearch") != null) {
            scopeCol = new ArrayList<String>(0);
        }
        int maxHits = 500;
        String maxHitsStr = this.request.getParameter("maxHits");
        if (maxHitsStr != null) {
            try {
                int clientmaxHits = Integer.parseInt(maxHitsStr);
                if (clientmaxHits > 0 && clientmaxHits < 500) {
                    maxHits = clientmaxHits;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return new SearchResults(scopeCol, maxHits, this.getLocale());
    }
}

