/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.help.internal.HelpSystem;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.data.WebappPreferences;

public class RequestData {
    public static final int MODE_WORKBENCH = 0;
    public static final int MODE_INFOCENTER = 1;
    public static final int MODE_STANDALONE = 2;
    protected ServletContext context;
    protected HttpServletRequest request;
    protected String locale;
    protected WebappPreferences preferences;

    public RequestData(ServletContext context, HttpServletRequest request) {
        this.context = context;
        this.request = request;
        this.preferences = new WebappPreferences();
        this.locale = UrlUtil.getLocale(request);
    }

    public WebappPreferences getPrefs() {
        return this.preferences;
    }

    public boolean isGecko() {
        return UrlUtil.isGecko(this.request);
    }

    public boolean isIE() {
        return UrlUtil.isIE(this.request);
    }

    public boolean isKonqueror() {
        return UrlUtil.isKonqueror(this.request);
    }

    public boolean isMozilla() {
        return UrlUtil.isMozilla(this.request);
    }

    public String getMozillaVersion() {
        return UrlUtil.getMozillaVersion(this.request);
    }

    public boolean isOpera() {
        return UrlUtil.isOpera(this.request);
    }

    public String getLocale() {
        return this.locale;
    }

    public int getMode() {
        return HelpSystem.getMode();
    }

    public String getDBCSParameter(String name) {
        if (UrlUtil.isIE(this.request) && this.request.getParameter("encoding") != null) {
            return UrlUtil.unescape(UrlUtil.getRawRequestParameter(this.request, name));
        }
        return this.request.getParameter(name);
    }

    public String[] getDBCSParameters(String name) {
        if (UrlUtil.isIE(this.request) && this.request.getParameter("encoding") != null) {
            String[] rawValues = UrlUtil.getRawRequestParameters(this.request, name);
            if (rawValues == null || rawValues.length == 0) {
                return null;
            }
            String[] values = new String[rawValues.length];
            int i = 0;
            while (i < rawValues.length) {
                values[i] = UrlUtil.unescape(rawValues[i]);
                ++i;
            }
            return values;
        }
        return this.request.getParameterValues(name);
    }
}

