/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.prop.impl;

import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.misc.api.IOUtil;
import com.sap.aii.util.misc.api.Util;
import com.sap.aii.util.prop.api.PropertyNode;
import com.sap.aii.util.prop.api.PropertySet;
import com.sap.aii.util.prop.api.PropertySource;
import com.sap.aii.util.prop.api.PropertyTools;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;

public class BasicPropertySource
implements PropertySource {
    protected static final Logger log = Logger.getLogger((class$com$sap$aii$util$prop$impl$BasicPropertySource == null ? (class$com$sap$aii$util$prop$impl$BasicPropertySource = BasicPropertySource.class$("com.sap.aii.util.prop.impl.BasicPropertySource")) : class$com$sap$aii$util$prop$impl$BasicPropertySource).getName());
    public static final String PARAMETER_LOCALDIRECTORY = "localDir";
    protected transient PropertyChangeSupport pcsupport = new PropertyChangeSupport(this);
    protected PropertySet propSet = null;
    protected PropertySet internalSet = new InternalPropertySet();
    protected Map nodeMap = new Hashtable();
    protected PropertySource fallbackSource = null;
    protected String baseName = "";
    private Map metaData = null;
    private Timer timer = null;
    static /* synthetic */ Class class$com$sap$aii$util$prop$impl$BasicPropertySource;
    static /* synthetic */ Class class$java$util$Properties;

    protected BasicPropertySource() {
    }

    public BasicPropertySource(PropertySet propSet) {
        this.propSet = propSet;
        this.getInternalFallback();
    }

    public BasicPropertySource(Properties prop, String baseName) {
        this(new PropertiesAdapter(prop, baseName));
    }

    protected void setPropertySet(PropertySet propSet) {
        this.propSet = propSet;
        this.getInternalFallback();
    }

    public void setFallbackSource(PropertySource source) {
        this.fallbackSource = source;
    }

    public String getName() {
        return Util.getClassName(this);
    }

    protected PropertyNode getRoot() {
        return this.getNode("");
    }

    public PropertySet getPropertySet() {
        return this.internalSet;
    }

    public void sync() {
        this.syncFallbackSource();
    }

    public void syncFallbackSource() {
        if (this.fallbackSource != null) {
            this.fallbackSource.sync();
        }
    }

    public void flush() {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcsupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        this.pcsupport.addPropertyChangeListener(name, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcsupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener listener) {
        this.pcsupport.removePropertyChangeListener(name, listener);
    }

    protected void firePropertyChange(String name, String oldValue, String newValue) {
        this.pcsupport.firePropertyChange(name, oldValue, newValue);
    }

    public synchronized void periodicUpdate(int secs) {
        if (this.timer == null) {
            if (secs > 0) {
                this.timer = new Timer(true);
            } else {
                return;
            }
        }
        if (secs > 0) {
            UpdateTask timerTask = new UpdateTask();
            this.timer.scheduleAtFixedRate((TimerTask)timerTask, 0L, (long)(secs * 1000));
        } else {
            this.timer.cancel();
        }
    }

    protected String getLocalDir() {
        return ".";
    }

    protected static String resolveFile(String localDir, String fileName) {
        File file = new File(fileName);
        if (!file.isAbsolute()) {
            file = new File(localDir, fileName);
        }
        return IOUtil.getFileName(file);
    }

    private void getInternalFallback() {
        PropertyNode node = this.getRoot().getNode("com.sap.aii.util.prop.fallback");
        String className = node.getProperty("class");
        Properties parameters = PropertyTools.exportProperties(node.getNode("parameters"), "", false);
        if (!((Hashtable)parameters).contains(PARAMETER_LOCALDIRECTORY)) {
            parameters.setProperty(PARAMETER_LOCALDIRECTORY, this.getLocalDir());
        }
        if (className != null) {
            try {
                PropertySource source;
                Class<?> c = Class.forName(className);
                Constructor<?> constr = c.getConstructor(class$java$util$Properties == null ? (class$java$util$Properties = BasicPropertySource.class$("java.util.Properties")) : class$java$util$Properties);
                this.fallbackSource = source = (PropertySource)constr.newInstance(parameters);
                log.debug("using internal fallback source \"" + source.getName() + "\"");
            }
            catch (ClassNotFoundException ex) {
                log.error("internal fallback source \"" + className + "\" not found");
            }
            catch (NoSuchMethodException ex) {
                log.error("constructor of internal fallback source \"" + className + "\" not found");
            }
            catch (Exception ex) {
                Throwable t = ex;
                if (ex instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)ex).getTargetException();
                }
                log.error("exception while initializing internal fallback source \"" + className + "\"", t);
            }
        }
    }

    private boolean isEmptyNode(String nodeName) {
        String key = this.baseName + nodeName + '.';
        boolean result = true;
        String[] props = this.propSet.getPropertyNames();
        int i = 0;
        while (i < props.length) {
            if (props[i].startsWith(key)) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }

    private PropertyNode getNode(String nodeName) {
        String key = this.baseName + nodeName;
        PropertyNode node = (PropertyNode)this.nodeMap.get(key);
        if (node == null) {
            node = new PropertyNodeImpl(nodeName);
            this.nodeMap.put(key, node);
        }
        return node;
    }

    public PropertyNode createNode(String nodeName) {
        return this.getNode(nodeName);
    }

    public synchronized void deleteNode(String nodeName) {
        if (!nodeName.equals("")) {
            nodeName = nodeName + '.';
        }
        nodeName = this.baseName + nodeName;
        int pos = nodeName.length();
        HashSet<String> result = new HashSet<String>();
        String[] props = this.propSet.getPropertyNames();
        int i = 0;
        while (i < props.length) {
            String name = props[i];
            if (name.startsWith(nodeName)) {
                result.add(name.substring(pos));
            }
            ++i;
        }
        Iterator i2 = result.iterator();
        while (i2.hasNext()) {
            this.propSet.deleteProperty((String)i2.next());
        }
    }

    public static void main(String[] args) throws Exception {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class PropertyNodeImpl
    implements PropertyNode {
        private String localNodeName;
        private String fullNodeName;
        private String nodePrefix;

        public PropertyNodeImpl(String fullName) {
            this.fullNodeName = fullName;
            this.nodePrefix = this.isRoot() ? "" : fullName + '.';
            int pos = fullName.lastIndexOf(46);
            this.localNodeName = pos < 0 ? fullName : fullName.substring(pos + 1);
        }

        public String getProperty(String key) {
            key = this.nodePrefix + key;
            String value = BasicPropertySource.this.propSet.getProperty(BasicPropertySource.this.baseName + key);
            if (value == null && BasicPropertySource.this.fallbackSource != null) {
                value = BasicPropertySource.this.fallbackSource.getPropertySet().getProperty(key);
            }
            return value;
        }

        public String[] getPropertyNames() {
            String nodeName = this.fullNodeName;
            if (!nodeName.equals("")) {
                nodeName = nodeName + '.';
            }
            nodeName = BasicPropertySource.this.baseName + nodeName;
            Set result = PropertyTools.extractPropertyNames(BasicPropertySource.this.propSet, nodeName);
            if (BasicPropertySource.this.fallbackSource != null) {
                result.addAll(PropertyTools.extractPropertyNames(BasicPropertySource.this.fallbackSource.getPropertySet(), nodeName));
            }
            return result.toArray(new String[result.size()]);
        }

        public PropertyNode getNode(String key) {
            return BasicPropertySource.this.getNode(this.nodePrefix + key);
        }

        public String[] getNodeNames() {
            String nodeName = this.fullNodeName;
            if (!nodeName.equals("")) {
                nodeName = nodeName + '.';
            }
            nodeName = BasicPropertySource.this.baseName + nodeName;
            Set result = PropertyTools.extractNodeNames(BasicPropertySource.this.propSet, nodeName);
            if (BasicPropertySource.this.fallbackSource != null) {
                result.addAll(PropertyTools.extractNodeNames(BasicPropertySource.this.fallbackSource.getPropertySet(), nodeName));
            }
            return result.toArray(new String[result.size()]);
        }

        public PropertyNode getParent() {
            if (this.isRoot()) {
                return null;
            }
            int pos = this.fullNodeName.lastIndexOf(46);
            String parentName = pos < 0 ? "" : this.fullNodeName.substring(pos + 1);
            return BasicPropertySource.this.getNode(parentName);
        }

        public boolean isRoot() {
            return this.fullNodeName.equals("");
        }

        public String getName() {
            return this.localNodeName;
        }

        public String getFullName() {
            return this.fullNodeName;
        }

        public synchronized void setProperty(String name, String value) {
            if (value == null) {
                this.deleteProperty(name);
                return;
            }
            String fullName = this.nodePrefix + name;
            String key = BasicPropertySource.this.baseName + fullName;
            String oldValue = this.getProperty(key);
            BasicPropertySource.this.propSet.setProperty(key, value);
            if (!value.equals(oldValue)) {
                BasicPropertySource.this.firePropertyChange(fullName, oldValue, value);
            }
        }

        public synchronized void deleteProperty(String name) {
            String fullName = this.nodePrefix + name;
            String key = BasicPropertySource.this.baseName + fullName;
            String oldValue = this.getProperty(key);
            BasicPropertySource.this.propSet.deleteProperty(key);
            if (oldValue != null) {
                BasicPropertySource.this.firePropertyChange(fullName, oldValue, null);
            }
        }
    }

    protected class InternalPropertySet
    implements PropertySet {
        protected InternalPropertySet() {
        }

        public String[] getPropertyNames() {
            String[] fallBackNames;
            String[] result = BasicPropertySource.this.propSet.getPropertyNames();
            if (BasicPropertySource.this.fallbackSource != null && (fallBackNames = BasicPropertySource.this.fallbackSource.getPropertySet().getPropertyNames()).length > 0) {
                TreeSet<String> resultSet = new TreeSet<String>(Arrays.asList(result));
                resultSet.addAll(Arrays.asList(fallBackNames));
                result = resultSet.toArray(new String[resultSet.size()]);
            }
            return result;
        }

        public String getProperty(String key) {
            String value = BasicPropertySource.this.propSet.getProperty(key);
            if (value == null && BasicPropertySource.this.fallbackSource != null) {
                value = BasicPropertySource.this.fallbackSource.getPropertySet().getProperty(key);
            }
            return value;
        }

        public void setProperty(String key, String value) {
            BasicPropertySource.this.propSet.setProperty(key, value);
        }

        public void deleteProperty(String key) {
            BasicPropertySource.this.propSet.deleteProperty(key);
        }
    }

    protected static class PropertiesAdapter
    implements PropertySet {
        protected Properties prop;
        protected String baseName;

        public PropertiesAdapter(Properties prop) {
            this(prop, "");
        }

        public PropertiesAdapter(Properties prop, String baseName) {
            this.prop = prop;
            this.baseName = baseName.equals("") ? "" : baseName + '.';
        }

        public String[] getPropertyNames() {
            Set keys = ((Hashtable)this.prop).keySet();
            if (this.baseName.length() > 0) {
                int pos = this.baseName.length();
                TreeSet result = new TreeSet();
                Iterator i = keys.iterator();
                while (i.hasNext()) {
                    String name = (String)i.next();
                    if (!name.startsWith(this.baseName)) continue;
                    result.add(name.substring(pos));
                }
                keys = result;
            }
            return keys.toArray(new String[keys.size()]);
        }

        public String getProperty(String key) {
            return this.prop.getProperty(this.baseName + key);
        }

        public void setProperty(String key, String value) {
            if (value == null) {
                this.deleteProperty(this.baseName + key);
                return;
            }
            this.prop.setProperty(this.baseName + key, value);
        }

        public void deleteProperty(String key) {
            ((Hashtable)this.prop).remove(this.baseName + key);
        }
    }

    private class UpdateTask
    extends TimerTask {
        private UpdateTask() {
        }

        public void run() {
            BasicPropertySource.this.sync();
        }
    }
}

