/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.misc.api;

public class NumServices {
    private static final short byteBits = 8;
    private static final short shortBits = 16;
    private static final short intBits = 32;
    private static final short longBits = 64;

    private NumServices() {
    }

    public static byte[] getBytes(long value) {
        return NumServices.getBytes(value, 8);
    }

    public static byte[] getBytes(int value) {
        return NumServices.getBytes(value, 4);
    }

    public static byte[] getBytes(short value) {
        return NumServices.getBytes(value, 2);
    }

    public static String toBinaryString(byte value) {
        return NumServices.toBinaryString(value, (short)8);
    }

    public static String toBinaryString(short value) {
        return NumServices.toBinaryString(value, (short)16);
    }

    public static String toBinaryString(int value) {
        return NumServices.toBinaryString(value, (short)32);
    }

    public static String toBinaryString(long value) {
        return NumServices.toBinaryString(value, (short)64);
    }

    public static String toHexString(byte value) {
        String ret;
        long v = value;
        if (v < 0L) {
            v += 256L;
        }
        if ((ret = Long.toHexString(v)).length() == 1) {
            return "0" + ret;
        }
        return ret;
    }

    private static byte[] getBytes(long value, int numBytes) {
        byte[] bytes = new byte[numBytes];
        int i = numBytes - 1;
        while (i >= 0) {
            bytes[i] = NumServices.getByte(value, i);
            --i;
        }
        return bytes;
    }

    private static byte getByte(long value, int bytePos) {
        long l = NumServices.getBits(value, (bytePos + 1) * 8 - 1, 8);
        return new Long(l).byteValue();
    }

    public static long getBits(long value, int pos, int n) {
        long rl = value >> pos + 1 - n & (long)(~(-1 << n));
        return rl;
    }

    private static String toBinaryString(long value, short numBits) {
        StringBuffer sb = new StringBuffer(numBits);
        int i = numBits - 1;
        while (i >= 0) {
            sb.append(NumServices.getBits(value, i, 1) == 1L ? (char)'1' : '0');
            --i;
        }
        return new String(sb);
    }
}

