/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.misc.api;

import com.sap.aii.util.misc.api.AbstractMessage;
import com.sap.aii.util.misc.api.BabelMessage;
import com.sap.aii.util.misc.api.InteractionMap;
import com.sap.aii.util.misc.api.Message;
import java.util.Locale;
import java.util.Vector;

public class MessagePara
extends AbstractMessage {
    private static final long serialVersionUID = 42L;
    private Vector messages = new Vector(3);

    public MessagePara() {
    }

    public MessagePara(Message m) {
        this.add(m);
    }

    public MessagePara(Message m1, Message m2) {
        this.add(m1);
        this.add(m2);
    }

    public MessagePara(Message m1, Message m2, Message m3) {
        this.add(m1);
        this.add(m2);
        this.add(m3);
    }

    public MessagePara add(String s) {
        if (s != null) {
            this.messages.add(BabelMessage.createFromString(s));
        }
        return this;
    }

    public MessagePara add(Message bm) {
        if (bm != null) {
            this.messages.add(bm);
        }
        return this;
    }

    public void insert(int index, Message msg) {
        if (index < 0) {
            return;
        }
        if (index >= this.messages.size()) {
            this.add(msg);
        } else {
            this.messages.insertElementAt(msg, index);
        }
    }

    public void set(int index, Message msg) {
        if (index < 0) {
            return;
        }
        int s = this.messages.size();
        if (index == s) {
            this.add(msg);
        } else {
            if (index > s) {
                return;
            }
            this.messages.set(index, msg);
        }
    }

    public void remove(int index) {
        if (index < 0 || index >= this.messages.size()) {
            return;
        }
        this.messages.removeElementAt(index);
    }

    public Message get(int index) {
        if (index < 0 || index >= this.messages.size()) {
            return null;
        }
        return (Message)this.messages.elementAt(index);
    }

    public int size() {
        return this.messages.size();
    }

    public String toString(Locale loc) {
        if (loc == null) {
            loc = Locale.getDefault();
        }
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        while (i < this.messages.size()) {
            Message m;
            if (i > 0) {
                sbuf.append(" ");
            }
            if ((m = this.get(i)) != null) {
                sbuf.append(m.toString(loc));
            }
            ++i;
        }
        return sbuf.toString();
    }

    public String toHTML(Locale loc, InteractionMap imap) {
        if (loc == null) {
            loc = Locale.getDefault();
        }
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        while (i < this.messages.size()) {
            Message m;
            if (i > 0) {
                sbuf.append(" ");
            }
            if ((m = this.get(i)) != null) {
                sbuf.append(m.toHTML(loc, imap));
            }
            ++i;
        }
        return sbuf.toString();
    }

    public void finallyLocalize(Locale loc) {
        int i = 0;
        while (i < this.messages.size()) {
            Message m = this.get(i);
            if (m != null) {
                m.finallyLocalize(loc);
            }
            ++i;
        }
    }
}

