/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.misc.api;

import com.sap.aii.util.misc.api.Cache;
import com.sap.aii.util.misc.api.InvalidArgumentException;
import com.sap.aii.util.misc.api.ResourceException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class MapBasedCache
extends Cache {
    private Map base;
    private boolean cacheNull;

    protected MapBasedCache(boolean isWeak, boolean cacheNull) {
        this.cacheNull = cacheNull;
        this.base = isWeak ? new WeakHashMap() : new HashMap();
    }

    public final synchronized Object get(Object x) throws ResourceException, InvalidArgumentException {
        if (!this.base.containsKey(x)) {
            this.actualize(x, this.base, this.cacheNull);
        }
        return this.base.get(x);
    }

    public final synchronized void refresh() {
        this.base.clear();
    }

    public final synchronized void refresh(Object x) {
        this.base.remove(x);
    }

    public final synchronized void refresh(Object x, Object value) {
        if (this.cacheNull || value != null) {
            this.base.put(x, value);
        } else {
            this.base.remove(x);
        }
    }

    protected abstract void actualize(Object var1, Map var2, boolean var3) throws ResourceException, InvalidArgumentException;
}

