/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.misc.api;

import com.sap.aii.util.misc.api.BabelMessage;
import com.sap.aii.util.misc.api.BaseException;
import com.sap.aii.util.misc.api.IBaseException;
import com.sap.aii.util.misc.api.ServerExceptionInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class ClientServerException
extends BaseException
implements Serializable {
    private static final long serialVersionUID = 42L;
    private ArrayList nestedExceptionInformation = new ArrayList();
    private static final Locale LOG_LOCALE = Locale.ENGLISH;
    private boolean initIsDone = true;
    private Locale userLocale = null;

    public ClientServerException(Throwable throwable) {
        super(throwable);
        this.cleanRootCause();
        this.completeBabelMessage();
    }

    public ClientServerException(BabelMessage babelMessage) {
        super(babelMessage);
        this.completeBabelMessage();
    }

    public ClientServerException(BabelMessage babelMessage, Throwable throwable) {
        super(babelMessage, throwable);
        this.cleanRootCause();
        this.completeBabelMessage();
    }

    private void completeBabelMessage() {
        String message = this.getMessage();
        if (message == null || message.length() <= 0) {
            BabelMessage babelMessage = new BabelMessage("com.sap.aii.util.misc.api.rb_exception.SERVER_EXCEPTION_NULL");
            this.setBabelMessage(babelMessage);
        }
    }

    private void cleanRootCause() {
        Throwable rootCause = this.getRootCause();
        if (this.getRootCause() != null) {
            this.extractNestedInformation(rootCause);
            super.setRootCause(null);
        }
    }

    public void setRootCause(Throwable throwable) {
        if (!this.initIsDone) {
            super.setRootCause(throwable);
        } else if (throwable != null) {
            this.extractNestedInformation(throwable);
        }
    }

    public List getNestedInformation() {
        return Collections.unmodifiableList(this.nestedExceptionInformation);
    }

    private void extractNestedInformation(Throwable throwable) {
        if (throwable != null) {
            ClientServerException cse;
            this.nestedExceptionInformation.add(new ServerExceptionInfo(throwable));
            if (throwable instanceof ClientServerException && (cse = (ClientServerException)throwable).getNestedInformation().size() > 0) {
                this.nestedExceptionInformation.addAll(cse.getNestedInformation());
            }
            if (throwable instanceof IBaseException) {
                this.extractNestedInformation(((IBaseException)((Object)throwable)).getRootCause());
            }
        }
    }
}

