/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.misc.api;

import com.sap.aii.util.log.api.Level;
import com.sap.aii.util.misc.api.BabelMessage;
import com.sap.aii.util.misc.api.CheckMessage;
import com.sap.aii.util.misc.api.ICheckResult;
import com.sap.aii.util.misc.api.Message;
import com.sap.aii.util.misc.api.MessageList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CheckResult
implements ICheckResult,
Serializable {
    private static final long serialVersionUID = 42L;
    private List checkMessages = new ArrayList();

    public void append(ICheckResult checkResult) {
        int i = 0;
        while (i < checkResult.size()) {
            CheckMessage msg = checkResult.get(i);
            this.append(msg);
            ++i;
        }
    }

    public void append(CheckMessage checkMessage) {
        this.checkMessages.add(checkMessage);
    }

    public void addHeadline(BabelMessage headline) {
        CheckMessage msg = new CheckMessage((Message)headline, CheckMessage.HEADLINE_LEVEL);
        this.checkMessages.add(0, msg);
    }

    public int size() {
        return this.checkMessages.size();
    }

    public CheckMessage get(int i) {
        return (CheckMessage)this.checkMessages.get(i);
    }

    public Level getMaxSeverity() {
        Level maxSeverity = CheckMessage.HEADLINE_LEVEL;
        int i = 0;
        while (i < this.checkMessages.size()) {
            Level level = this.get(i).getSeverity();
            if (maxSeverity.compareTo(level) < 0) {
                maxSeverity = level;
            }
            ++i;
        }
        return maxSeverity;
    }

    public boolean hasAtLeastSeverity(Level minLevel) {
        int i = 0;
        while (i < this.checkMessages.size()) {
            Level level = this.get(i).getSeverity();
            if (minLevel.compareTo(level) <= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public MessageList getMessageList() {
        MessageList mainList = new MessageList();
        MessageList bulletedList = null;
        int i = 0;
        while (i < this.checkMessages.size()) {
            CheckMessage msg = this.get(i);
            if (msg.isHeadline()) {
                if (bulletedList != null) {
                    mainList.add(bulletedList);
                    bulletedList = null;
                }
                mainList.add(msg);
            } else {
                if (bulletedList == null) {
                    bulletedList = new MessageList(2);
                }
                bulletedList.add(msg);
            }
            ++i;
        }
        if (bulletedList != null) {
            mainList.add(bulletedList);
        }
        return mainList;
    }
}

