/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.misc.api;

import com.sap.aii.util.log.api.Level;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.misc.api.AbstractMessage;
import com.sap.aii.util.misc.api.InteractionMap;
import com.sap.aii.util.misc.api.StringUtil;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class BabelMessage
extends AbstractMessage {
    private static final long serialVersionUID = 42L;
    private static boolean INITIALIZED_BABELLOG = false;
    private String messageId;
    private String resourceBundleName;
    private String resourceBundleKey;
    private Object[] args;
    protected static Map bundles = Collections.synchronizedMap(new HashMap());
    private static Localizer localizer;
    private static char START_QUARK;
    private static char END_QUARK;

    public static void setLocalizer(Localizer l) {
        localizer = l;
    }

    public static String createString(String resourceID) {
        return new BabelMessage(resourceID).toString(null);
    }

    public static String createString(String resourceID, Object arg0) {
        return new BabelMessage(resourceID, arg0).toString(null);
    }

    public static String createString(String resourceID, Object arg0, Object arg1) {
        return new BabelMessage(resourceID, arg0, arg1).toString(null);
    }

    public static String createString(String resourceID, Object arg0, Object arg1, Object arg2) {
        return new BabelMessage(resourceID, arg0, arg1, arg2).toString(null);
    }

    public static String createString(String resourceID, Object[] args) {
        return new BabelMessage(resourceID, args).toString(null);
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getResourceId() {
        if (this.resourceBundleName != null && this.resourceBundleKey != null) {
            return this.resourceBundleName + "." + this.resourceBundleKey;
        }
        return null;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public String getResourceBundleKey() {
        if (this.resourceBundleName != null) {
            return this.resourceBundleKey;
        }
        return null;
    }

    private void init(String resourceId) {
        if (resourceId == null) {
            throw new IllegalArgumentException("Resource ID was null.");
        }
        int i = resourceId.lastIndexOf(46);
        if (i < 1) {
            throw new IllegalArgumentException("Resource ID has not the format ResourceBundleName.ResourceBundleKey");
        }
        this.messageId = resourceId;
        this.resourceBundleName = resourceId.substring(0, i);
        this.resourceBundleKey = resourceId.substring(i + 1, resourceId.length());
    }

    public String localize(Locale loc) {
        return this.toString(loc);
    }

    public void finallyLocalize(Locale loc) {
        String text = this.toString(loc);
        this.resourceBundleName = null;
        this.resourceBundleKey = text;
    }

    public static BabelMessage createFromString(String text) {
        BabelMessage bm = new BabelMessage();
        bm.resourceBundleKey = text;
        return bm;
    }

    public String toString(Locale loc) {
        if (this.resourceBundleName != null) {
            if (loc == null) {
                loc = BabelMessage.getLocale();
            }
            try {
                String message;
                ResourceBundle rb = this.getBundle(this.resourceBundleName, loc);
                if (rb != null && (message = rb.getString(this.resourceBundleKey)) != null) {
                    if (this.args != null) {
                        MessageFormat mf = new MessageFormat("");
                        mf.setLocale(loc);
                        mf.applyPattern(message);
                        message = mf.format(this.args);
                    }
                    BabelMessage.babelLog(this.resourceBundleName, this.resourceBundleKey, message);
                    return message;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return this.resourceBundleKey != null ? this.resourceBundleKey : "";
    }

    public String toHTML(Locale loc, InteractionMap imap) {
        int spaceHint;
        String message = null;
        if (this.resourceBundleName != null) {
            if (loc == null) {
                loc = BabelMessage.getLocale();
            }
            try {
                ResourceBundle rb = this.getBundle(this.resourceBundleName, loc);
                if (rb != null && (message = rb.getString(this.resourceBundleKey)) != null) {
                    spaceHint = message.length() + (this.args == null ? 0 : this.args.length * 2);
                    message = BabelMessage.insertQuarks(message, spaceHint);
                    if (this.args != null) {
                        MessageFormat mf = new MessageFormat("");
                        mf.setLocale(loc);
                        mf.applyPattern(message);
                        message = mf.format(this.args);
                    }
                }
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        if (message == null) {
            message = this.resourceBundleKey != null ? this.resourceBundleKey : "";
        }
        message = StringUtil.escapeXMLChars(message);
        spaceHint = message.length() + (this.args == null ? 0 : this.args.length * 5);
        message = BabelMessage.replaceQuarks(message, spaceHint);
        BabelMessage.babelLog(this.resourceBundleName, this.resourceBundleKey, message);
        return message;
    }

    private static String insertQuarks(String s, int spaceHint) {
        StringBuffer buf = new StringBuffer(spaceHint);
        int level = 0;
        int length = s.length();
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            if (c == '{') {
                if (level == 0) {
                    buf.append(START_QUARK);
                }
                ++level;
            }
            buf.append(c);
            if (c == '}' && --level == 0) {
                buf.append(END_QUARK);
            }
            ++i;
        }
        return buf.toString();
    }

    private static String replaceQuarks(String s, int spaceHint) {
        StringBuffer buf = new StringBuffer(spaceHint);
        int length = s.length();
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            if (c == START_QUARK) {
                buf.append("<b>");
            } else if (c == END_QUARK) {
                buf.append("</b>");
            } else {
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }

    protected BabelMessage() {
    }

    public BabelMessage(String resourceId) {
        this.init(resourceId);
    }

    public BabelMessage(String resourceId, Object[] args) {
        this.init(resourceId);
        this.args = args;
    }

    public BabelMessage(String resourceId, int arg0) {
        this(resourceId, BabelMessage.toObjectArray(arg0));
    }

    public BabelMessage(String resourceId, Object arg0) {
        this(resourceId, BabelMessage.toObjectArray(arg0));
    }

    public BabelMessage(String resourceId, Object arg0, Object arg1) {
        this(resourceId, BabelMessage.toObjectArray(arg0, arg1));
    }

    public BabelMessage(String resourceId, Object arg0, Object arg1, Object arg2) {
        this(resourceId, BabelMessage.toObjectArray(arg0, arg1, arg2));
    }

    public BabelMessage(String resourceId, int arg0, int arg1) {
        this(resourceId, BabelMessage.toObjectArray(arg0, arg1));
    }

    public BabelMessage(String resourceId, Object arg0, int arg1) {
        this(resourceId, BabelMessage.toObjectArray(arg0, arg1));
    }

    public BabelMessage(String resourceId, int arg0, Object arg1) {
        this(resourceId, BabelMessage.toObjectArray(arg0, arg1));
    }

    public BabelMessage(String resourceId, int arg0, int arg1, int arg2) {
        this(resourceId, BabelMessage.toObjectArray(arg0, arg1, arg2));
    }

    public BabelMessage(String resourceId, Object arg0, int arg1, int arg2) {
        this(resourceId, BabelMessage.toObjectArray(arg0, arg1, arg2));
    }

    public BabelMessage(String resourceId, int arg0, Object arg1, int arg2) {
        this(resourceId, BabelMessage.toObjectArray(arg0, arg1, arg2));
    }

    public BabelMessage(String resourceId, Object arg0, Object arg1, int arg2) {
        this(resourceId, BabelMessage.toObjectArray(arg0, arg1, arg2));
    }

    public BabelMessage(String resourceId, int arg0, int arg1, Object arg2) {
        this(resourceId, BabelMessage.toObjectArray(arg0, arg1, arg2));
    }

    public BabelMessage(String resourceId, Object arg0, int arg1, Object arg2) {
        this(resourceId, BabelMessage.toObjectArray(arg0, arg1, arg2));
    }

    public BabelMessage(String resourceId, int arg0, Object arg1, Object arg2) {
        this(resourceId, BabelMessage.toObjectArray(arg0, arg1, arg2));
    }

    private static Object[] toObjectArray(int arg0) {
        return new Object[]{new Integer(arg0)};
    }

    private static Object[] toObjectArray(Object arg0) {
        return new Object[]{arg0};
    }

    private static Object[] toObjectArray(int arg0, int arg1) {
        return new Object[]{new Integer(arg0), new Integer(arg1)};
    }

    private static Object[] toObjectArray(Object arg0, int arg1) {
        return new Object[]{arg0, new Integer(arg1)};
    }

    private static Object[] toObjectArray(int arg0, Object arg1) {
        return new Object[]{new Integer(arg0), arg1};
    }

    private static Object[] toObjectArray(Object arg0, Object arg1) {
        return new Object[]{arg0, arg1};
    }

    private static Object[] toObjectArray(int arg0, int arg1, int arg2) {
        return new Object[]{new Integer(arg0), new Integer(arg1), new Integer(arg2)};
    }

    private static Object[] toObjectArray(Object arg0, int arg1, int arg2) {
        return new Object[]{arg0, new Integer(arg1), new Integer(arg2)};
    }

    private static Object[] toObjectArray(int arg0, Object arg1, int arg2) {
        return new Object[]{new Integer(arg0), arg1, new Integer(arg2)};
    }

    private static Object[] toObjectArray(Object arg0, Object arg1, int arg2) {
        return new Object[]{arg0, arg1, new Integer(arg2)};
    }

    private static Object[] toObjectArray(int arg0, int arg1, Object arg2) {
        return new Object[]{new Integer(arg0), new Integer(arg1), arg2};
    }

    private static Object[] toObjectArray(Object arg0, int arg1, Object arg2) {
        return new Object[]{arg0, new Integer(arg1), arg2};
    }

    private static Object[] toObjectArray(int arg0, Object arg1, Object arg2) {
        return new Object[]{new Integer(arg0), arg1, arg2};
    }

    private static Object[] toObjectArray(Object arg0, Object arg1, Object arg2) {
        return new Object[]{arg0, arg1, arg2};
    }

    public static Locale getLocale() {
        if (localizer != null) {
            return localizer.getLocale();
        }
        return Locale.getDefault();
    }

    private ResourceBundle getBundle(String name, Locale l) {
        String key = name + "%" + l;
        if (bundles.containsKey(key)) {
            return (ResourceBundle)bundles.get(key);
        }
        ResourceBundle rb = ResourceBundle.getBundle(name, l);
        bundles.put(key, rb);
        return rb;
    }

    protected static void babelLog(String resourceBundleName, String resourceBundleKey, String message) {
        if (!INITIALIZED_BABELLOG) {
            Logger.getLogger("BabelLog").setUseParentHandlers(false);
            INITIALIZED_BABELLOG = true;
        }
        Logger log = Logger.getLogger("BabelLog." + resourceBundleName);
        log.log(Level.FINEST, resourceBundleKey + "=" + message);
    }

    static {
        START_QUARK = (char)65534;
        END_QUARK = (char)65535;
        char c = '\u0001';
        while (c < '\ufffe') {
            if (!Character.isDefined(c)) {
                if (START_QUARK == '\ufffe') {
                    START_QUARK = c;
                } else {
                    END_QUARK = c;
                    break;
                }
            }
            c = (char)(c + '\u0001');
        }
    }

    public static interface Localizer {
        public Locale getLocale();
    }
}

