/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.log.impl;

import com.sap.aii.util.log.api.Level;
import com.sap.aii.util.log.api.LogUtil;
import com.sap.aii.util.log.api.SimpleLog;
import com.sap.aii.util.log.impl.AIILogFactoryImpl;
import com.sap.aii.util.log.impl.AsyncHandler;
import com.sap.aii.util.log.impl.ConsoleHandler;
import com.sap.aii.util.log.impl.DefaultFormatter;
import com.sap.aii.util.log.impl.FileHandler;
import com.sap.aii.util.log.impl.Handler;
import com.sap.aii.util.log.impl.LoggerImpl;
import com.sap.aii.util.log.impl.MemLogHandler;
import com.sap.aii.util.log.impl.PatternFormatter;
import com.sap.aii.util.log.impl.PipedHandler;
import com.sap.aii.util.log.impl.SimpleFormatter;
import com.sap.aii.util.log.impl.SocketHandler;
import com.sap.aii.util.misc.api.IOUtil;
import com.sap.aii.util.misc.api.StringUtil;
import com.sap.aii.util.misc.api.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public class PropertiesConfigurator {
    private static final String CONFIG_FILE = "log.properties";
    private static final String SYSTEM_DIR = "com.sap.systemdir";
    public static final String PROP_INTERNAL_DEBUG = "log.internalDebug";
    public static final String PROP_INTERNAL_INFO = "log.internalInfo";
    public static final String PROP_STACKTRACE_MODE = "log.stacktraceMode";
    public static final String PROP_USE_FILE = "log.useDefaultFile";
    public static final String PROP_CREATE_FILE = "log.createDefaultFile";
    public static final String PROP_INITIAL_CONFIG = "log.initialConfiguration";
    private static final String CONFIG_MODE_NONE = "none";
    private static final String CONFIG_MODE_FILE = "file";
    private static final String CONFIG_MODE_SYSTEM = "system";
    private static final String CONFIG_MODE_DEFAULT = "default";
    private static final String CONFIG_MODE_SIMPLE = "simple";
    private static final String DEFAULT_CONFIGURATION = "file,default";
    private static File configurationFile = null;
    static /* synthetic */ Class class$com$sap$aii$util$log$api$Logger;
    static /* synthetic */ Class class$java$lang$String;

    public static void clearAll() {
        Iterator i = LoggerImpl.categoryMap.keySet().iterator();
        while (i.hasNext()) {
            LoggerImpl l = (LoggerImpl)LoggerImpl.categoryMap.get((String)i.next());
            l.removeAllHandlers();
            l.setLevel(null);
        }
    }

    public static void resetAll() {
        PropertiesConfigurator.clearAll();
        PropertiesConfigurator.init();
    }

    public static Properties getDefaultConfiguration() {
        return PropertiesConfigurator.readInternalProperties(CONFIG_MODE_DEFAULT);
    }

    public static Properties getSimpleConfiguration(Level level) {
        Properties props = PropertiesConfigurator.readInternalProperties(CONFIG_MODE_SIMPLE);
        if (level == null) {
            level = Level.ERROR;
        }
        props.setProperty("log.handler.RootConsole.level", level.getName());
        return props;
    }

    private static Properties getSubProperties(Properties prop, String prefix) {
        Properties newProp = new Properties();
        int len = prefix.length();
        Enumeration<?> e = prop.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith(prefix)) continue;
            String value = prop.getProperty(name);
            name = name.length() > len ? name.substring(len) : "";
            newProp.setProperty(name, value);
        }
        return newProp;
    }

    private static Properties readInternalProperties(String name) {
        Properties props = new Properties();
        ClassLoader loader = (class$com$sap$aii$util$log$api$Logger == null ? (class$com$sap$aii$util$log$api$Logger = PropertiesConfigurator.class$("com.sap.aii.util.log.api.Logger")) : class$com$sap$aii$util$log$api$Logger).getClassLoader();
        try {
            InputStream in = loader.getResourceAsStream("com/sap/aii/util/log/impl/" + name + ".properties");
            props.load(in);
            in.close();
        }
        catch (Exception e) {
            SimpleLog.error("error reading internal file " + name + ".properties (" + e.getClass().getName() + ": " + e.getMessage() + ")");
        }
        return props;
    }

    public static File getConfigurationFile() {
        if (configurationFile == null) {
            configurationFile = PropertiesConfigurator.initConfigurationFile();
        }
        return configurationFile;
    }

    private static File initConfigurationFile() {
        File systemFile;
        File file = PropertiesConfigurator.getLocalConfigurationFile();
        if (!IOUtil.isFileReadable(file) && (systemFile = PropertiesConfigurator.getSystemConfigurationFile()) != null) {
            file = systemFile;
        }
        return file;
    }

    public static File getLocalConfigurationFile() {
        return new File(CONFIG_FILE);
    }

    public static File getSystemConfigurationFile() {
        String systemDir = PropertiesConfigurator.getSystemProperty(SYSTEM_DIR, null);
        return systemDir != null ? new File(systemDir, CONFIG_FILE) : null;
    }

    public static void configure(Properties props) {
        String name;
        String value = props.getProperty(PROP_INTERNAL_DEBUG);
        if (value != null) {
            PropertiesConfigurator.setInternalDebug(Boolean.valueOf(value));
        }
        if ((value = props.getProperty(PROP_INTERNAL_INFO)) != null) {
            PropertiesConfigurator.setInternalInfo(Boolean.valueOf(value));
        }
        if ((value = props.getProperty(PROP_STACKTRACE_MODE)) != null) {
            if (value.equals("always")) {
                LogUtil.setStacktraceMode(0);
            }
            if (value.equals("never")) {
                LogUtil.setStacktraceMode(2);
            }
            if (value.equals("runtime")) {
                LogUtil.setStacktraceMode(1);
            }
        }
        Properties handlerProp = PropertiesConfigurator.getSubProperties(props, "log.handler.");
        Enumeration<?> e = handlerProp.propertyNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            value = handlerProp.getProperty(name);
            SimpleLog.debug("configure Handler: " + name + "=" + value);
            if (StringUtil.contains(name, '.')) continue;
            Handler handler = null;
            StringTokenizer tok = new StringTokenizer(value, " ,");
            if (tok.hasMoreTokens()) {
                String handlerClass = tok.nextToken();
                if (handlerClass.equals("ConsoleHandler")) {
                    boolean async = false;
                    while (tok.hasMoreTokens()) {
                        String flag = tok.nextToken();
                        if (!flag.equalsIgnoreCase("async")) continue;
                        async = true;
                    }
                    if (async) {
                        handler = new AsyncHandler(name);
                        ((PipedHandler)handler).addHandler(new ConsoleHandler());
                    } else {
                        handler = new ConsoleHandler(name);
                    }
                    SimpleLog.debug("   new ConsoleHandler \"" + name + "\" async=" + async);
                } else if (handlerClass.equals("MemoryHandler")) {
                    int size = Util.parseIntDefault(tok.nextToken(), 100);
                    handler = new MemLogHandler(name, size);
                    SimpleLog.info(">>> MemoryHandler has been replaced by MemLogHandler! Please change your configuration properties. <<<");
                    SimpleLog.debug("   new MemLogHandler \"" + name + "\" size=" + size);
                } else if (handlerClass.equals("MemLogHandler")) {
                    int size = Util.parseIntDefault(tok.nextToken(), 100);
                    handler = new MemLogHandler(name, size);
                    SimpleLog.debug("   new MemLogHandler \"" + name + "\" size=" + size);
                } else if (handlerClass.equals("SocketHandler")) {
                    String host = tok.nextToken();
                    int port = Util.parseIntDefault(tok.nextToken(), 100);
                    try {
                        handler = new SocketHandler(name, host, port);
                        SimpleLog.debug("   new SocketHandler \"" + name + "\" host=" + host + " port=" + port);
                    }
                    catch (IOException ex) {
                        SimpleLog.error("cannot create SocketHandler \"" + name + "\" host=" + host + " port=" + port, ex);
                    }
                } else if (handlerClass.equals("FileHandler")) {
                    String file = "log.txt";
                    boolean append = false;
                    boolean async = false;
                    if (tok.hasMoreTokens()) {
                        file = tok.nextToken();
                    }
                    while (tok.hasMoreTokens()) {
                        String flag = tok.nextToken();
                        if (flag.equalsIgnoreCase("append")) {
                            append = true;
                            continue;
                        }
                        if (!flag.equalsIgnoreCase("async")) continue;
                        async = true;
                    }
                    try {
                        if (async) {
                            handler = new AsyncHandler(name);
                            ((AsyncHandler)handler).addHandler(new FileHandler(null, file, append));
                        } else {
                            handler = new FileHandler(name, file, append);
                        }
                        SimpleLog.debug("   new FileHandler \"" + name + "\" file=" + file + " append=" + append + " async=" + async);
                    }
                    catch (IOException ex) {
                        SimpleLog.error("cannot create FileHandler \"" + name + "\" file=" + file, ex);
                    }
                } else {
                    try {
                        Class<?> c = Class.forName(handlerClass);
                        try {
                            Constructor<?> constr = c.getConstructor(class$java$lang$String == null ? PropertiesConfigurator.class$("java.lang.String") : class$java$lang$String);
                            handler = (Handler)constr.newInstance(name);
                        }
                        catch (NoSuchMethodException ex) {
                            SimpleLog.error("Handler class \"" + handlerClass + "\" has no (String) constructor.");
                        }
                    }
                    catch (ClassNotFoundException ex) {
                        SimpleLog.error("Handler \"" + handlerClass + "\" not found.");
                    }
                    catch (Exception ex) {
                        SimpleLog.error("Exception while creating Handler \"" + handlerClass + "\".", ex);
                    }
                }
            }
            if (handler == null || name == null) continue;
            Properties subProp = PropertiesConfigurator.getSubProperties(handlerProp, name + ".");
            Enumeration<?> e2 = subProp.propertyNames();
            while (e2.hasMoreElements()) {
                String n = (String)e2.nextElement();
                String v = subProp.getProperty(n);
                if (n.equals("level")) {
                    handler.setLevel(Level.getLevel(v));
                    continue;
                }
                if (!n.equals("format")) continue;
                if (v.equals("SIMPLE")) {
                    handler.setFormatter(new SimpleFormatter());
                    continue;
                }
                if (v.equals("DEFAULT")) {
                    handler.setFormatter(new DefaultFormatter());
                    continue;
                }
                handler.setFormatter(new PatternFormatter(v));
            }
        }
        Properties logProp = PropertiesConfigurator.getSubProperties(props, "log.logger.");
        e = logProp.propertyNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            value = logProp.getProperty(name);
            SimpleLog.debug("configure Logger: " + name + "=" + value);
            LoggerImpl logger = (LoggerImpl)AIILogFactoryImpl.getInstance().getLogger(name);
            StringTokenizer tok = new StringTokenizer(value, " ,");
            if (tok.hasMoreTokens()) {
                String levelName = tok.nextToken();
                Level level = Level.getLevel(levelName);
                if (level == null) {
                    SimpleLog.error("unknown Level \"" + levelName + "\" in configuration");
                } else {
                    logger.setLevel(level);
                    SimpleLog.debug("   setLevel=" + logger.getLevel());
                }
            }
            while (tok.hasMoreTokens()) {
                String t = tok.nextToken();
                Handler h = Handler.getHandler(t);
                if (h != null) {
                    logger.addHandler(h);
                    SimpleLog.debug("   addHandler=" + t);
                    continue;
                }
                SimpleLog.error("Handler \"" + t + "\" not found");
            }
        }
    }

    private static String getSystemProperty(String name, String defaultValue) {
        String value = System.getProperty("jnlp." + name);
        if (value == null) {
            try {
                value = System.getProperty(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value != null ? value : defaultValue;
    }

    private static boolean getSystemPropertyBoolean(String name, boolean defaultValue) {
        String value = PropertiesConfigurator.getSystemProperty(name, null);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return defaultValue;
    }

    static void init() {
        boolean useDefaultFile = PropertiesConfigurator.getSystemPropertyBoolean(PROP_USE_FILE, true);
        boolean createDefaultFile = PropertiesConfigurator.getSystemPropertyBoolean(PROP_CREATE_FILE, false);
        boolean fileNotFound = false;
        String mode = PropertiesConfigurator.getSystemProperty(PROP_INITIAL_CONFIG, DEFAULT_CONFIGURATION);
        StringTokenizer tokenizer = new StringTokenizer(mode, ",");
        Properties props = new Properties();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token.equalsIgnoreCase(CONFIG_MODE_NONE)) break;
            if (token.equalsIgnoreCase(CONFIG_MODE_SYSTEM)) {
                SimpleLog.info("using system properties for log configuration");
                ((Hashtable)props).putAll(System.getProperties());
                break;
            }
            if (token.equalsIgnoreCase(CONFIG_MODE_DEFAULT)) {
                SimpleLog.info("using default log configuration");
                ((Hashtable)props).putAll(PropertiesConfigurator.getDefaultConfiguration());
                break;
            }
            if (token.equalsIgnoreCase(CONFIG_MODE_SIMPLE)) {
                SimpleLog.info("using simple log configuration");
                ((Hashtable)props).putAll(PropertiesConfigurator.getSimpleConfiguration(null));
                break;
            }
            if (token.equalsIgnoreCase(CONFIG_MODE_FILE)) {
                try {
                    if (!useDefaultFile) continue;
                    File file = PropertiesConfigurator.getConfigurationFile();
                    if (IOUtil.isFileReadable(file)) {
                        FileInputStream in = new FileInputStream(file);
                        SimpleLog.info("reading log configuration from \"" + IOUtil.getFileName(file) + "\"");
                        props.load(in);
                        ((InputStream)in).close();
                        break;
                    }
                    SimpleLog.info("log configuration file \"" + IOUtil.getFileName(file) + "\" could not be read");
                    fileNotFound = true;
                }
                catch (Exception ex) {
                    SimpleLog.error("error during log configuration", ex);
                }
                continue;
            }
            SimpleLog.error("error during log configuration - unknown mode: " + token);
            break;
        }
        PropertiesConfigurator.configure(props);
        if (fileNotFound && createDefaultFile) {
            PropertiesConfigurator.writeDefaultPropertiesFile(props);
        }
    }

    public static boolean writeDefaultPropertiesFile(Properties props) {
        File file = PropertiesConfigurator.getConfigurationFile();
        try {
            FileOutputStream out = new FileOutputStream(file);
            props.store(out, "Logging Properties");
            ((OutputStream)out).close();
            return true;
        }
        catch (Exception e) {
            SimpleLog.error("failed writing default properties: " + IOUtil.getFileName(file));
            return false;
        }
    }

    public static void setInternalDebug(boolean x) {
        SimpleLog.setDebug(x);
    }

    public static void setInternalInfo(boolean x) {
        SimpleLog.setInfo(x);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

