/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.log.impl;

import com.sap.aii.util.log.api.LogUtil;
import com.sap.aii.util.log.impl.AIILogFactoryImpl;
import com.sap.aii.util.log.impl.Formatter;
import com.sap.aii.util.log.impl.LogRecord;
import java.text.DateFormat;

public class PatternFormatter
extends Formatter {
    private static final DateFormat dateFormat = DateFormat.getDateInstance(2);
    private static final DateFormat timeFormat = DateFormat.getTimeInstance(2);
    private static Runtime runtime = Runtime.getRuntime();
    private String pattern;
    private static final long SIZE_10KB = 10240L;
    private static final long SIZE_10MB = 0xA00000L;
    private static final long SIZE_10GB = 0x280000000L;
    private static final long SIZE_10TB = 0xA0000000000L;

    public static String formatMemSize(long size) {
        if (size < 10240L) {
            return Long.toString(size);
        }
        if (size < 0xA00000L) {
            return Long.toString(size >> 10) + "k";
        }
        if (size < 0x280000000L) {
            return Long.toString(size >> 20) + "M";
        }
        if (size < 0xA0000000000L) {
            return Long.toString(size >> 30) + "G";
        }
        return Long.toString(size >> 40) + "T";
    }

    public PatternFormatter(String pattern) {
        this.pattern = pattern;
    }

    public String format(LogRecord rec) {
        StringBuffer sb = new StringBuffer();
        int len = this.pattern.length();
        int pos = 0;
        int next = this.pattern.indexOf(37);
        while (next > -1) {
            if (next > pos) {
                sb.append(this.pattern.substring(pos, next));
            }
            if (++next < len) {
                switch (this.pattern.charAt(next)) {
                    case 'm': {
                        sb.append(rec.getMessage());
                        break;
                    }
                    case 'C': {
                        sb.append(rec.getLoggerName());
                        break;
                    }
                    case 'l': {
                        sb.append(rec.getLevel());
                        break;
                    }
                    case 'n': {
                        sb.append(rec.getSequenceNumber());
                        break;
                    }
                    case 'd': {
                        sb.append(dateFormat.format(rec.getDate()));
                        break;
                    }
                    case 't': {
                        sb.append(timeFormat.format(rec.getDate()));
                        break;
                    }
                    case 's': {
                        sb.append(rec.getMillis());
                        break;
                    }
                    case 'T': {
                        sb.append(rec.getThreadName());
                        break;
                    }
                    case 'c': {
                        sb.append(rec.getLogger().getShortName());
                        break;
                    }
                    case 'x': {
                        Throwable t = rec.getThrown();
                        if (t == null) break;
                        sb.append(LogUtil.formatThrowable(t));
                        break;
                    }
                    case '%': {
                        sb.append('%');
                        break;
                    }
                    case 'u': {
                        sb.append(AIILogFactoryImpl.logContext.getCurrentUser());
                        break;
                    }
                    case 'F': {
                        sb.append(runtime.freeMemory());
                        break;
                    }
                    case 'f': {
                        sb.append(PatternFormatter.formatMemSize(runtime.freeMemory()));
                        break;
                    }
                    case 'Y': {
                        sb.append(runtime.totalMemory() - runtime.freeMemory());
                        break;
                    }
                    case 'y': {
                        sb.append(PatternFormatter.formatMemSize(runtime.totalMemory() - runtime.freeMemory()));
                        break;
                    }
                    case 'Z': {
                        sb.append(runtime.totalMemory());
                        break;
                    }
                    case 'z': {
                        sb.append(PatternFormatter.formatMemSize(runtime.totalMemory()));
                    }
                }
            }
            pos = next + 1;
            next = this.pattern.indexOf(37, pos);
        }
        if (pos < len) {
            sb.append(this.pattern.substring(pos));
        }
        return sb.toString();
    }
}

