/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.log.api;

import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.log.api.SimpleLog;
import com.sap.aii.util.misc.api.ClientServerException;
import com.sap.aii.util.misc.api.IBaseException;
import com.sap.aii.util.misc.api.ServerExceptionInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;

public class LogUtil {
    private static String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final int STACKTRACE_ALWAYS = 0;
    public static final int STACKTRACE_RUNTIME = 1;
    public static final int STACKTRACE_NEVER = 2;
    private static int stacktraceMode = 0;

    public static int getStacktraceMode() {
        return stacktraceMode;
    }

    public static void setStacktraceMode(int mode) {
        stacktraceMode = mode;
    }

    public static String formatThrowable(Throwable t) {
        try {
            StringBuffer buf = new StringBuffer("Thrown:" + LINE_SEPARATOR);
            LogUtil.formatThrowable(t, buf);
            return buf.toString();
        }
        catch (Error e) {
            SimpleLog.error("Unexpected Error during Trace output");
            return "";
        }
    }

    private static void formatThrowable(Throwable t, StringBuffer buf) {
        if (t instanceof IBaseException) {
            buf.append("MESSAGE ID: ");
            buf.append(((IBaseException)((Object)t)).getErrorCode());
            buf.append(LINE_SEPARATOR);
        }
        buf.append(t.getClass().getName());
        buf.append(": ");
        if (t instanceof IBaseException) {
            buf.append(((IBaseException)((Object)t)).getMessage(Logger.DEFAULT_LOCALE));
        } else {
            buf.append(t.getMessage());
        }
        buf.append(LINE_SEPARATOR);
        switch (stacktraceMode) {
            case 2: {
                break;
            }
            case 1: {
                if (!(t instanceof RuntimeException)) break;
            }
            default: {
                buf.append(LogUtil.formatStackTrace(t));
            }
        }
        if (t instanceof ClientServerException) {
            buf.append("Serialized server exceptions:" + LINE_SEPARATOR);
            LogUtil.formatServerExceptionInfoList((ClientServerException)t, buf);
        }
        Throwable innerT = null;
        if (t instanceof IBaseException) {
            innerT = ((IBaseException)((Object)t)).getRootCause();
        } else if (t instanceof RemoteException) {
            innerT = ((RemoteException)t).detail;
        }
        if (innerT != null) {
            buf.append("Root cause:" + LINE_SEPARATOR);
            LogUtil.formatThrowable(innerT, buf);
        }
    }

    private static void formatServerExceptionInfoList(ClientServerException clientServerException, StringBuffer buf) {
        List serverExceptionInfos = clientServerException.getNestedInformation();
        Iterator iter = serverExceptionInfos.iterator();
        while (iter.hasNext()) {
            ServerExceptionInfo exceptionInfo = (ServerExceptionInfo)iter.next();
            buf.append("MESSAGE ID: " + exceptionInfo.getErrorCode() + " (serialized)" + LINE_SEPARATOR);
            buf.append(exceptionInfo.getExceptionName() + ": " + exceptionInfo.getMessage(Logger.DEFAULT_LOCALE) + LINE_SEPARATOR);
            buf.append(LogUtil.formatStackTrace(exceptionInfo.getStackTrace()) + LINE_SEPARATOR);
        }
    }

    private static String formatStackTrace(String stacktrace) {
        int i = stacktrace.indexOf("\n");
        if (i < 0) {
            return stacktrace;
        }
        return stacktrace.substring(i + 1);
    }

    private static String formatStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        pw.close();
        String s = sw.toString();
        int i = s.indexOf("\n");
        if (i < 0) {
            return s;
        }
        return s.substring(i + 1);
    }
}

