/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.hmi.core.msg;

import com.sap.aii.util.applcomp.ApplCompLevel;
import com.sap.aii.util.hmi.api.HmiCoreException;
import com.sap.aii.util.hmi.api.HmiMethodInput;
import com.sap.aii.util.hmi.api.UriElement;
import com.sap.aii.util.hmi.core.gdi2.GdiCharStreamer;
import com.sap.aii.util.hmi.core.gdi2.GdiForPrimitives;
import com.sap.aii.util.hmi.core.gdi2.GenericAttributeMultivalue;
import com.sap.aii.util.hmi.core.gdi2.GenericAttributes;
import com.sap.aii.util.hmi.core.gdi2.GenericDataInstance;
import com.sap.aii.util.hmi.core.gdi2.GenericallyRepresentable;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.misc.api.GUIDFactory;
import com.sap.aii.util.misc.api.HelperFunctions;
import com.sap.aii.util.misc.api.Language;
import com.sap.guid.IGUID;

public class HmiRequest
implements GenericallyRepresentable {
    private static final Logger sLogger = Logger.getLogger((class$com$sap$aii$util$hmi$api$HmiClientFactory == null ? (class$com$sap$aii$util$hmi$api$HmiClientFactory = HmiRequest.class$("com.sap.aii.util.hmi.api.HmiClientFactory")) : class$com$sap$aii$util$hmi$api$HmiClientFactory).getName());
    private IGUID iRequestId;
    private boolean iRequiresSession;
    private UriElement iServiceId;
    private UriElement iMethodId;
    private HmiMethodInput iMethodInput;
    private String iServerLogicalSystemName;
    private String iServerApplicationId;
    private IGUID iClientId;
    private ApplCompLevel iClientLevel;
    private String iClientUser;
    private String iClientPassword;
    private Language iClientLanguage;
    private int iControlFlag;
    private String iHmiSpecVersion;
    private static String[] sAttributeNames = new String[]{"RequestId", "RequiresSession", "ServiceId", "MethodId", "MethodInput", "ServerLogicalSystemName", "ServerApplicationId", "ClientId", "ClientLevel", "ClientUser", "ClientPassword", "ClientLanguage", "ControlFlag", "HmiSpecVersion"};
    static /* synthetic */ Class class$com$sap$aii$util$hmi$api$HmiClientFactory;

    private HmiRequest(IGUID aRequestId, boolean aRequiresSession, UriElement aServiceId, UriElement aMethodId, HmiMethodInput aMethodInput, String aServerLogicalSystemName, String aServerApplicationId, IGUID aClientId, ApplCompLevel aClientLevel, String aClientUser, String aClientPassword, Language aClientLanguage, int aControlFlag) throws HmiCoreException {
        this.iRequestId = aRequestId;
        this.iRequiresSession = aRequiresSession;
        this.iServiceId = aServiceId;
        this.iMethodId = aMethodId;
        this.iMethodInput = aMethodInput;
        this.iServerLogicalSystemName = aServerLogicalSystemName;
        this.iServerApplicationId = aServerApplicationId;
        this.iClientId = aClientId;
        this.iClientLevel = aClientLevel;
        this.iClientUser = aClientUser;
        this.iClientPassword = "dummy";
        this.iClientLanguage = aClientLanguage;
        this.iControlFlag = aControlFlag;
        this.iHmiSpecVersion = "1.0";
    }

    public static HmiRequest createRequest(boolean aRequiresSession, UriElement aServiceId, UriElement aMethodId, HmiMethodInput aMethodInput, String aServerLogicalSystemName, String aServerApplicationId, IGUID aClientId, ApplCompLevel aClientLevel, String aClientUser, String aClientPassword, Language aClientLanguage, int aControlFlag) throws HmiCoreException {
        IGUID lRequestId = GUIDFactory.getInstance().createGUID();
        return new HmiRequest(lRequestId, aRequiresSession, aServiceId, aMethodId, aMethodInput, aServerLogicalSystemName, aServerApplicationId, aClientId, aClientLevel, aClientUser, aClientPassword, aClientLanguage, aControlFlag);
    }

    public IGUID getRequestId() {
        return this.iRequestId;
    }

    public boolean getRequiresSession() {
        return this.iRequiresSession;
    }

    public UriElement getServiceId() {
        return this.iServiceId;
    }

    public UriElement getMethodId() {
        return this.iMethodId;
    }

    public HmiMethodInput getMethodInput() {
        return this.iMethodInput;
    }

    public String getServerLogicalSystemName() {
        return this.iServerLogicalSystemName;
    }

    public String getServerApplicationId() {
        return this.iServerApplicationId;
    }

    public IGUID getClientId() {
        return this.iClientId;
    }

    public ApplCompLevel getClientLevel() {
        return this.iClientLevel;
    }

    public String getClientUser() {
        return this.iClientUser;
    }

    public String getClientPassword() {
        return this.iClientPassword;
    }

    public Language getClientLanguage() {
        return this.iClientLanguage;
    }

    public int getControlFlag() {
        return this.iControlFlag;
    }

    public String getHmiSpecVersion() {
        return this.iHmiSpecVersion;
    }

    private HmiRequest() {
    }

    public static String render(HmiRequest aRequest) throws HmiCoreException {
        GenericDataInstance lRequestAsGdi = aRequest.getState();
        String lRequestAsString = GdiCharStreamer.gdiToString(lRequestAsGdi);
        return lRequestAsString;
    }

    public static HmiRequest parse(String aRequest) throws HmiCoreException {
        GenericDataInstance lRequestAsGdi = GdiCharStreamer.stringToGdi(aRequest);
        HmiRequest lRequest = new HmiRequest();
        lRequest.setState(lRequestAsGdi);
        return lRequest;
    }

    public void setState(GenericDataInstance aState) throws HmiCoreException {
        try {
            String lRequestId = aState.getAttributes().getValue("RequestId").getString(0);
            this.iRequestId = GUIDFactory.getInstance().parseHexGUID(lRequestId);
            this.iRequiresSession = Boolean.getBoolean(aState.getAttributes().getValue("RequiresSession").getString(0));
            String lServiceId = aState.getAttributes().getValue("ServiceId").getString(0);
            this.iServiceId = UriElement.getInstanceFromUriString(lServiceId);
            String lMethodId = aState.getAttributes().getValue("MethodId").getString(0);
            this.iMethodId = UriElement.getInstanceFromUriString(lMethodId);
            GenericDataInstance lMethodInput = aState.getAttributes().getValue("MethodInput").getGenericDataInstance(0);
            this.iMethodInput = HmiMethodInput.parseGdi(lMethodInput);
            this.iServerLogicalSystemName = aState.getAttributes().getValue("ServerLogicalSystemName").getString(0);
            this.iServerApplicationId = aState.getAttributes().getValue("ServerApplicationId").getString(0);
            String lClientId = aState.getAttributes().getValue("ClientId").getString(0);
            this.iClientId = GUIDFactory.getInstance().parseHexGUID(lClientId);
            GenericDataInstance lClientLevel = aState.getAttributes().getValue("ClientLevel").getGenericDataInstance(0);
            this.iClientLevel = GdiForPrimitives.GdiApplCompLevel.parse(lClientLevel);
            this.iClientUser = aState.getAttributes().getValue("ClientUser").getString(0);
            this.iClientPassword = aState.getAttributes().getValue("ClientPassword").getString(0);
            this.iClientLanguage = new Language(aState.getAttributes().getValue("ClientLanguage").getString(0));
            this.iControlFlag = Integer.parseInt(aState.getAttributes().getValue("ControlFlag").getString(0));
            GenericAttributeMultivalue lHmiSpecVersion = aState.getAttributes().getValue("HmiSpecVersion");
            this.iHmiSpecVersion = lHmiSpecVersion == null ? "1.0" : lHmiSpecVersion.getString(0);
        }
        catch (Exception e) {
            String lMsg = "Unexpected exception!\n" + HelperFunctions.getThrowableAsString(e);
            sLogger.error("Parsing GDI (method setState): " + lMsg);
            throw HmiCoreException.newParsingError(this.getClass().getName(), lMsg);
        }
    }

    public GenericDataInstance getState() throws HmiCoreException {
        try {
            String lRequestIdAsString = this.iRequestId.toHexString();
            GenericAttributeMultivalue lRequestId = new GenericAttributeMultivalue(lRequestIdAsString);
            String lRequiresSessionAsString = String.valueOf(this.iRequiresSession);
            GenericAttributeMultivalue lRequiresSession = new GenericAttributeMultivalue(lRequiresSessionAsString);
            String lServiceIdAsString = this.iServiceId.toString();
            GenericAttributeMultivalue lServiceId = new GenericAttributeMultivalue(lServiceIdAsString);
            String lMethodIdAsString = this.iMethodId.toString();
            GenericAttributeMultivalue lMethodId = new GenericAttributeMultivalue(lMethodIdAsString);
            GenericDataInstance lMethodInputAsGenericDataInstance = HmiMethodInput.renderGdi(this.iMethodInput);
            GenericAttributeMultivalue lMethodInput = new GenericAttributeMultivalue(lMethodInputAsGenericDataInstance);
            GenericAttributeMultivalue lServerLogicalSystemName = new GenericAttributeMultivalue(this.iServerLogicalSystemName);
            GenericAttributeMultivalue lServerApplicationId = new GenericAttributeMultivalue(this.iServerApplicationId);
            String lClientIdAsString = this.iClientId.toHexString();
            GenericAttributeMultivalue lClientId = new GenericAttributeMultivalue(lClientIdAsString);
            GenericDataInstance lClientLevelAsGenericDataInstance = GdiForPrimitives.GdiApplCompLevel.render(this.iClientLevel);
            GenericAttributeMultivalue lClientLevel = new GenericAttributeMultivalue(lClientLevelAsGenericDataInstance);
            GenericAttributeMultivalue lClientUser = new GenericAttributeMultivalue(this.iClientUser);
            GenericAttributeMultivalue lClientPassword = new GenericAttributeMultivalue(this.iClientPassword);
            String lClientLanguageAsString = this.iClientLanguage.toString();
            GenericAttributeMultivalue lClientLanguage = new GenericAttributeMultivalue(lClientLanguageAsString);
            String lControlFlagAsString = String.valueOf(this.iControlFlag);
            GenericAttributeMultivalue lControlFlag = new GenericAttributeMultivalue(lControlFlagAsString);
            GenericAttributeMultivalue lHmiSpecVersion = new GenericAttributeMultivalue(this.iHmiSpecVersion);
            GenericAttributes lAttributes = new GenericAttributes(sAttributeNames, new GenericAttributeMultivalue[]{lRequestId, lRequiresSession, lServiceId, lMethodId, lMethodInput, lServerLogicalSystemName, lServerApplicationId, lClientId, lClientLevel, lClientUser, lClientPassword, lClientLanguage, lControlFlag, lHmiSpecVersion});
            return new GenericDataInstance(this.getClass().getName(), lAttributes);
        }
        catch (Exception e) {
            String lMsg = "Caught unexpected exception:\n" + HelperFunctions.getThrowableAsString(e);
            sLogger.error("Rendering into GDI (method getState): " + lMsg);
            throw HmiCoreException.newRenderingError(this.getClass().getName(), lMsg);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface ControlFlags {
        public static final int None = 0;
        public static final int ClientDestruction = 1;
    }
}

