/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.hmi.core.gdi2;

import com.sap.aii.util.hmi.core.gdi2.GenericAttributeMultivalue;
import com.sap.aii.util.hmi.core.gdi2.GenericAttributes;
import com.sap.aii.util.hmi.core.gdi2.GenericDataInstance;
import com.sap.aii.util.log.api.Level;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.misc.api.AIIProperties;
import com.sap.aii.util.misc.api.BaseRuntimeException;
import com.sap.aii.util.misc.api.HelperFunctions;
import com.sap.aii.util.misc.api.StringUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class GdiCharStreamer {
    private static final Logger sLogger = Logger.getLogger((class$com$sap$aii$util$hmi$core$gdi2$GdiCharStreamer == null ? (class$com$sap$aii$util$hmi$core$gdi2$GdiCharStreamer = GdiCharStreamer.class$("com.sap.aii.util.hmi.core.gdi2.GdiCharStreamer")) : class$com$sap$aii$util$hmi$core$gdi2$GdiCharStreamer).getName());
    static /* synthetic */ Class class$com$sap$aii$util$hmi$core$gdi2$GdiCharStreamer;

    public static GenericDataInstance readGdi(Reader aReader) {
        sLogger.finest("Reading GDI from char stream ...");
        XMLReader lReader = GdiCharStreamer.getGdiXmlReader();
        GdiCharReader lGdiContentHandler = new GdiCharReader();
        lReader.setContentHandler(lGdiContentHandler);
        try {
            lReader.parse(new InputSource(aReader));
            sLogger.finest("Reading GDI ... DONE.");
        }
        catch (SAXParseException e) {
            String lMsg = "Reading GDI ... FAILED. Source is not well formed. SAXParseException at line " + e.getLineNumber() + ", column " + e.getColumnNumber() + ". Details:\n" + HelperFunctions.getThrowableAsString(e);
            sLogger.error(lMsg);
            throw new BaseRuntimeException(lMsg);
        }
        catch (SAXException e) {
            String lMsg = "Reading GDI ... FAILED. SAXException:\n" + HelperFunctions.getThrowableAsString(e);
            sLogger.finest(lMsg);
            throw new BaseRuntimeException(e);
        }
        catch (IOException e) {
            String lMsg = "Reading GDI ... FAILED. IOException:\n" + HelperFunctions.getThrowableAsString(e);
            sLogger.finest(lMsg);
            throw new BaseRuntimeException(e);
        }
        GenericDataInstance lResult = lGdiContentHandler.getResult();
        if (sLogger.isLoggable(Level.FINEST)) {
            String lResultAsString = GdiCharStreamer.gdiToString(lResult);
            sLogger.finest("Result is:\n" + HelperFunctions.trunc(lResultAsString, 4096, true));
        }
        return lResult;
    }

    public static void writeGdi(GenericDataInstance aGdi, Writer aWriter, String aEncoding) {
        XmlCharWriter lWriter = new XmlCharWriter();
        try {
            lWriter.startDocument(aWriter, aEncoding);
            GdiCharStreamer.writeGenericDataInstance(lWriter, aGdi);
            lWriter.endDocument();
        }
        catch (IOException e) {
            String lMsg = "writeGdi failed with IOException! Details:\n" + HelperFunctions.getThrowableAsString(e);
            throw new BaseRuntimeException(lMsg);
        }
    }

    public static GenericDataInstance stringToGdi(String aSource) {
        sLogger.finest("stringToGdi ...");
        StringReader lReader = new StringReader(aSource);
        GenericDataInstance lGdi = GdiCharStreamer.readGdi(lReader);
        sLogger.finest("stringToGdi ... DONE.");
        return lGdi;
    }

    public static String gdiToString(GenericDataInstance aGdi) {
        sLogger.finest("gdiToString ...");
        StringWriter lWriter = new StringWriter();
        GdiCharStreamer.writeGdi(aGdi, lWriter, "UTF-8");
        sLogger.finest("gdiToString ... DONE.");
        return lWriter.getBuffer().toString();
    }

    public static XMLReader getGdiXmlReader() {
        try {
            if (sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest("Creating XMLReader for parsing GDIs ...");
            }
            SAXParserFactory lParserFactory = PartialCopyOfXMLServices.getParserFactory();
            SAXParser lParser = lParserFactory.newSAXParser();
            XMLReader lReader = lParser.getXMLReader();
            if (sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest("Creating XMLReader for parsing GDIs ... DONE.");
            }
            return lReader;
        }
        catch (Exception e) {
            String lMsg = "Creating SAP XMLReader for parsing GDIs ... FAILED!";
            sLogger.error(lMsg + " Exception: " + HelperFunctions.getThrowableAsString(e));
            throw new BaseRuntimeException(lMsg, (Throwable)e);
        }
    }

    public static void writeGenericDataInstance(XmlCharWriter aWriter, GenericDataInstance aGdi) throws IOException {
        TreeMap<String, String> lAttributes = new TreeMap<String, String>();
        lAttributes.put("typeid", aGdi.getTypeId());
        aWriter.startElement("instance", lAttributes);
        GdiCharStreamer.writeGenericDataAttributes(aWriter, aGdi.getAttributes());
        aWriter.endElement("instance");
    }

    public static void writeGenericDataAttributes(XmlCharWriter aWriter, GenericAttributes aGas) throws IOException {
        Iterator lEntryIter = aGas.getAttributes().entrySet().iterator();
        while (lEntryIter.hasNext()) {
            Map.Entry lEntry = lEntryIter.next();
            String lAttrName = (String)lEntry.getKey();
            GenericAttributeMultivalue lAttrValue = (GenericAttributeMultivalue)lEntry.getValue();
            TreeMap<String, String> lAttributes = new TreeMap<String, String>();
            lAttributes.put("name", lAttrName);
            lAttributes.put("isleave", String.valueOf(lAttrValue.getIsLeave()));
            if (lAttrValue.getLeaveTypeId() != null) {
                lAttributes.put("leave_typeid", lAttrValue.getLeaveTypeId());
            }
            if (lAttrValue.getLeaveEncoding() != null) {
                lAttributes.put("leave_encoding", lAttrValue.getLeaveEncoding());
            }
            aWriter.startElement("attribute", lAttributes);
            GdiCharStreamer.writeGenericDataMultivalue(aWriter, lAttrValue);
            aWriter.endElement("attribute");
        }
    }

    public static void writeGenericDataMultivalue(XmlCharWriter aWriter, GenericAttributeMultivalue aGam) throws IOException {
        String lLeaveTypeId = aGam.getLeaveTypeId();
        String lLeaveEncoding = aGam.getLeaveEncoding();
        boolean VtGdi = false;
        boolean VtString = true;
        int VtInputStream = 2;
        int VtByteArray = 3;
        int lValueType = -1;
        if (!aGam.getIsLeave()) {
            lValueType = 0;
        } else if ("string".equals(lLeaveTypeId)) {
            lValueType = 1;
        } else if ("inputstream".equals(lLeaveTypeId)) {
            lValueType = 2;
        } else if ("bytearray".equals(lLeaveTypeId)) {
            lValueType = 3;
        } else {
            String lMsg = "writeGenericDataMultivalue: leaveTypeId " + lLeaveTypeId + " is not supported!";
            sLogger.error(lMsg);
            throw new BaseRuntimeException(lMsg);
        }
        TreeMap<String, String> lAttributes = new TreeMap<String, String>();
        int i = 0;
        while (i < aGam.getSize()) {
            boolean lIsNull = aGam.getIsNull(i);
            lAttributes.put("index", String.valueOf(i));
            lAttributes.put("isnull", String.valueOf(lIsNull));
            aWriter.startElement("value", lAttributes);
            if (!lIsNull) {
                switch (lValueType) {
                    case 0: {
                        GdiCharStreamer.writeGenericDataInstance(aWriter, aGam.getGenericDataInstance(i));
                        break;
                    }
                    case 1: {
                        String lEscaped = StringUtil.escapeXMLChars(aGam.getString(i));
                        aWriter.characters(lEscaped);
                        break;
                    }
                    case 2: {
                        throw new UnsupportedOperationException("writeGenericDataMultivalue: InputStream not yet supported!");
                    }
                    case 3: {
                        throw new UnsupportedOperationException("writeGenericDataMultivalue: Byte[] not yet supported!");
                    }
                    default: {
                        throw new BaseRuntimeException("writeGenericDataMultivalue: Invalid internal state: lValueType=" + lValueType);
                    }
                }
            }
            aWriter.endElement("value");
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static abstract class PartialCopyOfXMLServices {
        private static final Logger log = Logger.getLogger((class$com$sap$aii$util$hmi$core$gdi2$GdiCharStreamer$PartialCopyOfXMLServices == null ? (class$com$sap$aii$util$hmi$core$gdi2$GdiCharStreamer$PartialCopyOfXMLServices = PartialCopyOfXMLServices.class$("com.sap.aii.util.hmi.core.gdi2.GdiCharStreamer$PartialCopyOfXMLServices")) : class$com$sap$aii$util$hmi$core$gdi2$GdiCharStreamer$PartialCopyOfXMLServices).getName());
        private static final String DEFAULT_PARSER_FACTORY = "com.sap.engine.lib.jaxp.SAXParserFactoryImpl";
        private static SAXParserFactory factory = null;
        static /* synthetic */ Class class$com$sap$aii$util$hmi$core$gdi2$GdiCharStreamer$PartialCopyOfXMLServices;

        private PartialCopyOfXMLServices() {
        }

        public static synchronized SAXParserFactory getParserFactory() {
            if (factory == null) {
                AIIProperties props = AIIProperties.getInstance();
                String name = props.getProperty("com.sap.aii.util.xml.parserFactory", DEFAULT_PARSER_FACTORY);
                log.finest("ParserFactory \"" + name + "\"");
                try {
                    factory = (SAXParserFactory)Class.forName(name).newInstance();
                    if (log.getActiveLevel().compareTo(Level.FINEST) <= 0) {
                        ClassLoader cl = (class$com$sap$aii$util$hmi$core$gdi2$GdiCharStreamer$PartialCopyOfXMLServices == null ? (class$com$sap$aii$util$hmi$core$gdi2$GdiCharStreamer$PartialCopyOfXMLServices = PartialCopyOfXMLServices.class$("com.sap.aii.util.hmi.core.gdi2.GdiCharStreamer$PartialCopyOfXMLServices")) : class$com$sap$aii$util$hmi$core$gdi2$GdiCharStreamer$PartialCopyOfXMLServices).getClassLoader();
                        URL url = cl.getResource("javax/xml/parsers/SAXParserFactory.class");
                        log.finest("got ParserFactory \"" + factory.getClass().getName() + "\" from \"" + url + "\"");
                    }
                    factory.setNamespaceAware(true);
                    factory.setFeature("http://xml.org/sax/features/namespaces", true);
                    factory.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
                    factory.setValidating(false);
                }
                catch (Exception e) {
                    throw new BaseRuntimeException(e);
                }
            }
            return factory;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class XmlCharWriter {
        private static final Logger sLogger = Logger.getLogger((class$com$sap$aii$util$hmi$core$gdi2$GdiCharStreamer$XmlCharWriter == null ? (class$com$sap$aii$util$hmi$core$gdi2$GdiCharStreamer$XmlCharWriter = XmlCharWriter.class$("com.sap.aii.util.hmi.core.gdi2.GdiCharStreamer$XmlCharWriter")) : class$com$sap$aii$util$hmi$core$gdi2$GdiCharStreamer$XmlCharWriter).getName());
        private boolean iLoggingFinestEnabled;
        private Writer iWriter;
        private String iEncoding;
        private int iCurrentElementDepth;
        static /* synthetic */ Class class$com$sap$aii$util$hmi$core$gdi2$GdiCharStreamer$XmlCharWriter;

        private String cedPrefix() {
            return this.iCurrentElementDepth == 0 ? "0 " : HelperFunctions.rightAlign(this.iCurrentElementDepth, this.iCurrentElementDepth, '.') + " ";
        }

        public XmlCharWriter() {
            sLogger.finest("Instantiation of " + this);
            String lLoggingFinestEnabled = AIIProperties.getInstance().getProperty("util.hmi.core.gdi2.loggingfinestenabled", "false");
            this.iLoggingFinestEnabled = Boolean.valueOf(lLoggingFinestEnabled);
        }

        public void startDocument(Writer aWriter, String aEncoding) throws IOException {
            this.iCurrentElementDepth = 0;
            if (this.iLoggingFinestEnabled && sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest("startDocument()");
            }
            this.iWriter = aWriter;
            this.iEncoding = aEncoding;
            if (this.iEncoding == null) {
                this.iWriter.write("<?xml version=\"1.0\"?>\n");
            } else {
                this.iWriter.write("<?xml version=\"1.0\" encoding=\"" + this.iEncoding + "\" ?>\n");
            }
        }

        public void startElement(String aLocalName, Map aAttributes) throws IOException {
            ++this.iCurrentElementDepth;
            if (this.iLoggingFinestEnabled && sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest(this.cedPrefix() + "startElement(..., " + aLocalName + ", ...)");
            }
            this.iWriter.write(60);
            this.iWriter.write(aLocalName);
            if (aAttributes != null && aAttributes.size() > 0) {
                Iterator lEntryIter = aAttributes.entrySet().iterator();
                while (lEntryIter.hasNext()) {
                    Map.Entry lEntry = lEntryIter.next();
                    String lAttrName = (String)lEntry.getKey();
                    String lAttrValue = (String)lEntry.getValue();
                    this.iWriter.write(32);
                    this.iWriter.write(lAttrName);
                    this.iWriter.write(61);
                    this.iWriter.write(34);
                    this.iWriter.write(lAttrValue);
                    this.iWriter.write(34);
                }
            }
            this.iWriter.write(62);
        }

        public void endElement(String aLocalName) throws IOException {
            if (this.iLoggingFinestEnabled && sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest(this.cedPrefix() + "endElement(..., " + aLocalName + ", ...)");
            }
            this.iWriter.write(60);
            this.iWriter.write(47);
            this.iWriter.write(aLocalName);
            this.iWriter.write(62);
            --this.iCurrentElementDepth;
        }

        public void characters(String aText) throws IOException {
            if (this.iLoggingFinestEnabled && sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest(this.cedPrefix() + "characters(\"" + aText + ")");
            }
            this.iWriter.write(aText);
        }

        public void characters(char[] aText, int aStart, int aLength) throws IOException {
            if (this.iLoggingFinestEnabled && sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest(this.cedPrefix() + "characters(\"" + new String(aText, aStart, aLength) + "\", " + aStart + ", " + aLength + ")");
            }
            this.iWriter.write(aText, aStart, aLength);
        }

        public void endDocument() throws IOException {
            if (this.iLoggingFinestEnabled && sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest("endDocument()");
            }
            this.iWriter.write(10);
            this.iWriter = null;
            this.iEncoding = null;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class GdiCharReader
    implements ContentHandler {
        private static final Logger sLogger = Logger.getLogger((class$com$sap$aii$util$hmi$core$gdi2$GdiCharStreamer$GdiCharReader == null ? (class$com$sap$aii$util$hmi$core$gdi2$GdiCharStreamer$GdiCharReader = GdiCharReader.class$("com.sap.aii.util.hmi.core.gdi2.GdiCharStreamer$GdiCharReader")) : class$com$sap$aii$util$hmi$core$gdi2$GdiCharStreamer$GdiCharReader).getName());
        private boolean iLoggingFinestEnabled;
        private Locator iLocator;
        private LinkedList iParsingContexts;
        private LinkedList iElementStack;
        GenericDataInstance iResult;
        static /* synthetic */ Class class$com$sap$aii$util$hmi$core$gdi2$GdiCharStreamer$GdiCharReader;

        private void push(PartialResult aNewTop) {
            this.iParsingContexts.addFirst(aNewTop);
        }

        private int size() {
            return this.iParsingContexts.size();
        }

        private PartialResult top() {
            return (PartialResult)this.iParsingContexts.getFirst();
        }

        private PartialResult pop() {
            PartialResult lLastTop = this.top();
            this.iParsingContexts.removeFirst();
            return lLastTop;
        }

        private String cedPrefix() {
            int lCed = this.iElementStack == null ? 0 : this.iElementStack.size();
            return lCed == 0 ? "0 " : HelperFunctions.rightAlign(lCed, lCed, '.') + " ";
        }

        public GenericDataInstance getResult() {
            return this.iResult;
        }

        public GdiCharReader() {
            sLogger.finest("Instantiation of " + this);
            String lLoggingFinestEnabled = AIIProperties.getInstance().getProperty("util.hmi.core.gdi2.loggingfinestenabled", "false");
            this.iLoggingFinestEnabled = Boolean.valueOf(lLoggingFinestEnabled);
        }

        protected void finalize() {
            sLogger.finest("Finalization of " + this);
        }

        public void startDocument() throws SAXException {
            if (this.iLoggingFinestEnabled && sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest("startDocument()");
            }
            this.iParsingContexts = new LinkedList();
            this.iElementStack = new LinkedList();
        }

        public void startElement(String aNamespaceUri, String aLocalName, String aQualifiedName, Attributes aAttributes) throws SAXException {
            this.iElementStack.addFirst(aLocalName);
            if (this.iLoggingFinestEnabled && sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest(this.cedPrefix() + "startElement(..., " + aLocalName + ", ...)");
            }
            if ("instance".equals(aLocalName)) {
                this.push(new PartialResult());
                String lTypeId = aAttributes.getValue("typeid");
                this.top().beginGdi(lTypeId);
            } else if ("attribute".equals(aLocalName)) {
                String lName = aAttributes.getValue("name");
                String lIsLeaveAsString = aAttributes.getValue("isleave");
                Boolean lIsLeave = Boolean.valueOf(lIsLeaveAsString);
                String lLeaveTypeId = aAttributes.getValue("leave_typeid");
                if (lIsLeave.booleanValue() && lLeaveTypeId == null) {
                    lLeaveTypeId = "string";
                }
                String lLeaveEncoding = aAttributes.getValue("leave_encoding");
                if (lIsLeave.booleanValue() && lLeaveEncoding == null) {
                    lLeaveEncoding = "none";
                }
                this.top().beginGa(lName, lIsLeave, lLeaveTypeId, lLeaveEncoding);
            } else if ("value".equals(aLocalName)) {
                String lIndexAsString = aAttributes.getValue("index");
                Integer lIndex = Integer.valueOf(lIndexAsString);
                String lIsNullAsString = aAttributes.getValue("isnull");
                Boolean lIsNull = Boolean.valueOf(lIsNullAsString);
                this.top().beginGsv(lIndex, lIsNull);
            } else {
                String lMsg = "Parsing generic data instance: begin of unexpected element \"" + aLocalName + "\"!";
                sLogger.error(lMsg + " => throwing exception ...");
                throw new BaseRuntimeException(lMsg);
            }
        }

        public void endElement(String aNamespaceUri, String aLocalName, String qualifiedName) throws SAXException {
            if (this.iLoggingFinestEnabled && sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest(this.cedPrefix() + "endElement(..., " + aLocalName + ", ...)");
            }
            this.iElementStack.removeFirst();
            if ("instance".equals(aLocalName)) {
                this.top().endGdi();
                GenericDataInstance lGdi = this.top().getGdi();
                this.pop();
                if (this.size() > 0) {
                    if (this.top().gaIsLeave.booleanValue()) {
                        String lMsg = "Parsing generic data instance: value is leave, but contained generic data instance!";
                        sLogger.error(lMsg + " => throwing exception ...");
                        throw new BaseRuntimeException(lMsg);
                    }
                    this.top().setGsv(lGdi);
                } else {
                    this.iResult = lGdi;
                }
            } else if ("attribute".equals(aLocalName)) {
                this.top().endGa();
            } else if ("value".equals(aLocalName)) {
                this.top().endGsv();
            } else {
                String lMsg = "Parsing generic data instance: end of unexpected element \"" + aLocalName + "\"!";
                sLogger.error(lMsg + " => throwing exception ...");
                throw new BaseRuntimeException(lMsg);
            }
        }

        public void characters(char[] aText, int aStart, int aLength) throws SAXException {
            if (this.iLoggingFinestEnabled && sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest(this.cedPrefix() + "characters(\"" + new String(aText, aStart, aLength) + "\", " + aStart + ", " + aLength + ")");
            }
            if ("value".equals(this.iElementStack.getFirst())) {
                this.top().addToGsv(aText, aStart, aLength);
            } else {
                String lCdata = new String(aText, aStart, aLength);
                if (lCdata.trim().length() > 0) {
                    String lMsg = "Error parsing GDI: Unexpected CDATA in element " + this.iElementStack.getFirst() + ":\n" + lCdata;
                    sLogger.error(lMsg + "\nThrowing exception now ...");
                    throw new BaseRuntimeException(lMsg);
                }
            }
        }

        public void ignorableWhitespace(char[] aText, int aStart, int aLength) throws SAXException {
            if (this.iLoggingFinestEnabled && sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest(this.cedPrefix() + "ignorableWhitespace(...)");
            }
        }

        public void processingInstruction(String aTarget, String aData) throws SAXException {
            if (this.iLoggingFinestEnabled && sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest(this.cedPrefix() + "processingInstruction(" + aTarget + ", " + aData + ")");
            }
        }

        public void endDocument() throws SAXException {
            if (this.iLoggingFinestEnabled && sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest("endDocument()");
            }
            this.iElementStack = null;
            this.iParsingContexts = null;
            if (this.iResult == null) {
                String lMsg = "Parsing generic data instance: no result!";
                sLogger.error(lMsg + " => throwing exception ...");
                throw new BaseRuntimeException(lMsg);
            }
        }

        public void setDocumentLocator(Locator aLocator) {
            if (this.iLoggingFinestEnabled && sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest(this.cedPrefix() + "setDocumentLocator(" + aLocator + ")");
            }
            this.iLocator = aLocator;
        }

        public void startPrefixMapping(String aPrefix, String aUri) throws SAXException {
            if (this.iLoggingFinestEnabled && sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest(this.cedPrefix() + "startPrefixMapping(" + aPrefix + ", " + aUri + ")");
            }
        }

        public void endPrefixMapping(String aPrefix) throws SAXException {
            if (this.iLoggingFinestEnabled && sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest(this.cedPrefix() + "endPrefixMapping(" + aPrefix + ")");
            }
        }

        public void skippedEntity(String aName) throws SAXException {
            if (this.iLoggingFinestEnabled && sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest(this.cedPrefix() + "skippedEntity(" + aName + ")");
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        private static class PartialResult {
            String gdiTypeId;
            Map gdiAttributes;
            String gaName;
            Boolean gaIsLeave;
            String gaLeaveTypeId;
            String gaLeaveEncoding;
            Object gaSingleValueAtIndexZero;
            SortedMap gaSingleValuesAtIndicesLargerZero;
            Integer gsvIndex;
            Boolean gsvIsNull;
            Object gsvValue;

            private PartialResult() {
            }

            void beginGdi(String aTypeId) {
                this.gdiTypeId = aTypeId;
                this.gdiAttributes = new HashMap();
            }

            void endGdi() {
            }

            GenericDataInstance getGdi() {
                GenericAttributes lGas = new GenericAttributes(this.gdiAttributes);
                GenericDataInstance lGdi = new GenericDataInstance(this.gdiTypeId, lGas);
                this.gdiTypeId = null;
                this.gdiAttributes = null;
                return lGdi;
            }

            void beginGa(String aAttributeName, Boolean aIsLeave, String aLeaveTypeId, String aLeaveEncoding) {
                this.gaName = aAttributeName;
                this.gaIsLeave = aIsLeave;
                this.gaLeaveTypeId = aLeaveTypeId;
                this.gaLeaveEncoding = aLeaveEncoding;
            }

            GenericAttributeMultivalue deriveGam() {
                int lNumberOfValues = 0;
                if (this.gaSingleValueAtIndexZero != null) {
                    ++lNumberOfValues;
                }
                if (this.gaSingleValuesAtIndicesLargerZero != null) {
                    lNumberOfValues += this.gaSingleValuesAtIndicesLargerZero.size();
                }
                ArrayList<Object> lSingleValues = new ArrayList<Object>(lNumberOfValues);
                if (lNumberOfValues > 0 && this.gaSingleValueAtIndexZero == null) {
                    String lMsg = "Inconsistency parsing values: missing value with index 0!";
                    sLogger.error(lMsg + " => throwing exception now ...");
                    throw new BaseRuntimeException(lMsg);
                }
                lSingleValues.add(this.gaSingleValueAtIndexZero);
                if (this.gaSingleValuesAtIndicesLargerZero != null) {
                    int lExpectedIndexOfNextValue = 1;
                    Iterator lEntryIter = this.gaSingleValuesAtIndicesLargerZero.entrySet().iterator();
                    while (lEntryIter.hasNext()) {
                        Map.Entry lEntry = lEntryIter.next();
                        int lIndex = (Integer)lEntry.getKey();
                        if (lIndex != lExpectedIndexOfNextValue) {
                            String lMsg = "Inconsistency parsing values: missing value with index " + lExpectedIndexOfNextValue + "!";
                            sLogger.error(lMsg + " => throwing exception now ...");
                            throw new BaseRuntimeException(lMsg);
                        }
                        lSingleValues.add(lEntry.getValue());
                        ++lExpectedIndexOfNextValue;
                    }
                }
                GenericAttributeMultivalue lGam = new GenericAttributeMultivalue(this.gaIsLeave, lSingleValues, this.gaLeaveTypeId, this.gaLeaveEncoding);
                this.gaIsLeave = null;
                this.gaSingleValueAtIndexZero = null;
                this.gaSingleValuesAtIndicesLargerZero = null;
                this.gaLeaveTypeId = null;
                this.gaLeaveEncoding = null;
                return lGam;
            }

            void endGa() {
                GenericAttributeMultivalue lValue = this.deriveGam();
                this.gdiAttributes.put(this.gaName, lValue);
                this.gaName = null;
            }

            void beginGsv(Integer aIndex, Boolean aIsNull) {
                this.gsvIndex = aIndex;
                this.gsvIsNull = aIsNull;
                this.gsvValue = null;
            }

            void setGsv(GenericDataInstance aSingleValue) {
                if (aSingleValue == null) {
                    throw new BaseRuntimeException("aSingleValue == null");
                }
                if (this.gaIsLeave.booleanValue()) {
                    throw new BaseRuntimeException("gaIsLeave == true!");
                }
                if (this.gsvValue != null) {
                    throw new BaseRuntimeException("gsvValue != null");
                }
                this.gsvValue = aSingleValue;
            }

            void addToGsv(char[] aText, int aStart, int aLength) {
                if (aText == null) {
                    throw new BaseRuntimeException("aText == null");
                }
                if (!this.gaIsLeave.booleanValue()) {
                    throw new BaseRuntimeException("gaIsLeave != true!");
                }
                if (this.gsvValue == null) {
                    this.gsvValue = new StringBuffer();
                }
                ((StringBuffer)this.gsvValue).append(aText, aStart, aLength);
            }

            void endGsv() {
                if (this.gsvValue == null && !this.gsvIsNull.booleanValue() && "string".equals(this.gaLeaveTypeId)) {
                    this.gsvValue = new StringBuffer("");
                }
                if (this.gsvIsNull != (this.gsvValue == null)) {
                    String lMsg = "Inconsistency parsing value: " + (this.gsvIsNull != false ? "attribute states that value is null, but value element is not empty!" : "attribute states that value is not null, but value element is empty!");
                    sLogger.error(lMsg + " => throwing exception ...");
                    throw new BaseRuntimeException(lMsg);
                }
                if (this.gaIsLeave.booleanValue()) {
                    if ("string".equals(this.gaLeaveTypeId)) {
                        if (this.gsvValue != null) {
                            this.gsvValue = ((StringBuffer)this.gsvValue).toString();
                        }
                    } else {
                        throw new BaseRuntimeException("primitive " + this.gaLeaveTypeId + " not yet supported!");
                    }
                }
                if (this.gsvIndex == 0) {
                    this.gaSingleValueAtIndexZero = this.gsvValue;
                } else {
                    if (this.gaSingleValuesAtIndicesLargerZero == null) {
                        this.gaSingleValuesAtIndicesLargerZero = new TreeMap();
                    }
                    this.gaSingleValuesAtIndicesLargerZero.put(this.gsvIndex, this.gsvValue);
                }
                this.gsvIsNull = null;
                this.gsvIndex = null;
                this.gsvValue = null;
            }
        }
    }
}

