/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.hmi.core.bs;

import com.sap.aii.util.base64.api.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public abstract class ByteStreamInString {
    private static Object[] sExampleObjects = new Object[]{"short", "does not require type declaration", "(2178AB70A0DA11D7ADBAF2370A140A60 TYPE ?) requires type declaration", new ByteArrayInputStream("StringBufferInputStream content".getBytes()), new ByteArrayInputStream(new byte[]{0, 1, 2, 3, 4, 5, 6, 35, 36, 37, 127, -128, -1})};
    private static String[] sPackedExampleObjects = new String[]{"short", "without type declaration", "(2178AB70A0DA11D7ADBAF2370A140A60 TYPE S) (2178AB70A0DA11D7ADBAF2370A140A60 TYPE with string type declaration", "(2178AB70A0DA11D7ADBAF2370A140A60 TYPE I) AAAABBBB", "(2178AB70A0DA11D7ADBAF2370A140A60 TYPE I) U3RyaW5nQnVmZmVySW5wdXRTdHJlYW0gY29udGVudA==", "(2178AB70A0DA11D7ADBAF2370A140A60 TYPE ?) with invalid type declaration (treated as default type) => unpack/pack source != source"};

    private static boolean needsTypeDecl(String aObject) {
        if (aObject.length() < Constants.TypeDeclLength) {
            return false;
        }
        String lTypeDeclBeginCandidate = aObject.substring(0, "(2178AB70A0DA11D7ADBAF2370A140A60 TYPE ".length());
        return "(2178AB70A0DA11D7ADBAF2370A140A60 TYPE ".equals(lTypeDeclBeginCandidate);
    }

    public static String packObject(Object aObject) throws IOException {
        if (aObject == null) {
            return null;
        }
        if (aObject instanceof String) {
            String lObject = (String)aObject;
            return ByteStreamInString.needsTypeDecl(lObject) ? ByteStreamInString.packStringWithTypeDecl(lObject) : lObject;
        }
        if (aObject instanceof InputStream) {
            return ByteStreamInString.packInputStreamWithTypeDecl((InputStream)aObject);
        }
        throw new IllegalArgumentException("aObject must be either of type String or InputStream!");
    }

    private static char getTypeOf(String aPackedObject) {
        if (aPackedObject == null) {
            return 'N';
        }
        if (aPackedObject.length() < Constants.TypeDeclLength) {
            return 'D';
        }
        String lTypeDeclCandidate = aPackedObject.substring(0, Constants.TypeDeclLength);
        if ("(2178AB70A0DA11D7ADBAF2370A140A60 TYPE I) ".equals(lTypeDeclCandidate)) {
            return 'I';
        }
        if ("(2178AB70A0DA11D7ADBAF2370A140A60 TYPE S) ".equals(lTypeDeclCandidate)) {
            return 'S';
        }
        return 'D';
    }

    public static Object unpackObject(String aPackedObject) {
        char lTypeId = ByteStreamInString.getTypeOf(aPackedObject);
        switch (lTypeId) {
            case 'N': {
                return null;
            }
            case 'D': {
                return aPackedObject;
            }
            case 'S': {
                return ByteStreamInString.unpackStringWithTypeDecl(aPackedObject);
            }
            case 'I': {
                return ByteStreamInString.unpackInputStreamWithTypeDecl(aPackedObject);
            }
        }
        throw new RuntimeException("getTypeOf returned unexpected value \"" + lTypeId + "\"!");
    }

    private static String packStringWithTypeDecl(String aString) {
        return "(2178AB70A0DA11D7ADBAF2370A140A60 TYPE S) " + aString;
    }

    private static String unpackStringWithTypeDecl(String aPackedString) {
        return aPackedString.substring(Constants.TypeDeclLength);
    }

    /*
     * WARNING - void declaration
     */
    private static String packInputStreamWithTypeDecl(InputStream aInputStream) throws IOException {
        int b;
        ByteArrayOutputStream lInputStream = new ByteArrayOutputStream();
        while ((b = aInputStream.read()) != -1) {
            void var2_2;
            lInputStream.write((int)var2_2);
        }
        byte[] lByteArray = lInputStream.toByteArray();
        String lBase64 = Base64.encode(lByteArray);
        return "(2178AB70A0DA11D7ADBAF2370A140A60 TYPE I) " + lBase64;
    }

    private static InputStream unpackInputStreamWithTypeDecl(String aPackedInputStream) {
        String lBase64 = aPackedInputStream.substring("(2178AB70A0DA11D7ADBAF2370A140A60 TYPE I) ".length());
        byte[] lByteArray = Base64.decode(lBase64);
        return new ByteArrayInputStream(lByteArray);
    }

    public static void main(String[] args) {
        try {
            Object lUnpackedExampleObject;
            String lPackedExampleObject;
            System.out.println("PACKING ...");
            int i = 0;
            while (i < sExampleObjects.length) {
                System.out.println(i);
                Object lExampleObject = sExampleObjects[i];
                System.out.println(lExampleObject.toString());
                lPackedExampleObject = ByteStreamInString.packObject(lExampleObject);
                System.out.println(lPackedExampleObject);
                lUnpackedExampleObject = ByteStreamInString.unpackObject(lPackedExampleObject);
                System.out.println(lUnpackedExampleObject.toString());
                ByteStreamInString.logAssertedEquality(lExampleObject, lUnpackedExampleObject);
                System.out.println();
                ++i;
            }
            System.out.println("UNPACKING ...");
            int i2 = 0;
            while (i2 < sPackedExampleObjects.length) {
                System.out.println(i2);
                lPackedExampleObject = sPackedExampleObjects[i2];
                System.out.println(lPackedExampleObject);
                lUnpackedExampleObject = ByteStreamInString.unpackObject(lPackedExampleObject);
                System.out.println(lUnpackedExampleObject.toString());
                String lRepackedExampleObject = ByteStreamInString.packObject(lUnpackedExampleObject);
                System.out.println((Object)lRepackedExampleObject);
                ByteStreamInString.logAssertedEquality(lPackedExampleObject, lRepackedExampleObject);
                System.out.println();
                ++i2;
            }
        }
        catch (Exception e) {
            System.err.println("Unexpected exception:");
            e.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void logAssertedEquality(Object aObject1, Object aObject2) throws IOException {
        if (aObject1 == aObject2) {
            System.out.println("OK: one object");
        } else if (aObject1 instanceof String && aObject2 instanceof String) {
            String lObject1 = (String)aObject1;
            String lObject2 = (String)aObject2;
            if (lObject1.equals(lObject2)) {
                System.out.println("OK: strings are equal");
            } else {
                System.err.println("NOT OK: strings are not equal!");
            }
        } else if (aObject1 instanceof InputStream && aObject2 instanceof InputStream) {
            int b;
            InputStream lObject1 = (InputStream)aObject1;
            lObject1.reset();
            InputStream lObject2 = (InputStream)aObject2;
            lObject2.reset();
            ByteArrayOutputStream lInputStream1 = new ByteArrayOutputStream();
            while ((b = lObject1.read()) != -1) {
                void var4_7;
                lInputStream1.write((int)var4_7);
            }
            byte[] lByteArray1 = lInputStream1.toByteArray();
            ByteArrayOutputStream lInputStream2 = new ByteArrayOutputStream();
            while ((b = lObject2.read()) != -1) {
                lInputStream2.write(b);
            }
            byte[] lByteArray2 = lInputStream2.toByteArray();
            if (Arrays.equals(lByteArray1, lByteArray2)) {
                System.out.println("OK: bytes are equal");
            } else {
                System.err.println("NOT OK: bytes are not equal!");
                int i = 0;
                while (i < lByteArray1.length) {
                    if (i == 0) {
                        System.err.print("byte array 1: ");
                    } else {
                        System.err.print(",");
                    }
                    System.err.print(lByteArray1[i]);
                    ++i;
                }
                int i2 = 0;
                while (i2 < lByteArray2.length) {
                    if (i2 == 0) {
                        System.err.print("byte array 2: ");
                    } else {
                        System.err.print(",");
                    }
                    System.err.print(lByteArray2[i2]);
                    ++i2;
                }
            }
        } else {
            throw new IllegalArgumentException("aObject1 and aObject2 must either be both of type String or both of type InputStream!");
        }
    }

    private static abstract class Constants {
        private static final String Unification = "2178AB70A0DA11D7ADBAF2370A140A60";
        private static final String TypeDeclBegin = "(2178AB70A0DA11D7ADBAF2370A140A60 TYPE ";
        private static final String TypeDeclEnd = ") ";
        private static final char TypeIdNull = 'N';
        private static final char TypeIdDefaultType = 'D';
        private static final char TypeIdString = 'S';
        private static final char TypeIdInputStream = 'I';
        private static final int TypeDeclLength = "(2178AB70A0DA11D7ADBAF2370A140A60 TYPE ".length() + 1 + ") ".length();
        private static final String TypeDeclString = "(2178AB70A0DA11D7ADBAF2370A140A60 TYPE S) ";
        private static final String TypeDeclInputStream = "(2178AB70A0DA11D7ADBAF2370A140A60 TYPE I) ";

        private Constants() {
        }
    }
}

