/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.hmi.api;

import com.sap.aii.util.hmi.api.HmiCoreException;
import com.sap.aii.util.hmi.api.IHmiHttpURLConnectionFactory;
import com.sap.aii.util.log.api.Level;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.misc.api.AIIProperties;
import com.sap.aii.util.misc.api.BaseException;
import com.sap.engine.interfaces.keystore.KeystoreManager;
import com.sap.security.core.server.https.SecureConnectionFactory;
import com.sap.security.core.server.https.Utils;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyStore;
import java.util.Enumeration;
import javax.naming.InitialContext;

public class HmiHttpsURLConnectionFactory
implements IHmiHttpURLConnectionFactory {
    private static final String sClassname = (class$com$sap$aii$util$hmi$api$HmiHttpsURLConnectionFactory == null ? (class$com$sap$aii$util$hmi$api$HmiHttpsURLConnectionFactory = HmiHttpsURLConnectionFactory.class$("com.sap.aii.util.hmi.api.HmiHttpsURLConnectionFactory")) : class$com$sap$aii$util$hmi$api$HmiHttpsURLConnectionFactory).getName();
    private static final Logger sLogger = Logger.getLogger(sClassname);
    private static HmiHttpsURLConnectionFactory sSingleton;
    static /* synthetic */ Class class$com$sap$aii$util$hmi$api$HmiHttpsURLConnectionFactory;

    private HmiHttpsURLConnectionFactory() {
    }

    public static HmiHttpsURLConnectionFactory getInstance() {
        if (sSingleton == null) {
            sSingleton = new HmiHttpsURLConnectionFactory();
        }
        return sSingleton;
    }

    public HttpURLConnection createConnection(URL aUrl) throws Exception {
        if (aUrl == null) {
            throw HmiCoreException.newProgrammingModelViolation(sClassname, "createConnection(URL aUrl)", "aUrl == null");
        }
        if ("http".equals(aUrl.getProtocol())) {
            return this.createHttpConnection(aUrl);
        }
        if ("https".equals(aUrl.getProtocol())) {
            return this.createHttpsConnectionViaSSF(aUrl);
        }
        throw HmiCoreException.newProgrammingModelViolation(sClassname, "createConnection(URL aUrl)", "Unsupported protocol " + aUrl.getProtocol() + " -- supported protocols are http and https");
    }

    private HttpURLConnection createHttpConnection(URL aUrl) throws Exception {
        if (!"http".equals(aUrl.getProtocol())) {
            throw HmiCoreException.newProgrammingModelViolation(sClassname, "createHttpConnection(URL aUrl)", "!\"http\".equals(aUrl.getProtocol())");
        }
        return (HttpURLConnection)aUrl.openConnection();
    }

    private HttpURLConnection createHttpsConnectionViaSSF(URL aUrl) throws Exception {
        if (!"https".equals(aUrl.getProtocol())) {
            throw HmiCoreException.newProgrammingModelViolation(sClassname, "createHttpsConnection(URL aUrl)", "!\"https\".equals(aUrl.getProtocol())");
        }
        boolean lDebug = sLogger.isLoggable(Level.DEBUG);
        SecureConnectionFactory lConnectionFactory = HmiHttpsURLConnectionFactory.getSecureConnectionFactory();
        if (lDebug) {
            sLogger.debug("Creating URL connection to \"" + aUrl + "\" ...");
        }
        HttpURLConnection lUrlConnection = lConnectionFactory.createURLConnection(aUrl.toString());
        if (lDebug) {
            PrintStream lDebugStream = System.out;
            Utils.setSSLDebugStream((HttpURLConnection)lUrlConnection, (OutputStream)lDebugStream);
        }
        return lUrlConnection;
    }

    private static SecureConnectionFactory getSecureConnectionFactory() throws Exception {
        boolean lDebug = sLogger.isLoggable(Level.DEBUG);
        sLogger.debug("Looking up keystore manager ...");
        InitialContext lInitialContext = new InitialContext();
        sLogger.debug("Got initial context.");
        String lJndiName = "keystore";
        sLogger.debug("Looking up \"" + lJndiName + "\"");
        KeystoreManager lKeystoreManager = (KeystoreManager)lInitialContext.lookup(lJndiName);
        sLogger.debug("Looking up keystore manager ... DONE.");
        if (lDebug) {
            sLogger.debug("Getting keystore view aliases ...");
            String[] lKeystoreViewAliases = lKeystoreManager.getKeystoreViewAliases();
            int i = 0;
            while (i < lKeystoreViewAliases.length) {
                sLogger.debug(String.valueOf(i + 1) + lKeystoreViewAliases[i]);
                ++i;
            }
            sLogger.debug("Getting keystore view aliases ... DONE.");
        }
        sLogger.debug("Getting keystore view with trusted CAs ...");
        String lKeystoreTrustedCAsName = AIIProperties.getInstance().getProperty("ib.server.hmi.trustedcas");
        if (lKeystoreTrustedCAsName == null || lKeystoreTrustedCAsName.trim().length() == 0) {
            lKeystoreTrustedCAsName = "TrustedCAs";
        }
        sLogger.debug("Trusted CAs view name is " + lKeystoreTrustedCAsName);
        KeyStore lKeystoreTrustedCAs = lKeystoreManager.getKeystore(lKeystoreTrustedCAsName);
        if (lKeystoreTrustedCAs == null) {
            String lMsg = "Cannot get trusted CAs view " + lKeystoreTrustedCAsName + "!";
            sLogger.error(lMsg + " ==> throwing exception now ...");
            throw new BaseException(lMsg);
        }
        if (lDebug) {
            sLogger.debug("Got trusted CAs view. Contained aliases:");
            Enumeration<String> lAliases = lKeystoreTrustedCAs.aliases();
            int lNumberOfCertificates = 0;
            int lNumberOfKeys = 0;
            while (lAliases.hasMoreElements()) {
                String lAlias = lAliases.nextElement();
                if (lKeystoreTrustedCAs.isCertificateEntry(lAlias)) {
                    sLogger.debug("Certificate " + lAlias);
                    ++lNumberOfCertificates;
                    continue;
                }
                if (lKeystoreTrustedCAs.isKeyEntry(lAlias)) {
                    sLogger.debug("Key " + lAlias);
                    ++lNumberOfKeys;
                    continue;
                }
                sLogger.debug("Uups ... neither key nor certificate: " + lAlias);
            }
            if (lNumberOfCertificates == 0) {
                String lMsg = "Trusted CAs view " + lKeystoreTrustedCAsName + " does not contain any certificates -- connection would fail!";
                sLogger.warning(lMsg);
            }
        }
        sLogger.debug("Creating secure connection factory ...");
        SecureConnectionFactory lConnectionFactory = new SecureConnectionFactory(lKeystoreTrustedCAs, null);
        sLogger.debug("Creating secure connection factory ... DONE.");
        return lConnectionFactory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

