/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.blob.api;

import com.sap.aii.util.blob.api.BlobResourceException;
import com.sap.aii.util.misc.api.ResourceException;
import java.io.IOException;
import java.io.InputStream;

public abstract class AIIBlob {
    public static final String MIMETYPE_ANY = "any";
    public static final String MIMETYPE_TEXT = "text/plain";
    public static final String MIMETYPE_HTML = "text/html";
    public static final String MIMETYPE_XML = "xml";
    public static final String MIMETYPE_XSD = "xsd";
    public static final String MIMETYPE_JAVA = "java";
    public static final String MIMETYPE_JAR = "jar";
    public static final String MIMETYPE_CLASS = "class";
    AIIBlob blob = null;

    AIIBlob() {
    }

    public AIIBlob(AIIBlob blob) {
        this.blob = blob;
    }

    public InputStream getBinaryStream() throws ResourceException {
        return this.blob.getBinaryStream();
    }

    public int length() throws ResourceException {
        return this.blob.length();
    }

    public String getMimeType() {
        return this.blob.getMimeType();
    }

    public void close() {
        this.blob.close();
    }

    byte[] getByteArray() throws ResourceException {
        if (this.blob == null) {
            byte[] byteArray = new byte[this.length()];
            try {
                if (this.getBinaryStream().read(byteArray) < byteArray.length) {
                    throw new BlobResourceException("READ");
                }
            }
            catch (IOException e) {
                throw new ResourceException(e);
            }
            return byteArray;
        }
        return this.blob.getByteArray();
    }
}

