/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.base64.api;

public class Base64 {
    static final String ENCODING_ASCII = "US-ASCII";
    static char[] toBase64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    static byte[] fromBase64 = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};

    static int encode(byte[] in, int offset, int len, char[] out, int pos) {
        int end = offset + len;
        int outLength = (len + 2) / 3 * 4;
        int limit = end - 2;
        int i = offset;
        while (i < limit) {
            out[pos++] = toBase64[(in[i] & 0xFC) >> 2];
            out[pos++] = toBase64[(in[i] & 3) << 4 | (in[i + 1] & 0xF0) >> 4];
            out[pos++] = toBase64[(in[i + 1] & 0xF) << 2 | (in[i + 2] & 0xC0) >> 6];
            out[pos++] = toBase64[in[i + 2] & 0x3F];
            i += 3;
        }
        int rest = end - i;
        if (rest == 1) {
            out[pos++] = toBase64[(in[i] & 0xFC) >> 2];
            out[pos++] = toBase64[(in[i] & 3) << 4];
            out[pos++] = 61;
            out[pos++] = 61;
        } else if (rest == 2) {
            out[pos++] = toBase64[(in[i] & 0xFC) >> 2];
            out[pos++] = toBase64[(in[i] & 3) << 4 | (in[i + 1] & 0xF0) >> 4];
            out[pos++] = toBase64[(in[i + 1] & 0xF) << 2];
            out[pos++] = 61;
        }
        return pos;
    }

    public static char[] encode(byte[] in, int offset, int len) {
        int resultLength = (len + 2) / 3 * 4;
        char[] result = new char[resultLength];
        Base64.encode(in, offset, len, result, 0);
        return result;
    }

    public static String encode(byte[] in) {
        char[] out = Base64.encode(in, 0, in.length);
        return new String(out);
    }

    static int decode(char[] in, int offset, int len, byte[] out, int pos) {
        byte b;
        byte a;
        int i = offset;
        while (len >= 4) {
            a = fromBase64[in[i + 1]];
            b = fromBase64[in[i + 2]];
            out[pos++] = (byte)(fromBase64[in[i]] << 2 | (a & 0x30) >> 4);
            out[pos++] = (byte)((a & 0xF) << 4 | (b & 0x3C) >> 2);
            out[pos++] = (byte)((b & 3) << 6 | fromBase64[in[i + 3]]);
            i += 4;
            len -= 4;
        }
        if (len >= 2) {
            a = fromBase64[in[i + 1]];
            out[pos] = (byte)(fromBase64[in[i]] << 2 | (a & 0x30) >> 4);
            if (len >= 3) {
                b = fromBase64[in[i + 2]];
                out[pos + 1] = (byte)((a & 0xF) << 4 | (b & 0x3C) >> 2);
            }
        }
        return pos + len;
    }

    public static byte[] decode(char[] in) {
        return Base64.decode(in, 0, in.length);
    }

    public static byte[] decode(char[] in, int offset, int len) {
        int end = offset + len;
        while (end > 0 && in[end - 1] == '=') {
            --end;
        }
        int sourceLength = end - offset;
        int resultLength = sourceLength / 4 * 3;
        int x = sourceLength % 4;
        if (x == 2) {
            ++resultLength;
        } else if (x == 3) {
            resultLength += 2;
        }
        byte[] result = new byte[resultLength];
        Base64.decode(in, offset, sourceLength, result, 0);
        return result;
    }

    public static byte[] decode(String in) {
        byte[] buffer = Base64.decode(in.toCharArray(), 0, in.length());
        return buffer;
    }
}

