/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.ui.multipageview;

import com.tssap.selena.gde.internal.DiagramImpl;
import com.tssap.selena.gde.internal.DiagramViewPart;
import com.tssap.selena.gde.internal.GdePlugin;
import com.tssap.selena.gde.internal.Messages;
import com.tssap.selena.license.CommonLicense;
import com.tssap.selena.license.UnaryOperation;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.preferences.PreferencesPlugin;
import com.tssap.selena.model.util.UndoTransparableCommand;
import com.tssap.selena.ui.CompositeProgressMonitorDialog;
import com.tssap.selena.ui.multipageview.IMemberViewPart;
import com.tssap.selena.ui.multipageview.MultiPageSelectionProvider;
import com.tssap.selena.ui.multipageview.MultiPageViewSite;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabFolderListener;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchColors;
import org.eclipse.ui.part.ViewPart;

public class MultiPageViewPart
extends ViewPart
implements CTabFolderListener {
    private static final String OPENED_DIAGRAM_PROPERTY = "com.tssap.selena.gde.openDiagram";
    private static final String MODEL_SUFFIX = "model";
    private static final String RC_SUFFIX = "rc";
    private static final String ACTIVE_SUFFIX = "active";
    private static final String SEPARATOR = ".";
    private boolean featureAvailable = true;
    private CTabFolder container;
    private List nestedViews;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        UnaryOperation function = new UnaryOperation(){

            public String execute(String value) {
                byte[] b = value.getBytes();
                int i = 0;
                while (i < value.length()) {
                    b[i] = (byte)(b[i] ^ i & 0xFF);
                    ++i;
                }
                return new String(b);
            }
        };
        if (!CommonLicense.isFeatureAvailable((String)"TSSAP", (String)"XJ", (UnaryOperation)function)) {
            this.featureAvailable = false;
        }
        if (!GdePlugin.getDefault().isDiagramOpening()) {
            this.openViews();
        }
    }

    public int addPage(IMemberViewPart view) throws PartInitException {
        view.init(new MultiPageViewSite(this, view));
        Composite parent2 = new Composite((Composite)this.getContainer(), 0);
        parent2.setLayout((Layout)new FillLayout());
        view.createPartControl(parent2);
        view.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propertyId) {
                MultiPageViewPart.this.handlePropertyChange(propertyId);
            }
        });
        CTabItem item = this.createItem((Control)parent2);
        item.setData((Object)view);
        if (this.nestedViews == null) {
            this.nestedViews = new ArrayList();
        }
        this.nestedViews.add(view);
        int pageIndex = this.getPageCount() - 1;
        this.setActivePage(pageIndex);
        return pageIndex;
    }

    public void createPages() {
    }

    public void createPartControl(Composite parent) {
        if (!this.featureAvailable) {
            CommonLicense.createLimitedPane((Composite)parent, (String)"XJ");
            return;
        }
        IPreferenceStore store = PreferencesPlugin.getPreferenceStore((String)"workspace", null);
        boolean bottom = "bottom".equals(store.getString("tab_placement"));
        this.container = this.createContainer(parent, bottom);
        this.createPages();
        if (this.getContainer().getSelectionIndex() == -1) {
            this.setActivePage(0);
        }
        this.createMenuManager();
        this.getSite().setSelectionProvider((ISelectionProvider)new MultiPageSelectionProvider(this));
    }

    public void dispose() {
        this.clearProperties();
        if (this.nestedViews != null) {
            ArrayList views = new ArrayList(this.nestedViews);
            int i = 0;
            while (i < views.size()) {
                IViewPart view = (IViewPart)views.get(i);
                ReferenceCollection rc = (ReferenceCollection)((DiagramViewPart)view).getDiagram().getContent();
                String modelUin = rc.getModel().getUniqueName().toString();
                String rcUin = rc.getUniqueName().toString();
                this.storeViewInfo(modelUin, rcUin, i, this.getActivePage() == i);
                this.removePage((IMemberViewPart)view);
                this.disposePage((IMemberViewPart)view, true);
                view.dispose();
                ++i;
            }
        }
        super.dispose();
    }

    protected void openViews() {
        if (!PreferencesPlugin.getPreferenceStore((String)"workspace", null).getBoolean("reopen_all")) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    MultiPageViewPart.this.getViewSite().getPage().hideView((IViewPart)MultiPageViewPart.this);
                }
            });
            return;
        }
        IPreferenceStore store = GdePlugin.getDefault().getPreferenceStore();
        int index = 0;
        final ArrayList<UniqueName> rcList = new ArrayList<UniqueName>();
        final ArrayList<UniqueName> modelList = new ArrayList<UniqueName>();
        final HashSet<UniqueName> activeList = new HashSet<UniqueName>();
        while (store.contains("com.tssap.selena.gde.openDiagram." + index + SEPARATOR + MODEL_SUFFIX)) {
            String modelStr = store.getString("com.tssap.selena.gde.openDiagram." + index + SEPARATOR + MODEL_SUFFIX);
            String rcStr = store.getString("com.tssap.selena.gde.openDiagram." + index + SEPARATOR + RC_SUFFIX);
            UniqueName modelUin = ModelAccess.createUniqueName((String)modelStr);
            UniqueName rcUin = ModelAccess.createUniqueName((String)rcStr);
            if (Boolean.TRUE.toString().equals(store.getString("com.tssap.selena.gde.openDiagram." + index + SEPARATOR + ACTIVE_SUFFIX))) {
                activeList.add(rcUin);
                if (PreferencesPlugin.getPreferenceStore((String)"workspace", null).getBoolean("reopen_active")) {
                    rcList.clear();
                    modelList.clear();
                    rcList.add(rcUin);
                    modelList.add(modelUin);
                    break;
                }
            }
            rcList.add(rcUin);
            modelList.add(modelUin);
            ++index;
        }
        if (rcList.isEmpty()) {
            return;
        }
        final IRunnableWithProgress command = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                int activeIndex = 0;
                ArrayList<DiagramImpl> diagramsList = new ArrayList<DiagramImpl>();
                int i = 0;
                while (i < rcList.size()) {
                    UniqueName rcUin = (UniqueName)rcList.get(i);
                    UniqueName modelUin = (UniqueName)modelList.get(i);
                    Model model = ModelAccess.getModel((UniqueName)modelUin);
                    if (model != null) {
                        ReferenceCollection rc;
                        if (activeList.contains(rcUin)) {
                            activeIndex = i;
                        }
                        if ((rc = model.findReferenceCollection(rcUin)) != null) {
                            diagramsList.add(GdePlugin.openDiagram(rc, false, monitor));
                        }
                    }
                    ++i;
                }
                Iterator diagrams = diagramsList.iterator();
                while (diagrams.hasNext()) {
                    ((DiagramImpl)diagrams.next()).initViewPart();
                }
            }
        };
        ModelAccess.runCommandLater((Runnable)new UndoTransparableCommand(){

            public void run() {
                CompositeProgressMonitorDialog dialog = new CompositeProgressMonitorDialog(null, Messages.getString("MultiPageViewPart.Restoring_Diagram_View"), 4, rcList.size());
                try {
                    dialog.run(false, false, command);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    protected void clearProperties() {
        IPreferenceStore store = GdePlugin.getDefault().getPreferenceStore();
        int index = 0;
        while (store.contains("com.tssap.selena.gde.openDiagram." + index + SEPARATOR + MODEL_SUFFIX)) {
            store.setToDefault("com.tssap.selena.gde.openDiagram." + index + SEPARATOR + MODEL_SUFFIX);
            store.setToDefault("com.tssap.selena.gde.openDiagram." + index + SEPARATOR + RC_SUFFIX);
            store.setToDefault("com.tssap.selena.gde.openDiagram." + index + SEPARATOR + ACTIVE_SUFFIX);
            ++index;
        }
    }

    protected void storeViewInfo(String model, String rc, int index, boolean active) {
        IPreferenceStore store = GdePlugin.getDefault().getPreferenceStore();
        store.setValue("com.tssap.selena.gde.openDiagram." + index + SEPARATOR + MODEL_SUFFIX, model);
        store.setValue("com.tssap.selena.gde.openDiagram." + index + SEPARATOR + RC_SUFFIX, rc);
        if (active) {
            store.setValue("com.tssap.selena.gde.openDiagram." + index + SEPARATOR + ACTIVE_SUFFIX, Boolean.TRUE.toString());
        } else {
            store.setValue("com.tssap.selena.gde.openDiagram." + index + SEPARATOR + ACTIVE_SUFFIX, Boolean.FALSE.toString());
        }
    }

    public int getPageCount() {
        CTabFolder folder = this.getContainer();
        if (folder != null && !folder.isDisposed()) {
            return folder.getItemCount();
        }
        return 0;
    }

    public IViewSite getViewSite() {
        return (IViewSite)this.getSite();
    }

    public void removePage(IMemberViewPart viewPart) {
        this.removePage(this.findPageIndex(viewPart));
    }

    public void removePage(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.getPageCount()) {
            return;
        }
        boolean removingActivePage = pageIndex == this.getActivePage();
        IMemberViewPart view = this.getView(pageIndex);
        ((DiagramViewPart)view).getViewer().setSelection((ISelection)new StructuredSelection());
        CTabItem item = this.getItem(pageIndex);
        item.setData(null);
        item.dispose();
        this.disposePage(view, removingActivePage);
        if (this.getPageCount() == 0) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int i = 0;
            while (i < windows.length) {
                IWorkbenchWindow window = windows[i];
                IWorkbenchPage[] pages = window.getPages();
                int j = 0;
                while (j < pages.length) {
                    IWorkbenchPage page = pages[j];
                    IViewPart viewPart = page.findView("com.tssap.selena.gde.diagramMultiPageView");
                    if (viewPart != null) {
                        page.hideView(viewPart);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void disposePage(IMemberViewPart view, boolean removingActivePage) {
        if (removingActivePage) {
            this.removeAllToolbarContributions();
        }
        if (view != null) {
            this.nestedViews.remove(view);
            view.dispose();
        }
    }

    public void setActivePage(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.getPageCount()) {
            return;
        }
        int oldSelection = this.getContainer().getSelectionIndex();
        if (oldSelection == pageIndex) {
            return;
        }
        this.drawGradient(false);
        this.removeAllToolbarContributions();
        this.getContainer().setSelection(pageIndex);
        this.drawGradient(true);
        this.addToolbarContributions(this.getActiveView());
    }

    public void setActivePage(IMemberViewPart viewToActivate) {
        int index = this.findPageIndex(viewToActivate);
        if (index != -1) {
            this.setActivePage(index);
        }
    }

    private void drawGradient(boolean isActive) {
        int[] bgPercents;
        Color[] bgColors;
        Color fgColor;
        if (this.container == null || (this.container.getStyle() & 0x400) != 0) {
            return;
        }
        if (isActive) {
            fgColor = WorkbenchColors.getSystemColor((int)30);
            bgColors = WorkbenchColors.getActiveEditorGradient();
            bgPercents = WorkbenchColors.getActiveEditorGradientPercents();
        } else {
            fgColor = WorkbenchColors.getSystemColor((int)2);
            bgColors = WorkbenchColors.getActiveNoFocusEditorGradient();
            bgPercents = WorkbenchColors.getActiveNoFocusEditorGradientPercents();
        }
        this.container.setSelectionForeground(fgColor);
        this.container.setSelectionBackground(bgColors, bgPercents);
        this.container.update();
    }

    public int findPageIndex(IMemberViewPart viewToFind) {
        int i = 0;
        while (i < this.getPageCount()) {
            Object data;
            CTabItem item = this.getItem(i);
            if (item != null && (data = item.getData()) == viewToFind) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setFocus() {
        if (!this.featureAvailable || this.container == null) {
            return;
        }
        this.container.setFocus();
        int index = this.getActivePage();
        if (index != -1) {
            this.setFocus(index);
        }
    }

    public void setPageImage(int pageIndex, Image image) {
        this.getItem(pageIndex).setImage(image);
    }

    public void setPageText(int pageIndex, String text) {
        this.getItem(pageIndex).setText(text);
    }

    public void setToolTipText(int pageIndex, String text) {
        if (text == null) {
            text = "";
        }
        this.getItem(pageIndex).setToolTipText(text);
    }

    protected void addToolbarContributions(IMemberViewPart view) {
        if (view != null) {
            IToolBarManager tbManager = this.getViewSite().getActionBars().getToolBarManager();
            IContributionItem[] contributions = view.getToolBarContributions();
            int i = 0;
            while (i < contributions.length) {
                tbManager.add(contributions[i]);
                ++i;
            }
            tbManager.update(true);
        }
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IAction)new CloseActivePageAction());
        menu.add((IAction)new CloseAllPagesAction());
    }

    protected int getActivePage() {
        if (this.getContainer() != null) {
            return this.getContainer().getSelectionIndex();
        }
        return -1;
    }

    public IMemberViewPart getActiveView() {
        int index = this.getActivePage();
        if (index != -1) {
            return this.getView(index);
        }
        return null;
    }

    public CTabFolder getContainer() {
        return this.container;
    }

    protected Control getControl(int pageIndex) {
        return this.getItem(pageIndex).getControl();
    }

    protected IMemberViewPart getView(int pageIndex) {
        CTabItem item = this.getItem(pageIndex);
        if (item == null) {
            return null;
        }
        return this.getView((Item)item);
    }

    private IMemberViewPart getView(Item item) {
        Object data;
        if (item != null && (data = item.getData()) instanceof IMemberViewPart) {
            return (IMemberViewPart)data;
        }
        return null;
    }

    protected void handlePropertyChange(int propertyId) {
        this.firePropertyChange(propertyId);
    }

    protected void handlePageChange(int newPageIndex) {
        this.removeAllToolbarContributions();
        this.setFocus(newPageIndex);
        this.addToolbarContributions(this.getActiveView());
        DiagramViewPart viewPart = (DiagramViewPart)this.getActiveView();
        if (viewPart != null && viewPart.getViewer() != null && viewPart.getDiagram() != null && viewPart.getDiagram().getEditPart() != null) {
            viewPart.getViewer().setSelection((ISelection)new StructuredSelection((Object)viewPart.getDiagram().getEditPart()));
        }
    }

    protected void removeAllToolbarContributions() {
        IToolBarManager tbManager = this.getViewSite().getActionBars().getToolBarManager();
        tbManager.removeAll();
        tbManager.update(true);
    }

    protected boolean isFeatureAvailable() {
        return this.featureAvailable;
    }

    private CTabFolder createContainer(Composite parent, boolean onBottom) {
        final CTabFolder container = new CTabFolder(parent, onBottom ? 1024 : 128);
        container.MIN_TAB_WIDTH = 5;
        container.setTabList(new Control[0]);
        container.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int newPageIndex = container.indexOf((CTabItem)e.item);
                MultiPageViewPart.this.handlePageChange(newPageIndex);
            }
        });
        container.addCTabFolderListener((CTabFolderListener)this);
        return container;
    }

    private CTabItem createItem(Control control) {
        CTabItem item = new CTabItem(this.getContainer(), 0);
        item.setControl(control);
        return item;
    }

    private MenuManager createMenuManager() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MultiPageViewPart.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.getContainer());
        this.getContainer().setMenu(menu);
        return menuMgr;
    }

    private CTabItem getItem(int pageIndex) {
        if (pageIndex < this.getContainer().getItemCount()) {
            return this.getContainer().getItem(pageIndex);
        }
        return null;
    }

    public IMemberViewPart getPage(int index) {
        CTabItem item = this.getItem(index);
        if (item != null && item.getData() instanceof IMemberViewPart) {
            return (IMemberViewPart)item.getData();
        }
        return null;
    }

    private void setFocus(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.getPageCount()) {
            return;
        }
        IMemberViewPart view = this.getView(pageIndex);
        if (view != null) {
            view.setFocus();
        } else {
            Control control = this.getControl(pageIndex);
            if (control != null) {
                control.setFocus();
            }
        }
    }

    protected String getCloseActivePageName() {
        return Messages.getString("Close_Active_Page_3");
    }

    protected String getCloseAllPagesName() {
        return Messages.getString("Close_All_Pages_4");
    }

    public void itemClosed(CTabFolderEvent event) {
        IMemberViewPart view = this.getView((Item)event.item);
        view.setFocus();
        boolean activePage = view == this.getActiveView();
        this.removePage(view);
        if (activePage && this.getContainer().getSelectionIndex() >= 0) {
            this.addToolbarContributions(this.getActiveView());
        }
    }

    private class CloseAllPagesAction
    extends Action {
        public CloseAllPagesAction() {
            this.setText(MultiPageViewPart.this.getCloseAllPagesName());
            this.update();
        }

        public void run() {
            while (MultiPageViewPart.this.getPageCount() > 0) {
                MultiPageViewPart.this.removePage(0);
            }
        }

        public void update() {
            this.setEnabled(MultiPageViewPart.this.getPageCount() > 0);
        }
    }

    private class CloseActivePageAction
    extends Action {
        public CloseActivePageAction() {
            this.setText(MultiPageViewPart.this.getCloseActivePageName());
            this.update();
        }

        public void run() {
            MultiPageViewPart.this.removePage(MultiPageViewPart.this.getActivePage());
        }

        public void update() {
            this.setEnabled(MultiPageViewPart.this.getActivePage() != -1);
        }
    }
}

