/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.ui.multipageview;

import com.tssap.selena.ui.multipageview.IMemberViewPart;
import com.tssap.selena.ui.multipageview.MultiPageViewPart;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class MultiPageSelectionProvider
implements ISelectionProvider {
    private ListenerList listeners = new ListenerList();
    private MultiPageViewPart multiPageView;

    public MultiPageSelectionProvider(MultiPageViewPart multiPageView) {
        this.multiPageView = multiPageView;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add((Object)listener);
    }

    public void fireSelectionChanged(SelectionChangedEvent event) {
        Object[] listeners = this.listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ISelectionChangedListener)listeners[i]).selectionChanged(event);
            ++i;
        }
    }

    public MultiPageViewPart getMultiPageView() {
        return this.multiPageView;
    }

    public ISelection getSelection() {
        ISelectionProvider selectionProvider;
        IMemberViewPart activeView = this.multiPageView.getActiveView();
        if (activeView != null && (selectionProvider = activeView.getSite().getSelectionProvider()) != null) {
            return selectionProvider.getSelection();
        }
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        ISelectionProvider selectionProvider;
        IMemberViewPart activeView = this.multiPageView.getActiveView();
        if (activeView != null && (selectionProvider = activeView.getSite().getSelectionProvider()) != null) {
            selectionProvider.setSelection(selection);
        }
    }
}

