/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.draw2d;

import java.util.HashMap;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class BorderLayout
extends AbstractLayout {
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final String CENTER = "Center";
    int hgap;
    int vgap;
    IFigure north;
    IFigure west;
    IFigure east;
    IFigure south;
    IFigure center;
    private HashMap myFigureConstraints = new HashMap(5);

    public BorderLayout() {
        this(0, 0);
    }

    public BorderLayout(int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    protected Dimension calculatePreferredSize(IFigure target) {
        Dimension d;
        Dimension dim = new Dimension(0, 0);
        IFigure c = null;
        c = this.getChild(EAST);
        if (c != null) {
            d = c.getPreferredSize();
            dim.width += d.width + this.hgap;
            dim.height = Math.max(d.height, dim.height);
        }
        if ((c = this.getChild(WEST)) != null) {
            d = c.getPreferredSize();
            dim.width += d.width + this.hgap;
            dim.height = Math.max(d.height, dim.height);
        }
        if ((c = this.getChild(CENTER)) != null) {
            d = c.getPreferredSize();
            dim.width += d.width;
            dim.height = Math.max(d.height, dim.height);
        }
        if ((c = this.getChild(NORTH)) != null) {
            d = c.getPreferredSize();
            dim.width = Math.max(d.width, dim.width);
            dim.height += d.height + this.vgap;
        }
        if ((c = this.getChild(SOUTH)) != null) {
            d = c.getPreferredSize();
            dim.width = Math.max(d.width, dim.width);
            dim.height += d.height + this.vgap;
        }
        Insets insets = target.getInsets();
        dim.width += insets.left + insets.right;
        dim.height += insets.top + insets.bottom;
        return dim;
    }

    public void layout(IFigure target) {
        Rectangle bounds;
        Dimension d;
        Insets insets = target.getInsets();
        Dimension size = target.getSize();
        Rectangle clientArea = target.getClientArea();
        int top = insets.top;
        int bottom = size.height - insets.bottom;
        int left = insets.left;
        int right = size.width - insets.right;
        IFigure c = null;
        c = this.getChild(NORTH);
        if (c != null) {
            c.setSize(new Dimension(right - left, c.getSize().height));
            d = c.getPreferredSize();
            bounds = new Rectangle(left + clientArea.x, top + clientArea.y, right - left, d.height);
            c.setBounds(bounds);
            top += d.height + this.vgap;
        }
        if ((c = this.getChild(SOUTH)) != null) {
            c.setSize(new Dimension(right - left, c.getSize().height));
            d = c.getPreferredSize();
            bounds = new Rectangle(left + clientArea.x, bottom - d.height + clientArea.y, right - left, d.height);
            c.setBounds(bounds);
            bottom -= d.height + this.vgap;
        }
        if ((c = this.getChild(EAST)) != null) {
            c.setSize(new Dimension(c.getSize().width, bottom - top));
            d = c.getPreferredSize();
            bounds = new Rectangle(right - d.width + clientArea.x, top + clientArea.y, d.width, bottom - top);
            c.setBounds(bounds);
            right -= d.width + this.hgap;
        }
        if ((c = this.getChild(WEST)) != null) {
            c.setSize(new Dimension(c.getSize().width, bottom - top));
            d = c.getPreferredSize();
            bounds = new Rectangle(left + clientArea.x, top + clientArea.y, d.width, bottom - top);
            c.setBounds(bounds);
            left += d.width + this.hgap;
        }
        if ((c = this.getChild(CENTER)) != null) {
            Rectangle bounds2 = new Rectangle(left + clientArea.x, top + clientArea.y, right - left, bottom - top);
            c.setBounds(bounds2);
        }
    }

    public void setConstraint(IFigure comp, Object newConstraint) {
        super.setConstraint(comp, newConstraint);
        if (newConstraint == null || newConstraint instanceof String) {
            this.myFigureConstraints.put(comp, newConstraint);
            String name = (String)newConstraint;
            if (name == null) {
                name = CENTER;
            }
            if (CENTER.equals(name)) {
                this.center = comp;
            } else if (NORTH.equals(name)) {
                this.north = comp;
            } else if (SOUTH.equals(name)) {
                this.south = comp;
            } else if (EAST.equals(name)) {
                this.east = comp;
            } else if (WEST.equals(name)) {
                this.west = comp;
            } else {
                throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + name);
            }
        }
    }

    public Object getConstraint(IFigure child) {
        return this.myFigureConstraints.get(child);
    }

    public void remove(IFigure comp) {
        super.remove(comp);
        this.myFigureConstraints.remove(comp);
        if (comp == this.center) {
            this.center = null;
        } else if (comp == this.north) {
            this.north = null;
        } else if (comp == this.south) {
            this.south = null;
        } else if (comp == this.east) {
            this.east = null;
        } else if (comp == this.west) {
            this.west = null;
        }
    }

    private IFigure getChild(String key) {
        IFigure result = null;
        if (key == NORTH) {
            result = this.north;
        } else if (key == SOUTH) {
            result = this.south;
        } else if (key == WEST) {
            result = this.west;
        } else if (key == EAST) {
            result = this.east;
        } else if (key == CENTER) {
            result = this.center;
        }
        if (result != null && !result.isVisible()) {
            result = null;
        }
        return result;
    }
}

