/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.zoom.tools;

import com.tssap.selena.gde.internal.DiagramViewer;
import com.tssap.selena.gde.internal.commands.MoveLinkCommand;
import com.tssap.selena.gde.zoom.Zoomer;
import com.tssap.selena.gde.zoom.requests.ChangeBoundsRequest;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class DragEditPartsTracker
extends org.eclipse.gef.tools.DragEditPartsTracker {
    private Zoomer myZoomer;

    public DragEditPartsTracker(EditPart sourceEditPart) {
        super(sourceEditPart);
        this.myZoomer = ((DiagramViewer)sourceEditPart.getRoot().getViewer()).getZoomer();
    }

    protected Request createTargetRequest() {
        return new ChangeBoundsRequest("move", this.myZoomer);
    }

    protected Command getCommand() {
        CompoundCommand command = (CompoundCommand)super.getCommand();
        if (this.getTargetRequest() instanceof ChangeBoundsRequest) {
            Point delta = ((ChangeBoundsRequest)this.getTargetRequest()).getMoveDelta();
            Iterator parts = this.getOperationSet().iterator();
            while (parts.hasNext()) {
                GraphicalEditPart part = (GraphicalEditPart)parts.next();
                Rectangle bounds = part.getFigure().getBounds();
                bounds.x += delta.x;
                bounds.y += delta.y;
                if (bounds.x >= 0 && bounds.y >= 0) continue;
                return new CompoundCommand();
            }
            MoveLinkCommand links = new MoveLinkCommand(new ArrayList(this.getOperationSet()), delta);
            command.add((Command)links);
        }
        return command;
    }
}

