/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.zoom.draw2d;

import com.tssap.selena.gde.internal.DiagramViewer;
import com.tssap.selena.gde.zoom.Zoomer;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.RootEditPart;

public class ScalableStackLayout
extends StackLayout {
    private RootEditPart myRootEditPart;
    private Zoomer myZoomer = null;

    public ScalableStackLayout(RootEditPart rootEP) {
        this.myRootEditPart = rootEP;
    }

    protected Dimension calculatePreferredSize(IFigure figure) {
        Dimension d = new Dimension();
        List children = figure.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            d.union(child.getPreferredSize());
            ++i;
        }
        d = this.getZoomer().scale(d);
        d.expand(figure.getInsets().getWidth(), figure.getInsets().getHeight());
        d.union(this.getBorderPreferredSize(figure));
        return d;
    }

    public Dimension getMinimumSize(IFigure figure) {
        Dimension d = new Dimension();
        List children = figure.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            d.union(child.getMinimumSize());
            ++i;
        }
        d = this.getZoomer().scale(d);
        d.expand(figure.getInsets().getWidth(), figure.getInsets().getHeight());
        return d;
    }

    public void layout(IFigure figure) {
        Rectangle r = figure.getClientArea();
        r = this.getZoomer().unscale(r);
        List children = figure.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            child.setBounds(r);
            ++i;
        }
    }

    private Zoomer getZoomer() {
        DiagramViewer viewer = (DiagramViewer)this.myRootEditPart.getViewer();
        if (viewer != null) {
            return viewer.getZoomer();
        }
        return new Zoomer();
    }
}

