/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.zoom.draw2d;

import com.tssap.selena.gde.internal.DiagramRootEditPart;
import com.tssap.selena.gde.internal.DiagramViewer;
import com.tssap.selena.gde.zoom.ScalableGraphics;
import com.tssap.selena.gde.zoom.Zoomer;
import com.tssap.selena.gde.zoom.draw2d.ScalableStackLayout;
import java.util.Collection;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.RootEditPart;

public class ScalableLayeredPane
extends LayeredPane {
    private final Point myTestPoint = new Point(0, 0);
    private RootEditPart myRootEditPart;

    public ScalableLayeredPane(DiagramRootEditPart rootEP) {
        this.myRootEditPart = rootEP;
        this.setLayoutManager((LayoutManager)new ScalableStackLayout((RootEditPart)rootEP));
    }

    public void paint(Graphics graphics) {
        ScalableGraphics scalableGraphics = new ScalableGraphics(graphics, this.getZoomer());
        if (graphics instanceof ScalableGraphics) {
            scalableGraphics.setGridEnabled(((ScalableGraphics)graphics).isGridEanbled());
        }
        super.paint((Graphics)scalableGraphics);
        scalableGraphics.disposeFonts();
    }

    public void translateFromParent(Translatable t) {
        this.myTestPoint.x = 0;
        this.myTestPoint.y = 0;
        this.getParent().translateFromParent((Translatable)this.myTestPoint);
        this.getParent().translateToRelative((Translatable)this.myTestPoint);
        t.performTranslate(this.myTestPoint.x, this.myTestPoint.y);
        t.performScale(1.0f / this.getZoomer().getScale());
        t.performTranslate(-1 * this.myTestPoint.x, -1 * this.myTestPoint.y);
    }

    public void translateToParent(Translatable t) {
        t.performScale(this.getZoomer().getScale());
    }

    protected IFigure findMouseEventTargetInDescendantsAt(int x, int y) {
        if (this.useLocalCoordinates()) {
            x -= this.getBounds().x + this.getInsets().left;
            y -= this.getBounds().y + this.getInsets().top;
        }
        x = this.getZoomer().unscale(x);
        y = this.getZoomer().unscale(y);
        Figure.FigureIterator iter = new Figure.FigureIterator((IFigure)this);
        while (iter.hasNext()) {
            IFigure fig = iter.nextFigure();
            if (!fig.isVisible() || !fig.isEnabled() || !fig.containsPoint(x, y)) continue;
            fig = fig.findMouseEventTargetAt(x, y);
            return fig;
        }
        return null;
    }

    public IFigure findMouseEventTargetAt(int x, int y) {
        if (!this.containsPoint(x, y)) {
            return null;
        }
        IFigure f = this.findMouseEventTargetInDescendantsAt(x, y);
        if (f != null) {
            return f;
        }
        if (this.isMouseEventTarget()) {
            return this;
        }
        return null;
    }

    protected IFigure findDescendantAtExcluding(int x, int y, Collection c) {
        if (this.useLocalCoordinates()) {
            x -= this.getBounds().x + this.getInsets().left;
            y -= this.getBounds().y + this.getInsets().top;
        }
        if (!this.getClientArea(Rectangle.SINGLETON).contains(x, y)) {
            return null;
        }
        x = this.getZoomer().unscale(x);
        y = this.getZoomer().unscale(y);
        Figure.FigureIterator iter = new Figure.FigureIterator((IFigure)this);
        while (iter.hasNext()) {
            IFigure fig = iter.nextFigure();
            if (!fig.isVisible() || (fig = fig.findFigureAtExcluding(x, y, c)) == null) continue;
            return fig;
        }
        return null;
    }

    public boolean containsPoint(int x, int y) {
        return super.containsPoint(this.getZoomer().unscale(x), this.getZoomer().unscale(y));
    }

    public IFigure findFigureAtExcluding(int x, int y, Collection c) {
        return super.findFigureAtExcluding(x, y, c);
    }

    public Zoomer getZoomer() {
        DiagramViewer viewer = (DiagramViewer)this.myRootEditPart.getViewer();
        if (viewer != null) {
            return viewer.getZoomer();
        }
        return new Zoomer();
    }
}

