/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.zoom.draw2d;

import org.eclipse.draw2d.DefaultRangeModel;

public class PositionSavingRangeModel
extends DefaultRangeModel {
    private boolean mySavePositionFlag = false;
    private float myRatio = 0.0f;

    public void savePositionOnResize() {
        if (this.isEnabled()) {
            this.mySavePositionFlag = true;
        }
    }

    public void setMaximum(int maximum) {
        if (this.getMaximum() == maximum) {
            super.setMaximum(maximum);
            return;
        }
        if (this.mySavePositionFlag) {
            this.storeRelativePosition();
        }
        super.setMaximum(maximum);
        if (this.mySavePositionFlag) {
            this.restoreRelativePosition();
        }
    }

    public void setMinimum(int minimum) {
        if (this.getMinimum() == minimum) {
            super.setMinimum(minimum);
            return;
        }
        if (this.mySavePositionFlag) {
            this.storeRelativePosition();
        }
        super.setMinimum(minimum);
        if (this.mySavePositionFlag) {
            this.restoreRelativePosition();
        }
    }

    private void storeRelativePosition() {
        this.myRatio = this.getMaximum() - this.getMinimum();
        this.myRatio = (float)(this.getValue() + this.getExtent() / 2) / this.myRatio;
    }

    private void restoreRelativePosition() {
        this.mySavePositionFlag = false;
        float absoluteRange = this.getMaximum() - this.getMinimum();
        this.setValue(Math.round(this.myRatio * absoluteRange - (float)(this.getExtent() / 2)));
    }
}

