/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.zoom;

import com.tssap.selena.gde.internal.DiagramRootEditPart;
import com.tssap.selena.gde.internal.DiagramViewer;
import com.tssap.selena.gde.internal.actions.AbstractDiagramAwareAction;
import com.tssap.selena.gde.zoom.Zoomer;
import com.tssap.selena.gde.zoom.draw2d.PositionSavingRangeModel;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Control;

public class ZoomAction
extends AbstractDiagramAwareAction
implements IExecutableExtension {
    private static final String ATTRIBUTE_ZOOM_TYPE = "zoomType";
    private static final String ZOOM_TYPE_IN = "zoomIn";
    private static final String ZOOM_TYPE_OUT = "zoomOut";
    private static final String ZOOM_TYPE_INITIAL = "zoomToInitialSize";
    private static final float ZOOM_INCREMENT = 1.25f;
    private static final float ZOOM_MAXIMUM = 10.0f;
    private boolean myZoomToInitial = false;
    private boolean myZoomIn = false;

    protected boolean customIsChecked() {
        return false;
    }

    public void setInitializationData(IConfigurationElement configElement, String propertyName, Object data) {
        String zoomType = configElement.getAttribute(ATTRIBUTE_ZOOM_TYPE);
        if (ZOOM_TYPE_INITIAL.equalsIgnoreCase(zoomType)) {
            this.myZoomToInitial = true;
            return;
        }
        if (ZOOM_TYPE_IN.equalsIgnoreCase(zoomType)) {
            this.myZoomIn = true;
            return;
        }
        this.myZoomIn = false;
    }

    protected boolean customIsEnabled() {
        return this.getCurrentDiagramViewer() != null && this.getCurrentDiagramEditPart() != null;
    }

    public void run(IAction action) {
        Control diagramCanvas;
        DiagramViewer viewer = this.getCurrentDiagramViewer();
        Zoomer zoomer = viewer.getZoomer();
        float oldScale = zoomer.getScale();
        if (this.myZoomToInitial) {
            zoomer.setScale(1.0f);
        } else if (this.myZoomIn) {
            if (oldScale < 10.0f) {
                zoomer.setScale(oldScale * 1.25f);
            }
        } else {
            zoomer.setScale(oldScale / 1.25f);
        }
        if (viewer.getRootEditPart() instanceof DiagramRootEditPart) {
            DiagramRootEditPart rootEP = (DiagramRootEditPart)viewer.getRootEditPart();
            ScrollPane scrollPane = rootEP.getDiagramScrollPane();
            this.setSavePositionFlag(scrollPane.getVerticalScrollBar());
            this.setSavePositionFlag(scrollPane.getHorizontalScrollBar());
        }
        this.getCurrentDiagramEditPart().refresh();
        if ("gtk".equals(BootLoader.getWS()) && (diagramCanvas = this.getCurrentDiagramEditPart().getDiagramCanvas()) != null) {
            this.getCurrentDiagramEditPart().getDiagramCanvas().redraw();
        }
    }

    private void setSavePositionFlag(ScrollBar scrollBar) {
        RangeModel rangeModel = scrollBar.getRangeModel();
        if (rangeModel instanceof PositionSavingRangeModel) {
            ((PositionSavingRangeModel)rangeModel).savePositionOnResize();
        }
    }
}

