/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.zoom;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public class ScalableSWTGraphics
extends SWTGraphics {
    private float scaleF = 1.0f;
    private FontCache fontCache = new FontCache();

    public ScalableSWTGraphics(GC gc) {
        super(gc);
    }

    public void clipRect(Rectangle rect) {
        super.clipRect(this.scale(rect, true));
    }

    public void dispose() {
        this.fontCache.dispose();
    }

    public void drawArc(Rectangle r, int offset, int length) {
        super.drawArc(this.scale(r, true), this.scale(offset), this.scale(length));
    }

    public void drawFocus(int x, int y, int w, int h) {
        super.drawFocus(this.scale(x), this.scale(y), this.scale(w), this.scale(h));
    }

    public void drawImage(Image srcImage, int x, int y) {
        super.drawImage(srcImage, this.scale(x), this.scale(y));
    }

    public void drawImage(Image srcImage, int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        super.drawImage(srcImage, this.scale(x1), this.scale(y1), this.scale(w1), this.scale(h1), this.scale(x2), this.scale(y2), this.scale(w2), this.scale(h2));
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        super.drawLine(this.scale(x1), this.scale(y1), this.scale(x2), this.scale(y2));
    }

    public void drawOval(Rectangle r) {
        super.drawOval(this.scale(r, true));
    }

    public void drawPolygon(PointList points) {
        super.drawPolygon(this.scale(points));
    }

    public void drawPolyline(PointList points) {
        super.drawPolyline(this.scale(points));
    }

    public void drawRectangle(int x, int y, int width, int height) {
        super.drawRectangle(this.scale(x), this.scale(y), this.scale(width), this.scale(height));
    }

    public void drawRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        super.drawRoundRectangle(this.scale(r, true), this.scale(arcWidth), this.scale(arcHeight));
    }

    public void drawString(String s, int x, int y) {
        super.drawString(s, this.scale(x), this.scale(y));
    }

    public void drawText(String s, int x, int y) {
        super.drawText(s, this.scale(x), this.scale(y));
    }

    public void fillArc(Rectangle r, int offset, int length) {
        super.fillArc(this.scale(r, true), this.scale(offset), this.scale(length));
    }

    public void fillOval(Rectangle r) {
        super.fillOval(this.scale(r, true));
    }

    public void fillPolygon(PointList points) {
        super.fillPolygon(this.scale(points));
    }

    public void fillRectangle(int x, int y, int width, int height) {
        super.fillRectangle(this.scale(x), this.scale(y), this.scale(width), this.scale(height));
    }

    public void fillRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        super.fillRoundRectangle(this.scale(r, true), this.scale(arcWidth), this.scale(arcHeight));
    }

    public void fillString(String s, int x, int y) {
        super.fillString(s, this.scale(x), this.scale(y));
    }

    public void fillText(String s, int x, int y) {
        super.fillText(s, this.scale(x), this.scale(y));
    }

    public Rectangle getClip(Rectangle rect) {
        rect = super.getClip(this.scale(rect, false));
        rect = this.unscale(rect, false);
        return rect;
    }

    public Font getFont() {
        Font f = super.getFont();
        return this.unscale(f);
    }

    public void pushState() {
        super.pushState();
    }

    public void scale(float amount) {
        this.scaleF = amount;
    }

    public void setClip(Rectangle rect) {
        super.setClip(this.scale(rect, true));
    }

    public void setFont(Font f) {
        Font scaledFont;
        FontData fd = f.getFontData()[0];
        int scaledHeight = this.scale(fd.getHeight());
        if (scaledHeight != fd.getHeight()) {
            FontData scaledFD = new FontData(fd.getName(), scaledHeight, fd.getStyle());
            if (this.fontCache.has(scaledFD)) {
                scaledFont = this.fontCache.get((FontData)scaledFD).scaled;
            } else {
                scaledFont = new Font(null, scaledFD);
                this.fontCache.put(scaledFD, f, scaledFont);
            }
        } else {
            scaledFont = f;
            this.fontCache.put(fd, f, f);
        }
        super.setFont(scaledFont);
    }

    public void translate(int x, int y) {
        super.translate(this.scale(x), this.scale(y));
    }

    protected void restoreState(SWTGraphics.State s) {
        try {
            SWTGraphics.State ss = (SWTGraphics.State)s.clone();
            ss.font = this.unscale(s.font);
            super.restoreState(ss);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    protected int scale(int x) {
        int result = Math.round(this.scaleF * (float)x);
        return result;
    }

    protected Rectangle scale(Rectangle r, boolean copy) {
        Rectangle rr = copy ? new Rectangle() : r;
        rr.x = this.scale(r.x);
        rr.y = this.scale(r.y);
        rr.width = this.scale(r.width);
        rr.height = this.scale(r.height);
        return rr;
    }

    protected PointList scale(PointList points) {
        PointList scaled = new PointList(points.size());
        int[] intArray = points.toIntArray();
        int i = 0;
        while (i < points.size()) {
            scaled.addPoint(this.scale(intArray[2 * i]), this.scale(intArray[2 * i + 1]));
            ++i;
        }
        return scaled;
    }

    protected int unscale(int x) {
        int result = Math.round(1.0f / this.scaleF * (float)x);
        return result;
    }

    protected Rectangle unscale(Rectangle r, boolean copy) {
        Rectangle rr = copy ? new Rectangle() : r;
        rr.x = this.unscale(r.x);
        rr.y = this.unscale(r.y);
        rr.width = this.unscale(r.width);
        rr.height = this.unscale(r.height);
        return rr;
    }

    protected Font unscale(Font f) {
        FontData fd = f.getFontData()[0];
        FontRecord fr = this.fontCache.get(fd);
        return fr == null ? f : fr.unscaled;
    }

    private void print(Font f) {
        System.out.println("Font: " + f);
        if (f != null) {
            System.out.println("  fd: " + f.getFontData()[0]);
        }
    }

    static class FontCache {
        private Map map = new HashMap();

        FontCache() {
        }

        void dispose() {
            Collection frs = this.map.values();
            Iterator itr = frs.iterator();
            while (itr.hasNext()) {
                FontRecord fr = (FontRecord)itr.next();
                if (fr.unscaled == fr.scaled) continue;
                fr.scaled.dispose();
            }
        }

        FontRecord get(FontData scaledFD) {
            return (FontRecord)this.map.get(scaledFD);
        }

        boolean has(FontData scaledFD) {
            return this.get(scaledFD) != null;
        }

        void put(FontData scaledFD, Font unscaled, Font scaled) {
            this.map.put(scaledFD, new FontRecord(unscaled, scaled));
        }
    }

    static class FontRecord {
        Font unscaled;
        Font scaled;

        FontRecord(Font unscaled, Font scaled) {
            this.unscaled = unscaled;
            this.scaled = scaled;
        }
    }
}

