/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.zoom;

import com.tssap.selena.gde.zoom.Zoomer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class ScalableGraphics
extends Graphics {
    private Graphics myGraphics;
    private Zoomer myZoomer;
    private Map myScaledFonts = new HashMap();
    private Map myUnscaledFonts = new HashMap();
    private boolean myIsGridEnabled = true;

    public ScalableGraphics(Graphics destination, Zoomer zoomer) {
        this.myGraphics = destination;
        this.myZoomer = zoomer;
        this.setFont(JFaceResources.getDefaultFont());
    }

    public void clipRect(org.eclipse.draw2d.geometry.Rectangle r) {
        org.eclipse.draw2d.geometry.Rectangle scaled = new org.eclipse.draw2d.geometry.Rectangle();
        scaled.x = this.myZoomer.scale(r.x);
        scaled.y = this.myZoomer.scale(r.y);
        scaled.width = this.myZoomer.scale(r.right()) - scaled.x + 1;
        scaled.height = this.myZoomer.scale(r.bottom()) - scaled.y + 1;
        this.myGraphics.clipRect(scaled);
    }

    public boolean isGridEanbled() {
        return this.myIsGridEnabled;
    }

    public void setGridEnabled(boolean enabled) {
        this.myIsGridEnabled = enabled;
    }

    public void drawArc(org.eclipse.draw2d.geometry.Rectangle r, int offset, int length) {
        this.myGraphics.drawArc(this.myZoomer.scale(r), offset, length);
    }

    public void fillArc(org.eclipse.draw2d.geometry.Rectangle r, int offset, int length) {
        this.myGraphics.fillArc(this.myZoomer.scale(r), offset, length);
    }

    public void drawFocus(org.eclipse.draw2d.geometry.Rectangle r) {
        this.myGraphics.drawFocus(this.myZoomer.scale(r));
    }

    public void drawFocus(int x, int y, int w, int h) {
        this.myGraphics.drawFocus(this.myZoomer.scale(x), this.myZoomer.scale(y), this.myZoomer.scale(w), this.myZoomer.scale(h));
    }

    public void drawImage(Image srcImage, Point p) {
        Rectangle size = srcImage.getBounds();
        this.myGraphics.drawImage(srcImage, size.x, size.y, size.width, size.height, this.myZoomer.scale(p.x), this.myZoomer.scale(p.y), this.myZoomer.scale(size.width), this.myZoomer.scale(size.height));
    }

    public void drawImage(Image srcImage, int x, int y) {
        Rectangle size = srcImage.getBounds();
        this.myGraphics.drawImage(srcImage, size.x, size.y, size.width, size.height, this.myZoomer.scale(x), this.myZoomer.scale(y), this.myZoomer.scale(size.width), this.myZoomer.scale(size.height));
    }

    public void drawImage(Image srcImage, org.eclipse.draw2d.geometry.Rectangle src, org.eclipse.draw2d.geometry.Rectangle dest) {
        this.myGraphics.drawImage(srcImage, src, this.myZoomer.scale(dest));
    }

    public void drawImage(Image srcImage, int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        this.myGraphics.drawImage(srcImage, x1, y1, w1, h1, this.myZoomer.scale(x2), this.myZoomer.scale(y2), this.myZoomer.scale(w2), this.myZoomer.scale(h2));
    }

    public void drawLine(Point p1, Point p2) {
        this.myGraphics.drawLine(this.myZoomer.scale(p1), this.myZoomer.scale(p2));
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.myGraphics.drawLine(this.myZoomer.scale(x1), this.myZoomer.scale(y1), this.myZoomer.scale(x2), this.myZoomer.scale(y2));
    }

    public void drawOval(org.eclipse.draw2d.geometry.Rectangle r) {
        this.myGraphics.drawOval(this.myZoomer.scale(r));
    }

    public void fillOval(org.eclipse.draw2d.geometry.Rectangle r) {
        this.myGraphics.fillOval(this.myZoomer.scaleFill(r));
    }

    public void drawPolygon(PointList points) {
        this.myGraphics.drawPolygon(this.myZoomer.scale(points));
    }

    public void fillPolygon(PointList points) {
        this.myGraphics.fillPolygon(this.myZoomer.scale(points));
    }

    public void drawPolyline(PointList points) {
        this.myGraphics.drawPolyline(this.myZoomer.scale(points));
    }

    public void drawRectangle(org.eclipse.draw2d.geometry.Rectangle r) {
        this.myGraphics.drawRectangle(this.myZoomer.scale(r));
    }

    public void drawRectangle(int x1, int x2, int width, int height) {
        this.myGraphics.drawRectangle(this.myZoomer.scale(x1), this.myZoomer.scale(x2), this.myZoomer.scale(width), this.myZoomer.scale(height));
    }

    public void fillRectangle(org.eclipse.draw2d.geometry.Rectangle r) {
        this.myGraphics.fillRectangle(this.myZoomer.scaleFill(r));
    }

    public void fillRectangle(int x1, int x2, int width, int height) {
        this.myGraphics.fillRectangle(this.myZoomer.scale(x1), this.myZoomer.scale(x2), this.myZoomer.scale(width), this.myZoomer.scale(height));
    }

    public void drawRoundRectangle(org.eclipse.draw2d.geometry.Rectangle r, int arcWidth, int arcHeight) {
        this.myGraphics.drawRoundRectangle(this.myZoomer.scale(r), this.myZoomer.scale(arcWidth), this.myZoomer.scale(arcHeight));
    }

    public void fillRoundRectangle(org.eclipse.draw2d.geometry.Rectangle r, int arcWidth, int arcHeight) {
        this.myGraphics.fillRoundRectangle(this.myZoomer.scaleFill(r), this.myZoomer.scale(arcWidth), this.myZoomer.scale(arcHeight));
    }

    public void drawString(String s, Point p, Graphics.TransparencyFlag transparent) {
        this.myGraphics.drawString(s, this.scaleTextPoint(p.x, p.y), transparent);
    }

    public void drawText(String s, Point p, Graphics.TransparencyFlag transparent) {
        this.myGraphics.drawText(s, this.scaleTextPoint(p.x, p.y), transparent);
    }

    public void drawString(String s, int x, int y, Graphics.TransparencyFlag transparent) {
        Point scaledPoint = this.scaleTextPoint(x, y);
        this.myGraphics.drawString(s, scaledPoint.x, scaledPoint.y, transparent);
    }

    public void drawText(String s, int x, int y, Graphics.TransparencyFlag transparent) {
        Point scaledPoint = this.scaleTextPoint(x, y);
        this.myGraphics.drawText(s, scaledPoint.x, scaledPoint.y, transparent);
    }

    public int getAdvanceWidth(char c) {
        return this.myZoomer.unscale(this.myGraphics.getAdvanceWidth(c));
    }

    public Color getBackgroundColor() {
        return this.myGraphics.getBackgroundColor();
    }

    public int getCharWidth(char c) {
        return this.myZoomer.unscale(this.myGraphics.getCharWidth(c));
    }

    public org.eclipse.draw2d.geometry.Rectangle getClip(org.eclipse.draw2d.geometry.Rectangle rect) {
        rect = this.myGraphics.getClip(rect);
        rect.width = this.myZoomer.unscale(rect.right() - 1) - this.myZoomer.unscale(rect.x);
        rect.height = this.myZoomer.unscale(rect.bottom() - 1) - this.myZoomer.unscale(rect.y);
        rect.x = this.myZoomer.unscale(rect.x);
        rect.y = this.myZoomer.unscale(rect.y);
        return rect;
    }

    public Font getFont() {
        Font font = this.myGraphics.getFont();
        if (this.myUnscaledFonts.containsKey(font)) {
            return (Font)this.myUnscaledFonts.get(font);
        }
        return font;
    }

    public FontMetrics getFontMetrics() {
        return FigureUtilities.getFontMetrics((Font)this.getFont());
    }

    public Color getForegroundColor() {
        return this.myGraphics.getForegroundColor();
    }

    public int getLineStyle() {
        return this.myGraphics.getLineStyle();
    }

    public int getLineWidth() {
        return this.myZoomer.unscale(this.myGraphics.getLineWidth());
    }

    public Dimension getStringExtent(String s) {
        return this.myZoomer.unscale(this.myGraphics.getStringExtent(s));
    }

    public Dimension getTextExtent(String s) {
        return this.myZoomer.unscale(this.myGraphics.getTextExtent(s));
    }

    public boolean getXORMode() {
        return this.myGraphics.getXORMode();
    }

    public void popState() {
        this.myGraphics.popState();
    }

    public void pushState() {
        this.myGraphics.pushState();
    }

    public void restoreState() {
        this.myGraphics.restoreState();
    }

    public void scale(float amount) {
        this.myGraphics.scale(amount);
    }

    public void setBackgroundColor(Color rgb) {
        this.myGraphics.setBackgroundColor(rgb);
    }

    public void setClip(org.eclipse.draw2d.geometry.Rectangle r) {
        org.eclipse.draw2d.geometry.Rectangle scaled = new org.eclipse.draw2d.geometry.Rectangle();
        scaled.x = this.myZoomer.scale(r.x);
        scaled.y = this.myZoomer.scale(r.y);
        scaled.width = this.myZoomer.scale(r.right()) - scaled.x + 1;
        scaled.height = this.myZoomer.scale(r.bottom()) - scaled.y + 1;
        this.myGraphics.setClip(scaled);
    }

    public void setFont(Font f) {
        Font newFont = (Font)this.myScaledFonts.get(f);
        if (newFont == null) {
            newFont = this.myZoomer.scale(f);
            this.myScaledFonts.put(f, newFont);
            this.myUnscaledFonts.put(newFont, f);
        }
        this.myGraphics.setFont(newFont);
    }

    public void setForegroundColor(Color rgb) {
        this.myGraphics.setForegroundColor(rgb);
    }

    public void setLineStyle(int style) {
        this.myGraphics.setLineStyle(style);
    }

    public void setLineWidth(int width) {
        this.myGraphics.setLineWidth(this.myZoomer.scale(width));
    }

    public void setXORMode(boolean b) {
        this.myGraphics.setXORMode(b);
    }

    public void translate(Point pt) {
        Point tmpPoint = this.myZoomer.scale(pt);
        this.myGraphics.translate(tmpPoint);
        tmpPoint = this.myZoomer.unscale(tmpPoint);
        pt.x = tmpPoint.x;
        pt.y = tmpPoint.y;
    }

    public void translate(int x, int y) {
        this.myGraphics.translate(this.myZoomer.scale(x), this.myZoomer.scale(y));
    }

    public void disposeFonts() {
        Iterator it = this.myScaledFonts.values().iterator();
        while (it.hasNext()) {
            Font font = (Font)it.next();
            if (font.isDisposed()) continue;
            font.dispose();
        }
        this.myScaledFonts.clear();
        this.myUnscaledFonts.clear();
    }

    private Point scaleTextPoint(int x, int y) {
        FontMetrics metrics = this.getFontMetrics();
        int localFontHeight = metrics.getHeight() - metrics.getDescent();
        metrics = this.myGraphics.getFontMetrics();
        int targetFontHeight = metrics.getHeight() - metrics.getDescent();
        return new Point(this.myZoomer.scale(x), this.myZoomer.scale(y + localFontHeight - 1) - targetFontHeight + 1);
    }
}

