/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.viewmap;

import com.tssap.selena.gde.ModelElementEditPart;
import com.tssap.selena.gde.viewmap.IViewMapMatcher;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Reference;

public class PropertyViewMapMatcher
implements IViewMapMatcher {
    private String[] propertyNames;
    private boolean[] entityProperties;
    private String[] propertyValues;

    public PropertyViewMapMatcher(String[] propertyNames, boolean[] entityProperties, String[] propertyValues) {
        if (propertyNames.length != propertyValues.length) {
            throw new IllegalArgumentException();
        }
        this.propertyNames = propertyNames;
        this.entityProperties = entityProperties;
        this.propertyValues = propertyValues;
    }

    public boolean isViewMapApplicable(ModelElementEditPart editPart) {
        int ip = 0;
        while (ip < this.propertyNames.length) {
            String expectedValue = this.propertyValues[ip];
            String value = this.getPropertyValue(this.propertyNames[ip], this.entityProperties[ip], editPart);
            if (expectedValue == null ? value != null : !expectedValue.equals(value)) {
                return false;
            }
            ++ip;
        }
        return true;
    }

    protected String getPropertyValue(String name, boolean entityProperty, ModelElementEditPart editPart) {
        Element element = editPart.getElement();
        if (entityProperty) {
            element = ((Reference)element).getEntity();
        }
        String value = element.getPropertyValue(name);
        return value;
    }
}

