/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.viewmap;

import com.tssap.selena.gde.ModelElementEditPart;
import com.tssap.selena.gde.internal.GdePlugin;
import com.tssap.selena.gde.internal.editparts.NodeEditPart;
import com.tssap.selena.gde.internal.editpolicies.ConnectableNodeEditPolicy;
import com.tssap.selena.gde.internal.editpolicies.GDEResizableEditPolicy;
import com.tssap.selena.gde.internal.editpolicies.NonlayoutableEditPolicy;
import com.tssap.selena.gde.internal.editpolicies.PartlyResizableEditPolicy;
import com.tssap.selena.gde.internal.editpolicies.XYLayoutWithMinimumSizeEditPolicy;
import com.tssap.selena.gde.internal.grid.IGridSetup;
import com.tssap.selena.gde.internal.handles.ZoomableNonResizableHandleKit;
import com.tssap.selena.gde.viewmap.DefaultElementEditPolicyAdapter;
import com.tssap.selena.gde.viewmap.IViewMapParameters;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class DefaultNodeEditPolicyAdapter
extends DefaultElementEditPolicyAdapter {
    public void createEditPolicies(ModelElementEditPart editPart, IViewMapParameters parameters) {
        super.createEditPolicies(editPart, parameters);
        IGridSetup gridSetup = GdePlugin.getDefault().getGridSetup(editPart.getDiagram());
        if (parameters.toBoolean("resizable", false)) {
            if (editPart instanceof NodeEditPart && ((NodeEditPart)editPart).isInner()) {
                editPart.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new NonResizableEditPolicyWithSelection());
            } else {
                editPart.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new GDEResizableEditPolicy(gridSetup));
            }
        } else if (editPart instanceof NodeEditPart && ((NodeEditPart)editPart).isInner()) {
            editPart.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new NonResizableEditPolicyWithSelection());
        } else {
            editPart.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new NonResizableEditPolicy(){

                protected List createSelectionHandles() {
                    ArrayList list = new ArrayList();
                    ZoomableNonResizableHandleKit.addHandles((GraphicalEditPart)this.getHost(), list);
                    return list;
                }
            });
        }
        if (parameters.toBoolean("resizable_height", false)) {
            editPart.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new PartlyResizableEditPolicy(5));
        }
        if (parameters.toBoolean("resizable_width", false)) {
            editPart.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new PartlyResizableEditPolicy(24));
        }
        if (parameters.toBoolean("container", false)) {
            editPart.installEditPolicy("LayoutEditPolicy", (EditPolicy)new XYLayoutWithMinimumSizeEditPolicy(gridSetup));
        } else {
            editPart.installEditPolicy("LayoutEditPolicy", (EditPolicy)new NonlayoutableEditPolicy());
        }
        boolean resizable = parameters.toBoolean("outgoingLinks", parameters.toBoolean("resizable", false));
        if (resizable) {
            editPart.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new ConnectableNodeEditPolicy());
        }
    }

    private static class NonResizableEditPolicyWithSelection
    extends NonResizableEditPolicy {
        private boolean myPreviousOpaque;
        private Color myPreviousBackground;
        private Color myPreviousForeground;

        private NonResizableEditPolicyWithSelection() {
        }

        protected void showSelection() {
            IFigure figure = ((GraphicalEditPart)this.getHost()).getFigure();
            if (this.myPreviousBackground == null) {
                this.myPreviousBackground = figure.getBackgroundColor();
                this.myPreviousForeground = figure.getForegroundColor();
                this.myPreviousOpaque = figure.isOpaque();
            }
            figure.setOpaque(true);
            figure.setBackgroundColor(Display.getCurrent().getSystemColor(26));
            figure.setForegroundColor(Display.getCurrent().getSystemColor(27));
        }

        protected void hideSelection() {
            IFigure figure = ((GraphicalEditPart)this.getHost()).getFigure();
            figure.setOpaque(this.myPreviousOpaque);
            figure.setBackgroundColor(this.myPreviousBackground);
            figure.setForegroundColor(this.myPreviousForeground);
            this.myPreviousBackground = null;
            this.myPreviousForeground = null;
        }

        protected List createSelectionHandles() {
            ArrayList list = new ArrayList();
            ZoomableNonResizableHandleKit.addHandles((GraphicalEditPart)this.getHost(), list);
            return list;
        }
    }
}

