/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.viewmap;

import com.tssap.selena.gde.IElementViewMap;
import com.tssap.selena.gde.internal.viewmap.ViewMapParameters;
import com.tssap.selena.gde.viewmap.IViewMapDescriptor;
import com.tssap.selena.gde.viewmap.IViewMapMatcher;
import com.tssap.selena.gde.viewmap.IViewMapParameters;
import com.tssap.selena.gde.viewmap.IViewMapRecord;

public class ViewMapRecord
implements IViewMapRecord {
    private IViewMapDescriptor descriptor;
    private IViewMapMatcher matcher;
    private int priority;
    private int rank;
    private IElementViewMap viewMap;
    private ViewMapParameters parameters;

    public ViewMapRecord(IViewMapDescriptor descriptor, IViewMapMatcher matcher, int priority, IElementViewMap viewMap, ViewMapParameters parameters) {
        this.descriptor = descriptor;
        this.matcher = matcher;
        this.priority = priority;
        this.viewMap = viewMap;
        this.parameters = parameters;
        this.rank = this.computeRank();
    }

    public void addParameter(String name, String value) {
        this.parameters.add(name, value);
    }

    public IViewMapDescriptor getDescriptor() {
        return this.descriptor;
    }

    public IViewMapMatcher getMatcher() {
        return this.matcher;
    }

    public IViewMapParameters getParameters() {
        return this.parameters;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getRank() {
        return this.rank;
    }

    public IElementViewMap getViewMap() {
        return this.viewMap;
    }

    public boolean isMatcherDefined() {
        return this.matcher != null;
    }

    public String toString() {
        return "(" + this.rank + ", " + this.priority + ", " + this.descriptor + ")";
    }

    private int computeRank() {
        int rank = 0;
        if (this.descriptor.getProjectNature() != null && !"*".equals(this.descriptor.getProjectNature())) {
            ++rank;
        }
        if (this.descriptor.getMetaclass() != null && !"*".equals(this.descriptor.getMetaclass())) {
            ++rank;
        }
        if (this.descriptor.getDiagramMetaclass() != null && !"*".equals(this.descriptor.getDiagramMetaclass())) {
            ++rank;
        }
        if (this.descriptor.getStereotype() != null && !"*".equals(this.descriptor.getStereotype())) {
            ++rank;
        }
        if (this.matcher != null) {
            ++rank;
        }
        return rank;
    }
}

