/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.viewmap;

import com.tssap.selena.gde.viewmap.IViewMapParameters;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;

public class ViewMapParameters
implements IViewMapParameters {
    private Map records = new HashMap();
    private static final int iBOOLEAN = 0;
    private static final int iBOOLEAN_FROM_CLASSNAME = 1;
    private static final int iINT = 2;
    private static final int iINT_FROM_CLASSNAME = 3;
    private static final int iCOLOR = 4;
    private static final int iOBJECT = 5;
    private static IInterpreter[] interpreters = new IInterpreter[]{new BooleanInterpreter(), new BooleanFromClassnameInterpreter(), new IntInterpreter(), new IntFromClassnameInterpreter(), new ColorInterpreter(), new ObjectInterpreter()};
    private static ParameterRecord emptyRecord = new EmptyParameterRecord();

    public void add(String name, String value) {
        this.records.put(name, new ParameterRecord(value));
    }

    public String get(String name) {
        return this.getRecord(name).getValue();
    }

    public boolean toBoolean(String name, boolean defaultValue) {
        Boolean bool = (Boolean)this.getRecord(name).getValue(0);
        return bool == null ? defaultValue : bool;
    }

    public boolean toBooleanFromClassname(String name, boolean defaultValue) {
        Boolean bool = (Boolean)this.getRecord(name).getValue(1);
        return bool == null ? defaultValue : bool;
    }

    public Color toColorFromClassname(String name) {
        return this.toColorFromClassname(name, null);
    }

    public Color toColorFromClassname(String name, Color defaultValue) {
        Color color = (Color)this.getRecord(name).getValue(4);
        return color == null ? defaultValue : color;
    }

    public int toInt(String name, int defaultValue) {
        Integer integer = (Integer)this.getRecord(name).getValue(2);
        return integer == null ? defaultValue : integer;
    }

    public int toIntFromClassname(String name, int defaultValue) {
        Integer integer = (Integer)this.getRecord(name).getValue(3);
        return integer == null ? defaultValue : integer;
    }

    public Object toObject(String name) {
        return this.getRecord(name).getValue(5);
    }

    public Object toObject(String name, Class desiredClass) {
        Object obj = this.toObject(name);
        if (obj != null && !desiredClass.isAssignableFrom(obj.getClass())) {
            obj = null;
        }
        return obj;
    }

    private ParameterRecord getRecord(String name) {
        ParameterRecord record = (ParameterRecord)this.records.get(name);
        if (record == null) {
            record = emptyRecord;
        }
        return record;
    }

    private static class EmptyParameterRecord
    extends ParameterRecord {
        EmptyParameterRecord() {
            super(null);
        }

        Object getValue(int target) {
            return null;
        }
    }

    private static class ParameterRecord {
        private String value;
        private Object[] targets;

        ParameterRecord(String value) {
            this.value = value;
            this.targets = new Object[interpreters.length];
        }

        String getValue() {
            return this.value;
        }

        Object getValue(int target) {
            if (this.targets[target] == null) {
                this.targets[target] = interpreters[target].interpret(this.value);
            }
            return this.targets[target];
        }
    }

    private static class ObjectInterpreter
    implements IInterpreter {
        private ObjectInterpreter() {
        }

        public Object interpret(String value) {
            return this.getFieldValue(value);
        }

        protected Field findField(String qualifiedName) {
            int lastDotIndex = qualifiedName.lastIndexOf(".");
            if (lastDotIndex > 0 && lastDotIndex < qualifiedName.length() - 1) {
                String classname = qualifiedName.substring(0, lastDotIndex);
                String fieldname = qualifiedName.substring(lastDotIndex + 1);
                try {
                    Class<?> clazz = Class.forName(classname);
                    return clazz.getField(fieldname);
                }
                catch (ClassNotFoundException e) {
                }
                catch (NoSuchFieldException e) {
                }
                catch (SecurityException e) {
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            return null;
        }

        protected Object getFieldValue(String qualifiedName) {
            Field field = this.findField(qualifiedName);
            if (field != null) {
                try {
                    return field.get(null);
                }
                catch (IllegalAccessException e) {
                    return null;
                }
            }
            return null;
        }

        protected Object getFieldValue(String qualifiedName, Class desiredClass) {
            Object value = this.getFieldValue(qualifiedName);
            if (value != null && !desiredClass.isAssignableFrom(value.getClass())) {
                value = null;
            }
            return value;
        }
    }

    private static class ColorInterpreter
    extends ObjectInterpreter {
        static /* synthetic */ Class class$org$eclipse$swt$graphics$Color;

        private ColorInterpreter() {
        }

        public Object interpret(String value) {
            return this.getFieldValue(value, class$org$eclipse$swt$graphics$Color == null ? (class$org$eclipse$swt$graphics$Color = ColorInterpreter.class$("org.eclipse.swt.graphics.Color")) : class$org$eclipse$swt$graphics$Color);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class IntFromClassnameInterpreter
    extends ObjectInterpreter {
        static /* synthetic */ Class class$java$lang$Integer;

        private IntFromClassnameInterpreter() {
        }

        public Object interpret(String value) {
            return this.getFieldValue(value, class$java$lang$Integer == null ? (class$java$lang$Integer = IntFromClassnameInterpreter.class$("java.lang.Integer")) : class$java$lang$Integer);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class IntInterpreter
    implements IInterpreter {
        private IntInterpreter() {
        }

        public Object interpret(String value) {
            try {
                return new Integer(value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    private static class BooleanFromClassnameInterpreter
    extends ObjectInterpreter {
        static /* synthetic */ Class class$java$lang$Boolean;

        private BooleanFromClassnameInterpreter() {
        }

        public Object interpret(String value) {
            return this.getFieldValue(value, class$java$lang$Boolean == null ? (class$java$lang$Boolean = BooleanFromClassnameInterpreter.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class BooleanInterpreter
    implements IInterpreter {
        private BooleanInterpreter() {
        }

        public Object interpret(String value) {
            Boolean bool = new Boolean(value);
            return bool;
        }
    }

    private static interface IInterpreter {
        public Object interpret(String var1);
    }
}

