/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.viewmap;

import com.tssap.selena.gde.IElementViewMap;
import com.tssap.selena.gde.internal.GdePlugin;
import com.tssap.selena.gde.internal.viewmap.ViewMapDescriptor;
import com.tssap.selena.gde.internal.viewmap.ViewMapParameters;
import com.tssap.selena.gde.internal.viewmap.ViewMapRecord;
import com.tssap.selena.gde.viewmap.IViewMapMatcher;
import com.tssap.selena.gde.viewmap.IViewMapRegistry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;

public class ViewMapExtensionPointReader {
    public static void read(IExtensionPoint point, IViewMapRegistry viewMapRegistry) {
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            ViewMapExtensionPointReader.readExtension(extension, viewMapRegistry);
            ++i;
        }
    }

    private static void readExtension(IExtension extension, IViewMapRegistry viewMapRegistry) {
        IConfigurationElement[] configElements = extension.getConfigurationElements();
        int i = 0;
        while (i < configElements.length) {
            ViewMapRecord record;
            IConfigurationElement configElement = configElements[i];
            String name = configElement.getName();
            if ("viewmapdef".equals(name)) {
                record = ViewMapExtensionPointReader.readViewMapDef(configElement);
                if (record != null) {
                    viewMapRegistry.registerElementViewMap(record);
                }
            } else if ("diagramviewmapdef".equals(name) && (record = ViewMapExtensionPointReader.readViewMapDef(configElement)) != null) {
                viewMapRegistry.registerDiagramViewMap(record);
            }
            ++i;
        }
    }

    private static ViewMapRecord readViewMapDef(IConfigurationElement viewMapDefElement) {
        int priority;
        IViewMapMatcher matcher;
        ViewMapDescriptor descriptor = new ViewMapDescriptor();
        IElementViewMap viewMap = null;
        ViewMapParameters parameters = new ViewMapParameters();
        IConfigurationElement[] children = viewMapDefElement.getChildren("matcher");
        if (children.length != 1) {
            return null;
        }
        IConfigurationElement matcherElement = children[0];
        descriptor.setMetaclass(matcherElement.getAttribute("metaclass"));
        descriptor.setDiagramMetaclass(matcherElement.getAttribute("diagramMetaclass"));
        descriptor.setStereotype(matcherElement.getAttribute("stereotype"));
        descriptor.setProjectNature(matcherElement.getAttribute("projectNature"));
        try {
            matcher = matcherElement.getAttributeAsIs("matcherClass") != null ? (IViewMapMatcher)matcherElement.createExecutableExtension("matcherClass") : null;
        }
        catch (Throwable couldNotInstantiate) {
            matcher = null;
        }
        String sPriority = matcherElement.getAttribute("priority");
        try {
            priority = Integer.parseInt(sPriority);
        }
        catch (NumberFormatException e) {
            priority = 10;
        }
        children = viewMapDefElement.getChildren("viewmap");
        if (children.length != 1) {
            return null;
        }
        IConfigurationElement viewMapElement = children[0];
        try {
            Object viewMapInstance = viewMapElement.createExecutableExtension("class");
            if (viewMapInstance instanceof IElementViewMap) {
                viewMap = (IElementViewMap)viewMapInstance;
            }
        }
        catch (CoreException e) {
            GdePlugin.getDefault().logException(e);
        }
        catch (NoClassDefFoundError e) {
            GdePlugin.getDefault().logException(e);
            return null;
        }
        IConfigurationElement[] parameterElements = viewMapElement.getChildren("parameter");
        int j = 0;
        while (j < parameterElements.length) {
            IConfigurationElement parameterElement = parameterElements[j];
            String pName = parameterElement.getAttribute("name");
            String pValue = parameterElement.getAttribute("value");
            if (pName != null && pValue != null) {
                parameters.add(pName, pValue);
            }
            ++j;
        }
        ViewMapRecord record = new ViewMapRecord(descriptor, matcher, priority, viewMap, parameters);
        return record;
    }
}

