/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.viewmap;

import com.tssap.selena.gde.ModelElementEditPart;
import com.tssap.selena.gde.ModelElementEditPartHelper;
import com.tssap.selena.gde.ModelNodeEditPart;
import com.tssap.selena.gde.internal.viewmap.ChainMap;
import com.tssap.selena.gde.internal.viewmap.IListFactory;
import com.tssap.selena.gde.internal.viewmap.IMapFactory;
import com.tssap.selena.gde.internal.viewmap.ViewMapRecordList;
import com.tssap.selena.gde.viewmap.IViewMapDescriptor;
import com.tssap.selena.gde.viewmap.IViewMapMatcher;
import com.tssap.selena.gde.viewmap.IViewMapRecord;
import com.tssap.selena.gde.viewmap.IViewMapRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HashViewMapRegistry
implements IViewMapRegistry {
    private static final Object NULL_OBJECT = new Object();
    private ViewMapRecordList diagramList;
    private ViewMapRecordList elementList;
    private ChainMap diagramMap;
    private ChainMap elementMap;
    private static final boolean[] diagramAsterisks = new boolean[]{false, true};
    private static final boolean[] elementAsterisks = new boolean[]{false, true, true, false};
    private Map myNaiveViewMaps = new HashMap();

    public HashViewMapRegistry() {
        this.diagramList = new ViewMapRecordList();
        this.elementList = new ViewMapRecordList();
        this.diagramMap = this.createDiagramRecordMap();
        this.elementMap = this.createRecordMap();
    }

    public void createIndexes() {
        this.diagramMap = this.createDiagramRecordMap();
        this.elementMap = this.createRecordMap();
        IViewMapRecord[] records = this.diagramList.getAll();
        int ir = 0;
        while (ir < records.length) {
            IViewMapDescriptor descriptor = records[ir].getDescriptor();
            String projectNature = ChainMap.fixKey(descriptor.getProjectNature());
            String diagramMetaclass = ChainMap.fixKey(descriptor.getDiagramMetaclass());
            this.diagramMap.put(new String[]{projectNature, diagramMetaclass}, records[ir]);
            ++ir;
        }
        records = this.elementList.getAll();
        int ir2 = 0;
        while (ir2 < records.length) {
            IViewMapDescriptor descriptor = records[ir2].getDescriptor();
            String projectNature = ChainMap.fixKey(descriptor.getProjectNature());
            String metaclass = ChainMap.fixKey(descriptor.getMetaclass());
            String diagramMetaclass = ChainMap.fixKey(descriptor.getDiagramMetaclass());
            String stereotype = ChainMap.fixKey(descriptor.getStereotype() != null ? descriptor.getStereotype().toLowerCase() : null);
            this.elementMap.put(new String[]{projectNature, metaclass, diagramMetaclass, stereotype}, records[ir2]);
            ++ir2;
        }
    }

    public void dump() {
        this.diagramMap.dump();
        this.elementMap.dump();
    }

    public IViewMapRecord findDiagramViewMap(ModelNodeEditPart diagramEditPart) {
        String[] projectNatures = ModelElementEditPartHelper.getProjectNatureIDs(diagramEditPart);
        String diagramMetaclass = ChainMap.fixKey(ModelElementEditPartHelper.getDiagramMetaclass(diagramEditPart));
        Object[] keys = new String[]{"*", diagramMetaclass};
        ArrayList matches = new ArrayList();
        matches.addAll(this.diagramMap.get(keys, diagramAsterisks));
        int in = 0;
        while (in < projectNatures.length) {
            keys[0] = projectNatures[in];
            matches.addAll(this.diagramMap.get(keys, diagramAsterisks));
            ++in;
        }
        this.filterWithMatchers(matches, diagramEditPart);
        IViewMapRecord[] records = matches.toArray(new IViewMapRecord[matches.size()]);
        IViewMapRecord result = this.findStrongestViewMap(records);
        return result;
    }

    public IViewMapRecord findElementViewMap(ModelElementEditPart editPart) {
        String metaclass = ChainMap.fixKey(ModelElementEditPartHelper.getMetaclass(editPart));
        if (this.myNaiveViewMaps.get(metaclass) instanceof IViewMapRecord) {
            return (IViewMapRecord)this.myNaiveViewMaps.get(metaclass);
        }
        IViewMapRecord result = null;
        String[] projectNatures = ModelElementEditPartHelper.getProjectNatureIDs(editPart);
        String diagramMetaclass = ChainMap.fixKey(ModelElementEditPartHelper.getDiagramMetaclass(editPart));
        String[] stereotypes = ModelElementEditPartHelper.getStereotypes(editPart);
        int i = 0;
        while (i < stereotypes.length) {
            stereotypes[i] = stereotypes[i].toLowerCase();
            ++i;
        }
        String[] keys = new String[]{"*", metaclass, diagramMetaclass, null};
        ArrayList matches = new ArrayList();
        this.getApplicableElementViewmaps(keys, stereotypes, 3, matches);
        int in = 0;
        while (in < projectNatures.length) {
            keys[0] = projectNatures[in];
            this.getApplicableElementViewmaps(keys, stereotypes, 3, matches);
            ++in;
        }
        this.filterWithMatchers(matches, editPart);
        IViewMapRecord[] records = matches.toArray(new IViewMapRecord[matches.size()]);
        result = this.findStrongestViewMap(records);
        return result;
    }

    public IViewMapRecord[] getAllDiagramViewMaps() {
        return this.elementList.getAll();
    }

    public IViewMapRecord[] getAllElementViewMaps() {
        return this.elementList.getAll();
    }

    public void registerDiagramViewMap(IViewMapRecord record) {
        this.diagramList.add(record);
    }

    public void registerElementViewMap(IViewMapRecord record) {
        Object existingViewmap = this.myNaiveViewMaps.get(record.getDescriptor().getMetaclass());
        if (existingViewmap == null) {
            this.myNaiveViewMaps.put(record.getDescriptor().getMetaclass(), record);
        } else {
            this.myNaiveViewMaps.put(record.getDescriptor().getMetaclass(), NULL_OBJECT);
        }
        this.elementList.add(record);
    }

    private ChainMap createDiagramRecordMap() {
        return new ChainMap(2, new IMapFactory(){

            public Map createMap() {
                return new HashMap();
            }
        }, new IListFactory(){

            public List createList() {
                return new ArrayList();
            }
        });
    }

    private ChainMap createRecordMap() {
        return new ChainMap(4, new IMapFactory(){

            public Map createMap() {
                return new HashMap();
            }
        }, new IListFactory(){

            public List createList() {
                return new ArrayList();
            }
        });
    }

    private void filterWithMatchers(List records, ModelElementEditPart editPart) {
        IViewMapRecord[] array = records.toArray(new IViewMapRecord[records.size()]);
        int ir = 0;
        while (ir < array.length) {
            IViewMapMatcher matcher;
            IViewMapRecord record = array[ir];
            if (record.isMatcherDefined() && !(matcher = record.getMatcher()).isViewMapApplicable(editPart)) {
                records.remove(record);
            }
            ++ir;
        }
    }

    private IViewMapRecord findStrongestViewMap(IViewMapRecord[] applicableViewmaps) {
        if (applicableViewmaps.length == 0) {
            return null;
        }
        IViewMapRecord result = null;
        int maxRank = -1;
        int ir = 0;
        while (ir < applicableViewmaps.length) {
            IViewMapRecord record = applicableViewmaps[ir];
            int rank = record.getRank();
            if (rank > maxRank) {
                maxRank = rank;
                result = record;
            } else if (rank == maxRank && record.getPriority() > result.getPriority()) {
                result = record;
            }
            ++ir;
        }
        return result;
    }

    private void getApplicableElementViewmaps(String[] keys, String[] stereotypes, int stereotypeIndex, List container) {
        container.addAll(this.getApplicableElementViewmaps(keys, "*", stereotypeIndex));
        int is = 0;
        while (is < stereotypes.length) {
            container.addAll(this.getApplicableElementViewmaps(keys, stereotypes[is], stereotypeIndex));
            ++is;
        }
    }

    private List getApplicableElementViewmaps(String[] keys, String stereotype, int stereotypeIndex) {
        keys[stereotypeIndex] = stereotype;
        return this.elementMap.get(keys, elementAsterisks);
    }
}

