/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.viewmap;

import com.tssap.selena.gde.internal.viewmap.IListFactory;
import com.tssap.selena.gde.internal.viewmap.IMapFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChainMap {
    private int levels;
    private IMapFactory mapFactory;
    private IListFactory listFactory;
    private Map rootMap;
    private Cache cache;

    public static String fixKey(String key) {
        return key == null ? "*" : key;
    }

    public ChainMap(int levels, IMapFactory mapFactory, IListFactory listFactory) {
        if (levels < 1) {
            throw new IllegalArgumentException();
        }
        this.levels = levels;
        this.mapFactory = mapFactory;
        this.listFactory = listFactory;
        this.rootMap = mapFactory.createMap();
        this.cache = new Cache();
    }

    public void dump() {
        new Dumper().dump();
    }

    public List get(Object[] keys, boolean[] asterisks) {
        if (keys.length != this.levels || asterisks.length != this.levels) {
            throw new IllegalArgumentException();
        }
        List list = this.cache.get(keys, asterisks);
        if (list == null) {
            list = this.prepareForGet(this.rootMap, keys, asterisks, this.levels);
            this.cache.cache(keys, asterisks, list);
        }
        return list;
    }

    public void put(Object[] keys, Object element) {
        if (keys.length != this.levels) {
            throw new IllegalArgumentException();
        }
        List list = this.prepareForPut(this.rootMap, keys, this.levels);
        list.add(element);
        this.cache.setDirty();
    }

    private List prepareForGet(Map rootMap, Object[] keys, boolean[] asterisks, int remainingLevels) {
        ArrayList resultList = new ArrayList();
        if (remainingLevels == 0) {
            List list = (List)rootMap.get(keys[this.levels - 1]);
            if (list != null) {
                resultList.addAll(list);
            }
            if (asterisks[this.levels - 1] && (list = (List)rootMap.get("*")) != null) {
                resultList.addAll(list);
            }
        } else {
            Map map = (Map)rootMap.get(keys[this.levels - remainingLevels]);
            if (map != null) {
                resultList.addAll(this.prepareForGet(map, keys, asterisks, remainingLevels - 1));
            }
            if (asterisks[this.levels - remainingLevels] && (map = (Map)rootMap.get("*")) != null) {
                resultList.addAll(this.prepareForGet(map, keys, asterisks, remainingLevels - 1));
            }
        }
        return resultList;
    }

    private List prepareForPut(Map rootMap, Object[] keys, int remainingLevels) {
        List resultList = remainingLevels == 0 ? this.prepareList(rootMap, keys[this.levels - 1]) : this.prepareForPut(this.prepareMap(rootMap, keys[this.levels - remainingLevels]), keys, remainingLevels - 1);
        return resultList;
    }

    private List prepareList(Map map, Object key) {
        List list = (List)map.get(key);
        if (list == null) {
            list = this.listFactory.createList();
            map.put(key, list);
        }
        return list;
    }

    private Map prepareMap(Map map, Object key) {
        Map innerMap = (Map)map.get(key);
        if (innerMap == null) {
            innerMap = this.mapFactory.createMap();
            map.put(key, innerMap);
        }
        return innerMap;
    }

    private class Dumper {
        private Dumper() {
        }

        void dump() {
            this.dump(ChainMap.this.rootMap, 0);
        }

        void dump(Map map, int level) {
        }

        void indent(int level) {
            int ii = 0;
            while (ii < level * 4) {
                System.out.print(" ");
                ++ii;
            }
        }
    }

    private class Cache {
        private Map map = new HashMap();

        Cache() {
        }

        void cache(Object[] keys, boolean[] asterisks, List list) {
            this.map.put(this.getKey(keys, asterisks), list);
        }

        List get(Object[] keys, boolean[] asterisks) {
            return (List)this.map.get(this.getKey(keys, asterisks));
        }

        void setDirty() {
            if (!this.map.isEmpty()) {
                this.map = new HashMap();
            }
        }

        private String getKey(Object[] keys, boolean[] asterisks) {
            String key = keys[0] + "_";
            int ik = 1;
            while (ik < keys.length) {
                key = key + keys[ik] + "_";
                ++ik;
            }
            int ia = 0;
            while (ia < asterisks.length) {
                key = key + (asterisks[ia] ? "t" : "f");
                ++ia;
            }
            return key;
        }
    }
}

